//  MvPath
//
// .AUTHOR:
//  Gilberto Camara and Fernando Ii
//
// .SUMMARY:
//  Utilities used in PlotMod for
//  accessing the system and user default paths
//
//
#ifndef MvPath_H
#define MvPath_H
#include <stdio.h>
#include <Cached.h>
#include <string>
using std::string;

Cached MakeUserPath    ( const Cached& name );
string MakeUserDefPath ( const char* name, bool absolutePath=true );
string MakeUserPrefPath( const char* name );
string MakeSystemEtcPath  ( const string& name );
string MakeTmpPath     ( const char* name );
Cached MakeFilePath    ( const char* reqName);
const char* MakeIconName ( const char* path, const char* iconPrefix );
Cached MakePrinterFileName ( const Cached& path, const Cached& fileName );
Cached MakeTmpName  ( const Cached& iconPrefix );
const char* MakeIconDescriptionName(const char* fileName );
Cached MakeIconPath(const char* iconName );
string MakeProcessName ( const char* name );
bool FileCanBeOpened(const char* filename, const char* mode );
bool FileHasValidSize(const char* filename );

//! Prepends the current path to filename unless it is absolute path
string FullPathName( const char* filename );

string GetUserDirectory();

#endif
