/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQTreeViewSearchLine_H
#define MvQTreeViewSearchLine_H

#include "MvQAbstractSearchLine.h" 

#include <QModelIndex>

class QComboBox;
class QTreeView;

class MvQTreeViewSearchLine : public MvQAbstractSearchLine
{
	Q_OBJECT

public:
	MvQTreeViewSearchLine(QTreeView*,int,QString);
	~MvQTreeViewSearchLine(); 
	void clear();
	
public slots:
	void slotFind(QString);
	void slotFindNext();
	void slotFindPrev();
	void slotSearchColumnChanged(const QString&);
	void slotUpdateColumns();
	void slotSortingHappened(int,Qt::SortOrder);

signals:
	void indexSelected(const QModelIndex&);	
  
protected:	
	void selectIndex(const QModelIndex&);
  	
  	QTreeView* view_;
	int searchColumn_;
	QMap<QString,int> columns_;
	QComboBox* columnCb_;
	QModelIndexList resultItems_;
	int currentResultItem_;	
};

#endif