/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.util.Arrays;
import org.h2.engine.Mode;
import org.h2.engine.SysProperties;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueString;

public class ValueStringFixed
extends ValueString {
    public static final int PRECISION_DO_NOT_TRIM = Integer.MIN_VALUE;
    public static final int PRECISION_TRIM = -1;
    private static final ValueStringFixed EMPTY = new ValueStringFixed("");

    protected ValueStringFixed(String string) {
        super(string);
    }

    private static String trimRight(String string) {
        return ValueStringFixed.trimRight(string, 0);
    }

    private static String trimRight(String string, int n) {
        int n2;
        int n3;
        for (n3 = n2 = string.length() - 1; n3 >= n && string.charAt(n3) == ' '; --n3) {
        }
        string = n3 == n2 ? string : string.substring(0, n3 + 1);
        return string;
    }

    private static String rightPadWithSpaces(String string, int n) {
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        char[] cArray = new char[n];
        string.getChars(0, string.length(), cArray, 0);
        Arrays.fill(cArray, string.length(), n, ' ');
        return new String(cArray);
    }

    @Override
    public int getType() {
        return 21;
    }

    public static ValueStringFixed get(String string) {
        return ValueStringFixed.get(string, -1, null);
    }

    public static ValueStringFixed get(String string, int n, Mode mode) {
        if (mode != null && mode.padFixedLengthStrings) {
            if (n == Integer.MAX_VALUE) {
                n = 1;
            }
            string = string.length() < n ? ValueStringFixed.rightPadWithSpaces(string, n) : ValueStringFixed.trimRight(string, n);
        } else if (n != Integer.MIN_VALUE) {
            string = ValueStringFixed.trimRight(string);
        }
        if (string.length() == 0) {
            return EMPTY;
        }
        ValueStringFixed valueStringFixed = new ValueStringFixed(StringUtils.cache(string));
        if (string.length() > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueStringFixed;
        }
        return (ValueStringFixed)Value.cache(valueStringFixed);
    }

    @Override
    protected ValueString getNew(String string) {
        return ValueStringFixed.get(string);
    }
}

