/**************************************************************************
    Lightspark, a free flash player implementation

    Copyright (C) 2009-2013  Alessandro Pignotti (a.pignotti@sssup.it)

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**************************************************************************/

#include "scripting/flash/accessibility/flashaccessibility.h"
#include "scripting/class.h"
#include "scripting/argconv.h"

using namespace lightspark;

AccessibilityProperties::AccessibilityProperties(Class_base* c):
	ASObject(c), forceSimple(false), noAutoLabeling(false), silent(false)
{
}

void AccessibilityProperties::sinit(Class_base* c)
{
	CLASS_SETUP(c, ASObject, _constructor, CLASS_SEALED);
	REGISTER_GETTER_SETTER(c, description);
	REGISTER_GETTER_SETTER(c, forceSimple);
	REGISTER_GETTER_SETTER(c, name);
	REGISTER_GETTER_SETTER(c, noAutoLabeling);
	REGISTER_GETTER_SETTER(c, shortcut);
	REGISTER_GETTER_SETTER(c, silent);
}

ASFUNCTIONBODY(AccessibilityProperties,_constructor)
{
	return NULL;
}

ASFUNCTIONBODY_GETTER_SETTER(AccessibilityProperties, description);
ASFUNCTIONBODY_GETTER_SETTER(AccessibilityProperties, forceSimple);
ASFUNCTIONBODY_GETTER_SETTER(AccessibilityProperties, name);
ASFUNCTIONBODY_GETTER_SETTER(AccessibilityProperties, noAutoLabeling);
ASFUNCTIONBODY_GETTER_SETTER(AccessibilityProperties, shortcut);
ASFUNCTIONBODY_GETTER_SETTER(AccessibilityProperties, silent);

void AccessibilityImplementation::sinit(Class_base* c)
{
	CLASS_SETUP(c, ASObject, _constructor, CLASS_SEALED);
}

ASFUNCTIONBODY(AccessibilityImplementation,_constructor)
{
	LOG(LOG_NOT_IMPLEMENTED, _("AccessibilityImplementation class is unimplemented."));
	return NULL;
}


void Accessibility::sinit(Class_base* c)
{
	CLASS_SETUP(c, ASObject, _constructorNotInstantiatable, CLASS_FINAL);
	c->setVariableByQName("active","",abstract_b(false),CONSTANT_TRAIT);
}

ASFUNCTIONBODY(Accessibility,updateProperties)
{
	Accessibility* th=obj->as<Accessibility>();
	LOG(LOG_NOT_IMPLEMENTED, "Accessibility is not supported.");
	ARG_UNPACK (th->properties);

	return NULL;
}
