/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
**************************************************************************/

#ifndef HEADER_XMLDATASTORE
#define HEADER_XMLDATASTORE

#include <QString>
#include <QDir>
#include <QObject>
#include <QtXml>
#include <QList>
#include <QTextStream>
#include <sqlite3.h>
#include "../constants.h"
#include "../../client/core/bean/remote_computer_info.h"
#include "../../client/core/bean/command.h"

// Column in sqlite database for the client_parameter table.
#define DB_ID_SERVER 0
#define DB_IP 1
#define DB_OS 2
#define DB_HOSTNAME 3
#define DB_PORT 4
#define DB_PORT_FILE 5

#define DB_ID_COMMAND 1
#define DB_COMMAND 2
#define DB_DATE 3

class Database : public QObject
{
    Q_OBJECT

public:
    Database();

    void saveRemoteClients(RemoteComputerInfo* data);
    void dropRemoteClients();
    QList<RemoteComputerInfo*> getRemoteClients();
    void saveCommand(Command* data);
    void dropCommands();
    QList<Command*>* getCommandsByIdServer(int id_server);
    void delete_command(int id_server, int id_command, QString command);
    void freeDatabase();

private:
    QString db_path;
    sqlite3 *db;
    char *zErrMsg;
    int rc;

};
#endif

