/* Minimum terminal size
 */
#define TUI_MIN_LINES  10  /* help screen is 20 high but 10 displays ok.*/
#define TUI_MIN_COLS   20  /* help screen is 20 wide */

/* Display modes
 */
#define DM_ITEMS  0
#define DM_QUEUE  1

/* Cursor movement
 */
#define CURSOR_UP           0
#define CURSOR_DOWN_ADD     1
#define CURSOR_DOWN_DELETE  2
#define CURSOR_DOWN         3
#define CURSOR_PG_UP        4
#define CURSOR_PG_DOWN      5
#define CURSOR_REDRAW       6

struct TUI_DISP {
  int items;
  int base;
  int cursor;
};

/* It's messy to have disp[DM_QUEUE].items _and_ queue.items 
 * Fix some day.
 */

struct TUI {
  int dm;
  int redraw;
  int lines;
  int cols;
  
  int view;                   /* -1 for tree view */
  
  int *list;
  struct TUI_DISP disp[2];    /* td[0] is item list, td[1] is queue list */
  
  struct CONFIG *cfg;
  struct DIR_INFO *dinfo;
  struct QUEUE *queue;
  struct PLAYER *player;
};

void tui_start (struct TUI *tui);
