//**************************************************************************************************
//                              App_gSpiceUI.hpp                                                   *
//                             ------------------                                                  *
// Started     : 2003-08-15                                                                        *
// Last Update : 2014-12-13                                                                        *
// Copyright   : (C) 2003 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#include "App_gSpiceUI.hpp"

//**************************************************************************************************
// All programs must have a "main" function. Under wxWidgets main( ) is
// implemented using the following macro which creates an application instance
// and starts program execution.

wxIMPLEMENT_APP( App_gSpiceUI );

//**************************************************************************************************
// Implement an event table in which the events are routed to their respective
// handler functions in the class. If -1 is given as the ID, the given handler
// will be invoked for any event of the specified type.

//wxBEGIN_EVENT_TABLE( App_gSpiceUI, wxApp )


//wxEND_EVENT_TABLE( )

//**************************************************************************************************
// Constructor.

App_gSpiceUI::App_gSpiceUI( void )
{
  g_bDebug = false;

  m_poFrmMain = NULL;
}

//**************************************************************************************************
// Destructor.

App_gSpiceUI::~App_gSpiceUI( )
{
}

//**************************************************************************************************
//                                         Event Handlers                                          *
//**************************************************************************************************
// wxWidgets calls wxApp::OnInit( ) at startup.
//
// This method is used to initialize the application.
//
// Return Values :
//   true  - Success (continue  application execution)
//   false - Failure (terminate application execution)

bool  App_gSpiceUI::OnInit( void )
{
  // The following lines magically makes locale stuff work, don't touch!
  m_oLocale.Init( wxLANGUAGE_DEFAULT, wxLOCALE_LOAD_DEFAULT );
//  setlocale( LC_ALL, "C" );
  setlocale( LC_NUMERIC, "C" );

  // Set the command line and process it
  if( ! m_oCmdLnPcr.bSetCmdLine( argc, argv ) ) return( false );
  if( ! m_oCmdLnPcr.bProcArgs( ) )              return( false );

  // Create the GUI
  m_poFrmMain = new FrmMain( this );
  m_poFrmMain->Show( true );
  SetTopWindow( m_poFrmMain );

  // Display error message held over during startup
  m_poFrmMain->DlgErrMsg( );

  return( true );
}

//**************************************************************************************************
// wxWidgets calls wxApp::OnRun( ) to start execution of the application.
//
// This function is where the execution of a program written in wxWidgets
// starts. The default implementation just enters the main loop and starts
// handling the events until it terminates. The return value of this function
// becomes the exit code of the application.
//
// Return Values :
//   EXIT_SUCCESS - application exit code on success
//   EXIT_FAILURE - application exit code on failure
/*
int  App_gSpiceUI::OnRun( void )
{
  MainLoop( );

  return( EXIT_SUCCESS );
}
// */
//**************************************************************************************************
// wxWidgets calls wxApp::Mainloop( ) on creation of the application.
//
// Return Values :
//   0 - the return value is not used
/*
int  App_gSpiceUI::MainLoop( void )
{
  while( m_poFrmMain->bIsOpen( ) )
  {
     Yield( );            // Allow messages in the event queue to be processed

     wxMilliSleep( 100 ); // Sleep for 100msec
  }

  return( 0 );
}
// */
//**************************************************************************************************
// wxWidgets calls wxApp::OnExit( ) on application termination.
//
// This method does any processing which needs to be done as the application is
// about to exit. Note that it is not called at all if OnInit( ) failed.
//
// Return Values :
//   0 - the return value is not used

int  App_gSpiceUI::OnExit( void )
{
  // Delete the global configuration object
  delete wxConfig::Set( (wxConfig *) NULL );

  return( 0 );
}

//**************************************************************************************************
