//*****************************************************************************
//                                NbkSimrBase.cpp                             *
//                               -----------------                            *
// Started     : 05/05/2004                                                   *
// Last Update : 23/05/2011                                                   *
// Copyright   : (C) 2004 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "base/NbkSimrBase.hpp"

//*****************************************************************************
// Implement an event table.

BEGIN_EVENT_TABLE( NbkSimrBase, wxNotebook )

  EVT_NOTEBOOK_PAGE_CHANGED( -1, NbkSimrBase::OnPageChangd )

END_EVENT_TABLE( )

//*****************************************************************************
// Constructor.
//
// Arguments:
//   poParent - The parent window
//   oWinID   - The display object ID
//   roPosn   - The notebook position
//   roSize   - The notebook size

NbkSimrBase::NbkSimrBase( wxWindow * poParent, wxWindowID oWinID )
                        : wxNotebook( poParent, oWinID )
{
  // Set the simulator engine type specifier
  m_eSimEng = eSIMR_NONE;
}

//*****************************************************************************
// Default constructor.
// (Used for two stage creation ie. must call Create( ) method.

NbkSimrBase::NbkSimrBase( void ) : wxNotebook( )
{
  m_eSimEng = eSIMR_NONE;
}

//*****************************************************************************
// Destructor.

NbkSimrBase::~NbkSimrBase( )
{
}

//*****************************************************************************
// Clear the object attributes.
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  NbkSimrBase::bClear( void )
{
  m_osErrMsg.Empty( ); // Clear the error string

  return( TRUE );
}

//*****************************************************************************
//                                                                            *
//                             Event Handlers                                 *
//                                                                            *
//*****************************************************************************
// This event is generated when a notebook page has just changed.
//
// Argument List:
//   roEvtNbk - An object holding information about the event

void  NbkSimrBase::OnPageChangd( wxNotebookEvent & roEvtNbk )
{
  PnlAnaBase * poPnlAna;
  wxString     os1;

  // Get a pointer to the currently displayed analysis page
  poPnlAna = (PnlAnaBase *) GetCurrentPage( );
  if( poPnlAna == NULL ) return;

  // Synchronize the sweep sources between the different analysis pages
  if( poPnlAna->m_bSyncSwpSrcs )
  {
    os1 = poPnlAna->m_oCpntSwpSrcs.m_osName;

    if( poPnlAna->m_oChoSrcName.SetStringSelection( os1 ) )
    { // Set the sweep source value if it's been defined
      if( poPnlAna->m_oPnlSrcLvl.GetParent( ) != NULL )
      {
        poPnlAna->m_oPnlSrcLvl.bSetUnitsType( poPnlAna->m_oCpntSwpSrcs.eGetUnitsType() );
        poPnlAna->m_oPnlSrcLvl.bSetValue( poPnlAna->m_oCpntSwpSrcs.m_osValue );
      }
    }
    else
    { // Couldn't set the sweep source name so clear it
      poPnlAna->m_oChoSrcName.SetSelection( 0 );
      if( poPnlAna->m_oPnlSrcLvl.GetParent( ) != NULL )
      {
        poPnlAna->m_oPnlSrcLvl.bSetUnitsType( eUNITS_NONE );
        poPnlAna->m_oPnlSrcLvl.bSetValue( 0.0 );
      }
    }
  }
}

//*****************************************************************************
