
/**
 * \file flush.c
 *
 * \brief Segment flush routines.
 *
 * This program is free software under the GNU General Public License
 * (>=v2). Read the file COPYING that comes with GRASS for details.
 *
 * \author GRASS GIS Development Team
 *
 * \date 2005-2006
 */

#include <grass/segment.h>


/**
 * \fn int segment_flush (SEGMENT *SEG)
 *
 * \brief Flush pending updates to disk.
 *
 * Forces all pending updates generated by <i>segment_put()</i> to be 
 * written to the segment file <b>seg</b>. Must be called after the 
 * final <i>segment_put()</i> to force all pending updates to disk. Must 
 * also be called before the first call to <i>segment_get_row</i>.
 *
 * \param[in] seg segment
 * \return always returns 0
 */

int segment_flush(SEGMENT * SEG)
{
    int i;

    for (i = 0; i < SEG->nseg; i++)
	if (SEG->scb[i].n >= 0 && SEG->scb[i].dirty)
	    segment_pageout(SEG, i);

    return 0;
}
