#!/usr/bin/python

##   GNOME Comics Organizer - Python Branch
##   Copyright (C) 2004 Mads Villadsen <maxximum@krakoa.dk>
    
##   This program is free software; you can redistribute it and/or modify
##   it under the terms of the GNU General Public License as published by
##   the Free Software Foundation; either version 2 of the License, or
##   (at your option) any later version.
   
##   This program is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY; without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##   GNU General Public License for more details.
   
##   You should have received a copy of the GNU General Public License
##   along with this program; if not, write to the Free Software
##   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import comiclist

import sys
import libxml2
import xml.sax.saxutils

def get_file_identifier(file):
    ident_str = ""
    # first try reading the file as xml
    try:
        comics_doc = libxml2.parseFile (file)
        if comics_doc.name != file:
            print "doc.name error"
            sys.exit(1)
        ident_str = comics_doc.xpathEval("/comics/@identifier")[0].get_content()
    except:
        print "File is not a GNOME Comics Organizer XML file"

        f = open(file)

        ident_str = ""
        for i in range(11):
            c = f.read(1)
            if (c != "\x00"):
                ident_str = ident_str + c

    return ident_str

def get_file_uuid(file):
    temp_string = ""
    
    # first try reading the file as xml
    try:
        comics_doc = libxml2.parseFile (file)
        if comics_doc.name != file:
            print "doc.name error"
            sys.exit(1)
        temp_string = comics_doc.xpathEval("/comics/@guid")[0].get_content()
    except:
        print "File is not a GNOME Comics Organizer XML file"

        f = open(file)

        # skip the identifier
        ident_str = ""
        for i in range(11):
            c = f.read(1)
            if (c != "\x00"):
                ident_str = ident_str + c

        temp_string = ""
        c = f.read(1)
        while (c != "\x00"):
            temp_string = temp_string + c
            c = f.read(1)

    return temp_string

def load_gco_file(file):
    retval = None
    file_id = get_file_identifier(file)

    if (file_id == "GCO_0_3__"):
        retval = load_gco_0_3(file)
    if (file_id == "GCO_0_5__"):
        retval = load_gco_0_5(file)

    return retval

def load_gco_0_3(file):
    retlist = []

    f = open(file)

    # skip identifier and uuid
    ident_str = ""
    for i in range(11):
        c = f.read(1)
        if (c != "\x00"):
            ident_str = ident_str + c

    temp_string = ""
    c = f.read(1)
    while (c != "\x00"):
        temp_string = temp_string + c
        c = f.read(1)

    # start reading the actual data
    c = f.read(1)
    while (c != ""):
        temp_string = ""
        while (c != "\x00"):
            temp_string = temp_string + c
            c = f.read(1)
        title = unicode(temp_string, "cp1252")
        temp_string = ""
        c = f.read(1)
        while (c != "\x00"):
            temp_string = temp_string + c
            c = f.read(1)
        publisher = unicode(temp_string, "cp1252")
        temp_string = ""
        c = f.read(1)
        while (c != "\x00"):
            temp_string = temp_string + c
            c = f.read(1)
        type = unicode(temp_string, "cp1252")
        temp_string = ""
        c = f.read(1)
        while (c != "\x00"):
            temp_string = temp_string + c
            c = f.read(1)
        volume = unicode(temp_string, "cp1252")
        temp_string = ""
        c = f.read(1)
        while (c != "\x00"):
            temp_string = temp_string + c
            c = f.read(1)
        group = unicode(temp_string, "cp1252")
        temp_string = ""
        c = f.read(1)
        while (c != "\x00"):
            temp_string = temp_string + c
            c = f.read(1)
        comment = unicode(temp_string, "cp1252")
        temp_string = ""
        c = f.read(1)
        while (c != "\x00"):
            temp_string = temp_string + c
            c = f.read(1)
        link_file = unicode(temp_string, "cp1252")
        temp_string = ""
        c = f.read(1)
        while (c != "\x00"):
            temp_string = temp_string + c
            c = f.read(1)
        guid = unicode(temp_string, "cp1252")

        comic = comiclist.ComicBook()
        comic.init(title, publisher, type, volume, group, comment, link_file, guid)

        c = f.read(1)
        while (c != "\x00"):
            temp_string = ""
            while (c != "\x01"):
                temp_string = temp_string + c
                c = f.read(1)
            issue_number = unicode(temp_string, "cp1252")
            temp_string = ""
            c = f.read(1)
            writer_list = []
            while (c != "\x01"):
                while (c != "\x02"):
                    temp_string = temp_string + c
                    c = f.read(1)
                writer_list.append(unicode(temp_string, "cp1252"))
                temp_string = ""
                c = f.read(1)
            temp_string = ""
            c = f.read(1)
            penciller_list = []
            while (c != "\x01"):
                while (c != "\x02"):
                    temp_string = temp_string + c
                    c = f.read(1)
                penciller_list.append(unicode(temp_string, "cp1252"))
                temp_string = ""
                c = f.read(1)
            temp_string = ""
            c = f.read(1)
            inker_list = []
            while (c != "\x01"):
                while (c != "\x02"):
                    temp_string = temp_string + c
                    c = f.read(1)
                inker_list.append(unicode(temp_string, "cp1252"))
                temp_string = ""
                c = f.read(1)
            temp_string = ""
            c = f.read(1)
            title_list = []
            while (c != "\x01"):
                while (c != "\x02"):
                    temp_string = temp_string + c
                    c = f.read(1)
                title_list.append(unicode(temp_string, "cp1252"))
                temp_string = ""
                c = f.read(1)
            temp_string = ""
            c = f.read(1)
            while (c != "\x01"):
                temp_string = temp_string + c
                c = f.read(1)
            location = unicode(temp_string, "cp1252")
            temp_string = ""
            c = f.read(1)
            while (c != "\x01"):
                temp_string = temp_string + c
                c = f.read(1)
            price = unicode(temp_string, "cp1252")
            temp_string = ""
            c = f.read(1)
            while (c != "\x01"):
                temp_string = temp_string + c
                c = f.read(1)
            current_price = unicode(temp_string, "cp1252")
            temp_string = ""
            c = f.read(1)
            while (c != "\x01"):
                temp_string = temp_string + c
                c = f.read(1)
            purchase_price = unicode(temp_string, "cp1252")
            temp_string = ""
            c = f.read(1)
            while (c != "\x01"):
                temp_string = temp_string + c
                c = f.read(1)
            image = unicode(temp_string, "cp1252")
            temp_string = ""
            c = f.read(1)
            while (c != "\x01"):
                temp_string = temp_string + c
                c = f.read(1)
            condition = unicode(temp_string, "cp1252")
            temp_string = ""
            c = f.read(1)
            while (c != "\x01"):
                temp_string = temp_string + c
                c = f.read(1)
            comment = unicode(temp_string, "cp1252")
            temp_string = ""
            c = f.read(1)
            while (c != "\x01"):
                temp_string = temp_string + c
                c = f.read(1)
            date = unicode(temp_string, "cp1252")
            temp_string = ""
            c = f.read(1)
            while (c != "\x01"):
                temp_string = temp_string + c
                c = f.read(1)
            guid = unicode(temp_string, "cp1252")

            issue = comiclist.Issue()
            issue.init(issue_number, price, current_price, purchase_price, comment, image, writer_list, penciller_list, inker_list, title_list, condition, location, date, guid)
            comic.append_issue(issue)

            c = f.read(1)

        retlist.append(comic)
        c = f.read(1)

    return retlist

def load_gco_0_5(file):
    retlist = []

    try:
        comics_doc = libxml2.parseFile (file)
        if comics_doc.name != file:
            print "doc.name error"
            sys.exit(1)

    except:
        print "File is not a GNOME Comics Organizer XML file"

    res = comics_doc.xpathEval ("/comics//comic")

    for i in range (len(res)):
        comic = None
        try:
            guid = res[i].xpathEval("@guid")[0].get_content()
            title = res[i].xpathEval("title")[0].get_content()
            publisher = res[i].xpathEval("publisher")[0].get_content()
            type = res[i].xpathEval("type")[0].get_content()
            volume = res[i].xpathEval("volume")[0].get_content()
            group = res[i].xpathEval("group")[0].get_content()
            comment = res[i].xpathEval("comment")[0].get_content()
            link_file = res[i].xpathEval("link_file")[0].get_content()

            comic = comiclist.ComicBook()
            comic.init(title, publisher, type, volume, group, comment, link_file, guid)

            issue_res = res[i].xpathEval (".//issue")

            for j in range (len(issue_res)):
                issue = None
                try:
                    guid = issue_res[j].xpathEval("@guid")[0].get_content()
                    issue_number = issue_res[j].xpathEval("issue_number")[0].get_content()
                    price = issue_res[j].xpathEval("price")[0].get_content()
                    current_price = issue_res[j].xpathEval("current_price")[0].get_content()
                    purchase_price = issue_res[j].xpathEval("purchase_price")[0].get_content()
                    comment = issue_res[j].xpathEval("comment")[0].get_content()
                    image = issue_res[j].xpathEval("image")[0].get_content()
                    condition = issue_res[j].xpathEval("condition")[0].get_content()
                    location = issue_res[j].xpathEval("location")[0].get_content()
                    date = issue_res[j].xpathEval("date")[0].get_content()

                    # FIXME: load these as well
                    writer_list = []
                    penciller_list = []
                    inker_list = []
                    title_list = []

                    writers_res = None
                    try:
                        writers_res = issue_res[j].xpathEval ("./writers//writer")
                    except:
                        pass
                    if (writers_res != None):
                        for w in range (len(writers_res)):
                            writer_list.append(writers_res[w].get_content())

                    pencillers_res = None
                    try:
                        pencillers_res = issue_res[j].xpathEval ("./pencillers//penciller")
                    except:
                        pass
                    if (pencillers_res != None):
                        for w in range (len(pencillers_res)):
                            penciller_list.append(pencillers_res[w].get_content())

                    inkers_res = None
                    try:
                        inkers_res = issue_res[j].xpathEval ("./inkers//inker")
                    except:
                        pass
                    if (inkers_res != None):
                        for w in range (len(inkers_res)):
                            inker_list.append(inkers_res[w].get_content())

                    titles_res = None
                    try:
                        titles_res = issue_res[j].xpathEval ("./titles//title")
                    except:
                        pass
                    if (titles_res != None):
                        for w in range (len(titles_res)):
                            title_list.append(titles_res[w].get_content())


                    issue = comiclist.Issue()
                    issue.init(issue_number, price, current_price, purchase_price, comment, image, writer_list, penciller_list, inker_list, title_list, condition, location, date, guid)

                    comic.append_issue(issue)
                except:
                    print "Error loading an issue"

            retlist.append(comic)
        except:
            print "Error loading a comic"

    return retlist

def save_gco(file, comics, highest_uuid):
    save_gco_0_5(file, comics, highest_uuid)

def save_gco_0_5(file, comics, highest_uuid):
    save_doc = libxml2.newDoc("1.0")
    save_root = save_doc.newChild(None, "comics", None)
    save_root.setProp("guid", highest_uuid)
    save_root.setProp("identifier", "GCO_0_5__")
    
    for comic in comics:
        elem = save_root.newChild(None, "comic", None)
        elem.setProp("guid", comic.get_guid())
        title_elem = elem.newChild(None, "title", xml.sax.saxutils.escape(comic.get_title()))
        publisher_elem = elem.newChild(None, "publisher", xml.sax.saxutils.escape(comic.get_publisher()))
        type_elem = elem.newChild(None, "type", xml.sax.saxutils.escape(comic.get_type()))
        volume_elem = elem.newChild(None, "volume", xml.sax.saxutils.escape(comic.get_volume()))
        group_elem = elem.newChild(None, "group", xml.sax.saxutils.escape(comic.get_group()))
        comment_elem = elem.newChild(None, "comment", xml.sax.saxutils.escape(comic.get_comment()))
        link_file_elem = elem.newChild(None, "link_file", xml.sax.saxutils.escape(comic.get_link_file()))

        for issue in comic.get_issues():
            issue_elem = elem.newChild(None, "issue", None)
            issue_elem.setProp("guid", issue.get_guid())
            issue_number_elem = issue_elem.newChild(None, "issue_number", xml.sax.saxutils.escape(issue.get_issue_number()))
            price_elem = issue_elem.newChild(None, "price", xml.sax.saxutils.escape(issue.get_price()))
            current_price_elem = issue_elem.newChild(None, "current_price", xml.sax.saxutils.escape(issue.get_current_price()))
            purchase_price_elem = issue_elem.newChild(None, "purchase_price", xml.sax.saxutils.escape(issue.get_purchase_price()))
            comment_elem = issue_elem.newChild(None, "comment", xml.sax.saxutils.escape(issue.get_comment()))
            image_elem = issue_elem.newChild(None, "image", xml.sax.saxutils.escape(issue.get_image()))
            condition_elem = issue_elem.newChild(None, "condition", xml.sax.saxutils.escape(issue.get_condition()))
            location_elem = issue_elem.newChild(None, "location", xml.sax.saxutils.escape(issue.get_location()))
            date_elem = issue_elem.newChild(None, "date", xml.sax.saxutils.escape(issue.get_date()))
            
            writers_elem = issue_elem.newChild(None, "writers", None)
            for w in issue.get_writer():
                writer_elem = writers_elem.newChild(None, "writer", xml.sax.saxutils.escape(w))
                
            pencillers_elem = issue_elem.newChild(None, "pencillers", None)
            for p in issue.get_penciller():
                penciller_elem = pencillers_elem.newChild(None, "penciller", xml.sax.saxutils.escape(p))
                
            inkers_elem = issue_elem.newChild(None, "inkers", None)
            for i in issue.get_inker():
                inker_elem = inkers_elem.newChild(None, "inker", xml.sax.saxutils.escape(i))
                
            titles_elem = issue_elem.newChild(None, "titles", None)
            for t in issue.get_title():
                title_elem = titles_elem.newChild(None, "title", xml.sax.saxutils.escape(t))
                

    save_doc.saveFile(file)
