<!--
Thanks for your interest in the project. Bugs filed and PRs submitted are appreciated!

Some guidelines are provided like this, in HTML comments, to expedite the code review before merging your contribution.

First, please make sure that you have read the documentation page on fpdf2 development:
https://py-pdf.github.io/fpdf2/Development.html

If you're new to contributing to open source projects,
you might find this free video course helpful: http://kcd.im/pull-request
-->

<!-- What changes are being made? (What feature/bug is being fixed here?) -->

e.g. Fixes #0 <!-- This will automatically close issue #0 once the PR is merged: https://help.github.com/en/articles/closing-issues-using-keywords -->

<!-- Have you done all of these things?  -->
**Checklist**:

<!-- To check an item, place an "x" in the box like so: "- [x] Item description"
     Add "N/A" to the end of each line that's irrelevant to your changes -->

- [ ] The GitHub pipeline is OK (green), <!-- The maintainers will trigger it if this is your 1st contribution -->
      meaning that both `pylint` (static code analyzer) and `black` (code formatter) are happy with the changes of this PR.

- [ ] A unit test is covering the code added / modified by this PR

- [ ] This PR is ready to be merged <!-- In your opinion, can this be merged as soon as it's reviewed? Else, this can be turned into a Draft PR -->

- [ ] In case of a new feature, docstrings have been added, with also some documentation in the `docs/` folder

- [ ] A mention of the change is present in `CHANGELOG.md`

<!-- Feel free to add additional comments, and to ask questions if some of those guidelines are unclear to you! -->

<!--
Once a PR is merged, maintainers will add your name to the contributors table in README.md.
If they forget, or you do not wish this to happen, please mention it.
-->

By submitting this pull request, I confirm that my contribution is made under the terms of the [GNU LGPL 3.0 license](https://github.com/py-pdf/fpdf2/blob/master/LICENSE).
