/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.ServiceType;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.FileWriter;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordSysBuilderIF;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.NcMLGWriter;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.stream.CdmRemote;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetcdfDataset
extends NetcdfFile {
    private static Set<Enhance> EnhanceAll = Collections.unmodifiableSet(EnumSet.of(Enhance.ScaleMissing, Enhance.CoordSystems, Enhance.ConvertEnums));
    private static Set<Enhance> EnhanceNone = Collections.unmodifiableSet(EnumSet.noneOf(Enhance.class));
    private static Set<Enhance> defaultEnhanceMode = EnhanceAll;
    private static Set<Enhance> coordSysEnhanceMode = null;
    private static Logger log = LoggerFactory.getLogger(NetcdfDataset.class);
    protected static boolean useNaNs = true;
    protected static boolean fillValueIsMissing = true;
    protected static boolean invalidDataIsMissing = true;
    protected static boolean missingDataIsMissing = true;
    private static FileCache fileCache = null;
    private static FileFactory defaultNetcdfFileFactory = null;
    private static HttpClient httpClient = null;
    private NetcdfFile orgFile = null;
    private List<CoordinateSystem> coordSys = new ArrayList<CoordinateSystem>();
    private List<CoordinateAxis> coordAxes = new ArrayList<CoordinateAxis>();
    private List<CoordinateTransform> coordTransforms = new ArrayList<CoordinateTransform>();
    private String convUsed;
    private EnumSet<Enhance> enhanceMode = EnumSet.noneOf(Enhance.class);
    private Aggregation agg = null;

    public static Set<Enhance> getEnhanceAll() {
        return EnhanceAll;
    }

    public static Set<Enhance> getEnhanceNone() {
        return EnhanceNone;
    }

    public static Set<Enhance> getEnhanceDefault() {
        return defaultEnhanceMode;
    }

    public static void setDefaultEnhanceMode(Set<Enhance> mode) {
        defaultEnhanceMode = Collections.unmodifiableSet(mode);
        coordSysEnhanceMode = null;
    }

    public static Set<Enhance> getDefaultEnhanceMode() {
        return defaultEnhanceMode;
    }

    public static Set<Enhance> getCoordSysEnhanceMode() {
        if (coordSysEnhanceMode == null) {
            EnumSet<Enhance> mode = EnumSet.copyOf(defaultEnhanceMode);
            mode.add(Enhance.CoordSystems);
            coordSysEnhanceMode = Collections.unmodifiableSet(mode);
        }
        return coordSysEnhanceMode;
    }

    public static Set<Enhance> parseEnhanceMode(String enhanceMode) {
        if (enhanceMode == null) {
            return null;
        }
        Set<Enhance> mode = null;
        if (enhanceMode.equalsIgnoreCase("true") || enhanceMode.equalsIgnoreCase("All")) {
            mode = NetcdfDataset.getEnhanceAll();
        } else if (enhanceMode.equalsIgnoreCase("AllDefer")) {
            mode = EnumSet.of(Enhance.ScaleMissingDefer, Enhance.CoordSystems, Enhance.ConvertEnums);
        } else if (enhanceMode.equalsIgnoreCase("ScaleMissing")) {
            mode = EnumSet.of(Enhance.ScaleMissing);
        } else if (enhanceMode.equalsIgnoreCase("ScaleMissingDefer")) {
            mode = EnumSet.of(Enhance.ScaleMissingDefer);
        } else if (enhanceMode.equalsIgnoreCase("CoordSystems")) {
            mode = EnumSet.of(Enhance.CoordSystems);
        } else if (enhanceMode.equalsIgnoreCase("ConvertEnums")) {
            mode = EnumSet.of(Enhance.ConvertEnums);
        }
        return mode;
    }

    public static void setUseNaNs(boolean b) {
        useNaNs = b;
    }

    public static boolean getUseNaNs() {
        return useNaNs;
    }

    public static void setFillValueIsMissing(boolean b) {
        fillValueIsMissing = b;
    }

    public static boolean getFillValueIsMissing() {
        return fillValueIsMissing;
    }

    public static void setInvalidDataIsMissing(boolean b) {
        invalidDataIsMissing = b;
    }

    public static boolean getInvalidDataIsMissing() {
        return invalidDataIsMissing;
    }

    public static void setMissingDataIsMissing(boolean b) {
        missingDataIsMissing = b;
    }

    public static boolean getMissingDataIsMissing() {
        return missingDataIsMissing;
    }

    public static void initNetcdfFileCache(int minElementsInMemory, int maxElementsInMemory, int period) {
        fileCache = new FileCache("NetcdfFileCache ", minElementsInMemory, maxElementsInMemory, -1, period);
        defaultNetcdfFileFactory = new MyNetcdfFileFactory();
    }

    public static void initNetcdfFileCache(int minElementsInMemory, int maxElementsInMemory, int hardLimit, int period) {
        fileCache = new FileCache("NetcdfFileCache ", minElementsInMemory, maxElementsInMemory, hardLimit, period);
        defaultNetcdfFileFactory = new MyNetcdfFileFactory();
    }

    public static void disableNetcdfFileCache() {
        if (null != fileCache) {
            fileCache.disable();
        }
        fileCache = null;
        NetcdfDataset.shutdown();
    }

    public static void shutdown() {
        FileCache.shutdown();
    }

    public static FileCache getNetcdfFileCache() {
        return fileCache;
    }

    public static NetcdfDataset wrap(NetcdfFile ncfile, Set<Enhance> enhanceMode) throws IOException {
        NetcdfDataset ncd;
        if (ncfile instanceof NetcdfDataset) {
            ncd = (NetcdfDataset)ncfile;
            ncd.enhance(enhanceMode);
        } else {
            ncd = new NetcdfDataset(ncfile, enhanceMode);
        }
        return ncd;
    }

    public static NetcdfDataset openDataset(String location) throws IOException {
        return NetcdfDataset.openDataset(location, true, null);
    }

    public static NetcdfDataset openDataset(String location, boolean enhance, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.openDataset(location, enhance, -1, cancelTask, null);
    }

    public static NetcdfDataset openDataset(String location, boolean enhance, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        return NetcdfDataset.openDataset(location, enhance ? defaultEnhanceMode : null, buffer_size, cancelTask, spiObject);
    }

    public static NetcdfDataset openDataset(String location, Set<Enhance> enhanceMode, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        NetcdfDataset ds;
        NetcdfFile ncfile = NetcdfDataset.openOrAcquireFile(null, null, null, location, buffer_size, cancelTask, spiObject);
        if (ncfile instanceof NetcdfDataset) {
            ds = (NetcdfDataset)ncfile;
            NetcdfDataset.enhance(ds, enhanceMode, cancelTask);
        } else {
            ds = new NetcdfDataset(ncfile, enhanceMode);
        }
        return ds;
    }

    private static CoordSysBuilderIF enhance(NetcdfDataset ds, Set<Enhance> mode, CancelTask cancelTask) throws IOException {
        if (mode == null) {
            return null;
        }
        CoordSysBuilderIF builder = null;
        if (mode.contains((Object)Enhance.CoordSystems) && !ds.enhanceMode.contains((Object)Enhance.CoordSystems)) {
            builder = CoordSysBuilder.factory(ds, cancelTask);
            builder.augmentDataset(ds, cancelTask);
            ds.convUsed = builder.getConventionUsed();
        }
        if (mode.contains((Object)Enhance.ConvertEnums) || mode.contains((Object)Enhance.ScaleMissing) || mode.contains((Object)Enhance.ScaleMissingDefer)) {
            for (Variable v : ds.getVariables()) {
                VariableEnhanced ve = (VariableEnhanced)((Object)v);
                ve.enhance(mode);
                if (cancelTask == null || !cancelTask.isCancel()) continue;
                return null;
            }
        }
        if (builder != null) {
            builder.buildCoordinateSystems(ds);
        }
        ds.finish();
        ds.enhanceMode.addAll(mode);
        return builder;
    }

    public static NetcdfDataset acquireDataset(String location, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.acquireDataset(null, location, defaultEnhanceMode, -1, cancelTask, null);
    }

    public static NetcdfDataset acquireDataset(FileFactory fac, String location, Set<Enhance> enhanceMode, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
        if (fileCache == null) {
            if (fac == null) {
                return NetcdfDataset.openDataset(location, enhanceMode, buffer_size, cancelTask, iospMessage);
            }
            return (NetcdfDataset)fac.open(location, buffer_size, cancelTask, iospMessage);
        }
        if (fac != null) {
            return (NetcdfDataset)NetcdfDataset.openOrAcquireFile(fileCache, fac, null, location, buffer_size, cancelTask, iospMessage);
        }
        fac = new MyNetcdfDatasetFactory(location, enhanceMode);
        return (NetcdfDataset)NetcdfDataset.openOrAcquireFile(fileCache, fac, fac.hashCode(), location, buffer_size, cancelTask, iospMessage);
    }

    public static NetcdfFile openFile(String location, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.openOrAcquireFile(null, null, null, location, -1, cancelTask, null);
    }

    public static NetcdfFile openFile(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        return NetcdfDataset.openOrAcquireFile(null, null, null, location, buffer_size, cancelTask, spiObject);
    }

    public static NetcdfFile acquireFile(String location, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.acquireFile(null, null, location, -1, cancelTask, null);
    }

    public static NetcdfFile acquireFile(FileFactory factory, Object hashKey, String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (fileCache == null && factory != null) {
            return (NetcdfFile)factory.open(location, buffer_size, cancelTask, spiObject);
        }
        return NetcdfDataset.openOrAcquireFile(fileCache, factory, hashKey, location, buffer_size, cancelTask, spiObject);
    }

    private static NetcdfFile openOrAcquireFile(FileCache cache, FileFactory factory, Object hashKey, String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (location == null) {
            throw new IOException("NetcdfDataset.openFile: location is null");
        }
        location = location.trim();
        if ((location = StringUtil.replace(location, '\\', "/")).startsWith("dods:")) {
            return NetcdfDataset.acquireDODS(cache, factory, hashKey, location, buffer_size, cancelTask, spiObject);
        }
        if (location.startsWith("cdmremote:")) {
            return NetcdfDataset.acquireRemote(cache, factory, hashKey, location, buffer_size, cancelTask, spiObject);
        }
        if (location.startsWith("thredds:")) {
            ThreddsDataFactory tdf = new ThreddsDataFactory();
            Formatter log = new Formatter();
            NetcdfDataset ncfile = tdf.openDataset(location, false, cancelTask, log);
            if (ncfile == null) {
                throw new IOException(log.toString());
            }
            return ncfile;
        }
        if (location.endsWith(".xml") || location.endsWith(".ncml")) {
            if (!location.startsWith("http:") && !location.startsWith("file:")) {
                location = "file:" + location;
            }
            return NetcdfDataset.acquireNcml(cache, factory, hashKey, location, buffer_size, cancelTask, spiObject);
        }
        if (location.startsWith("http:")) {
            ServiceType stype = NetcdfDataset.disambiguateHttp(location);
            if (stype == ServiceType.OPENDAP) {
                return NetcdfDataset.acquireDODS(cache, factory, hashKey, location, buffer_size, cancelTask, spiObject);
            }
            if (stype == ServiceType.CdmRemote) {
                return NetcdfDataset.acquireRemote(cache, factory, hashKey, location, buffer_size, cancelTask, spiObject);
            }
        }
        if (cache != null) {
            if (factory == null) {
                factory = defaultNetcdfFileFactory;
            }
            return (NetcdfFile)cache.acquire(factory, hashKey, location, buffer_size, cancelTask, spiObject);
        }
        return NetcdfFile.open(location, buffer_size, cancelTask, spiObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceType disambiguateHttp(String location) throws IOException {
        HeadMethod method;
        block8: {
            NetcdfDataset.initHttpClient();
            ServiceType result = NetcdfDataset.checkIfDods(location);
            if (result != null) {
                return result;
            }
            method = null;
            try {
                String v;
                method = new HeadMethod(location);
                method.setFollowRedirects(true);
                int statusCode = httpClient.executeMethod(method);
                if (statusCode >= 300) {
                    if (statusCode == 401) {
                        throw new IOException("Unauthorized to open dataset " + location);
                    }
                    throw new IOException(location + " is not a valid URL, return status=" + statusCode);
                }
                Header h = method.getResponseHeader("Content-Description");
                if (h == null || h.getValue() == null || !(v = h.getValue()).equalsIgnoreCase("ncstream")) break block8;
                ServiceType serviceType = ServiceType.CdmRemote;
                Object var8_7 = null;
                if (method != null) {
                    method.releaseConnection();
                }
                return serviceType;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var8_9 = null;
                    if (method == null) break block9;
                    method.releaseConnection();
                }
                throw throwable;
            }
        }
        ServiceType serviceType = null;
        Object var8_8 = null;
        if (method != null) {
            method.releaseConnection();
        }
        return serviceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ServiceType checkIfDods(String location) throws IOException {
        ServiceType serviceType;
        HttpMethod method = null;
        try {
            Header h;
            method = new HeadMethod(location + ".dds");
            method.setFollowRedirects(true);
            int status = httpClient.executeMethod(method);
            if (status == 200 && (h = method.getResponseHeader("Content-Description")) != null && h.getValue() != null) {
                String v = h.getValue();
                if (!v.equalsIgnoreCase("dods-dds")) {
                    if (!v.equalsIgnoreCase("dods_dds")) throw new IOException("OPeNDAP Server Error= " + method.getResponseBodyAsString());
                }
                ServiceType serviceType2 = ServiceType.OPENDAP;
                Object var7_6 = null;
                if (method == null) return serviceType2;
                method.releaseConnection();
                return serviceType2;
            }
            if (status == 401) {
                throw new IOException("Unauthorized to open dataset " + location);
            }
            serviceType = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (method == null) throw throwable;
            method.releaseConnection();
            throw throwable;
        }
        Object var7_7 = null;
        if (method == null) return serviceType;
        method.releaseConnection();
        return serviceType;
    }

    public static void setHttpClient(HttpClient client) {
        httpClient = client;
    }

    private static synchronized void initHttpClient() {
        if (httpClient != null) {
            return;
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        httpClient = new HttpClient(connectionManager);
    }

    private static NetcdfFile acquireDODS(FileCache cache, FileFactory factory, Object hashKey, String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (cache == null) {
            return new DODSNetcdfFile(location, cancelTask);
        }
        if (factory == null) {
            factory = new DodsFactory();
        }
        return (NetcdfFile)cache.acquire(factory, hashKey, location, buffer_size, cancelTask, spiObject);
    }

    private static NetcdfFile acquireNcml(FileCache cache, FileFactory factory, Object hashKey, String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (cache == null) {
            return NcMLReader.readNcML(location, cancelTask);
        }
        if (factory == null) {
            factory = new NcMLFactory();
        }
        return (NetcdfFile)cache.acquire(factory, hashKey, location, buffer_size, cancelTask, spiObject);
    }

    private static NetcdfFile acquireRemote(FileCache cache, FileFactory factory, Object hashKey, String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (cache == null) {
            return new CdmRemote(location);
        }
        if (factory == null) {
            factory = new RemoteFactory();
        }
        return (NetcdfFile)cache.acquire(factory, hashKey, location, buffer_size, cancelTask, spiObject);
    }

    public Aggregation getAggregation() {
        return this.agg;
    }

    public void setAggregation(Aggregation agg) {
        this.agg = agg;
    }

    public List<CoordinateSystem> getCoordinateSystems() {
        return this.coordSys;
    }

    public String getConventionUsed() {
        return this.convUsed;
    }

    public EnumSet<Enhance> getEnhanceMode() {
        return this.enhanceMode;
    }

    public List<CoordinateTransform> getCoordinateTransforms() {
        return this.coordTransforms;
    }

    public List<CoordinateAxis> getCoordinateAxes() {
        return this.coordAxes;
    }

    public void clearCoordinateSystems() {
        this.coordSys = new ArrayList<CoordinateSystem>();
        this.coordAxes = new ArrayList<CoordinateAxis>();
        this.coordTransforms = new ArrayList<CoordinateTransform>();
        for (Variable v : this.getVariables()) {
            VariableEnhanced ve = (VariableEnhanced)((Object)v);
            ve.clearCoordinateSystems();
        }
        this.enhanceMode.remove((Object)Enhance.CoordSystems);
    }

    public CoordinateAxis findCoordinateAxis(AxisType type) {
        if (type == null) {
            return null;
        }
        for (CoordinateAxis v : this.coordAxes) {
            if (type != v.getAxisType()) continue;
            return v;
        }
        return null;
    }

    public CoordinateAxis findCoordinateAxis(String fullName) {
        if (fullName == null) {
            return null;
        }
        for (CoordinateAxis v : this.coordAxes) {
            String n = v.getName();
            if (!fullName.equals(n)) continue;
            return v;
        }
        return null;
    }

    public CoordinateSystem findCoordinateSystem(String name) {
        if (name == null) {
            return null;
        }
        for (CoordinateSystem v : this.coordSys) {
            if (!name.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    public CoordinateTransform findCoordinateTransform(String name) {
        if (name == null) {
            return null;
        }
        for (CoordinateTransform v : this.coordTransforms) {
            if (!name.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.agg != null) {
            this.agg.persistWrite();
        }
        if (this.cache != null) {
            this.unlocked = true;
            this.cache.release(this);
        } else {
            if (this.agg != null) {
                this.agg.close();
            }
            this.agg = null;
            if (this.orgFile != null) {
                this.orgFile.close();
            }
            this.orgFile = null;
        }
    }

    @Override
    public boolean sync() throws IOException {
        this.unlocked = false;
        if (this.agg != null) {
            return this.agg.sync();
        }
        if (this.orgFile != null && this.orgFile.sync()) {
            this.location = this.orgFile.getLocation();
            this.id = this.orgFile.getId();
            this.title = this.orgFile.getTitle();
            this.empty();
            this.convertGroup(this.getRootGroup(), this.orgFile.getRootGroup());
            this.finish();
            EnumSet<Enhance> saveMode = this.enhanceMode;
            this.enhanceMode = EnumSet.noneOf(Enhance.class);
            NetcdfDataset.enhance(this, saveMode, null);
            return true;
        }
        return false;
    }

    @Override
    public void empty() {
        super.empty();
        this.coordSys = new ArrayList<CoordinateSystem>();
        this.coordAxes = new ArrayList<CoordinateAxis>();
        this.coordTransforms = new ArrayList<CoordinateTransform>();
        this.convUsed = null;
    }

    @Override
    public boolean syncExtend() throws IOException {
        boolean wasExtended;
        this.unlocked = false;
        if (this.agg != null) {
            return this.agg.syncExtend(false);
        }
        if (this.orgFile != null && (wasExtended = this.orgFile.syncExtend())) {
            Dimension ndim = this.orgFile.getUnlimitedDimension();
            int newLength = ndim.getLength();
            Dimension udim = this.getUnlimitedDimension();
            udim.setLength(newLength);
            for (Variable v : this.getVariables()) {
                if (!v.isUnlimited()) continue;
                v.setDimensions(v.getDimensions());
            }
            return true;
        }
        return false;
    }

    @Override
    public void writeNcML(OutputStream os, String uri) throws IOException {
        new NcMLWriter().writeXML(this, os, uri);
    }

    public void writeNcMLG(OutputStream os, boolean showCoords, String uri) throws IOException {
        new NcMLGWriter().writeXML(this, os, showCoords, uri);
    }

    public NetcdfDataset(NetcdfFile ncfile) throws IOException {
        this(ncfile, defaultEnhanceMode);
    }

    public NetcdfDataset(NetcdfFile ncfile, boolean enhance) throws IOException {
        this(ncfile, enhance ? defaultEnhanceMode : null);
    }

    public NetcdfDataset(NetcdfFile ncfile, Set<Enhance> mode) throws IOException {
        super(ncfile);
        this.orgFile = ncfile;
        this.spi = null;
        this.convertGroup(this.getRootGroup(), ncfile.getRootGroup());
        this.finish();
        NetcdfDataset.enhance(this, mode, null);
    }

    private void convertGroup(Group g, Group from) {
        for (EnumTypedef et : from.getEnumTypedefs()) {
            g.addEnumeration(et);
        }
        for (Dimension d : from.getDimensions()) {
            g.addDimension(new Dimension(d.getName(), d));
        }
        for (Attribute a : from.getAttributes()) {
            g.addAttribute(a);
        }
        for (Variable v : from.getVariables()) {
            g.addVariable(this.convertVariable(g, v));
        }
        for (Group nested : from.getGroups()) {
            Group nnested = new Group(this, g, nested.getShortName());
            g.addGroup(nnested);
            this.convertGroup(nnested, nested);
        }
    }

    private Variable convertVariable(Group g, Variable v) {
        Variable newVar = v instanceof Sequence ? new SequenceDS(g, (Sequence)v) : (v instanceof Structure ? new StructureDS(g, (Structure)v) : new VariableDS(g, v, false));
        return newVar;
    }

    @Override
    protected Boolean makeRecordStructure() {
        if (this.orgFile == null) {
            return false;
        }
        Boolean hasRecord = (Boolean)this.orgFile.sendIospMessage("AddRecordStructure");
        if (hasRecord == null || !hasRecord.booleanValue()) {
            return false;
        }
        Variable orgV = this.orgFile.getRootGroup().findVariable("record");
        if (orgV == null || !(orgV instanceof Structure)) {
            return false;
        }
        Structure orgStructure = (Structure)orgV;
        Dimension udim = this.getUnlimitedDimension();
        if (udim == null) {
            return false;
        }
        Group root = this.getRootGroup();
        StructureDS newStructure = new StructureDS(this, root, null, "record", udim.getName(), null, null);
        newStructure.setOriginalVariable(orgStructure);
        for (Variable v : this.getVariables()) {
            VariableDS memberV;
            if (!v.isUnlimited()) continue;
            try {
                memberV = (VariableDS)v.slice(0, 0);
            }
            catch (InvalidRangeException e) {
                log.error("Cant slice variable " + v);
                return false;
            }
            memberV.setParentStructure(newStructure);
            newStructure.addMemberVariable(memberV);
        }
        root.addVariable(newStructure);
        this.finish();
        return true;
    }

    public void sort() {
        Collections.sort(this.variables, new VariableComparator());
        Collections.sort(this.coordAxes, new VariableComparator());
    }

    public NetcdfDataset() {
    }

    public NetcdfFile getReferencedFile() {
        return this.orgFile;
    }

    @Override
    public IOServiceProvider getIosp() {
        return this.orgFile == null ? null : this.orgFile.getIosp();
    }

    public void setReferencedFile(NetcdfFile ncfile) {
        this.orgFile = ncfile;
    }

    @Override
    protected String toStringDebug(Object o) {
        return "";
    }

    public void addCoordinateSystem(CoordinateSystem cs) {
        this.coordSys.add(cs);
    }

    public void addCoordinateTransform(CoordinateTransform ct) {
        if (!this.coordTransforms.contains(ct)) {
            this.coordTransforms.add(ct);
        }
    }

    public CoordinateAxis addCoordinateAxis(VariableDS v) {
        if (v == null) {
            return null;
        }
        CoordinateAxis oldVar = this.findCoordinateAxis(v.getName());
        if (oldVar != null) {
            this.coordAxes.remove(oldVar);
        }
        CoordinateAxis ca = v instanceof CoordinateAxis ? (CoordinateAxis)v : CoordinateAxis.factory(this, v);
        this.coordAxes.add(ca);
        if (v.isMemberOfStructure()) {
            Structure parentOrg = v.getParentStructure();
            Structure parent = (Structure)this.findVariable(parentOrg.getNameEscaped());
            parent.replaceMemberVariable(ca);
        } else {
            this.removeVariable(v.getParentGroup(), v.getShortName());
            this.addVariable(ca.getParentGroup(), ca);
        }
        return ca;
    }

    @Override
    public Variable addVariable(Group g, Variable v) {
        if (!(v instanceof VariableDS) && !(v instanceof StructureDS)) {
            throw new IllegalArgumentException("NetcdfDataset variables must be VariableEnhanced objects");
        }
        return super.addVariable(g, v);
    }

    public CoordSysBuilderIF enhance() throws IOException {
        return NetcdfDataset.enhance(this, defaultEnhanceMode, null);
    }

    public void enhance(Set<Enhance> mode) throws IOException {
        NetcdfDataset.enhance(this, mode, null);
    }

    public void setValues(Variable v, int npts, double start, double incr) {
        if ((long)npts != v.getSize()) {
            throw new IllegalArgumentException("bad npts = " + npts + " should be " + v.getSize());
        }
        Array data = Array.makeArray(v.getDataType(), npts, start, incr);
        if (v.getRank() != 1) {
            data = data.reshape(v.getShape());
        }
        v.setCachedData(data, true);
    }

    public void setValues(Variable v, List<String> values) throws IllegalArgumentException {
        Array data = Array.makeArray(v.getDataType(), values);
        if (data.getSize() != v.getSize()) {
            throw new IllegalArgumentException("Incorrect number of values specified for the Variable " + v.getName() + " needed= " + v.getSize() + " given=" + data.getSize());
        }
        if (v.getRank() != 1) {
            data = data.reshape(v.getShape());
        }
        v.setCachedData(data, true);
    }

    public static Array makeArray(DataType dtype, List<String> stringValues) throws NumberFormatException {
        return Array.makeArray(dtype, stringValues);
    }

    @Override
    public String getDetailInfo() {
        Formatter f = new Formatter();
        f.format("NetcdfDataset location= %s%n", this.getLocation());
        f.format("  title= %s%n", this.getTitle());
        f.format("  id= %s%n", this.getId());
        f.format("  fileType= %s%n", this.getFileTypeId());
        f.format("  fileDesc= %s%n", this.getFileTypeDescription());
        f.format("  class= %s%n", this.getClass().getName());
        if (this.orgFile == null) {
            f.format("  has no referenced NetcdfFile%n", new Object[0]);
        } else {
            f.format("%nReferenced File:%n", new Object[0]);
            f.format(this.orgFile.getDetailInfo(), new Object[0]);
        }
        if (this.agg == null) {
            f.format("  has no Aggregation element%n", new Object[0]);
        } else {
            f.format("%nAggregation:%n", new Object[0]);
            this.agg.getDetailInfo(f);
        }
        return f.toString();
    }

    void dumpClasses(Group g, PrintStream out) {
        out.println("Dimensions:");
        for (Dimension ds : g.getDimensions()) {
            out.println("  " + ds.getName() + " " + ds.getClass().getName());
        }
        out.println("Atributes:");
        for (Attribute a : g.getAttributes()) {
            out.println("  " + a.getName() + " " + a.getClass().getName());
        }
        out.println("Variables:");
        this.dumpVariables(g.getVariables(), out);
        out.println("Groups:");
        for (Group nested : g.getGroups()) {
            out.println("  " + nested.getName() + " " + nested.getClass().getName());
            this.dumpClasses(nested, out);
        }
    }

    private void dumpVariables(List<Variable> vars, PrintStream out) {
        for (Variable v : vars) {
            out.print("  " + v.getName() + " " + v.getClass().getName());
            if (v instanceof CoordinateAxis) {
                out.println("  " + (Object)((Object)((CoordinateAxis)v).getAxisType()));
            } else {
                out.println();
            }
            if (!(v instanceof Structure)) continue;
            this.dumpVariables(((Structure)v).getVariables(), out);
        }
    }

    public static void debugDump(PrintStream out, NetcdfDataset ncd) {
        String referencedLocation = ncd.orgFile == null ? "(null)" : ncd.orgFile.getLocation();
        out.println("\nNetcdfDataset dump = " + ncd.getLocation() + " uri= " + referencedLocation + "\n");
        ncd.dumpClasses(ncd.getRootGroup(), out);
    }

    @Override
    public String getFileTypeId() {
        if (this.orgFile != null) {
            return this.orgFile.getFileTypeId();
        }
        if (this.agg != null) {
            return this.agg.getFileTypeId();
        }
        return "N/A";
    }

    @Override
    public String getFileTypeDescription() {
        if (this.orgFile != null) {
            return this.orgFile.getFileTypeDescription();
        }
        if (this.agg != null) {
            return this.agg.getFileTypeDescription();
        }
        return "N/A";
    }

    public void check(Formatter f) {
        for (Variable v : this.getVariables()) {
            Variable orgVar;
            VariableDS vds = (VariableDS)v;
            if (vds.getOriginalDataType() != vds.getDataType()) {
                f.format("Variable %s has type %s, org = %s%n", new Object[]{vds.getName(), vds.getOriginalDataType(), vds.getDataType()});
            }
            if (vds.getOriginalVariable() == null || (orgVar = vds.getOriginalVariable()).getRank() == vds.getRank()) continue;
            f.format("Variable %s has rank %d, org = %d%n", vds.getName(), vds.getRank(), orgVar.getRank());
        }
    }

    public static void main(String[] arg) throws IOException {
        String usage = "usage: ucar.nc2.dataset.NetcdfDataset -in <fileIn> -out <fileOut> [-isLargeFile]";
        if (arg.length < 4) {
            System.out.println(usage);
            System.exit(0);
        }
        boolean isLargeFile = false;
        String datasetIn = null;
        String datasetOut = null;
        for (int i = 0; i < arg.length; ++i) {
            String s = arg[i];
            if (s.equalsIgnoreCase("-in")) {
                datasetIn = arg[i + 1];
            }
            if (s.equalsIgnoreCase("-out")) {
                datasetOut = arg[i + 1];
            }
            if (!s.equalsIgnoreCase("-isLargeFile")) continue;
            isLargeFile = true;
        }
        if (datasetIn == null || datasetOut == null) {
            System.out.println(usage);
            System.exit(0);
        }
        NetcdfFile ncfileIn = NetcdfDataset.openFile(datasetIn, null);
        System.out.println("Read from " + datasetIn + " write to " + datasetOut);
        NetcdfFile ncfileOut = FileWriter.writeToFile(ncfileIn, datasetOut, false, -1, isLargeFile);
        ncfileIn.close();
        ncfileOut.close();
        System.out.println("NetcdfFile written = " + ncfileOut);
    }

    private class VariableComparator
    implements Comparator {
        private VariableComparator() {
        }

        public int compare(Object o1, Object o2) {
            String cs2;
            VariableEnhanced v1 = (VariableEnhanced)o1;
            VariableEnhanced v2 = (VariableEnhanced)o2;
            List<CoordinateSystem> list1 = v1.getCoordinateSystems();
            String cs1 = list1.size() > 0 ? list1.get(0).getName() : "";
            List<CoordinateSystem> list2 = v2.getCoordinateSystems();
            String string = cs2 = list2.size() > 0 ? list2.get(0).getName() : "";
            if (cs2.equals(cs1)) {
                return v1.getName().compareToIgnoreCase(v2.getName());
            }
            return cs1.compareToIgnoreCase(cs2);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    private static class RemoteFactory
    implements FileFactory {
        private RemoteFactory() {
        }

        public NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
            return new CdmRemote(location);
        }
    }

    private static class NcMLFactory
    implements FileFactory {
        private NcMLFactory() {
        }

        public NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
            return NcMLReader.readNcML(location, cancelTask);
        }
    }

    private static class DodsFactory
    implements FileFactory {
        private DodsFactory() {
        }

        public NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
            return new DODSNetcdfFile(location, cancelTask);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyNetcdfDatasetFactory
    implements FileFactory {
        String location;
        EnumSet<Enhance> enhanceMode;

        MyNetcdfDatasetFactory(String location, Set<Enhance> enhanceMode) {
            this.location = location;
            this.enhanceMode = enhanceMode == null ? EnumSet.noneOf(Enhance.class) : EnumSet.copyOf(enhanceMode);
        }

        @Override
        public NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
            return NetcdfDataset.openDataset(location, this.enhanceMode, buffer_size, cancelTask, iospMessage);
        }

        public int hashCode() {
            int result = this.location.hashCode();
            result += 37 * result + this.enhanceMode.hashCode();
            return result;
        }
    }

    private static class MyNetcdfFileFactory
    implements FileFactory {
        private MyNetcdfFileFactory() {
        }

        public NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
            return NetcdfDataset.openFile(location, buffer_size, cancelTask, iospMessage);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Enhance {
        ScaleMissing,
        ScaleMissingDefer,
        CoordSystems,
        ConvertEnums;

    }
}

