/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.crawl;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import ucar.nc2.util.CancelTask;

public class CatalogCrawler {
    public static final int USE_ALL = 0;
    public static final int USE_ALL_DIRECT = 1;
    public static final int USE_FIRST_DIRECT = 2;
    public static final int USE_RANDOM_DIRECT = 3;
    public static final int USE_RANDOM_DIRECT_NOT_FIRST_OR_LAST = 4;
    private boolean skipDatasetScan = false;
    private int type = 0;
    private Listener listen;
    private Random random;
    private int countCatrefs;

    public CatalogCrawler(int type, boolean skipDatasetScan, Listener listen) {
        this.type = type;
        this.skipDatasetScan = skipDatasetScan;
        this.listen = listen;
        if (type == 3 || type == 4) {
            this.random = new Random(System.currentTimeMillis());
        }
    }

    public int crawl(String catUrl, CancelTask task, PrintStream out) {
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
        InvCatalogImpl cat = catFactory.readXML(catUrl);
        StringBuilder buff = new StringBuilder();
        boolean isValid = cat.check(buff, false);
        if (out != null) {
            out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
            out.println(" validation output=\n" + buff);
        }
        if (isValid) {
            return this.crawl(cat, task, out);
        }
        return 0;
    }

    public int crawl(InvCatalogImpl cat, CancelTask task, PrintStream out) {
        if (out != null) {
            out.println("***CATALOG " + cat.getCreateFrom());
        }
        this.countCatrefs = 0;
        for (InvDataset ds : cat.getDatasets()) {
            if (this.type == 0) {
                this.crawlDataset(ds, task, out);
            } else {
                this.crawlDirectDatasets(ds, task, out);
            }
            if (task == null || !task.isCancel()) continue;
            break;
        }
        return 1 + this.countCatrefs;
    }

    public void crawlDataset(InvDataset ds, CancelTask task, PrintStream out) {
        InvCatalogRef catref;
        boolean skipScanChildren;
        boolean isCatRef = ds instanceof InvCatalogRef;
        boolean isDataScan = ds.findProperty("DatasetScan") != null;
        boolean bl = skipScanChildren = this.skipDatasetScan && ds instanceof InvCatalogRef && isDataScan;
        if (isCatRef) {
            catref = (InvCatalogRef)ds;
            if (out != null) {
                out.println(" **CATREF " + catref.getURI() + " (" + ds.getName() + ") ");
            }
            ++this.countCatrefs;
            if (!this.listen.getCatalogRef(catref)) {
                catref.release();
                return;
            }
        }
        if (!isCatRef || skipScanChildren || isDataScan) {
            this.listen.getDataset(ds);
        }
        if (!skipScanChildren) {
            List<InvDataset> dlist = ds.getDatasets();
            if (isCatRef) {
                InvCatalogRef catref2 = (InvCatalogRef)ds;
                if (!isDataScan) {
                    this.listen.getDataset(catref2.getProxyDataset());
                }
            }
            for (InvDataset dds : dlist) {
                this.crawlDataset(dds, task, out);
                if (task == null || !task.isCancel()) continue;
                break;
            }
        }
        if (isCatRef) {
            catref = (InvCatalogRef)ds;
            catref.release();
        }
    }

    public void crawlDirectDatasets(InvDataset ds, CancelTask task, PrintStream out) {
        boolean skipScanChildren;
        boolean isCatRef = ds instanceof InvCatalogRef;
        boolean bl = skipScanChildren = this.skipDatasetScan && ds instanceof InvCatalogRef && ds.findProperty("DatasetScan") != null;
        if (isCatRef) {
            InvCatalogRef catref = (InvCatalogRef)ds;
            if (out != null) {
                out.println(" **CATREF " + catref.getURI() + " (" + ds.getName() + ") ");
            }
            ++this.countCatrefs;
            if (!this.listen.getCatalogRef(catref)) {
                catref.release();
                return;
            }
        }
        List<InvDataset> dlist = ds.getDatasets();
        ArrayList<InvDataset> leaves = new ArrayList<InvDataset>();
        for (InvDataset dds : dlist) {
            if (!dds.hasAccess()) continue;
            leaves.add(dds);
        }
        if (leaves.size() > 0) {
            if (this.type == 2) {
                InvDataset dds = (InvDataset)leaves.get(0);
                this.listen.getDataset(dds);
            } else if (this.type == 3) {
                this.listen.getDataset(this.chooseRandom(leaves));
            } else if (this.type == 4) {
                this.listen.getDataset(this.chooseRandomNotFirstOrLast(leaves));
            } else {
                for (InvDataset dds : leaves) {
                    this.listen.getDataset(dds);
                    if (task == null || !task.isCancel()) continue;
                    break;
                }
            }
        }
        if (!skipScanChildren) {
            for (InvDataset dds : dlist) {
                if (dds.hasNestedDatasets()) {
                    this.crawlDirectDatasets(dds, task, out);
                }
                if (task == null || !task.isCancel()) continue;
                break;
            }
        }
        if (ds instanceof InvCatalogRef) {
            InvCatalogRef catref = (InvCatalogRef)ds;
            catref.release();
        }
    }

    private InvDataset chooseRandom(List datasets) {
        int index = this.random.nextInt(datasets.size());
        return (InvDataset)datasets.get(index);
    }

    private InvDataset chooseRandomNotFirstOrLast(List datasets) {
        int index = this.random.nextInt(datasets.size());
        if (index == 0 && datasets.size() > 1) {
            ++index;
        } else if (index == datasets.size() - 1 && datasets.size() > 1) {
            --index;
        }
        return (InvDataset)datasets.get(index);
    }

    public static interface Listener {
        public void getDataset(InvDataset var1);

        public boolean getCatalogRef(InvCatalogRef var1);
    }
}

