//################################### turenas.dsp ########################################
// A simple smart phone percussion based on an additive synthesizer.
//
// ## `SmartKeyboard` Use Strategy
//
// Since the sounds generated by this synth are very short, the strategy here is to take
// advantage of the polyphony capabilities of the iOSKeyboard architecture by creating
// a new voice every time a new key is pressed. Since the `SmartKeyboard` interface has a 
// large number of keys here (180), lots of sounds are generated when sliding a 
// finger across the keyboard.
//
// Author: Romain Michon (rmichon_at_ccrma_dot_stanford_dot_edu)
// 06/17/2016
//########################################################################################

declare name "turenas";

import("stdfaust.lib");

//========================= Smart Keyboard Configuration ================================= 
// (10 keyboards with 18 keys each configured as a pitch matrix.
//========================================================================================

declare interface "SmartKeyboard{
	'nKeyb':'10',
	'keyb0_nKeys':'18',
	'keyb1_nKeys':'18',
	'keyb2_nKeys':'18',
	'keyb3_nKeys':'18',
	'keyb4_nKeys':'18',
	'keyb5_nKeys':'18',
	'keyb6_nKeys':'18',
	'keyb7_nKeys':'18',
	'keyb8_nKeys':'18',
	'keyb9_nKeys':'18',
	'keyb0_lowestKey':'50',
	'keyb1_lowestKey':'55',
	'keyb2_lowestKey':'60',
	'keyb3_lowestKey':'65',
	'keyb4_lowestKey':'70',
	'keyb5_lowestKey':'75',
	'keyb6_lowestKey':'80',
	'keyb7_lowestKey':'85',
	'keyb8_lowestKey':'90',
	'keyb9_lowestKey':'95',
	'keyb0_showNotesName':'0',
	'keyb1_showNotesName':'0',
	'keyb2_showNotesName':'0',
	'keyb3_showNotesName':'0',
	'keyb4_showNotesName':'0',
	'keyb5_showNotesName':'0',
	'keyb6_showNotesName':'0',
	'keyb7_showNotesName':'0',
	'keyb8_showNotesName':'0',
	'keyb9_showNotesName':'0'
}";

//================================ Instrument Parameters =================================
// Creates the connection between the synth and the mobile device
//========================================================================================

// SmartKeyboard Y parameter
y = hslider("y",0,0,1,0.01);
// Smart Keyboard frequency parameter
freq = hslider("freq",400,50,2000,0.01);
// SmartKeyboard gate parameter
gate = button("gate");
// mode resonance duration is controlled with the x axis of the accelerometer
res = hslider("res[acc: 0 0 -10 0 10]",2.5,0.01,5,0.01);

//=================================== Parameters Mapping =================================
//========================================================================================

// number of modes
nModes = 6;
// distance between each mode
maxModeSpread = 5;
modeSpread = y*maxModeSpread;
// computing modes frequency ratio
modeFreqRatios = par(i,nModes,1+(i+1)/nModes*modeSpread);
// computing modes gain
minModeGain = 0.3;
modeGains = par(i,nModes,1-(i+1)/(nModes*minModeGain));
// smoothed mode resonance
modeRes = res : si.smoo;

//============================================ DSP =======================================
//========================================================================================

process = sy.additiveDrum(freq,modeFreqRatios,modeGains,0.8,0.001,modeRes,gate)*0.5;



















