/*
 * Decompiled with CFR 0.152.
 */
package dumphd.bdplus;

import dumphd.util.ByteArray;
import dumphd.util.ByteSource;
import dumphd.util.Utils;
import java.io.IOException;

public class Segment {
    public static final int PATCH_LENGTH = 5;
    private int segmentIndex = 0;
    private long segmentOffset = 0L;
    private long entries = 0L;
    private byte[] indexData = null;
    private byte[] entryData = null;

    public Segment(int index) {
        this.segmentIndex = index;
    }

    public Segment(ByteSource source, int index) throws IOException {
        this.segmentIndex = index;
        this.segmentOffset = source.getPosition();
        if (source.read(Utils.buffer, 0, 4) != 4) {
            throw new IOException("Unexpected EOF, segment too small for header");
        }
        this.entries = ByteArray.getVarLong(Utils.buffer, 0, 4);
        this.indexData = new byte[4 * (int)this.entries];
        if (source.read(this.indexData, 0, this.indexData.length) != this.indexData.length) {
            throw new IOException("Unexpected EOF, segment too small for index data");
        }
        this.entryData = new byte[16 * (int)this.entries];
        if (source.read(this.entryData, 0, this.entryData.length) != this.entryData.length) {
            throw new IOException("Unexpected EOF, segment too small for entry data");
        }
    }

    public int parse(byte[] raw, int offset) throws IndexOutOfBoundsException {
        this.segmentOffset = offset;
        this.entries = ByteArray.getVarLong(raw, offset, 4);
        this.indexData = new byte[4 * (int)this.entries];
        System.arraycopy(raw, offset += 4, this.indexData, 0, this.indexData.length);
        this.entryData = new byte[16 * (int)this.entries];
        System.arraycopy(raw, offset += this.indexData.length, this.entryData, 0, this.entryData.length);
        return offset += this.entryData.length;
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public long getSegmentOffset() {
        return this.segmentOffset;
    }

    public int size() {
        return (int)this.entries;
    }

    public long getBase(int index) {
        return ByteArray.getUInt(this.indexData, index * 4);
    }

    public int getFlags(int index) {
        return this.entryData[index * 16] & 0xFF;
    }

    public long getAdjust0(int index) {
        return ByteArray.getUShort(this.entryData, index * 16 + 1) >>> 4 & 0xFFF;
    }

    public long getAdjust1(int index) {
        return ByteArray.getUShort(this.entryData, index * 16 + 2) & 0xFFF;
    }

    public long getOffset0(int index) {
        return ByteArray.getUByte(this.entryData, index * 16 + 4);
    }

    public long getOffset1(int index) {
        return ByteArray.getUByte(this.entryData, index * 16 + 5);
    }

    public void getPatch0(int index, byte[] dst, int offset) {
        System.arraycopy(this.entryData, index * 16 + 6, dst, offset, 5);
    }

    public void getPatch1(int index, byte[] dst, int offset) {
        System.arraycopy(this.entryData, index * 16 + 11, dst, offset, 5);
    }

    public long getAddress0(int index) {
        return (this.getBase(index) + this.getAdjust0(index)) * 192L + this.getOffset0(index);
    }

    public long getAddress1(int index) {
        return (this.getBase(index) + this.getAdjust0(index) + this.getAdjust1(index)) * 192L + this.getOffset1(index);
    }
}

