/*******************************************************************************

  Intel Data Center Bridging (DCB) Software
  Copyright(c) 2007-2009 Intel Corporation.

  This program is free software; you can redistribute it and/or modify it
  under the terms and conditions of the GNU General Public License,
  version 2, as published by the Free Software Foundation.

  This program is distributed in the hope it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

  The full GNU General Public License is included in this distribution in
  the file called "COPYING".

  Contact Information:
  e1000-eedc Mailing List <e1000-eedc@lists.sourceforge.net>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497

*******************************************************************************/

#ifndef CLIF_CMDS_H
#define CLIF_CMDS_H

#include <sys/stat.h>
#include <sys/un.h>
#include "dcbd.h"

/* Client interface versions */
/* Version 2
 *   DCBX subtype field added to peer commands
 *   Priority Group feature adds 'number of TC's supported'
 *   Priority Flow Control feature adds 'number of TC's supported'
 *   BCN feature is added
*/
#define CLIF_EV_VERSION 2
#define CLIF_MSG_VERSION 2
#define CLIF_RSP_VERSION CLIF_MSG_VERSION

/* Client interface global command codes */
#define UNKNOWN_CMD  '.'
#define PING_CMD     'P'
#define LEVEL_CMD    'L'
#define ATTACH_CMD   'A'
#define DETACH_CMD   'D'
#define DCB_CMD      'C'
#define EVENT_MSG    'E'
#define CMD_RESPONSE 'R'

/* Client interface DCB command codes */
#define CMD_GET_CONFIG  1
#define CMD_SET_CONFIG  2
#define CMD_GET_OPER    3
#define CMD_GET_PEER    4

/* Client interface Feature codes */
#define FEATURE_DCB    1
#define FEATURE_PG     2
#define FEATURE_PFC    3
#define FEATURE_BCN    4
#define FEATURE_APP    5
#define FEATURE_LLINK  6
#define FEATURE_DCBX       0xfe
#define FEATURE_PG_DESC    0xff

/* Client interface DCB event message field offsets */
#define EV_MSG_OFF      0
#define EV_LEVEL_OFF    1
#define EV_GENMSG_OFF   2  /* for unformatted non-DCB event messages */
#define EV_VERSION_OFF  2  /* for DCB event messages */
#define EV_PORT_LEN_OFF 3
#define EV_PORT_LEN_LEN 2
#define EV_PORT_ID_OFF  (EV_PORT_LEN_OFF + EV_PORT_LEN_LEN)

/* DCB event message offsets (after port id field) */
#define EV_FEATURE_OFF      0
#define EV_SUBTYPE_OFF      2
#define EV_OP_MODE_CHG_OFF  4
#define EV_OP_CFG_CHG_OFF   5

/* Client interface DCB command message field offsets */
#define CLIF_CMD_OFF    0
#define CLIF_CMD_LEN    1
#define DCB_VER_OFF     (CLIF_CMD_OFF + CLIF_CMD_LEN)
#define DCB_VER_LEN     1
#define DCB_CMD_OFF     (DCB_VER_OFF + DCB_VER_LEN)
#define DCB_CMD_LEN     2
#define DCB_FEATURE_OFF (DCB_CMD_OFF + DCB_CMD_LEN)
#define DCB_FEATURE_LEN 2
#define DCB_SUBTYPE_OFF (DCB_FEATURE_OFF + DCB_FEATURE_LEN)
#define DCB_SUBTYPE_LEN 2
#define DCB_PORTLEN_OFF (DCB_SUBTYPE_OFF + DCB_SUBTYPE_LEN)
#define DCB_PORTLEN_LEN 2
#define DCB_PORT_OFF    (DCB_PORTLEN_OFF + DCB_PORTLEN_LEN)

/* DCBX configuration commands do not need to have a port field */
#define DCBX_CFG_OFF (DCB_FEATURE_OFF + DCB_FEATURE_LEN)

/* Client interface DCB command response message field offsets */
#define CLIF_RSP_MSG_OFF    0
#define CLIF_RSP_MSG_LEN    1
#define CLIF_STAT_OFF    (CLIF_RSP_MSG_OFF + CLIF_RSP_MSG_LEN)
#define CLIF_STAT_LEN    2
#define CLIF_RSP_OFF     (CLIF_STAT_OFF + CLIF_STAT_LEN)

/* Offset into the DCB protocol data section of the client
 * interface message.
 * GetConfig and SetConfig commands */
#define CFG_ENABLE      0
#define CFG_ADVERTISE   1
#define CFG_WILLING     2
#define CFG_LEN         3

/* Offset into the DCB protocol data section of the client
 * interface message.
 * GetOper commands */
#define OPER_OPER_VER   0
#define OPER_MAX_VER    2
#define OPER_ERROR      4
#define OPER_OPER_MODE  6
#define OPER_SYNCD      7
#define OPER_LEN        8

/* Offset into the DCB protocol data section of the client
 * interface message.
 * GetPeer command */
#define PEER_ENABLE     0
#define PEER_WILLING    1
#define PEER_OPER_VER   2
#define PEER_MAX_VER    4
#define PEER_ERROR      6
#define PEER_SUBTYPE    7
#define PEER_LEN        8

/* DCB status data offset */
#define DCB_STATE       0

/* DCB State configuration data length */
#define CFG_DCB_DLEN    1

/* DCBX Version configuration data offset */
#define DCBX_VERSION  0

/* DCBX configuration data length
 * Does not include the Operational version */
#define CFG_DCBX_DLEN   1

/* Priority Flow Control configuration data offsets */
#define PFC_UP(i)         (i)
#define PFC_NUM_TC        (PFC_UP(8))

/* Priority Flow Control configuration data length */
#define CFG_PFC_DLEN      (PFC_NUM_TC+1)

/* Priority Groups configuration data offsets */
#define PG_UP2TC(i)       (i)
#define PG_PG_PCNT(i)     (PG_UP2TC(8)     + (2*i))
#define PG_UP_PGID(i)     (PG_PG_PCNT(8)   +    i)
#define PG_UP_PCNT(i)     (PG_UP_PGID(8)   + (2*i))
#define PG_UP_STRICT(i)   (PG_UP_PCNT(8)   +    i)
#define PG_UP_NUM_TC      (PG_UP_STRICT(8))

/* Priority Groups configuration data length */
#define CFG_PG_DLEN      (PG_UP_NUM_TC+1)

/* Application configuration data offsets */
#define APP_LEN           0
#define APP_DATA          2

/* Priority group description data offsets */
#define PG_DESC_PGID          0
#define PG_DESC_LEN           1
#define PG_DESC_DATA          3

#define PG_DESC_GET_DLEN      1
#define PG_DESC_SET_DLEN      3


/* Logical link data offsets */
#define LLINK_STATUS          0
#define LLINK_DLEN            1

#define CLIF_NOT_SUPPLIED 'x'

#define CHANGED   "changed"
#define NOCHANGE   "no change"

/* max buffer length needed for a field with an unsigned char length */
#define MAX_U8_BUF 256

/* max buffer length for a clif message */
#define MAX_CLIF_MSGBUF 1024

void process_clif_cmd(  struct dcbd_data *dd,
			struct sockaddr_un *from,
			socklen_t fromlen,
			char *ibuf, int ilen, char *rbuf, int *rlen);

#endif /* CLIF_CMDS_H */
