//
// C++ Interface: FavouriteHubs
//
//
//
// Author: Rikard Björklind <olof@linux.nu>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef FAVOURITE_HUBS_H__
#define FAVOURITE_HUBS_H__

#include <boost/shared_ptr.hpp>

#include <QWidget>
#include <QAbstractTableModel>
#include <QItemDelegate>

#include "ui_favouritehublist.h"

#include "rpctypes.h"
#include "backendconnection.h"


//! Implements the favourite hub list user interface
class FavouriteHubs : public QWidget
{
    Q_OBJECT
public:
    FavouriteHubs( const BackendConnectionPtr& backendConn,
				   QWidget* parent=0);
    ~FavouriteHubs()
    {}

public slots:
	//! Called to set the list of favourite hubs.
	void setHubs(const QList<rpc_types::FavouriteHub>& hubs)
    {
        model->setHubs(hubs);
    }
	//! Called when a hub has been added.
    void addHub(const rpc_types::FavouriteHub& e)
    {
        model->addHub(e);
    }
	//! Called when a hub has been removed.
    void removeHub(const string& e)
    {
        model->removeHub(e);
    }
	
	void refresh();
	
private slots:
	void on_connectFavouriteButton_clicked();
	
	//! Called to execute a remove request to the backend.
	void on_removeFavouriteButton_clicked();
	
	void on_addFavouriteButton_clicked();
	
	void on_favouriteHubList_doubleClicked();
	
	void createPersistentEditors();
		
signals:
	void close();
	
private:
	class FavouriteHubsModel;
	class CheckBoxDelegate;
	boost::shared_ptr<FavouriteHubsModel> model;
	boost::shared_ptr<CheckBoxDelegate> delegate;
	
	Ui::FavouriteHubsForm ui;
	
	BackendConnectionPtr backendConnection;
		
	class CheckBoxDelegate : public QItemDelegate
	{
	public:
		CheckBoxDelegate(QObject *parent = 0);
		//! Returns the editor widget used for editing the given index
		QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,const QModelIndex &index) const;
		//! Set the data to be edited in the given editor
		void setEditorData(QWidget *editor, const QModelIndex &index) const;
		
		void setModelData(QWidget *editor, QAbstractItemModel *model,const QModelIndex &index) const;
		void updateEditorGeometry(QWidget *editor,const QStyleOptionViewItem &option, const QModelIndex &index) const;
	};
	
	class FavouriteHubsModel : public QAbstractTableModel
	{
		friend class CheckBoxDelegate;
	public:
		FavouriteHubsModel(QWidget* parent=0) : QAbstractTableModel( parent )
		{}
		~FavouriteHubsModel()
		{}
		
		// QAbstractTableModel methods...
		int rowCount ( const QModelIndex& ) const
		{
		return entries.size();
		}
		int columnCount ( const QModelIndex& ) const
		{
		return 7;
		}
		QVariant data ( const QModelIndex & index, int role = Qt::DisplayRole ) const;
		QVariant headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;
		
		QString getServer(int row) const
		{
			return entries.at(row).server.c_str();
		}
		
		//! AbstractItemView overload. Called by the view when editing.
		virtual bool setData ( const QModelIndex & index, const QVariant & value, int role = Qt::EditRole );
		virtual Qt::ItemFlags flags ( const QModelIndex & index ) const;
		
		void setHubs(const QList<rpc_types::FavouriteHub>&);
		void addHub(const rpc_types::FavouriteHub&);
		void removeHub(const string&);
	protected:
		rpc_types::FavouriteHub getHubData( const QModelIndex& index ) const;
			
	private:
		QList<rpc_types::FavouriteHub> entries;
	};
};


#endif













