/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.tool;

import java.io.FileOutputStream;
import java.util.List;
import net.sf.jiapi.file.ClassFile;
import net.sf.jiapi.file.Method;
import net.sf.jiapi.file.ProgramElement;
import net.sf.jiapi.file.attribute.Attribute;

public class ClassTool {
    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println("ClassTool <file.class> remove-attribute <name>");
            System.exit(0);
        }
        ClassTool ct = new ClassTool();
        ClassFile cf = ClassFile.parse((String)args[0]);
        if ("remove-attribute".equals(args[1])) {
            if (args.length == 3) {
                ct.removeAttribute((ProgramElement)cf, args[2]);
            } else {
                ct.removeAttribute(cf, args[2], args[3]);
            }
        }
        byte[] bytes = cf.toBytes();
        FileOutputStream fos = new FileOutputStream(args[0]);
        fos.write(bytes);
        fos.close();
    }

    public void removeAttribute(ProgramElement cf, String name) {
        List attrs = cf.getAttributes();
        boolean found = false;
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute a = (Attribute)attrs.get(i);
            if (!name.equals(a.getName())) continue;
            attrs.remove(i);
            found = true;
            break;
        }
        if (!found) {
            System.out.println("ERROR: Could not find class attribute " + name);
        }
    }

    public void removeAttribute(ClassFile cf, String method, String name) {
        ProgramElement m = this.findMethod(method, cf.getMethods());
        if (m == null) {
            System.out.println("ERROR: Could not find method " + method);
            return;
        }
        List attrs = m.getAttributes();
        boolean found = false;
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute a = (Attribute)attrs.get(i);
            if (!name.equals(a.getName())) continue;
            attrs.remove(i);
            found = true;
            break;
        }
        if (!found) {
            System.out.println("ERROR: Could not find method attribute " + name);
        }
    }

    private ProgramElement findMethod(String name, List<Method> il) {
        for (Method m : il) {
            if (!name.equals(m.getName())) continue;
            return m;
        }
        return null;
    }
}

