/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 10:34:49 GMT 2018
 */

package uk.ac.sanger.artemis.chado;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.sql.SQLException;
import javax.swing.JPasswordField;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.chado.JdbcDAO;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class JdbcDAO_ESTest extends JdbcDAO_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("Pkc");
      JdbcDAO jdbcDAO0 = null;
      try {
        jdbcDAO0 = new JdbcDAO("Pkc", jPasswordField0);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("NL+zT}", 2164);
      JdbcDAO jdbcDAO0 = null;
      try {
        jdbcDAO0 = new JdbcDAO((String) null, jPasswordField0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseLocationParser", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      JdbcDAO jdbcDAO0 = null;
      try {
        jdbcDAO0 = new JdbcDAO((String) null, jPasswordField0);
        fail("Expecting exception: SQLException");
      
      } catch(Throwable e) {
         //
         // The url cannot be null
         //
         verifyException("java.sql.DriverManager", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("KVy_x}D8H");
      JdbcDAO jdbcDAO0 = null;
      try {
        jdbcDAO0 = new JdbcDAO("KVy_x}D8H", jPasswordField0);
        fail("Expecting exception: SQLException");
      
      } catch(Throwable e) {
         //
         // No suitable driver found for jdbc:postgresql:/null?
         //
         verifyException("java.sql.DriverManager", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      JdbcDAO jdbcDAO0 = null;
      try {
        jdbcDAO0 = new JdbcDAO("0", (JPasswordField) null);
        fail("Expecting exception: SQLException");
      
      } catch(Throwable e) {
         //
         // No suitable driver found for 0
         //
         verifyException("java.sql.DriverManager", e);
      }
  }
}
