/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument.pass1;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.cobertura.instrument.pass1.DetectIgnoredCodeMethodVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.CheckClassAdapter;

public class DetectIgnoredCodeClassVisitor
extends ClassVisitor {
    private Set<Integer> ignoredLineIds = new HashSet<Integer>();
    private Set<String> ignoredMethodNamesAndSignatures = new HashSet<String>();
    private String className;
    private String superName;
    private final AtomicInteger lineIdGenerator = new AtomicInteger(0);
    private final boolean ignoreTrivial;
    private final Set<String> ignoreAnnotations;

    public DetectIgnoredCodeClassVisitor(ClassVisitor cv, boolean ignoreTrivial, Set<String> ignoreAnnotations) {
        super(262144, (ClassVisitor)new CheckClassAdapter(cv, false));
        this.ignoreTrivial = ignoreTrivial;
        this.ignoreAnnotations = ignoreAnnotations;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
        this.superName = superName;
    }

    public MethodVisitor visitMethod(int access, String methodName, String description, String signature, String[] exceptions) {
        MethodVisitor nestedVisitor = super.visitMethod(access, methodName, description, signature, exceptions);
        return new DetectIgnoredCodeMethodVisitor(nestedVisitor, this.ignoredLineIds, this.ignoredMethodNamesAndSignatures, this.ignoreTrivial, this.ignoreAnnotations, this.className, this.superName, methodName, description, this.lineIdGenerator);
    }

    public Set<Integer> getIgnoredLineIds() {
        return this.ignoredLineIds;
    }

    public Set<String> getIgnoredMethodNamesAndSignatures() {
        return this.ignoredMethodNamesAndSignatures;
    }
}

