/*
 * Copyright (c) 2000-2004 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

/*  ArgusSource.h */

#ifndef ArgusSource_h
#define ArgusSource_h

#include <stdio.h>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#include <string.h>
#include <strings.h>

#include <pcap.h>
 
int pcap_read(pcap_t *, int cnt, pcap_handler, u_char *);
int pcap_offline_read(pcap_t *, int, pcap_handler, u_char *);


#include <signal.h>
#include <errno.h>

#include <extract.h>
#include <fddi.h>

#if defined(__NetBSD__)
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#endif

#if !defined(__OpenBSD__)
#include <netinet/if_ether.h>
#endif

#include <netinet/in.h>

#if !defined(__OpenBSD__) || (defined(__OpenBSD__) && !defined(_NETINET_IF_SYSTEM_H_))
#include <netinet/in_systm.h>
#define _NETINET_IF_SYSTEM_H_
#endif

#if defined(__OpenBSD__)
#ifndef _NETINET_IP_H_
#include <netinet/ip.h>
#define _NETINET_IP_H_
#endif
#ifndef _NETINET_UDP_H_
#include <netinet/udp.h>
#define _NETINET_UDP_H_
#endif
#else
#include <netinet/ip.h>
#include <netinet/udp.h>
#endif

#include <netinet/tcp.h>


struct ArgusMoatTshPktHdr {
   unsigned int sec;
   char interface;
   char usec[3];
   struct ip ip;
   struct tcphdr tcp;
};

#define SNOOP_FILE_OFFSET 16

struct ArgusSnoopPktHdr {
    unsigned int len;
    unsigned int tlen;
    unsigned int pad[2];
    struct timeval argtvp;
};

int ArgusSnoopRead (void);

void ArgusEtherPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusSlipPacket  (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusPppPacket  (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusPppBsdosPacket  (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusFddiPacket  (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusATMPacket  (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusIpPacket  (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusSllPacket  (u_char *user, const struct pcap_pkthdr *h, const u_char *p);

struct callback {
   pcap_handler function;
   int type;
   char *fname;
};

pcap_t *ArgusOpenInputPacketFile(char *);
pcap_handler Arguslookup_pcap_callback (int);
void Argusbpf_dump(struct bpf_program *, int);

void setArgusMoatTshFile (int value);
int getArgusMoatTshFile (void);

void setArgusWriteOutPacketFile (char *);
void ArgusGetPackets (void);
 
#define ARGUSLIBPPKTFILE	1
#define ARGUSSNOOPKTFILE	2
#define ARGUSMOATTSHPKTFILE	3

#define ARGUS_MAXINTERFACE	3

struct ArgusSourceStruct {
   int state;
};

struct ArgusInterfaceStruct {
   char *ArgusDevice;
   int index, ArgusInterfaceType;
   unsigned int ArgusLocalNet, ArgusNetMask;
   long long ArgusTotalPkts;
   long long ArgusTotalIPPkts;
   long long ArgusTotalNonIPPkts;
   long long ArgusLastPkts;
   long long ArgusTotalDrop;
   long long ArgusLastDrop;
   long long ArgusTotalBytes;
   long long ArgusLastBytes;
};


#if defined(ArgusSource)

static struct callback callbacks[] = {
   { ArgusEtherPacket,     DLT_EN10MB,      "ArgusEtherPacket()" },
   { ArgusEtherPacket,     DLT_IEEE802,     "ArgusEtherPacket()" },
   { ArgusSlipPacket,      DLT_SLIP,        "ArgusSlipPacket()" },
   { ArgusSlipPacket,      DLT_SLIP_BSDOS,  "ArgusSlipPacket()" },
   { ArgusPppPacket,       DLT_PPP,         "ArgusPppPacket()" },
   { ArgusPppBsdosPacket,  DLT_PPP_BSDOS,   "ArgusPppBsdosPacket()" },
   { ArgusFddiPacket,      DLT_FDDI,        "ArgusFddiPacket()" },
   { ArgusATMPacket,       DLT_ATM_RFC1483, "ArgusATMPacket()" },
   { ArgusIpPacket,        DLT_RAW,         "ArgusIpPacket()" },
#ifdef DLT_LINUX_SLL
   { ArgusSllPacket,       DLT_LINUX_SLL,   "ArgusSllPacket()" },
#endif
   { NULL,                 DLT_NULL,        "NULL" },
   { NULL,                 0,               NULL},
};

struct ArgusSourceStruct *ArgusSourceTask = NULL;
struct ArgusListStruct *ArgusDeviceList = NULL;

char *ArgusInputFilter = NULL;

struct timeval ArgusStartTime, ArgusEndTime;


int kflag = 0;

extern int Argustflag;

int ArgusInterfaceIndex = 0;
struct ArgusInterfaceStruct ArgusInterface[ARGUS_MAXINTERFACE];

pcap_t *ArgusPd[ARGUS_MAXINTERFACE];
struct bpf_program ArgusFilters[ARGUS_MAXINTERFACE];
struct pcap_stat ArgusStats[ARGUS_MAXINTERFACE];

int ArgusInputPacketFileType;
int ArgusReadingOffLine = 0;
int Argusbpflag;

static FILE *ArgusPacketInput;
static pcap_handler ArgusCallBack;


struct arguspcap_sf {
	FILE *rfile;
	int swapped;
	int hdrsize;
	int version_major;
	int version_minor;
	u_char *base;
};

struct arguspcap_md {
	struct pcap_stat stat;
	/*XXX*/
	int use_bpf;		/* using kernel filter */
	u_long	TotPkts;	/* can't oflow for 79 hrs on ether */
	u_long	TotAccepted;	/* count accepted by filter */
	u_long	TotDrops;	/* count of dropped packets */
	long	TotMissed;	/* missed by i/f during this run */
	long	OrigMissed;	/* missed by i/f before this run */
#ifdef linux
	int	sock_packet;	/* using Linux 2.0 compatible interface */
	int	timeout;	/* timeout specified to pcap_open_live */
	int	clear_promisc;	/* must clear promiscuous mode when we close */
	int	cooked;		/* using SOCK_DGRAM rather than SOCK_RAW */
	int	lo_ifindex;	/* interface index of the loopback device */
	char 	*device;	/* device name */
	struct pcap *next;	/* list of open promiscuous sock_packet pcaps */
#endif
};

struct arguspcap {
	int fd;
	int snapshot;
	int linktype;
	int tzoff;		/* timezone offset */
	int offset;		/* offset for proper alignment */

	struct arguspcap_sf sf;
	struct arguspcap_md md;

	/*
	 * Read buffer.
	 */
	int bufsize;
	u_char *buffer;
	u_char *bp;
	int cc;

	/*
	 * Place holder for pcap_next().
	 */
	u_char *pkt;

	
	/*
	 * Placeholder for filter code if bpf not in kernel.
	 */
	struct bpf_program fcode;

	char errbuf[PCAP_ERRBUF_SIZE];
};

static struct arguspcap ArgusPcap;

static int ArgusSnapLen;
static int ArgusOflag = 1;
static int Arguspflag;
static char **ArgusArgv = NULL;
static int ArgusOptind;
static char *Argusrfile = NULL;
static char *ArgusDevice = NULL;
static char *ArgusInfile = NULL;

struct ArgusSourceStruct *ArgusNewSource(void);
void ArgusInitSource(void);
int ArgusDeleteSource(void);

void setArgusOutputTask(void);
void setArgusModeler(void);
 
struct ArgusOutputStruct *getArgusOutputTask(void);
struct ArgusModelerStruct *getArgusModeler(void);

int getArgusbpflag(void);
int getArguspflag(void);
int getArgusOflag(void);

void setArgusbpflag(int);
void setArguspflag(int);
void setArgusOflag(int);

void setArgusArgv(char **);
void setArgusOptind(int);

void setArgusDevice(char *);
void setArgusInfile(char *);
void setArgusrfile(char *);
void setArgusrFile(char *);

char *getArgusDevice(void);
char *getArgusInfile(void);
char *getArgusrfile(void);

void clearArgusDevice(void);

static char *ArgusCopyArgv (char **);
static char *ArgusReadInfile (char *);

int ArgusCreatePktFromFddi(const struct fddi_header *, struct ether_header *, int);

extern char *bpf_image(struct bpf_insn *, int);


#else /* defined(ArgusSource) */

extern char *ArgusInputFilter;

extern long long ArgusTotalPkts;
extern long long ArgusLastPkts;
extern long long ArgusTotalDrop;
extern long long ArgusLastDrop;
extern long long ArgusTotalBytes;
extern long long ArgusLastBytes;

struct timeval ArgusStartTime, ArgusEndTime;

extern int ArgusInterfaceIndex;
extern struct ArgusInterfaceStruct ArgusInterface[ARGUS_MAXINTERFACE];

extern pcap_t *ArgusPd[];
extern struct pcap_stat ArgusStats[];
extern int ArgusInputPacketFileType;
extern int ArgusReadingOffLine;
extern int Argusbpflag;

extern struct ArgusSourceStruct *ArgusSourceTask;
extern struct ArgusSourceStruct *ArgusNewSource(void);
extern void ArgusInitSource(void);
extern int ArgusDeleteSource(void);

extern struct ArgusOutputStruct *getArgusOutputTask(void);
extern void setArgusOutputTask(void);

extern struct ArgusModelerStruct *getArgusModeler(void);
extern void setArgusModeler(void);

extern int getArgusbpflag(void);
extern int getArguspflag(void);
extern int getArgusOflag(void);
extern int getArgusMoatTshFile (void);


extern void setArgusbpflag(int);
extern void setArguspflag(int);
extern void setArgusOflag(int);
extern void setArgusMoatTshFile (int value);

extern void setArgusWriteOutPacketFile (char *);

extern void setArgusArgv(char **);
extern void setArgusOptind(int);

extern void setArgusDevice(char *);
extern void setArgusInfile(char *);
extern void setArgusrfile(char *);

extern char *getArgusDevice(void);
extern char *getArgusInfile(void);
extern char *getArgusrfile(void);

extern void clearArgusDevice(void);

#endif
#endif /* #ifndef ArgusSource_h */
