# 7 How does the history of "anarcho"-capitalism show that it is not
anarchist?

Of course, "anarcho"-capitalism does have historic precedents and
"anarcho"-capitalists spend considerable time trying to co-opt various
individuals into their self-proclaimed tradition of "anti-statist" liberalism.
That, in itself, should be enough to show that anarchism and
"anarcho"-capitalism have little in common as anarchism developed in
opposition to liberalism and its defence of capitalism. Unsurprisingly, these
"anti-state" liberals tended to, at best, refuse to call themselves anarchists
or, at worse, explicitly deny they were anarchists.

One "anarcho"-capitalist overview of their tradition is presented by David M.
Hart. His perspective on anarchism is typical of the school, noting that in
his essay anarchism or anarchist _"are used in the sense of a political theory
which advocates the maximum amount of individual liberty, a necessary
condition of which is the elimination of governmental or other organised
force."_ [David M. Hart, _"Gustave de Molinari and the Anti-statist Liberal
Tradition: Part I"_, pp. 263-290, **Journal of Libertarian Studies**, vol. V,
no. 3, p. 284] Yet anarchism has **never** been solely concerned with
abolishing the state. Rather, anarchists have always raised economic and
social demands and goals along with their opposition to the state. As such,
anti-statism may be a necessary condition to be an anarchist, but not a
sufficient one to count a specific individual or theory as anarchist.

Specifically, anarchists have turned their analysis onto private property
noting that the hierarchical social relationships created by inequality of
wealth (for example, wage labour) restricts individual freedom. This means
that if we do seek _"the maximum of individual liberty"_ then our analysis
cannot be limited to just the state or government. Consequently, to limit
anarchism as Hart does requires substantial rewriting of history, as can be
seen from his account of William Godwin.

Hart tries to co-opt of William Godwin into the ranks of "anti-state"
liberalism, arguing that he _"defended individualism and the right to
property."_ [**Op. Cit.**, p. 265] He, of course, quotes from Godwin to
support his claim yet strangely truncates Godwin's argument to exclude his
conclusion that _"[w]hen the laws of morality shall be clearly understood,
their excellence universally apprehended, and themselves seen to be coincident
with each man's private advantage, the idea of property in this sense will
remain, but no man will have the least desire, for purposes of ostentation or
luxury, to possess more than his neighbours."_ [**An Enquiry into Political
Justice**, p. 199] In other words, personal property (possession) would still
exist but not private property in the sense of capital or inequality of
wealth.

This analysis is confirmed in book 8 of Godwin's classic work entitled _**"On
Property."**_ Needless to say, Hart fails to mention this analysis,
unsurprising as it was later reprinted as a socialist pamphlet. Godwin thought
that the _"subject of property is the key-stone that completes the fabric of
political justice."_ Like Proudhon, Godwin subjects property as well as the
state to an anarchist analysis. For Godwin, there were _"three degrees"_ of
property. The first is possession of things you need to live. The second is
_"the empire to which every man is entitled over the produce of his own
industry."_ The third is _"that which occupies the most vigilant attention in
the civilised states of Europe. It is a system, in whatever manner
established, by which one man enters into the faculty of disposing of the
produce of another man's industry."_ He notes that it is _"clear therefore
that the third species of property is in direct contradiction to the second."_
[**Op. Cit.**, p. 701 and p. 710-2]

Godwin, unlike classical liberals, saw the need to _"point out the evils of
accumulated property,"_ arguing that the the _"spirit of oppression, the
spirit of servility, and the spirit of fraud . . . are the immediate growth of
the established administration of property. They are alike hostile to
intellectual and moral improvement."_ Like the socialists he inspired, Godwin
argued that _"it is to be considered that this injustice, the unequal
distribution of property, the grasping and selfish spirit of individuals, is
to be regarded as one of the original sources of government, and, as it rises
in its excesses, is continually demanding and necessitating new injustice, new
penalties and new slavery."_ He stressed, _"let it never be forgotten that
accumulated property is usurpation."_ [**Op. Cit.**, p. 732, pp. 717-8, and p.
718]

Godwin argued against the current system of property and in favour of _"the
justice of an equal distribution of the good things of life."_ This would be
based on _"[e]quality of conditions, or, in other words, an equal admission to
the means of improvement and pleasure"_ as this _"is a law rigorously enjoined
upon mankind by the voice of justice."_ [**Op. Cit.**, p. 725 and p. 736] Thus
his anarchist ideas were applied to private property, noting like subsequent
anarchists that economic inequality resulted in the loss of liberty for the
many and, consequently, an anarchist society would see a radical change in
property and property rights. As Kropotkin noted, Godwin _"stated in 1793 in a
quite definite form the political and economic principle of Anarchism."_
Little wonder he, like so many others, argued that Godwin was _"the first
theoriser of Socialism without government -- that is to say, of Anarchism."_
[**Environment and Evolution**, p. 62 and p. 26] For Kropotkin, anarchism was
by definition not restricted to purely political issues but also attacked
economic hierarchy, inequality and injustice. As Peter Marshall confirms,
_"Godwin's economics, like his politics, are an extension of his ethics."_
[**Demanding the Impossible**, p. 210]

Godwin's theory of property is significant because it reflected what was to
become standard nineteenth century socialist thought on the matter. In
Britain, his ideas influenced Robert Owen and, as a result, the early
socialist movement in that country. His analysis of property, as noted,
predated Proudhon's classic anarchist analysis. As such, to state, as Hart
did, that Godwin simply _"concluded that the state was an evil which had to be
reduced in power if not eliminated completely"_ while not noting his analysis
of property gives a radically false presentation of his ideas. [Hart, **Op.
Cit.**, p. 265] However, it does fit into his flawed assertion that anarchism
is purely concerned with the state. Any evidence to the contrary is simply
ignored.

## 7.1 Are competing governments anarchism?

No, of course not. Yet according to "anarcho"-capitalism, it is. This can be
seen from the ideas of Gustave de Molinari.

Hart is on firmer ground when he argues that the 19th century French economist
Gustave de Molinari is the true founder of "anarcho"-capitalism. With
Molinari, he argues, _"the two different currents of anarchist thought
converged: he combined the political anarchism of Burke and Godwin with the
nascent economic anarchism of Adam Smith and Say to create a new forms of
anarchism"_ that has been called _"anarcho-capitalism, or free market
anarchism."_ [**Op. Cit.**, p. 269] Of course, Godwin (like other anarchists)
did not limit his anarchism purely to "political" issues and so he discussed
_"economic anarchism"_ as well in his critique of private property (as
Proudhon also did later). As such, to artificially split anarchism into
political and economic spheres is both historically and logically flawed.
While some dictionaries limit "anarchism" to opposition to the state,
anarchists did and do not.

The key problem for Hart is that Molinari refused to call himself an
anarchist. He did not even oppose government, as Hart himself notes Molinari
proposed a system of insurance companies to provide defence of property and
_"called these insurance companies 'governments' even though they did not have
a monopoly within a given geographical area."_ As Hart notes, Molinari was the
sole defender of such free-market justice at the time in France. [David M.
Hart, _"Gustave de Molinari and the Anti-statist Liberal Tradition: Part II"_,
pp. 399-434,Journal of Libertarian Studies, vol. V, no. 4, p. 415 and p. 411]
Molinari was clear that he wanted _"a regime of free government,"_
counterpoising _"monopolist or communist governments"_ to _"free
governments."_ This would lead to _"freedom of government"_ rather than its
abolition (not freedom **from** government). For Molinarie the future would
not bring _"the suppression of the state which is the dream of the anarchists
. . . It will bring the diffusion of the state within society. That is . . .
'a free state in a free society.'"_ [quoted by Hart, **Op. Cit.**, p. 429, p.
411 and p. 422] As such, Molinari can hardly be considered an anarchist, even
if "anarchist" is limited to purely being against government.

Moreover, in another sense Molinari was in favour of the state. As we discuss
in [section 6](append136.md), these companies would have a monopoly within a
given geographical area -- they have to in order to enforce the property
owner's power over those who use, but do not own, the property in question.
The key contradiction can be seen in Molinari's advocating of company towns,
privately owned communities (his term was a _"proprietary company"_). Instead
of taxes, people would pay rent and the _"administration of the community
would be either left in the hands of the company itself or handled special
organisations set up for this purpose."_ Within such a regime _"those with the
most property had proportionally the greater say in matters which affected the
community."_ If the poor objected then they could simply leave. [**Op. Cit.**,
pp. 421-2 and p. 422]

Given this, the idea that Molinari was an anarchist in any form can be
dismissed. His system was based on privatising government, not abolishing it
(as he himself admitted). This would be different from the current system, of
course, as landlords and capitalists would be hiring force directly to enforce
their decisions rather than relying on a state which they control indirectly.
This system, as we proved in [section 6](append136.md), would not be
anarchist as can be seen from American history. There capitalists and
landlords created their own private police forces and armies, which regularly
attacked and murdered union organisers and strikers. As an example, there is
Henry Ford's Service Department (private police force):

> _"In 1932 a hunger march of the unemployed was planned to march up to the
gates of the Ford plant at Dearborn. . . The machine guns of the Dearborn
police and the Ford Motor Company's Service Department killed [four] and
wounded over a score of others. . . Ford was fundamentally and entirely
opposed to trade unions. The idea of working men questioning his prerogatives
as an owner was outrageous . . . [T]he River Rouge plant. . . was dominated by
the autocratic regime of Bennett's service men. Bennett . . organise[d] and
train[ed] the three and a half thousand private policemen employed by Ford.
His task was to maintain discipline amongst the work force, protect Ford's
property [and power], and prevent unionisation. . . Frank Murphy, the mayor of
Detroit, claimed that 'Henry Ford employs some of the worst gangsters in our
city.' The claim was well based. Ford's Service Department policed the gates
of his plants, infiltrated emergent groups of union activists, posed as
workers to spy on men on the line. . . Under this tyranny the Ford worker had
no security, no rights. So much so that any information about the state of
things within the plant could only be freely obtained from ex-Ford workers."_
[Huw Beynon, **Working for Ford**, pp. 29-30]

The private police attacked women workers handing out pro-union handbills and
gave them _"a severe beating."_ At Kansas and Dallas _"similar beatings were
handed out to the union men."_ This use of private police to control the work
force was not unique. General Motors _"spent one million dollars on espionage,
employing fourteen detective agencies and two hundred spies at one time
[between 1933 and 1936]. The Pinkerton Detective Agency found anti-unionism
its most lucrative activity."_ [**Op. Cit.**, p. 34 and p. 32] We must also
note that the Pinkerton's had been selling their private police services for
decades before the 1930s. For over 60 years the Pinkerton Detective Agency had
_"specialised in providing spies, agent provocateurs, and private armed forces
for employers combating labour organisations."_ By 1892 it _"had provided its
services for management in seventy major labour disputes, and its 2 000 active
agents and 30 000 reserves totalled more than the standing army of the
nation."_ [Jeremy Brecher, **Strike!**, p. 55] With this force available,
little wonder unions found it so hard to survive in the USA.

Only an "anarcho"-capitalist would deny that this is a private government,
employing private police to enforce private power. Given that unions could be
considered as "defence" agencies for workers, this suggests a picture of how
"anarcho"-capitalism may work in practice radically different from the
pictures painted by its advocates. The reason is simple, it does not ignore
inequality and subjects economics to an anarchist analysis. Little wonder,
then, that Proudhon stressed that it _"becomes necessary for the workers to
form themselves into democratic societies, with equal conditions for all
members, on pain of a relapse into feudalism."_ Anarchism, in other words,
would see _"[c]apitalistic and proprietary exploitation stopped everywhere,
the wage system abolished"_ and so _"the economic organisation [would]
replac[e] the governmental and military system."_ [**The General Idea of the
Revolution**, p. 227 and p. 281] Clearly, the idea that Proudhon shared the
same political goal as Molinari is a joke. He would have dismissed such a
system as little more than an updated form of feudalism in which the property
owner is sovereign and the workers subjects (see [section B.4](secB4.md) for
more details).

Unsurprisingly, Molinari (unlike the individualist anarchists) attacked the
jury system, arguing that its obliged people to _"perform the duties of
judges. This is pure communism."_ People would _"judge according to the colour
of their opinions, than according to justice."_ [quoted by Hart, **Op. Cit.**,
p. 409] As the jury system used amateurs (i.e. ordinary people) rather than
full-time professionals it could not be relied upon to defend the power and
property rights of the rich. As we noted in [section
1.4](append131.md#secf14), Rothbard criticised the individualist anarchists
for supporting juries for essentially the same reasons.

But, as is clear from Hart's account, Molinari had little concern that working
class people should have a say in their own lives beyond consuming goods. His
perspective can be seen from his lament about those _"colonies where slavery
has been abolished without the compulsory labour being replaced with an
equivalent quantity of free [sic!] labour [i.e., wage labour], there has
occurred the opposite of what happens everyday before our eyes. Simple workers
have been seen to exploit in their turn the industrial **entrepreneurs,**
demanding from them wages which bear absolutely no relation to the legitimate
share in the product which they ought to receive. The planters were unable to
obtain for their sugar a sufficient price to cover the increase in wages, and
were obliged to furnish the extra amount, at first out of their profits, and
then out of their very capital. A considerable number of planters have been
ruined as a result . . . It is doubtless better that these accumulations of
capital should be destroyed than that generations of men should perish [Marx:
'how generous of M. Molinari'] but would it not be better if both survived?"_
[quoted by Karl Marx, **Capital**, vol. 1, p. 937f]

So workers exploiting capital is the _"opposite of what happens everyday
before our eyes"_? In other words, it is normal that entrepreneurs _"exploit"_
workers under capitalism? Similarly, what is a _"legitimate share"_ which
workers _"ought to receive"_? Surely that is determined by the eternal laws of
supply and demand and not what the capitalists (or Molinari) thinks is right?
And those poor former slave drivers, they really do deserve our sympathy. What
horrors they face from the impositions subjected upon them by their ex-
chattels -- they had to reduce their profits! How dare their ex-slaves refuse
to obey them in return for what their ex-owners think was their _"legitimate
share in the produce"_! How _"simple"_ these workers are, not understanding
the sacrifices their former masters suffer nor appreciating how much more
difficult it is for their ex-masters to create _"the product"_ without the
whip and the branding iron to aid them! As Marx so rightly comments: _"And
what, if you please, is this 'legitimate share', which, according to
[Molinari's] own admission, the capitalist in Europe daily neglects to pay?
Over yonder, in the colonies, where the workers are so 'simple' as to
'exploit' the capitalist, M. Molinari feels a powerful itch to use police
methods to set on the right road that law of supply and demand which works
automatically everywhere else."_ [**Op. Cit.**, p. 937f]

An added difficulty in arguing that Molinari was an anarchist is that he was a
contemporary of Proudhon, the first self-declared anarchist, and lived in a
country with a vigorous anarchist movement. Surely if he was really an
anarchist, he would have proclaimed his kinship with Proudhon and joined in
the wider movement. He did not, as Hart notes as regards Proudhon:

> _"their differences in economic theory were considerable, and it is probably
for this reason that Molinari refused to call himself an anarchist in spite of
their many similarities in political theory. Molinari refused to accept the
socialist economic ideas of Proudhon . . . in Molinari's mind, the term
'anarchist' was intimately linked with socialist and statist economic views."_
[**Op. Cit.**, p. 415]

Yet Proudhon's economic views, like Godwin's, flowed from his anarchist
analysis and principles. They cannot be arbitrarily separated as Hart
suggests. So while arguing that _"Molinari was just as much an anarchist as
Proudhon,"_ Hart forgets the key issue. Proudhon was aware that private
property ensured that the proletarian did not exercise _"self-government"_
during working hours, i.e. was not a self-governing individual. As for Hart
claiming that Proudhon had _"statist economic views"_ it simply shows how far
an "anarcho"-capitalist perspective is from genuine anarchism. Proudhon's
economic analysis, his critique of private property and capitalism, flowed
from his anarchism and was an integral aspect of it.

To restrict anarchism purely to opposition to the state, Hart is impoverishing
anarchist theory and denying its history. Given that anarchism was born from a
critique of private property as well as government, this shows the false
nature of Hart's claim that _"Molinari was the first to develop a theory of
free-market, proprietary anarchism that extended the laws of the market and a
rigorous defence of property to its logical extreme."_ [**Op. Cit.**, p. 415
and p. 416] Hart shows how far from anarchism Molinari was as Proudhon had
turned his anarchist analysis to property, showing that _"defence of
property"_ lead to the oppression of the many by the few in social
relationships identical to those which mark the state. Moreover, Proudhon,
argued the state would always be required to defend such social relations.
Privatising it would hardly be a step forward.

Unsurprisingly, Proudhon dismissed the idea that the laissez faire capitalists
shared his goals. _"The school of Say,"_ Proudhon argued, was _"the chief
focus of counter-revolution next to the Jesuits"_ and _"has for ten years past
seemed to exist only to protect and applaud the execrable work of the
monopolists of money and necessities, deepening more and more the obscurity of
a science naturally difficult and full of complications."_ Much the same can
be said of "anarcho"- capitalists, incidentally. For Proudhon, _"the disciples
of Malthus and of Say, who oppose with all their might any intervention of the
State in matters commercial or industrial, do not fail to avail themselves of
this seemingly liberal attitude, and to show themselves more revolutionary
than the Revolution. More than one honest searcher has been deceived
thereby."_ However, this apparent "anti-statist" attitude of supporters of
capitalism is false as pure free market capitalism cannot solve the social
question, which arises because of capitalism itself. As such, it was
impossible to abolish the state under capitalism. Thus _"this inaction of
Power in economic matters was the foundation of government. What need should
we have of a political organisation, if Power once permitted us to enjoy
economic order?"_ Instead of capitalism, Proudhon advocated the _"constitution
of Value,"_ the _"organisation of credit,"_ the elimination of interest, the
_"establishment of workingmen's associations"_ and _"the use of a just
price."_ [**The General Idea of the Revolution**, p. 225, p. 226 and p. 233]

Clearly, then, the claims that Molinari was an anarchist fail as he, unlike
his followers, were aware of what anarchism actually stood for. Hart, in his
own way, acknowledges this:

> _"In spite of his protestations to the contrary, Molinari should be
considered an anarchist thinker. His attack on the state's monopoly of defence
must surely warrant the description of anarchism. His reluctance to accept
this label stemmed from the fact that the socialists had used it first to
describe a form of non-statist society which Molinari definitely opposed. Like
many original thinkers, Molinari had to use the concepts developed by others
to describe his theories. In his case, he had come to the same political
conclusions as the communist anarchists although he had been working within
the liberal tradition, and it is therefore not surprising that the terms used
by the two schools were not compatible. It would not be until the latter half
of the twentieth century that radical, free-trade liberals would use the word
'anarchist' to describe their beliefs."_ [**Op. Cit.**, p. 416]

It should be noted that Proudhon was **not** a communist-anarchist, but the
point remains. The aims of anarchism were recognised by Molinari as being
inconsistent with his ideology. Consequently, he (rightly) refused the label.
If only his self-proclaimed followers in the _"latter half of the twentieth
century"_ did the same anarchists would not have to bother with them!

As such, it seems ironic that the founder of "anarcho"-capitalism should have
come to the same conclusion as modern day anarchists on the subject of whether
his ideas are a form of anarchism or not!

## 7.2 Is government compatible with anarchism?

Of course not, but ironically this is the conclusion arrived at by Hart's
analyst of the British "voluntaryists," particularly Auberon Herbert.
Voluntaryism was a fringe part of the right-wing individualist movement
inspired by Herbert Spencer, a spokesman for free market capitalism in the
later half of the nineteenth century. As with Molinari, there is a problem
with presenting this ideology as anarchist, namely that its leading light,
Herbert, explicitly rejected the label "anarchist."

Herbert was clearly aware of individualist anarchism and distanced himself
from it. He argued that such a system would be _"pandemonium."_ He thought
that people should _"not direct our attacks - as the anarchists do - **against
all government** , against government in itself"_ but _"only against the
overgrown, the exaggerated, the insolent, unreasonable and indefensible forms
of government, which are found everywhere today."_ Government should be
_"strictly limited to its legitimate duties in defence of self-ownership and
individual rights."_ He stressed that _"we are governmentalists . . . formally
constituted by the nation, employing in this matter of force the majority
method."_ Moreover, Herbert knew of, and rejected, individualist anarchism,
considering it to be _"founded on a fatal mistake."_ [**Essay X: The
Principles Of Voluntaryism And Free Life**] As such, claims that he was an
anarchist or "anarcho"-capitalist cannot be justified.

Hart is aware of this slight problem, quoting Herbert's claim that he aimed
for _"regularly constituted government, generally accepted by all citizens for
the protection of the individual."_ [quoted by Hart, **Op. Cit.**, p. 86] Like
Molinari, Herbert was aware that anarchism was a form of socialism and that
the political aims could not be artificially separated from its economic and
social aims. As such, he was right **not** to call his ideas anarchism as it
would result in confusion (particularly as anarchism was a much larger
movement than his). As Hart acknowledges, _"Herbert faced the same problems
that Molinari had with labelling his philosophy. Like Molinari, he rejected
the term 'anarchism,' which he associated with the socialism of Proudhon and .
. . terrorism."_ While _"quite tolerant"_ of individualist anarchism, he
thought they _"were mistaken in their rejections of 'government.'"_ However,
Hart knows better than Herbert about his own ideas, arguing that his ideology
_"is in fact a new form of anarchism, since the most important aspect of the
modern state, the monopoly of the use of force in a given area, is rejected in
no uncertain terms by both men."_ [**Op. Cit.**, p. 86] He does mention that
Benjamin Tucker called Herbert a _"true anarchist in everything but name,"_
but Tucker denied that Kropotkin was an anarchist suggesting that he was
hardly a reliable guide. [quoted by Hart, **Op. Cit.**, p. 87] As it stands,
it seems that Tucker was mistaken in his evaluation of Herbert's politics.

Economically, Herbert was not an anarchist, arguing that the state should
protect Lockean property rights. Of course, Hart may argue that these economic
differences are not relevant to the issue of Herbert's anarchism but that is
simply to repeat the claim that anarchism is simply concerned with government,
a claim which is hard to support. This position cannot be maintained, given
that both Herbert and Molinari defended the right of capitalists and landlords
to force their employees and tenants to follow their orders. Their
"governments" existed to defend the capitalist from rebellious workers, to
break unions, strikes and occupations. In other words, they were a monopoly of
the use of force in a given area to enforce the monopoly of power in a given
area (namely, the wishes of the property owner). While they may have argued
that this was "defence of liberty," in reality it is defence of power and
authority.

What about if we just look at the political aspects of his ideas? Did Herbert
actually advocate anarchism? No, far from it. He clearly demanded a minimal
state based on voluntary taxation. The state would not use force of any kind,
_"except for purposes of restraining force."_ He argued that in his system,
while _"the state should compel no services and exact no payments by force,"_
it _"should be free to conduct many useful undertakings . . . in competition
with all voluntary agencies . . . in dependence on voluntary payments."_
[Herbert, **Op. Cit.**] As such, _"the state"_ would remain and unless he is
using the term "state" in some highly unusual way, it is clear that he means a
system where individuals live under a single elected government as their
common law maker, judge and defender within a given territory.

This becomes clearer once we look at how the state would be organised. In his
essay _"A Politician in Sight of Haven,"_ Herbert does discuss the franchise,
stating it would be limited to those who paid a voluntary _"income tax,"_
anyone _"paying it would have the right to vote; those who did not pay it
would be -- as is just -- without the franchise. There would be no other
tax."_ The law would be strictly limited, of course, and the _"government . .
. must confine itself simply to the defense of life and property, whether as
regards internal or external defense."_ In other words, Herbert was a minimal
statist, with his government elected by a majority of those who choose to pay
their income tax and funded by that (and by any other voluntary taxes they
decided to pay). Whether individuals and companies could hire their own
private police in such a regime is irrelevant in determining whether it is an
anarchy.

This can be best seen by comparing Herbert with Ayn Rand. No one would ever
claim Rand was an anarchist, yet her ideas were extremely similar to
Herbert's. Like Herbert, Rand supported laissez-faire capitalism and was
against the "initiation of force." Like Herbert, she extended this principle
to favour a government funded by voluntary means [_"Government Financing in a
Free Society,"_ **The Virtue of Selfishness**, pp. 116-20] Moreover, like
Herbert, she explicitly denied being an anarchist and, again like Herbert,
thought the idea of competing defence agencies ("governments") would result in
chaos. The similarities with Herbert are clear, yet no "anarcho"-capitalist
would claim that Rand was an anarchist, yet they do claim that Herbert was.

This position is, of course, deeply illogical and flows from the non-anarchist
nature of "anarcho"-capitalism. Perhaps unsurprisingly, when Rothbard
discusses the ideas of the "voluntaryists" he fails to address the key issue
of who determines the laws being enforced in society. For Rothbard, the key
issue is **who** is enforcing the law, not where that law comes from (as long,
of course, as it is a law code he approves of). The implications of this is
significant, as it implies that "anarchism" need not be opposed to either the
state nor government! This can be clearly seen from Rothbard's analysis of
voluntary taxation.

Rothbard, correctly, notes that Herbert advocated voluntary taxation as the
means of funding a state whose basic role was to enforce Lockean property
rights. For Rothbard, the key issue was **not** who determines the law but who
enforces it. For Rothbard, it should be privatised police and courts and he
suggests that the _"voluntary taxationists have never attempted to answer this
problem; they have rather stubbornly assumed that no one would set up a
competing defence agency within a State's territorial limits."_ If the state
**did** bar such firms, then that system is not a genuine free market.
However, _"if the government **did** permit free competition in defence
service, there would soon no longer be a central government over the
territory. Defence agencies, police and judicial, would compete with one
another in the same uncoerced manner as the producers of any other service on
the market."_ [**Power and Market**, p. 122 and p. 123]

However, this misses the point totally. The key issue that Rothbard ignores is
who determines the laws which these private "defence" agencies would enforce.
If the laws are determined by a central government, then the fact that
citizen's can hire private police and attend private courts does not stop the
regime being statist. We can safely assume Rand, for example, would have had
no problem with companies providing private security guards or the hiring of
private detectives within the context of her minimal state. Ironically,
Rothbard stresses the need for such a monopoly legal system:

> _"While 'the government' would cease to exist, the same cannot be said for a
constitution or a rule of law, which, in fact, would take on in the free
society a far more important function than at present. For the freely
competing judicial agencies would have to be guided by a body of absolute law
to enable them to distinguish objectively between defence and invasion. This
law, embodying elaborations upon the basic injunction to defend person and
property from acts of invasion, would be codified in the basic legal code.
Failure to establish such a code of law would tend to break down the free
market, for then defence against invasion could not be adequately achieved."_
[**Op. Cit.**, p. 123-4]

So if you violate the _"absolute law"_ defending (absolute) property rights
then you would be in trouble. The problem now lies in determining who sets
that law. Rothbard is silent on how his system of monopoly laws are determined
or specified. The "voluntaryists" did propose a solution, namely a central
government elected by the majority of those who voluntarily decided to pay an
income tax. In the words of Herbert:

> _"We agree that there must be a central agency to deal with crime - an
agency that defends the liberty of all men, and employs force against the uses
of force; but my central agency rests upon voluntary support, whilst Mr.
Levy's central agency rests on compulsory support."_ [quoted by Carl Watner,
_"The English Individualists As They Appear In Liberty,"_ pp. 191-211,
**Benjamin R. Tucker and the Champions of Liberty**, p. 194]

And all Rothbard is concerned over private cops would exist or not! This lack
of concern over the existence of the state and government flows from the
strange fact that "anarcho"-capitalists commonly use the term "anarchism" to
refer to any philosophy that opposes all forms of initiatory coercion. Notice
that government does not play a part in this definition, thus Rothbard can
analyse Herbert's politics without commenting on who determines the law his
private "defence" agencies enforce. For Rothbard, _"an anarchist society"_ is
defined _"as one where there is no legal possibility for coercive aggression
against the person and property of any individual."_ He then moved onto the
state, defining that as an _"institution which possesses one or both (almost
always both) of the following properties: (1) it acquires its income by the
physical coercion known as 'taxation'; and (2) it acquires and usually obtains
a coerced monopoly of the provision of defence service (police and courts)
over a given territorial area."_ [_"Society without a State"_, in **Nomos
XIX**, Pennock and Chapman (eds.)., p. 192]

This is highly unusual definition of "anarchism," given that it utterly fails
to mention or define government. This, perhaps, is understandable as any
attempt to define it in terms of _"monopoly of decision-making power"_ results
in showing that capitalism is statist (see [section 1](append131.md) for a
summary). The key issue here is the term _"legal possibility."_ That
suggestions a system of laws which determine what is _"coercive aggression"_
and what constitutes what is and what is not legitimate "property." Herbert is
considered by "anarcho"-capitalists as one of them. Which brings us to a
strange conclusion, that for "anarcho"-capitalists you can have a system of
"anarchism" in which there is a government and state -- as long as the state
does not impose taxation nor stop private police forces from operating!

As Rothbard argues _"if a government based on voluntary taxation permits free
competition, the result will be the purely free-market system . . . The
previous government would now simply be one competing defence agency among
many on the market."_ [**Power and Market**, p. 124] That the government is
specifying what is and is not legal does not seem to bother him or even cross
his mind. Why should it, when the existence of government is irrelevant to his
definition of anarchism and the state? That private police are enforcing a
monopoly law determined by the government seems hardly a step in the right
direction nor can it be considered as anarchism. Perhaps this is unsurprising,
for under his system there would be _"a basic, common Law Code"_ which _"all
would have to abide by"_ as well as _"some way of resolving disputes that will
gain a majority consensus in society . . . whose decision will be accepted by
the great majority of the public."_ [_"Society without a State,"_ **Op.
Cit.**, p. 205]

At least Herbert is clear that this would be a government system, unlike
Rothbard who assumes a monopoly law but seems to think that this is not a
government or a state. As David Wieck argued, this is illogical for according
to Rothbard _"all 'would have to' conform to the same legal code"_ and this
can only be achieved by means of _"the forceful action of adherents to the
code against those who flout it"_ and so _"in his system **there would stand
over against every individual the legal authority of all the others.** An
individual who did not recognise private property as legitimate would surely
perceive this as a tyranny of law, a tyranny of the majority or of the most
powerful -- in short, a hydra-headed state. If the law code is itself unitary,
then this multiple state might be said to have properly a single head -- the
law . . . But it looks as though one might still call this 'a state,' under
Rothbard's definition, by satisfying **de facto** one of his pair of
sufficient conditions: 'It asserts and usually obtains a coerced monopoly of
provision of defence service (police and courts) over a given territorial
area' . . . Hobbes's individual sovereign would seem to have become many
sovereigns -- with but one law, however, and in truth, therefore, a single
sovereign in Hobbes's more important sense of the latter term. One might
better, and less confusingly, call this a libertarian state than an anarchy."_
[_"Anarchist Justice"_, in **Nomos XIX**, Pennock and Chapman (eds.)., pp.
216-7]

The obvious recipients of the coercion of the new state would be those who
rejected the authority of their bosses and landlords, those who reject the
Lockean property rights Rothbard and Herbert hold dear. In such cases, the
rebels and any "defence agency" (like, say, a union) which defended them would
be driven out of business as it violated the law of the land. How this is
different from a state banning competing agencies is hard to determine. This
is a _"difficulty"_ argues Wieck, which _"results from the attachment of a
principle of private property, and of unrestricted accumulation of wealth, to
the principle of individual liberty. This increases sharply the possibility
that many reasonable people who respect their fellow men and women will find
themselves outside the law because of dissent from a property interpretation
of liberty."_ Similarly, there is the economic results of capitalism. _"One
can imagine,"_ Wieck continues, _"that those who lose out badly in the free
competition of Rothbard's economic system, perhaps a considerable number,
might regard the legal authority as an alien power, state for them, based on
violence, and might be quite unmoved by the fact that, just as under
nineteenth century capitalism, a principle of liberty was the justification
for it all."_ [**Op. Cit.**, p. 217 and pp. 217-8]

## 7.3 Can there be a "right-wing" anarchism?

Hart, of course, mentions the individualist anarchists, calling Tucker's ideas
_"**laissez faire** liberalism."_ [**Op. Cit.**, p. 87] However, Tucker called
his ideas _"socialism"_ and presented a left-wing critique of most aspects of
liberalism, particularly its Lockean based private property rights. Tucker
based much of his ideas on property on Proudhon, so if Hart dismisses the
latter as a socialist then this must apply to the former. Given that he notes
that there are _"two main kinds of anarchist thought,"_ namely _"communist
anarchism which denies the right of an individual to seek profit, charge rent
or interest and to own property"_ and a _"'right-wing' proprietary anarchism,
which vigorously defends these rights"_ then Tucker, like Godwin, would have
to be placed in the _"left-wing"_ camp. [_"Gustave de Molinari and the Anti-
statist Liberal Tradition: Part II"_, **Op. Cit.**, p. 427] Tucker, after all,
argued that he aimed for the end of profit, interest and rent and attacked
private property in land and housing beyond "occupancy and use."

As can be seen, Hart's account of the history of "anti-state" liberalism is
flawed. Godwin is included only by ignoring his views on property, views which
in many ways reflects the later "socialist" (i.e. anarchist) analysis of
Proudhon. He then discusses a few individuals who were alone in their opinions
even within extreme free market right and all of whom knew of anarchism and
explicitly rejected the name for their respective ideologies. In fact, they
preferred the term _"government"_ to describe their systems which, on the face
of it, would be hard to reconcile with the usual "anarcho"-capitalist
definition of anarchism as being "no government." Hart's discussion of
individualist anarchism is equally flawed, failing to discuss their economic
views (just as well, as its links to "left-wing" anarchism would be obvious).

However, the similarities of Molinari's views with what later became known as
"anarcho"-capitalism are clear. Hart notes that with Molinari's death in 1912,
_"liberal anti-statism virtually disappeared until it was rediscovered by the
economist Murray Rothbard in the late 1950's"_ [_"Gustave de Molinari and the
Anti-statist Liberal Tradition: Part III"_, **Op. Cit.**, p. 88] While this
fringe is somewhat bigger than previously, the fact remains that the ideas
expounded by Rothbard are just as alien to the anarchist tradition as
Molinari's. It is a shame that Rothbard, like his predecessors, did not call
his ideology something other than anarchism. Not only would it have been more
accurate, it would also have lead to much less confusion and no need to write
this section of the FAQ! As it stands, the only reason why
"anarcho"-capitalism is considered a form of "anarchism" by some is because
one person (Rothbard) decided to steal the name of a well established and
widespread political and social theory and movement and apply it to an
ideology with little, if anything, in common with it.

As Hart inadvertently shows, it is not a firm base to build a claim. That
anyone can consider "anarcho"-capitalism as anarchist simply flows from a lack
of knowledge about anarchism. As numerous anarchists have argued. For example,
_"Rothbard's conjunction of anarchism with capitalism,"_ according to David
Wieck, _"results in a conception that is entirely outside the mainstream of
anarchist theoretical writings or social movements . . . this conjunction is a
self-contradiction."_ He stressed that _"the main traditions of anarchism are
entirely different. These traditions, and theoretical writings associated with
them, express the perspectives and the aspirations, and also, sometimes, the
rage, of the oppressed people in human society: not only those economically
oppressed, although the major anarchist movements have been mainly movements
of workers and peasants, but also those oppressed by power in all those social
dimensions . . . including of course that of political power expressed in the
state."_ In other words, _"anarchism represents . . . a moral commitment
(Rothbard's anarchism I take to be diametrically opposite)."_ [_"Anarchist
Justice"_, in **Nomos XIX**, Pennock and Chapman (eds.), p. 215, p. 229 and p.
234]

It is a shame that some academics consider only the word Rothbard uses as
relevant rather than the content and its relation to anarchist theory and
history. If they did, they would soon realise that the expressed opposition of
so many anarchists to "anarcho"-capitalism is something which cannot be
ignored or dismissed. In other words, a "right-wing" anarchist cannot and does
not exist, no matter how often they use that word to describe their ideology.
As Bob Black put it, _"a right-wing anarchist is just a minarchist who'd
abolish the state to his own satisfaction by calling it something else . . .
They don't denounce what the state does, they just object to who's doing it."_
[**Libertarian as Conservative**]

The reason is simple. Anarchist economics and politics cannot be artificially
separated, they are linked. Godwin and Proudhon did not stop their analysis at
the state. They extended it the social relationships produced by inequality of
wealth, i.e. economic power as well as political power. To see why, we need
only consult Rothbard's work. As noted in the [last
section](append137.md#secf72), for Rothbard the key issue with the
"voluntary taxationists" was not who determined the _"body of absolute law"_
but rather who enforced it. In his discussion, he argued that a democratic
"defence agency" is at a disadvantage in his "free market" system. As he put
it:

> _"It would, in fact, be competing at a severe disadvantage, having been
established on the principle of 'democratic voting.' Looked at as a market
phenomenon, 'democratic voting' (one vote per person) is simply the method of
the consumer 'co-operative.' Empirically, it has been demonstrated time and
again that co-operatives cannot compete successfully against stock-owned
companies, especially when both are equal before the law. There is no reason
to believe that co-operatives for defence would be any more efficient. Hence,
we may expect the old co-operative government to 'wither away' through loss of
customers on the market, while joint-stock (i.e., corporate) defence agencies
would become the prevailing market form."_

Notice how he assumes that both a co-operative and corporation would be
_"equal before the law."_ But who determines that law? Obviously **not** a
democratically elected government, as the idea of "one person, one vote" in
determining the common law all are subject to is _"inefficient."_ Nor does he
think, like the individualist anarchists, that the law would be judged by
juries along with the facts. As we note in [section
1.4](append131.md#secf14), he rejects that in favour of it being determined
by _"Libertarian lawyers and jurists."_ Thus the law is unchangeable by
ordinary people and enforced by private defence agencies hired to protect the
liberty and property of the owning class. In the case of a capitalist economy,
this means defending the power of landlords and capitalists against rebel
tenants and workers.

This means that Rothbard's _"common Law Code"_ will be determined,
interpreted, enforced and amended by corporations based on the will of the
majority of shareholders, i.e. the rich. That hardly seems likely to produce
equality before the law. As he argues in a footnote:

> _"There is a strong **a priori** reason for believing that corporations will
be superior to co-operatives in any given situation. For if each owner
receives only one vote regardless of how much money he has invested in a
project (and earnings are divided in the same way), there is no incentive to
invest more than the next man; in fact, every incentive is the other way. This
hampering of investment militates strongly against the co-operative form."_

So **if** the law is determined by the defence agencies and courts then it
will be determined by those who have invested most in these companies. As it
is unlikely that the rich will invest in defence firms which do not support
their property rights, power, profits and definition of property rights, it is
clear that agencies which favour the wealthy will survive on the market. The
idea that market demand will counter this class rule seems unlikely, given
Rothbard's own argument. After all, in order to compete successfully you need
more than demand, you need source of investment. If co-operative defence
agencies do form, they will be at a market disadvantage due to lack of
investment. As argued in [section J.5.12](secJ5.md#secj512), even though co-
operatives are more efficient than capitalist firms lack of investment (caused
by the lack of control by capitalists Rothbard notes) stops them replacing
wage slavery. Thus capitalist wealth and power inhibits the spread of freedom
in production. If we apply his own argument to Rothbard's system, we suggest
that the market in "defence" will also stop the spread of more libertarian
associations thanks to capitalist power and wealth. In other words, like any
market, Rothbard's "defence" market will simply reflect the interests of the
elite, not the masses.

Moreover, we can expect any democratic defence agency (like a union) to
support, say, striking workers or squatting tenants, to be crushed. This is
because, as Rothbard stresses, **all** "defence" firms would be expected to
apply the _"common"_ law, as written by _"Libertarian lawyers and jurists."_
If they did not they would quickly be labelled "outlaw" agencies and crushed
by the others. Ironically, Tucker would join Bakunin and Kropotkin in an
"anarchist" court accused to violating "anarchist" law by practising and
advocating "occupancy and use" rather than the approved Rothbardian property
rights. Even if these democratic "defence" agencies could survive and not be
driven out of the market by a combination of lack of investment and violence
due to their "outlaw" status, there is another problem. As we discussed in
[section 1](append131.md), landlords and capitalists have a monopoly of
decision making power over their property. As such, they can simply refuse to
recognise any democratic agency as a legitimate defence association and use
the same tactics perfected against unions to ensure that it does not gain a
foothold in their domain (see [section 6](append136.md) for more details).

Clearly, then, a "right-wing" anarchism is impossible as any system based on
capitalist property rights will simply be an oligarchy run by and for the
wealthy. As Rothbard notes, any defence agency based on democratic principles
will not survive in the "market" for defence simply because it does not allow
the wealthy to control it and its decisions. Little wonder Proudhon argued
that laissez-faire capitalism meant _"the victory of the strong over the weak,
of those who own property over those who own nothing."_ [quoted by Peter
Marshall, **Demanding the Impossible**, p. 259]

[‹ 6 Is "anarcho"-capitalism against the state?](append136.md "Go to
previous page" ) [up](append13.md "Go to parent page" ) [8 What role did the
state take in the creation of capitalism? ›](append138.md "Go to next page"
)

