#! /bin/sh
### BEGIN INIT INFO
# Provides:          ample
# Required-Start:    $remote_fs $network
# Required-Stop:     $remote_fs
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Ample MP3 server
# Description:       Simple MP3 Server
### END INIT INFO

# Author: Rene Mayorga <rmayorga@debian.org.sv>
#

PATH=/sbin:/usr/sbin:/bin:/usr/bin
DESC="AMPLE mp3 server"
NAME=ample
DAEMON=/usr/bin/$NAME
DAEMON_ARGS="-c 10 -f /etc/ample/ample.conf -i /var/run/$NAME.pid"
PIDFILE=/var/run/$NAME.pid
SCRIPTNAME=/etc/init.d/$NAME

# Exit if the package is not installed
[ -x "$DAEMON" ] || exit 0

# Read configuration variable file if it is present
[ -r /etc/default/$NAME ] && . /etc/default/$NAME

if [ -z "$STARTAMPLE" ] ; then
	exit 0
fi

if [ "$STARTAMPLE" != "no" ] ; then
	STARTAMPLE=yes
fi

if [ "$DEFUSER" -a "$DEFGROUP" ] ; then
	DAEMON_ARGS="$DAEMON_ARGS -u $DEFUSER -g $DEFGROUP"
fi

test "$STARTAMPLE" = yes || exit 0

. /lib/lsb/init-functions

do_start()
{
	# Return
	#   0 if daemon has been started
	#   1 if daemon was already running
	#   2 if daemon could not be started
	start-stop-daemon --start --pidfile $PIDFILE --exec $DAEMON --test > /dev/null \
		|| return 1
	start-stop-daemon --start --pidfile $PIDFILE --exec $DAEMON -- \
		$DAEMON_ARGS \
		|| return 2
}

do_stop()
{
	start-stop-daemon --stop --retry=TERM/30/KILL/5 --pidfile $PIDFILE --name $NAME \
		|| return 1
}

do_reload() {
	start-stop-daemon --stop --signal 1 --quiet --pidfile $PIDFILE --name $NAME
	return 0
}

case "$1" in
  start)
	[ "$VERBOSE" != no ] && log_daemon_msg "Starting $DESC" "$NAME"
	do_start
	case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
  stop)
	[ "$VERBOSE" != no ] && log_daemon_msg "Stopping $DESC" "$NAME"
	do_stop
	case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
  restart|force-reload)
	log_daemon_msg "Restarting $DESC" "$NAME"
	do_stop
	case "$?" in
	  0|1)
		do_start
		case "$?" in
			0) log_end_msg 0 ;;
			1) log_end_msg 1 ;; # Old process is still running
			*) log_end_msg 1 ;; # Failed to start
		esac
		;;
	  *)
	  	# Failed to stop
		log_end_msg 1
		;;
	esac
	;;
  *)
	echo "Usage: $SCRIPTNAME {start|stop|restart|force-reload}" >&2
	exit 3
	;;
esac
