!{\src2tex{textfont=tt}}
!!****f* ABINIT/vxcca
!! NAME
!! vxcca
!!
!! FUNCTION
!! Calculate the exchange correlation energy using Ceperley-Alder
!! and including relativistic effects (PRB 26 P.4199, 1982)
!! rho should be in e/au**3; Vxc is returned in Hartree
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  rho=density at a specific point
!!
!! OUTPUT
!!  function vxcca=CA potential
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

function vxcca(rho)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_15gw, except_this_one => vxcca
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 real(dp) :: vxcca
 real(dp),intent(in) :: rho

!Local variables ------------------------------

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 real(dp) :: vcjas
 real(dp) :: vxjas
#endif
!End of the abilint section

 if(rho<1.0e-10) then
   vxcca=zero
 else
   vxcca=vxjas(rho)+vcjas(rho)
 end if

 end function vxcca
!!***
