!{\src2tex{textfont=tt}}
!!****f* ABINIT/mlwfovlp
!! NAME
!! mlwfovlp
!!
!! FUNCTION
!! Routine which computes overlap M_{mn}(k,b) and projection A_{mn}(k)
!! for Wannier code (www.wannier.org f77 version).
!!
!! COPYRIGHT
!! Copyright (C) 2005-2007 ABINIT group (BA,FJ)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  atindx(natom)=index table for atoms (see scfcv.f)
!!  atindx1(natom)=index table for atoms, inverse of atindx (see scfcv.f)
!!  cg(2,mpw*nspinor*mband*mkmem*nsppol)=planewave coefficients of wavefunctions.
!!  compch_fft=compensation charge, from FFT grid
!!  compch_sph=compensation charge, from sphere
!!  dtfil <type(datafiles_type)>=variables related to files
!!  dtset <type(dataset_type)>=all input variables for this dataset
!!  ecut=cut-off energy for plane wave basis sphere (Ha)
!!  eigen(mband*nkpt*nsppol)=array for holding eigenvalues (hartree)
!!  etotal=total energy
!!  fermie= Fermi energy
!!  filapp character(len=fnlen)=generic output root name, with appendix
!!  gmet(3,3)=reciprocal space metric tensor in bohr**-2.
!!  gprimd(3,3)=dimensional reciprocal space primitive translations
!!  gsqcut=cutoff on (k+G)^2 (bohr^-2)
!!  hdr <type(hdr_type)>=the header of wf, den and pot files
!!  kg(3,mpw*mkmem)=reduced planewave coordinates.
!!  kssform=govern the Kohn-Sham Structure file format
!!  mband=maximum number of bands
!!  mgfft=maximum size of 1D FFTs
!!  mkmem =number of k points which can fit in memory; set to 0 if use disk
!!  mpi_enreg=informations about MPI parallelization
!!  mpsang= 1+maximum angular momentum for nonlocal pseudopotentials
!!  mpw=maximum dimensioned size of npw.
!!  natom=number of atoms in cell.
!!  nattyp(ntypat)= # atoms of each type.
!!  nfft=(effective) number of FFT grid points (for this processor) (see NOTES at beginning of scfcv)
!!  ngfft(18)=contain all needed information about 3D FFT (see NOTES at beginning of scfcv)
!!  nkpt=number of k points.
!!  npwarr(nkpt)=number of planewaves in basis at this k point
!!  nspden=number of spin-density components
!!  nspinor=number of spinorial components of the wavefunctions
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  nsym=number of symmetries in space group
!!  ntypat=number of types of atoms in unit cell.
!!  n3xccc=dimension of the xccc3d array (0 or nfft).
!!  occ(mband*nkpt*nsppol)=occupation number for each band (usually 2) for each k.
!!  pawfgr(natom) <type(pawfgr_type)>=fine grid parameters and related data
!!  paw_ij(natom) <type(paw_ij_type)>=paw arrays given on (i,j) channels
!!  ph1d(2,3*(2*mgfft+1)*natom)=one-dimensional structure factor information
!!  prtvol=control print volume and debugging output
!!  psps <type(pseudopotential_type)>=variables related to pseudopotentials
!!  rhog(nfft,nspden)=total electron density in electrons/bohr**3, reciprocal space.
!!  rhor(nfft,nspden)=total electron density in electrons/bohr**3, real space.
!!  rmet(3,3)=real space metric (bohr**2)
!!  rprimd(3,3)=dimensional primitive translations for real space (bohr)
!!  ucvol=unit cell volume (bohr**3)
!!  vhartr(nfft)=Hartree potential
!!  vxc(nfft,nspden)=xc potential
!!  vxcavg=vxc average
!!  wffnow=information about wf disk file
!!  vtrial(nfft,nsppol)=the trial potential
!!  xccc3d(n3xccc)=3D core electron density for XC core correction (bohr^-3)
!!  xred(3,natom)=reduced dimensionless atomic coordinates
!!  ylm(mpw*mkmem,mpsang*mpsang*useylm)=real spherical harmonics for each G and k point
!!
!! OUTPUT
!!  (only writing, printing)
!!
!! SIDE EFFECTS
!!  (only writing, printing)
!!
!! NOTES
!!
!! PARENTS
!!      outscfcv
!!
!! CHILDREN
!!      
!!     
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 subroutine mlwfovlp(atindx,atindx1,cg,compch_fft,compch_sph,dtfil,dtset,ecut,eigen,etotal,&
& fermie,filapp,gmet,gprimd,gsqcut,hdr,kg,&
& kssform,mband,mgfft,mkmem,mpi_enreg,mpsang,mpw,natom,&
& nattyp,nfft,ngfft,nkpt,npwarr,nspden,nspinor,nsppol,nsym,ntypat,n3xccc,occ,&
& pawang,pawfgr,paw_ij,pawrad,pawtab,ph1d,prtvol,psps,rhog,rhor,rmet,rprimd,&
& ucvol,wffnow,vhartr,vtrial,vxc,vxcavg,xccc3d,xred,ylm)

 use defs_basis
 use defs_datatypes

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: kssform,mband,mgfft,mkmem,mpsang,mpw,n3xccc,natom,nfft
 integer,intent(in) :: nkpt,nspden,nsppol,nsym,ntypat,prtvol
 integer,intent(inout) :: nspinor
 real(dp),intent(in) :: compch_fft,compch_sph,ecut,fermie,gsqcut,ucvol
 real(dp),intent(inout) :: etotal,vxcavg
 character(len=fnlen),intent(in) :: filapp
 type(MPI_type),intent(inout) :: mpi_enreg
 type(datafiles_type),intent(in) :: dtfil
 type(dataset_type),intent(in) :: dtset
 type(hdr_type),intent(inout) :: hdr
 type(pawang_type),intent(in) :: pawang
 type(pawfgr_type),intent(in) :: pawfgr
 type(pseudopotential_type),intent(in) :: psps
 type(wffile_type),intent(inout) :: wffnow
!arrays
 integer :: kg(3,mpw*mkmem),nattyp(ntypat),ngfft(18),npwarr(nkpt)
 integer,intent(in) :: atindx(natom),atindx1(natom)
 real(dp),intent(in) :: eigen(mband*nkpt*nsppol),gmet(3,3),gprimd(3,3)
 real(dp),intent(in) :: occ(mband*nkpt*nsppol),ph1d(2,3*(2*mgfft+1)*natom)
 real(dp),intent(in) :: rmet(3,3),rprimd(3,3),vhartr(nfft),xccc3d(n3xccc)
 real(dp),intent(in) :: ylm(mpw*mkmem,mpsang*mpsang*psps%useylm)
 real(dp),intent(inout) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
 real(dp),intent(inout) :: rhog(nfft,nspden),rhor(nfft,nspden)
 real(dp),intent(inout) :: vtrial(nfft,nsppol),vxc(nfft,nsppol),xred(3,natom)
 type(paw_ij_type),intent(in) :: paw_ij(natom)
 type(pawrad_type),intent(in) :: pawrad(psps%ntypat*psps%usepaw)
 type(pawtab_type),intent(in) :: pawtab(psps%ntypat*psps%usepaw)

!Local variables-------------------------------
!Wannier variables-------------------------------
!scalars
 integer :: accessfil,band_index,coordn,fformr,fformv,iatom,iband,iband1,iband2
 integer :: ic_lmn,ic_spin,icat,icb,icgtemp,icnk,icp,icpb,icspol,ictyp,idum
 integer :: ierr,ifft,ig,ig1,ig1b,ig2,ig2b,ig3,ig3b,igk1,igk2,ii,ikg,ikpt,ikpt1
 integer :: ikpt2,ilmn,ilmn2,imntot,intot,ip,iscf,isemicore,ispden,ispinor
 integer :: isppol,itypat,jj,jj1,jj2,jj3,jj4,lmn_size,lversion,mbandw,mbesslang
 integer :: mmntot,mpj,n1,n2,n3,nband_k,ndosfraction,nfirst,nntot,npoint
 integer :: npoint2,npw_k,nwan,optxc,partial_dos_flag,prt1dm,prtcml,prtden
 integer :: prtdos,prtgeo,prtpot,prtstm,prtvha,prtvhxc,prtvxc,rdwr,spaceComm
 real(dp) :: enxc_dum,fatchar,uniformrandom,x1,x2,xnorm,xnormb
 logical :: lnew
 character(len=500) :: message
 character(len=fnlen) :: fildata
!arrays
 integer :: gtemp(3)
 integer,allocatable :: g0(:,:),g1(:,:,:),icg(:,:),indpwk(:,:),invpwk(:,:)
 integer,allocatable :: iwav(:,:,:),kg_k(:,:),npwarr1(:),ovbd(:,:),ovikp(:,:)
 integer,allocatable :: ovkpt(:,:)
 real(dp) :: strsxc_dum(6),tsec(2)
 real(dp),allocatable :: amn(:,:,:,:),amn2(:,:,:,:,:,:,:),cm(:,:)
 real(dp),allocatable :: cm1(:,:,:,:,:),cm2(:,:,:,:,:),cp(:,:)
 real(dp),allocatable :: dos_fractions(:,:,:,:),kxc_dum(:,:),rhocorval(:,:)
 real(dp),allocatable :: vhartr_tmp(:),vwork(:,:),vxc_dum(:,:)

!************************************************************************   
 
!DEBUG
!write(6,*)' mlwfovlp : enter '
!ENDDEBUG


!DEBUG
!write(6,*)' mlwfovlp : exit'
!stop
!ENDDEBUG

 end subroutine mlwfovlp 
!!***
