#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Starship Titanic
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220203.3

# Set game-specific variables

GAME_ID='starship-titanic'
GAME_NAME='Starship Titanic'

ARCHIVE_BASE_0='starship_titanic_1_0_53361.sh'
ARCHIVE_BASE_0_MD5='a41b4da053b7d4191e0d864bc52e6a89'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='1400000'
ARCHIVE_BASE_0_VERSION='1.00.42-gog53361'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/starship_titanic'

ARCHIVE_BASE_WINDOWS_0='setup_starship_titanic_2.0.0.4.exe'
ARCHIVE_BASE_WINDOWS_0_MD5='1b0778ee3ed364ae55b2a20bd50e4cc6'
ARCHIVE_BASE_WINDOWS_0_TYPE='innosetup'
ARCHIVE_BASE_WINDOWS_0_SIZE='1300000'
ARCHIVE_BASE_WINDOWS_0_VERSION='1.00.42-gog2.0.0.4'

CONTENT_PATH_DEFAULT='data/noarch/game/data'
CONTENT_PATH_DEFAULT_WINDOWS='app'
ARCHIVE_DOC_MAIN_FILES='
*.doc
*.txt'
ARCHIVE_GAME_MAIN_FILES='
assets
Assets
newgame.st'

APP_MAIN_TYPE='scummvm'
APP_MAIN_SCUMMID='titanic'
APP_MAIN_ICON='data/noarch/support/icon.png'
APP_MAIN_ICON_WINDOWS='app/st.exe'

PKG_MAIN_DEPS='scummvm'

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Include game icon

icons_get_from_workdir 'APP_MAIN'

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
