/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_CONCRETEPCIIDENTITYACCESS_H_
#define OPENDRIM_CONCRETEPCIIDENTITYACCESS_H_

#include "PCI_Common.h"

#include "OpenDRIM_ConcretePCIIdentity.h"
#include "assocOpenDRIM_ConcretePCIIdentity.h"

int PCI_OpenDRIM_ConcretePCIIdentity_load(const CMPIBroker* broker, string& errorMessage);

int PCI_OpenDRIM_ConcretePCIIdentity_unload(string& errorMessage);

int PCI_OpenDRIM_ConcretePCIIdentity_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ConcretePCIIdentity>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_ConcretePCIIdentity_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ConcretePCIIdentity& instance, const char** properties, string& errorMessage);

int PCI_OpenDRIM_ConcretePCIIdentity_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ConcretePCIIdentity& newInstance, const OpenDRIM_ConcretePCIIdentity& oldInstance, const char** properties, string& errorMessage);

int PCI_OpenDRIM_ConcretePCIIdentity_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ConcretePCIIdentity& instance, string& errorMessage);

int PCI_OpenDRIM_ConcretePCIIdentity_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ConcretePCIIdentity& instance, string& errorMessage);

int PCI_OpenDRIM_ConcretePCIIdentity_associatorSystemElementToSameElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SystemElement_instance, const char** properties, vector<Instance>& SameElement_associatedInstances, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_ConcretePCIIdentity_associatorSameElementToSystemElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SameElement_instance, const char** properties, vector<Instance>& SystemElement_associatedInstances, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_ConcretePCIIdentity_referenceSystemElementToSameElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SystemElement_instance, const vector<Instance>& SameElement_instances, vector<OpenDRIM_ConcretePCIIdentity>& OpenDRIM_ConcretePCIIdentity_instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_ConcretePCIIdentity_referenceSameElementToSystemElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SameElement_instance, const vector<Instance>& SystemElement_instances, vector<OpenDRIM_ConcretePCIIdentity>& OpenDRIM_ConcretePCIIdentity_instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_ConcretePCIIdentity_populate(OpenDRIM_ConcretePCIIdentity& instance, string& errorMessage);

#endif /*OPENDRIM_CONCRETEPCIIDENTITYACCESS_H_*/
