/*###############################################################################
# Linux Management Providers (LMP), EthernetPort provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_ETHERNETPORTACCESS_H_
#define OPENDRIM_ETHERNETPORTACCESS_H_

#include "EthernetPort_Common.h"

#include "OpenDRIM_EthernetPort.h"

int EthernetPort_OpenDRIM_EthernetPort_load(const CMPIBroker* broker, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPort_unload(string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPort_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_EthernetPort>& instances, const char** properties, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_EthernetPort_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_EthernetPort& instance, const char** properties, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPort_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPort& newInstance, const OpenDRIM_EthernetPort& oldInstance, const char** properties, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPort_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPort& instance, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPort_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPort& instance, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPort_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPort& instance, unsigned int& returnValue, const OpenDRIM_EthernetPort_RequestStateChange_In& in, OpenDRIM_EthernetPort_RequestStateChange_Out& out, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPort_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPort& instance, unsigned int& returnValue, const OpenDRIM_EthernetPort_SetPowerState_In& in, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPort_Reset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPort& instance, unsigned int& returnValue, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPort_EnableDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPort& instance, unsigned int& returnValue, const OpenDRIM_EthernetPort_EnableDevice_In& in, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPort_OnlineDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPort& instance, unsigned int& returnValue, const OpenDRIM_EthernetPort_OnlineDevice_In& in, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPort_QuiesceDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPort& instance, unsigned int& returnValue, const OpenDRIM_EthernetPort_QuiesceDevice_In& in, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPort_SaveProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPort& instance, unsigned int& returnValue, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPort_RestoreProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPort& instance, unsigned int& returnValue, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPort_populate(OpenDRIM_EthernetPort& instance, string& errorMessage);

#endif /*OPENDRIM_ETHERNETPORTACCESS_H_*/
