/*
    open/read/close stress test

    Copyright (C) 2007  Hans Verkuil  <hverkuil@xs4all.nl>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/fcntl.h>
#include <time.h>

#include <linux/videodev2.h>

int main(int argc, char **argv)
{
	char *device = "/dev/video0";
	unsigned char buf[256 * 1024];
	struct v4l2_encoder_cmd cmd;
	int fh;
	int sz;
	int i;

	if (argc > 1) device = argv[1];

	fh = open(device, O_RDONLY);

	if (fh == -1) {
		fprintf(stderr, "cannot open %s\n", device);
		return -1;
	}
	for (;;) {
		for (i = 0; i < 10; i++) {
			if ((sz = read(fh, buf, sizeof(buf))) <= 0) {
				fprintf(stderr, "read %d, expected %u\n", sz, sizeof(buf));
				ioctl(fh, VIDIOC_LOG_STATUS, 0);
				return -1;
			}
			write(1, buf, sizeof(buf));
		}
		cmd.cmd = V4L2_ENC_CMD_STOP;
		cmd.flags = 0;

		ioctl(fh, VIDIOC_ENCODER_CMD, &cmd);
		sleep(1);
		cmd.cmd = V4L2_ENC_CMD_START;
		cmd.flags = 0;
		ioctl(fh, VIDIOC_ENCODER_CMD, &cmd);
	}
	return 0;
}
