/* umockdev.c generated by valac 0.22.1, the Vala compiler
 * generated from umockdev.vala, do not modify */

/*
 * Copyright (C) 2012-2013 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * SECTION:umockdev
 * @title: umockdev
 * @short_description: Build a test bed for testing software that handles Linux
 * hardware devices.
 *
 * Please see README.rst about an overview of the parts of umockdev, and how
 * they fit together.
 */
/**
 * SECTION:functions
 * @title: global functions
 * @short_description: Global functions
 *
 * These work independently from #Testbed objects.
 */
/**
 * SECTION:umockdeverror
 * @title: umockdev errors
 * @short_description: #GError types for parsing umockdev files
 * hardware devices.
 *
 * See #GError for more information on error domains.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "uevent_sender.h"
#include <unistd.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <gio/gio.h>
#include <stdarg.h>
#include <sys/socket.h>
#include <linux/input.h>
#include <time.h>
#include <pty.h>
#include <termios.h>
#include <stdio.h>
#include <sys/select.h>
#include <sys/time.h>
#include <gio/gunixsocketaddress.h>
#include <gobject/gvaluecollector.h>


#define UMOCKDEV_TYPE_TESTBED (umockdev_testbed_get_type ())
#define UMOCKDEV_TESTBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_TESTBED, UMockdevTestbed))
#define UMOCKDEV_TESTBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_TESTBED, UMockdevTestbedClass))
#define UMOCKDEV_IS_TESTBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_TESTBED))
#define UMOCKDEV_IS_TESTBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_TESTBED))
#define UMOCKDEV_TESTBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_TESTBED, UMockdevTestbedClass))

typedef struct _UMockdevTestbed UMockdevTestbed;
typedef struct _UMockdevTestbedClass UMockdevTestbedClass;
typedef struct _UMockdevTestbedPrivate UMockdevTestbedPrivate;

#define UMOCKDEV_TYPE_SCRIPT_RUNNER (umockdev_script_runner_get_type ())
#define UMOCKDEV_SCRIPT_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunner))
#define UMOCKDEV_SCRIPT_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunnerClass))
#define UMOCKDEV_IS_SCRIPT_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_SCRIPT_RUNNER))
#define UMOCKDEV_IS_SCRIPT_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_SCRIPT_RUNNER))
#define UMOCKDEV_SCRIPT_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunnerClass))

typedef struct _UMockdevScriptRunner UMockdevScriptRunner;
typedef struct _UMockdevScriptRunnerClass UMockdevScriptRunnerClass;

#define UMOCKDEV_TYPE_SOCKET_SERVER (umockdev_socket_server_get_type ())
#define UMOCKDEV_SOCKET_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServer))
#define UMOCKDEV_SOCKET_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServerClass))
#define UMOCKDEV_IS_SOCKET_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_SOCKET_SERVER))
#define UMOCKDEV_IS_SOCKET_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_SOCKET_SERVER))
#define UMOCKDEV_SOCKET_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServerClass))

typedef struct _UMockdevSocketServer UMockdevSocketServer;
typedef struct _UMockdevSocketServerClass UMockdevSocketServerClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _umockdev_socket_server_unref0(var) ((var == NULL) ? NULL : (var = (umockdev_socket_server_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _uevent_sender_close0(var) ((var == NULL) ? NULL : (var = (uevent_sender_close (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _UMockdevScriptRunnerPrivate UMockdevScriptRunnerPrivate;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _umockdev_script_runner_unref0(var) ((var == NULL) ? NULL : (var = (umockdev_script_runner_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _UMockdevParamSpecScriptRunner UMockdevParamSpecScriptRunner;
typedef struct _UMockdevSocketServerPrivate UMockdevSocketServerPrivate;
typedef struct _UMockdevParamSpecSocketServer UMockdevParamSpecSocketServer;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _UMockdevTestbed {
	GObject parent_instance;
	UMockdevTestbedPrivate * priv;
};

struct _UMockdevTestbedClass {
	GObjectClass parent_class;
};

struct _UMockdevTestbedPrivate {
	gchar* root_dir;
	gchar* sys_dir;
	GRegex* re_record_val;
	GRegex* re_record_keyval;
	GRegex* re_record_optval;
	uevent_sender* ev_sender;
	GHashTable* dev_fd;
	GHashTable* dev_script_runner;
	UMockdevSocketServer* socket_server;
};

typedef enum  {
	UMOCKDEV_ERROR_PARSE,
	UMOCKDEV_ERROR_VALUE
} UMockdevError;
#define UMOCKDEV_ERROR umockdev_error_quark ()
struct _UMockdevScriptRunner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UMockdevScriptRunnerPrivate * priv;
};

struct _UMockdevScriptRunnerClass {
	GTypeClass parent_class;
	void (*finalize) (UMockdevScriptRunner *self);
};

struct _UMockdevScriptRunnerPrivate {
	gchar* _device;
	gchar* script_file;
	GThread* thread;
	FILE* script;
	gint fd;
	gboolean running;
	guint fuzz;
};

struct _UMockdevParamSpecScriptRunner {
	GParamSpec parent_instance;
};

struct _UMockdevSocketServer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UMockdevSocketServerPrivate * priv;
};

struct _UMockdevSocketServerClass {
	GTypeClass parent_class;
	void (*finalize) (UMockdevSocketServer *self);
};

struct _UMockdevSocketServerPrivate {
	GSocket** listen_sockets;
	gint listen_sockets_length1;
	gint _listen_sockets_size_;
	GHashTable* socket_scriptfile;
	GHashTable* script_runners;
	GThread* thread;
	gboolean running;
	gint ctrl_r;
	gint ctrl_w;
};

struct _UMockdevParamSpecSocketServer {
	GParamSpec parent_instance;
};

/**
 * UMockdevError:
 * @UMOCKDEV_ERROR_PARSE:
 * There is a malformed or missing line in the device description.
 * @UMOCKDEV_ERROR_VALUE:
 * A value in the device description has an invalid value, for example a device
 * path does not start with "/devices/".
 *
 * Error codes for parsing umockdev files.
 */

static gpointer umockdev_testbed_parent_class = NULL;
static gpointer umockdev_script_runner_parent_class = NULL;
static gpointer umockdev_socket_server_parent_class = NULL;

GType umockdev_testbed_get_type (void) G_GNUC_CONST;
gpointer umockdev_script_runner_ref (gpointer instance);
void umockdev_script_runner_unref (gpointer instance);
GParamSpec* umockdev_param_spec_script_runner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void umockdev_value_set_script_runner (GValue* value, gpointer v_object);
void umockdev_value_take_script_runner (GValue* value, gpointer v_object);
gpointer umockdev_value_get_script_runner (const GValue* value);
GType umockdev_script_runner_get_type (void) G_GNUC_CONST;
gpointer umockdev_socket_server_ref (gpointer instance);
void umockdev_socket_server_unref (gpointer instance);
GParamSpec* umockdev_param_spec_socket_server (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void umockdev_value_set_socket_server (GValue* value, gpointer v_object);
void umockdev_value_take_socket_server (GValue* value, gpointer v_object);
gpointer umockdev_value_get_socket_server (const GValue* value);
GType umockdev_socket_server_get_type (void) G_GNUC_CONST;
#define UMOCKDEV_TESTBED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UMOCKDEV_TYPE_TESTBED, UMockdevTestbedPrivate))
enum  {
	UMOCKDEV_TESTBED_DUMMY_PROPERTY
};
void umockdev_script_runner_stop (UMockdevScriptRunner* self);
void umockdev_socket_server_stop (UMockdevSocketServer* self);
void umockdev_remove_dir (const gchar* path, gboolean remove_toplevel);
UMockdevTestbed* umockdev_testbed_new (void);
UMockdevTestbed* umockdev_testbed_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _umockdev_script_runner_unref0_ (gpointer var);
gchar* umockdev_testbed_get_root_dir (UMockdevTestbed* self);
gchar* umockdev_testbed_get_sys_dir (UMockdevTestbed* self);
void umockdev_testbed_set_attribute (UMockdevTestbed* self, const gchar* devpath, const gchar* name, const gchar* value);
void umockdev_testbed_set_attribute_binary (UMockdevTestbed* self, const gchar* devpath, const gchar* name, guint8* value, int value_length1);
void umockdev_testbed_set_attribute_int (UMockdevTestbed* self, const gchar* devpath, const gchar* name, gint value);
void umockdev_testbed_set_attribute_hex (UMockdevTestbed* self, const gchar* devpath, const gchar* name, guint value);
void umockdev_testbed_set_attribute_link (UMockdevTestbed* self, const gchar* devpath, const gchar* name, const gchar* value);
void umockdev_testbed_set_property (UMockdevTestbed* self, const gchar* devpath, const gchar* name, const gchar* value);
void umockdev_testbed_set_property_int (UMockdevTestbed* self, const gchar* devpath, const gchar* name, gint value);
void umockdev_testbed_set_property_hex (UMockdevTestbed* self, const gchar* devpath, const gchar* name, guint value);
gchar* umockdev_testbed_add_devicev (UMockdevTestbed* self, const gchar* subsystem, const gchar* name, const gchar* parent, gchar** attributes, gchar** properties);
gchar* umockdev_make_dotdots (const gchar* path);
gboolean umockdev_in_mock_environment (void);
void umockdev_testbed_uevent (UMockdevTestbed* self, const gchar* devpath, const gchar* action);
gchar* umockdev_testbed_add_device (UMockdevTestbed* self, const gchar* subsystem, const gchar* name, const gchar* parent, ...);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
void umockdev_testbed_remove_device (UMockdevTestbed* self, const gchar* syspath);
gchar* umockdev_find_devnode (const gchar* devpath);
GQuark umockdev_error_quark (void);
gboolean umockdev_testbed_add_from_string (UMockdevTestbed* self, const gchar* data, GError** error);
static gchar* umockdev_testbed_add_dev_from_string (UMockdevTestbed* self, const gchar* data, GError** error);
gboolean umockdev_testbed_add_from_file (UMockdevTestbed* self, const gchar* path, GError** error);
gboolean umockdev_testbed_load_ioctl (UMockdevTestbed* self, const gchar* dev, const gchar* recordfile, GError** error);
static guint8* _vala_array_dup1 (guint8* self, int length);
gboolean umockdev_testbed_load_script (UMockdevTestbed* self, const gchar* dev, const gchar* recordfile, GError** error);
gint umockdev_testbed_get_dev_fd (UMockdevTestbed* self, const gchar* devnode);
UMockdevScriptRunner* umockdev_script_runner_new (const gchar* device, const gchar* script_file, gint fd, GError** error);
UMockdevScriptRunner* umockdev_script_runner_construct (GType object_type, const gchar* device, const gchar* script_file, gint fd, GError** error);
gboolean umockdev_testbed_load_socket_script (UMockdevTestbed* self, const gchar* path, gint type, const gchar* recordfile, GError** error);
UMockdevSocketServer* umockdev_socket_server_new (void);
UMockdevSocketServer* umockdev_socket_server_construct (GType object_type);
void umockdev_socket_server_add (UMockdevSocketServer* self, const gchar* sock_path, gint fd, const gchar* record_file);
gboolean umockdev_testbed_load_evemu_events (UMockdevTestbed* self, const gchar* dev, const gchar* eventsfile, GError** error);
gchar* umockdev_script_runner_encode (guint8* data, int data_length1);
static gchar* umockdev_testbed_record_parse_line (UMockdevTestbed* self, const gchar* data, gchar* type, gchar** key, gchar** val);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value);
guint8* umockdev_decode_hex (const gchar* data, int* result_length1, GError** error);
static void umockdev_testbed_create_node_for_device (UMockdevTestbed* self, const gchar* subsystem, const gchar* node_path, guint8* node_contents, int node_contents_length1, GError** error);
void umockdev_testbed_disable (UMockdevTestbed* self);
void umockdev_testbed_enable (UMockdevTestbed* self);
void umockdev_testbed_clear (UMockdevTestbed* self);
static void umockdev_testbed_finalize (GObject* obj);
guint8 umockdev_hexdigit (gchar c);
#define UMOCKDEV_SCRIPT_RUNNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunnerPrivate))
enum  {
	UMOCKDEV_SCRIPT_RUNNER_DUMMY_PROPERTY
};
static void umockdev_script_runner_set_device (UMockdevScriptRunner* self, const gchar* value);
static void* umockdev_script_runner_run (UMockdevScriptRunner* self);
static gpointer _umockdev_script_runner_run_gthread_func (gpointer self);
const gchar* umockdev_script_runner_get_device (UMockdevScriptRunner* self);
static guint8* umockdev_script_runner_next_line (UMockdevScriptRunner* self, gchar* op, guint32* delta, int* result_length1);
static void umockdev_script_runner_op_write (UMockdevScriptRunner* self, guint8* data, int data_length1, guint32 delta);
static guint8* umockdev_script_runner_decode (const gchar* quoted, int* result_length1);
static guint umockdev_script_runner_hamming (guint8* d1, int d1_length1, guint8* d2, int d2_length1);
static void _vala_array_add11 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add12 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add13 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add14 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add15 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add16 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add17 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add18 (guint8** array, int* length, int* size, guint8 value);
static void umockdev_script_runner_finalize (UMockdevScriptRunner* obj);
#define UMOCKDEV_SOCKET_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServerPrivate))
enum  {
	UMOCKDEV_SOCKET_SERVER_DUMMY_PROPERTY
};
static void* umockdev_socket_server_run (UMockdevSocketServer* self);
static gpointer _umockdev_socket_server_run_gthread_func (gpointer self);
static void _vala_array_add19 (GSocket*** array, int* length, int* size, GSocket* value);
static void umockdev_socket_server_finalize (UMockdevSocketServer* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
     * umockdev_testbed_new:
     *
     * Create a new #UMockdevTestbed object. This is initially empty, call
     * methods like #umockdev_testbed_add_device or
     * #umockdev_testbed_add_from_string to fill it.
     *
     * Returns: The newly created #UMockdevTestbed object.
     */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _umockdev_script_runner_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (umockdev_script_runner_unref (var), NULL));
}


UMockdevTestbed* umockdev_testbed_construct (GType object_type) {
	UMockdevTestbed * self = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GHashFunc _tmp6_ = NULL;
	GEqualFunc _tmp7_ = NULL;
	GHashTable* _tmp8_ = NULL;
	GHashFunc _tmp9_ = NULL;
	GEqualFunc _tmp10_ = NULL;
	GHashTable* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	self = (UMockdevTestbed*) g_object_new (object_type, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_dir_make_tmp ("umockdev.XXXXXX", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (self->priv->root_dir);
		self->priv->root_dir = _tmp0_;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e->message;
		g_error ("umockdev.vala:67: Cannot create temporary directory: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp3_ = self->priv->root_dir;
	_tmp4_ = g_build_filename (_tmp3_, "sys", NULL);
	_g_free0 (self->priv->sys_dir);
	self->priv->sys_dir = _tmp4_;
	_tmp5_ = self->priv->sys_dir;
	g_mkdir (_tmp5_, 0755);
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->dev_fd);
	self->priv->dev_fd = _tmp8_;
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = g_hash_table_new_full (_tmp9_, _tmp10_, _g_free0_, _umockdev_script_runner_unref0_);
	_g_hash_table_unref0 (self->priv->dev_script_runner);
	self->priv->dev_script_runner = _tmp11_;
	_tmp12_ = self->priv->root_dir;
	g_setenv ("UMOCKDEV_DIR", _tmp12_, TRUE);
	_tmp13_ = self->priv->root_dir;
	g_debug ("umockdev.vala:76: Created udev test bed %s", _tmp13_);
	return self;
}


UMockdevTestbed* umockdev_testbed_new (void) {
	return umockdev_testbed_construct (UMOCKDEV_TYPE_TESTBED);
}


/**
     * umockdev_testbed_get_root_dir:
     * @self: A #UMockdevTestbed.
     *
     * Get the root directory for the testbed.
     *
     * Returns: The testbed's root directory.
     */
gchar* umockdev_testbed_get_root_dir (UMockdevTestbed* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
     * umockdev_testbed_get_sys_dir:
     * @self: A #UMockdevTestbed.
     *
     * Get the sysfs directory for the testbed.
     *
     * Returns: The testbed's sysfs directory.
     */
gchar* umockdev_testbed_get_sys_dir (UMockdevTestbed* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sys_dir;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
     * umockdev_testbed_set_attribute:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute string value
     *
     * Set a text sysfs attribute for a device.
     */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void umockdev_testbed_set_attribute (UMockdevTestbed* self, const gchar* devpath, const gchar* name, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = devpath;
	_tmp1_ = name;
	_tmp2_ = value;
	_tmp3_ = string_get_data (_tmp2_, &_tmp3__length1);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	umockdev_testbed_set_attribute_binary (self, _tmp0_, _tmp1_, _tmp4_, _tmp4__length1);
}


/**
     * umockdev_testbed_set_attribute_binary:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute binary value
     * @value_length1: Length of @value in bytes.
     *
     * Set a binary sysfs attribute for a device.
     */
void umockdev_testbed_set_attribute_binary (UMockdevTestbed* self, const gchar* devpath, const gchar* name, guint8* value, int value_length1) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	{
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		guint8* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		_tmp0_ = self->priv->root_dir;
		_tmp1_ = devpath;
		_tmp2_ = name;
		_tmp3_ = g_build_filename (_tmp0_, _tmp1_, _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = value;
		_tmp5__length1 = value_length1;
		g_file_set_contents (_tmp4_, (const char*) _tmp5_, (size_t) _tmp5__length1, &_inner_error_);
		_g_free0 (_tmp4_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e->message;
		g_error ("umockdev.vala:157: Cannot write attribute file: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
     * umockdev_testbed_set_attribute_int:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute integer value
     *
     * Set an integer sysfs attribute for a device.
     */
void umockdev_testbed_set_attribute_int (UMockdevTestbed* self, const gchar* devpath, const gchar* name, gint value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = devpath;
	_tmp1_ = name;
	_tmp2_ = value;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	umockdev_testbed_set_attribute (self, _tmp0_, _tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
}


/**
     * umockdev_testbed_set_attribute_hex:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute integer value
     *
     * Set an integer sysfs attribute for a device. Set an integer udev
     * property for a device. @value is interpreted as a hexadecimal number.
     * For example, for value==31 this sets the attribute contents to "1f".
     */
void umockdev_testbed_set_attribute_hex (UMockdevTestbed* self, const gchar* devpath, const gchar* name, guint value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = devpath;
	_tmp1_ = name;
	_tmp2_ = value;
	_tmp3_ = g_strdup_printf ("%x", _tmp2_);
	_tmp4_ = _tmp3_;
	umockdev_testbed_set_attribute (self, _tmp0_, _tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
}


/**
     * umockdev_testbed_set_attribute_link:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute link target value
     *
     * Set a symlink sysfs attribute for a device; this is primarily important
     * for setting "driver" links.
     */
void umockdev_testbed_set_attribute_link (UMockdevTestbed* self, const gchar* devpath, const gchar* name, const gchar* value) {
	gchar* path = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = devpath;
	_tmp2_ = name;
	_tmp3_ = g_build_filename (_tmp0_, _tmp1_, _tmp2_, NULL);
	path = _tmp3_;
	_tmp4_ = value;
	_tmp5_ = symlink (_tmp4_, path);
	if (_tmp5_ < 0) {
		gint _tmp6_ = 0;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = errno;
		_tmp7_ = g_strerror (_tmp6_);
		g_error ("umockdev.vala:205: Cannot create symlink %s: %s", path, _tmp7_);
	}
	_g_free0 (path);
}


/**
     * umockdev_testbed_set_property:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     * @value: Property string value
     *
     * Set a string udev property for a device.
     */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


void umockdev_testbed_set_property (UMockdevTestbed* self, const gchar* devpath, const gchar* name, const gchar* value) {
	gchar* uevent_path = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* props = NULL;
	gchar* _tmp3_ = NULL;
	gchar* real_value = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp8_ = FALSE;
	GFile* f = NULL;
	const gchar* _tmp13_ = NULL;
	GFile* _tmp14_ = NULL;
	gboolean existing = FALSE;
	gchar* prefix = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = devpath;
	_tmp2_ = g_build_filename (_tmp0_, _tmp1_, "uevent", NULL);
	uevent_path = _tmp2_;
	_tmp3_ = g_strdup ("");
	props = _tmp3_;
	_tmp5_ = name;
	if (g_strcmp0 (_tmp5_, "DEVNAME") == 0) {
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = value;
		_tmp7_ = g_str_has_prefix (_tmp6_, "/dev/");
		_tmp4_ = _tmp7_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp8_ = _tmp4_;
	if (_tmp8_) {
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp9_ = value;
		_tmp10_ = string_substring (_tmp9_, (glong) 5, (glong) (-1));
		_g_free0 (real_value);
		real_value = _tmp10_;
	} else {
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp11_ = value;
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (real_value);
		real_value = _tmp12_;
	}
	_tmp13_ = uevent_path;
	_tmp14_ = g_file_new_for_path (_tmp13_);
	f = _tmp14_;
	existing = FALSE;
	_tmp15_ = name;
	_tmp16_ = g_strconcat (_tmp15_, "=", NULL);
	prefix = _tmp16_;
	{
		GFileInputStream* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		GFileInputStream* _tmp19_ = NULL;
		GDataInputStream* inp = NULL;
		GFileInputStream* _tmp20_ = NULL;
		GDataInputStream* _tmp21_ = NULL;
		GDataInputStream* _tmp22_ = NULL;
		gchar* line = NULL;
		gsize len = 0UL;
		GDataInputStream* _tmp44_ = NULL;
		gboolean _tmp45_ = FALSE;
		const gchar* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		guint8* _tmp56_ = NULL;
		gint _tmp56__length1 = 0;
		guint8* _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		_tmp18_ = f;
		_tmp19_ = g_file_read (_tmp18_, NULL, &_inner_error_);
		_tmp17_ = _tmp19_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_tmp20_ = _tmp17_;
		_tmp21_ = g_data_input_stream_new ((GInputStream*) _tmp20_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		inp = _tmp22_;
		while (TRUE) {
			gchar* _tmp23_ = NULL;
			GDataInputStream* _tmp24_ = NULL;
			gsize _tmp25_ = 0UL;
			gchar* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			gboolean _tmp30_ = FALSE;
			_tmp24_ = inp;
			_tmp26_ = g_data_input_stream_read_line (_tmp24_, &_tmp25_, NULL, &_inner_error_);
			len = _tmp25_;
			_tmp23_ = _tmp26_;
			if (_inner_error_ != NULL) {
				_g_free0 (line);
				_g_object_unref0 (inp);
				goto __catch2_g_error;
			}
			_g_free0 (line);
			line = _tmp23_;
			_tmp27_ = line;
			if (!(_tmp27_ != NULL)) {
				break;
			}
			_tmp28_ = line;
			_tmp29_ = prefix;
			_tmp30_ = g_str_has_prefix (_tmp28_, _tmp29_);
			if (_tmp30_) {
				const gchar* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				existing = TRUE;
				_tmp31_ = props;
				_tmp32_ = prefix;
				_tmp33_ = real_value;
				_tmp34_ = g_strconcat (_tmp32_, _tmp33_, NULL);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strconcat (_tmp35_, "\n", NULL);
				_tmp37_ = _tmp36_;
				_tmp38_ = g_strconcat (_tmp31_, _tmp37_, NULL);
				_g_free0 (props);
				props = _tmp38_;
				_g_free0 (_tmp37_);
				_g_free0 (_tmp35_);
			} else {
				const gchar* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				_tmp39_ = props;
				_tmp40_ = line;
				_tmp41_ = g_strconcat (_tmp40_, "\n", NULL);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strconcat (_tmp39_, _tmp42_, NULL);
				_g_free0 (props);
				props = _tmp43_;
				_g_free0 (_tmp42_);
			}
		}
		_tmp44_ = inp;
		g_input_stream_close ((GInputStream*) _tmp44_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			goto __catch2_g_error;
		}
		_tmp45_ = existing;
		if (!_tmp45_) {
			const gchar* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
			_tmp46_ = props;
			_tmp47_ = prefix;
			_tmp48_ = real_value;
			_tmp49_ = g_strconcat (_tmp47_, _tmp48_, NULL);
			_tmp50_ = _tmp49_;
			_tmp51_ = g_strconcat (_tmp50_, "\n", NULL);
			_tmp52_ = _tmp51_;
			_tmp53_ = g_strconcat (_tmp46_, _tmp52_, NULL);
			_g_free0 (props);
			props = _tmp53_;
			_g_free0 (_tmp52_);
			_g_free0 (_tmp50_);
		}
		_tmp54_ = uevent_path;
		_tmp55_ = props;
		_tmp56_ = string_get_data (_tmp55_, &_tmp56__length1);
		_tmp57_ = _tmp56_;
		_tmp57__length1 = _tmp56__length1;
		g_file_set_contents (_tmp54_, (const char*) _tmp57_, (size_t) _tmp57__length1, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			goto __catch2_g_error;
		}
		_g_free0 (line);
		_g_object_unref0 (inp);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp58_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp58_ = e->message;
		g_error ("umockdev.vala:256: Cannot update uevent file: %s", _tmp58_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (prefix);
		_g_object_unref0 (f);
		_g_free0 (real_value);
		_g_free0 (props);
		_g_free0 (uevent_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (prefix);
	_g_object_unref0 (f);
	_g_free0 (real_value);
	_g_free0 (props);
	_g_free0 (uevent_path);
}


/**
     * umockdev_testbed_set_property_int:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     * @value: Property integer value
     *
     * Set an integer udev property for a device.
     */
void umockdev_testbed_set_property_int (UMockdevTestbed* self, const gchar* devpath, const gchar* name, gint value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = devpath;
	_tmp1_ = name;
	_tmp2_ = value;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	umockdev_testbed_set_property (self, _tmp0_, _tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
}


/**
     * umockdev_testbed_set_property_hex:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     * @value: Property integer value
     *
     * Set an integer udev property for a device. @value is interpreted as a
     * hexadecimal number. For example, for value==31 this sets the property's
     * value to "1f".
     */
void umockdev_testbed_set_property_hex (UMockdevTestbed* self, const gchar* devpath, const gchar* name, guint value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = devpath;
	_tmp1_ = name;
	_tmp2_ = value;
	_tmp3_ = g_strdup_printf ("%x", _tmp2_);
	_tmp4_ = _tmp3_;
	umockdev_testbed_set_property (self, _tmp0_, _tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
}


/**
     * umockdev_testbed_add_devicev:
     * @self: A #UMockdevTestbed.
     * @subsystem: The subsystem name, e. g. "usb"
     * @name: The device name; arbitrary, but needs to be unique within the testbed
     * @parent: (allow-none): device path of the parent device. Use %NULL for a
     *          top-level device.
     * @attributes: (array zero-terminated=1):
     *              A list of device sysfs attributes, alternating names and
     *              values, terminated with %NULL:
     *              { "key1", "value1", "key2", "value2", ..., NULL }
     * @properties: (array zero-terminated=1):
     *              A list of device udev properties; same format as @attributes
     *
     * This method is mostly meant for language bindings (where it is named
     * umockdev_testbed_add_device()). For C programs it is usually more convenient to
     * use umockdev_testbed_add_device().
     *
     * Add a new device to the testbed. A Linux kernel device always has a
     * subsystem (such as "usb" or "pci"), and a device name. The test bed only
     * builds a very simple sysfs structure without nested namespaces, so it
     * requires device names to be unique. Some gudev client programs might make
     * assumptions about the name (e. g. a SCSI disk block device should be called
     * sdaN). A device also has an arbitrary number of sysfs attributes and udev
     * properties; usually you should specify them upon creation, but it is also
     * possible to change them later on with umockdev_testbed_set_attribute() and
     * umockdev_testbed_set_property().
     *
     * Returns: The sysfs path for the newly created device. Free with g_free().
     *
     * Rename to: umockdev_testbed_add_device
     */
static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp5_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


gchar* umockdev_testbed_add_devicev (UMockdevTestbed* self, const gchar* subsystem, const gchar* name, const gchar* parent, gchar** attributes, gchar** properties) {
	gchar* result = NULL;
	gchar* dev_path = NULL;
	gchar* dev_node = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* dev_dir = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gchar* class_dir = NULL;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gchar* dev_path_no_sys = NULL;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	const gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	gchar* _tmp58_ = NULL;
	gchar* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gboolean _tmp61_ = FALSE;
	const gchar* _tmp62_ = NULL;
	gboolean _tmp64_ = FALSE;
	gchar* props = NULL;
	gchar* _tmp80_ = NULL;
	gchar** _tmp120_ = NULL;
	gint _tmp120__length1 = 0;
	const gchar* _tmp124_ = NULL;
	const gchar* _tmp125_ = NULL;
	gchar** _tmp190_ = NULL;
	gint _tmp190__length1 = 0;
	gboolean _tmp194_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	dev_node = NULL;
	_tmp0_ = parent;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp1_ = parent;
		_tmp2_ = g_str_has_prefix (_tmp1_, "/sys/");
		if (!_tmp2_) {
			const gchar* _tmp3_ = NULL;
			_tmp3_ = parent;
			g_critical ("umockdev.vala:331: add_devicev(): parent device %s does not start with" \
" /sys/", _tmp3_);
			result = NULL;
			_g_free0 (dev_node);
			_g_free0 (dev_path);
			return result;
		}
		_tmp4_ = parent;
		_tmp5_ = g_file_test (_tmp4_, G_FILE_TEST_IS_DIR);
		if (!_tmp5_) {
			const gchar* _tmp6_ = NULL;
			_tmp6_ = parent;
			g_critical ("umockdev.vala:335: add_devicev(): parent device %s does not exist", _tmp6_);
			result = NULL;
			_g_free0 (dev_node);
			_g_free0 (dev_path);
			return result;
		}
		_tmp7_ = parent;
		_tmp8_ = name;
		_tmp9_ = g_build_filename (_tmp7_, _tmp8_, NULL);
		_g_free0 (dev_path);
		dev_path = _tmp9_;
	} else {
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp10_ = name;
		_tmp11_ = g_build_filename ("/sys/devices", _tmp10_, NULL);
		_g_free0 (dev_path);
		dev_path = _tmp11_;
	}
	_tmp12_ = self->priv->root_dir;
	_tmp13_ = dev_path;
	_tmp14_ = g_build_filename (_tmp12_, _tmp13_, NULL);
	dev_dir = _tmp14_;
	_tmp16_ = dev_dir;
	_tmp17_ = g_file_test (_tmp16_, G_FILE_TEST_EXISTS);
	if (_tmp17_) {
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		_tmp18_ = dev_dir;
		_tmp19_ = g_build_filename (_tmp18_, "uevent", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_file_test (_tmp20_, G_FILE_TEST_EXISTS);
		_tmp15_ = _tmp21_;
		_g_free0 (_tmp20_);
	} else {
		_tmp15_ = FALSE;
	}
	_tmp22_ = _tmp15_;
	if (_tmp22_) {
		const gchar* _tmp23_ = NULL;
		_tmp23_ = dev_dir;
		g_error ("umockdev.vala:346: device %s already exists", _tmp23_);
	}
	_tmp24_ = dev_dir;
	_tmp25_ = g_mkdir_with_parents (_tmp24_, 0755);
	if (_tmp25_ != 0) {
		const gchar* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		const gchar* _tmp28_ = NULL;
		_tmp26_ = dev_dir;
		_tmp27_ = errno;
		_tmp28_ = g_strerror (_tmp27_);
		g_error ("umockdev.vala:350: cannot create dev dir '%s': %s", _tmp26_, _tmp28_);
	}
	_tmp29_ = self->priv->sys_dir;
	_tmp30_ = subsystem;
	_tmp31_ = g_build_filename (_tmp29_, "class", _tmp30_, NULL);
	class_dir = _tmp31_;
	_tmp32_ = class_dir;
	_tmp33_ = g_mkdir_with_parents (_tmp32_, 0755);
	if (_tmp33_ != 0) {
		const gchar* _tmp34_ = NULL;
		gint _tmp35_ = 0;
		const gchar* _tmp36_ = NULL;
		_tmp34_ = class_dir;
		_tmp35_ = errno;
		_tmp36_ = g_strerror (_tmp35_);
		g_error ("umockdev.vala:353: cannot create class dir '%s': %s", _tmp34_, _tmp36_);
	}
	_tmp37_ = dev_path;
	_tmp38_ = dev_path;
	_tmp39_ = string_index_of (_tmp38_, "/devices/", 0);
	_tmp40_ = string_substring (_tmp37_, (glong) _tmp39_, (glong) (-1));
	dev_path_no_sys = _tmp40_;
	_tmp41_ = dev_path;
	_tmp42_ = umockdev_make_dotdots (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = subsystem;
	_tmp45_ = g_build_filename (_tmp43_, "class", _tmp44_, NULL);
	_tmp46_ = _tmp45_;
	_tmp47_ = dev_dir;
	_tmp48_ = g_build_filename (_tmp47_, "subsystem", NULL);
	_tmp49_ = _tmp48_;
	_tmp50_ = symlink (_tmp46_, _tmp49_);
	_vala_assert (_tmp50_ == 0, "FileUtils.symlink(Path.build_filename(make_dotdots(dev_path), \"class\", subsystem),                                  Path.build_filename(dev_dir, \"subsystem\")) == 0");
	_g_free0 (_tmp49_);
	_g_free0 (_tmp46_);
	_g_free0 (_tmp43_);
	_tmp51_ = dev_path_no_sys;
	_tmp52_ = g_build_filename ("..", "..", _tmp51_, NULL);
	_tmp53_ = _tmp52_;
	_tmp54_ = class_dir;
	_tmp55_ = name;
	_tmp56_ = g_path_get_basename (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = g_build_filename (_tmp54_, _tmp57_, NULL);
	_tmp59_ = _tmp58_;
	_tmp60_ = symlink (_tmp53_, _tmp59_);
	_vala_assert (_tmp60_ == 0, "FileUtils.symlink(Path.build_filename(\"..\", \"..\", dev_path_no_sys),                                  Path.build_filename(class_dir, Path.get_basename(name))) == 0");
	_g_free0 (_tmp59_);
	_g_free0 (_tmp57_);
	_g_free0 (_tmp53_);
	_tmp62_ = subsystem;
	if (g_strcmp0 (_tmp62_, "usb") == 0) {
		_tmp61_ = TRUE;
	} else {
		const gchar* _tmp63_ = NULL;
		_tmp63_ = subsystem;
		_tmp61_ = g_strcmp0 (_tmp63_, "pci") == 0;
	}
	_tmp64_ = _tmp61_;
	if (_tmp64_) {
		const gchar* _tmp65_ = NULL;
		const gchar* _tmp66_ = NULL;
		gchar* _tmp67_ = NULL;
		const gchar* _tmp68_ = NULL;
		gint _tmp69_ = 0;
		const gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_ = NULL;
		const gchar* _tmp73_ = NULL;
		const gchar* _tmp74_ = NULL;
		gchar* _tmp75_ = NULL;
		gchar* _tmp76_ = NULL;
		gchar* _tmp77_ = NULL;
		gchar* _tmp78_ = NULL;
		gint _tmp79_ = 0;
		_tmp65_ = self->priv->sys_dir;
		_tmp66_ = subsystem;
		_tmp67_ = g_build_filename (_tmp65_, "bus", _tmp66_, "devices", NULL);
		_g_free0 (class_dir);
		class_dir = _tmp67_;
		_tmp68_ = class_dir;
		_tmp69_ = g_mkdir_with_parents (_tmp68_, 0755);
		_vala_assert (_tmp69_ == 0, "DirUtils.create_with_parents(class_dir, 0755) == 0");
		_tmp70_ = dev_path_no_sys;
		_tmp71_ = g_build_filename ("..", "..", "..", _tmp70_, NULL);
		_tmp72_ = _tmp71_;
		_tmp73_ = class_dir;
		_tmp74_ = name;
		_tmp75_ = g_path_get_basename (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = g_build_filename (_tmp73_, _tmp76_, NULL);
		_tmp78_ = _tmp77_;
		_tmp79_ = symlink (_tmp72_, _tmp78_);
		_vala_assert (_tmp79_ == 0, "FileUtils.symlink(Path.build_filename(\"..\", \"..\", \"..\", dev_path_no_sys),                                      Path.build_filename(class_dir, Path.get_basename(name))) == 0");
		_g_free0 (_tmp78_);
		_g_free0 (_tmp76_);
		_g_free0 (_tmp72_);
	}
	_tmp80_ = g_strdup ("");
	props = _tmp80_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp81_ = FALSE;
			_tmp81_ = TRUE;
			while (TRUE) {
				gboolean _tmp82_ = FALSE;
				gint _tmp84_ = 0;
				gchar** _tmp85_ = NULL;
				gint _tmp85__length1 = 0;
				gboolean _tmp86_ = FALSE;
				gchar** _tmp87_ = NULL;
				gint _tmp87__length1 = 0;
				gint _tmp88_ = 0;
				const gchar* _tmp89_ = NULL;
				gboolean _tmp94_ = FALSE;
				_tmp82_ = _tmp81_;
				if (!_tmp82_) {
					gint _tmp83_ = 0;
					_tmp83_ = i;
					i = _tmp83_ + 2;
				}
				_tmp81_ = FALSE;
				_tmp84_ = i;
				_tmp85_ = properties;
				_tmp85__length1 = _vala_array_length (properties);
				if (!(_tmp84_ < (_tmp85__length1 - 1))) {
					break;
				}
				_tmp87_ = properties;
				_tmp87__length1 = _vala_array_length (properties);
				_tmp88_ = i;
				_tmp89_ = _tmp87_[_tmp88_];
				if (g_strcmp0 (_tmp89_, "DEVNAME") == 0) {
					gchar** _tmp90_ = NULL;
					gint _tmp90__length1 = 0;
					gint _tmp91_ = 0;
					const gchar* _tmp92_ = NULL;
					gboolean _tmp93_ = FALSE;
					_tmp90_ = properties;
					_tmp90__length1 = _vala_array_length (properties);
					_tmp91_ = i;
					_tmp92_ = _tmp90_[_tmp91_ + 1];
					_tmp93_ = g_str_has_prefix (_tmp92_, "/dev/");
					_tmp86_ = _tmp93_;
				} else {
					_tmp86_ = FALSE;
				}
				_tmp94_ = _tmp86_;
				if (_tmp94_) {
					gchar** _tmp95_ = NULL;
					gint _tmp95__length1 = 0;
					gint _tmp96_ = 0;
					const gchar* _tmp97_ = NULL;
					gchar* _tmp98_ = NULL;
					const gchar* _tmp99_ = NULL;
					const gchar* _tmp100_ = NULL;
					gchar* _tmp101_ = NULL;
					gchar* _tmp102_ = NULL;
					gchar* _tmp103_ = NULL;
					gchar* _tmp104_ = NULL;
					gchar* _tmp105_ = NULL;
					_tmp95_ = properties;
					_tmp95__length1 = _vala_array_length (properties);
					_tmp96_ = i;
					_tmp97_ = _tmp95_[_tmp96_ + 1];
					_tmp98_ = string_substring (_tmp97_, (glong) 5, (glong) (-1));
					_g_free0 (dev_node);
					dev_node = _tmp98_;
					_tmp99_ = props;
					_tmp100_ = dev_node;
					_tmp101_ = g_strconcat ("DEVNAME=", _tmp100_, NULL);
					_tmp102_ = _tmp101_;
					_tmp103_ = g_strconcat (_tmp102_, "\n", NULL);
					_tmp104_ = _tmp103_;
					_tmp105_ = g_strconcat (_tmp99_, _tmp104_, NULL);
					_g_free0 (props);
					props = _tmp105_;
					_g_free0 (_tmp104_);
					_g_free0 (_tmp102_);
				} else {
					const gchar* _tmp106_ = NULL;
					gchar** _tmp107_ = NULL;
					gint _tmp107__length1 = 0;
					gint _tmp108_ = 0;
					const gchar* _tmp109_ = NULL;
					gchar* _tmp110_ = NULL;
					gchar* _tmp111_ = NULL;
					gchar** _tmp112_ = NULL;
					gint _tmp112__length1 = 0;
					gint _tmp113_ = 0;
					const gchar* _tmp114_ = NULL;
					gchar* _tmp115_ = NULL;
					gchar* _tmp116_ = NULL;
					gchar* _tmp117_ = NULL;
					gchar* _tmp118_ = NULL;
					gchar* _tmp119_ = NULL;
					_tmp106_ = props;
					_tmp107_ = properties;
					_tmp107__length1 = _vala_array_length (properties);
					_tmp108_ = i;
					_tmp109_ = _tmp107_[_tmp108_];
					_tmp110_ = g_strconcat (_tmp109_, "=", NULL);
					_tmp111_ = _tmp110_;
					_tmp112_ = properties;
					_tmp112__length1 = _vala_array_length (properties);
					_tmp113_ = i;
					_tmp114_ = _tmp112_[_tmp113_ + 1];
					_tmp115_ = g_strconcat (_tmp111_, _tmp114_, NULL);
					_tmp116_ = _tmp115_;
					_tmp117_ = g_strconcat (_tmp116_, "\n", NULL);
					_tmp118_ = _tmp117_;
					_tmp119_ = g_strconcat (_tmp106_, _tmp118_, NULL);
					_g_free0 (props);
					props = _tmp119_;
					_g_free0 (_tmp118_);
					_g_free0 (_tmp116_);
					_g_free0 (_tmp111_);
				}
			}
		}
	}
	_tmp120_ = properties;
	_tmp120__length1 = _vala_array_length (properties);
	if ((_tmp120__length1 % 2) != 0) {
		gchar** _tmp121_ = NULL;
		gint _tmp121__length1 = 0;
		gchar** _tmp122_ = NULL;
		gint _tmp122__length1 = 0;
		const gchar* _tmp123_ = NULL;
		_tmp121_ = properties;
		_tmp121__length1 = _vala_array_length (properties);
		_tmp122_ = properties;
		_tmp122__length1 = _vala_array_length (properties);
		_tmp123_ = _tmp121_[_tmp122__length1 - 1];
		g_warning ("umockdev.vala:385: add_devicev: Ignoring property key '%s' without val" \
"ue", _tmp123_);
	}
	_tmp124_ = dev_path;
	_tmp125_ = props;
	umockdev_testbed_set_attribute (self, _tmp124_, "uevent", _tmp125_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp126_ = FALSE;
			_tmp126_ = TRUE;
			while (TRUE) {
				gboolean _tmp127_ = FALSE;
				gint _tmp129_ = 0;
				gchar** _tmp130_ = NULL;
				gint _tmp130__length1 = 0;
				const gchar* _tmp131_ = NULL;
				gchar** _tmp132_ = NULL;
				gint _tmp132__length1 = 0;
				gint _tmp133_ = 0;
				const gchar* _tmp134_ = NULL;
				gchar** _tmp135_ = NULL;
				gint _tmp135__length1 = 0;
				gint _tmp136_ = 0;
				const gchar* _tmp137_ = NULL;
				gboolean _tmp138_ = FALSE;
				gchar** _tmp139_ = NULL;
				gint _tmp139__length1 = 0;
				gint _tmp140_ = 0;
				const gchar* _tmp141_ = NULL;
				gboolean _tmp143_ = FALSE;
				_tmp127_ = _tmp126_;
				if (!_tmp127_) {
					gint _tmp128_ = 0;
					_tmp128_ = i;
					i = _tmp128_ + 2;
				}
				_tmp126_ = FALSE;
				_tmp129_ = i;
				_tmp130_ = attributes;
				_tmp130__length1 = _vala_array_length (attributes);
				if (!(_tmp129_ < (_tmp130__length1 - 1))) {
					break;
				}
				_tmp131_ = dev_path;
				_tmp132_ = attributes;
				_tmp132__length1 = _vala_array_length (attributes);
				_tmp133_ = i;
				_tmp134_ = _tmp132_[_tmp133_];
				_tmp135_ = attributes;
				_tmp135__length1 = _vala_array_length (attributes);
				_tmp136_ = i;
				_tmp137_ = _tmp135_[_tmp136_ + 1];
				umockdev_testbed_set_attribute (self, _tmp131_, _tmp134_, _tmp137_);
				_tmp139_ = attributes;
				_tmp139__length1 = _vala_array_length (attributes);
				_tmp140_ = i;
				_tmp141_ = _tmp139_[_tmp140_];
				if (g_strcmp0 (_tmp141_, "dev") == 0) {
					const gchar* _tmp142_ = NULL;
					_tmp142_ = dev_node;
					_tmp138_ = _tmp142_ != NULL;
				} else {
					_tmp138_ = FALSE;
				}
				_tmp143_ = _tmp138_;
				if (_tmp143_) {
					gchar* infodir = NULL;
					const gchar* _tmp144_ = NULL;
					gchar* _tmp145_ = NULL;
					const gchar* _tmp146_ = NULL;
					gchar** _tmp147_ = NULL;
					gint _tmp147__length1 = 0;
					gint _tmp148_ = 0;
					const gchar* _tmp149_ = NULL;
					const gchar* _tmp150_ = NULL;
					const gchar* _tmp151_ = NULL;
					gchar* _tmp152_ = NULL;
					gchar* _tmp153_ = NULL;
					gchar* _tmp154_ = NULL;
					gchar* _tmp155_ = NULL;
					gint _tmp156_ = 0;
					const gchar* _tmp157_ = NULL;
					const gchar* _tmp158_ = NULL;
					gboolean _tmp159_ = FALSE;
					gchar* sysdev_dir = NULL;
					const gchar* _tmp160_ = NULL;
					const gchar* _tmp161_ = NULL;
					gchar* _tmp162_ = NULL;
					const gchar* _tmp163_ = NULL;
					gint _tmp164_ = 0;
					gchar* dest = NULL;
					const gchar* _tmp168_ = NULL;
					gchar** _tmp169_ = NULL;
					gint _tmp169__length1 = 0;
					gint _tmp170_ = 0;
					const gchar* _tmp171_ = NULL;
					gchar* _tmp172_ = NULL;
					const gchar* _tmp173_ = NULL;
					gboolean _tmp174_ = FALSE;
					_tmp144_ = self->priv->root_dir;
					_tmp145_ = g_build_filename (_tmp144_, "dev", ".node", NULL);
					infodir = _tmp145_;
					_tmp146_ = infodir;
					g_mkdir_with_parents (_tmp146_, 0755);
					_tmp147_ = attributes;
					_tmp147__length1 = _vala_array_length (attributes);
					_tmp148_ = i;
					_tmp149_ = _tmp147_[_tmp148_ + 1];
					_tmp150_ = infodir;
					_tmp151_ = dev_node;
					_tmp152_ = string_replace (_tmp151_, "/", "_");
					_tmp153_ = _tmp152_;
					_tmp154_ = g_build_filename (_tmp150_, _tmp153_, NULL);
					_tmp155_ = _tmp154_;
					_tmp156_ = symlink (_tmp149_, _tmp155_);
					_vala_assert (_tmp156_ == 0, "FileUtils.symlink(attributes[i+1],                                          Path.build_filename(infodir, dev_node.replace(\"/\", \"_\"))) == 0");
					_g_free0 (_tmp155_);
					_g_free0 (_tmp153_);
					_tmp158_ = dev_path;
					_tmp159_ = string_contains (_tmp158_, "/block/");
					if (_tmp159_) {
						_tmp157_ = "block";
					} else {
						_tmp157_ = "char";
					}
					_tmp160_ = self->priv->sys_dir;
					_tmp161_ = _tmp157_;
					_tmp162_ = g_build_filename (_tmp160_, "dev", _tmp161_, NULL);
					sysdev_dir = _tmp162_;
					_tmp163_ = sysdev_dir;
					_tmp164_ = g_mkdir_with_parents (_tmp163_, 0755);
					if (_tmp164_ != 0) {
						const gchar* _tmp165_ = NULL;
						gint _tmp166_ = 0;
						const gchar* _tmp167_ = NULL;
						_tmp165_ = sysdev_dir;
						_tmp166_ = errno;
						_tmp167_ = g_strerror (_tmp166_);
						g_error ("umockdev.vala:402: cannot create dir '%s': %s", _tmp165_, _tmp167_);
					}
					_tmp168_ = sysdev_dir;
					_tmp169_ = attributes;
					_tmp169__length1 = _vala_array_length (attributes);
					_tmp170_ = i;
					_tmp171_ = _tmp169_[_tmp170_ + 1];
					_tmp172_ = g_build_filename (_tmp168_, _tmp171_, NULL);
					dest = _tmp172_;
					_tmp173_ = dest;
					_tmp174_ = g_file_test (_tmp173_, G_FILE_TEST_EXISTS);
					if (!_tmp174_) {
						const gchar* _tmp175_ = NULL;
						gchar* _tmp176_ = NULL;
						gchar* _tmp177_ = NULL;
						gchar* _tmp178_ = NULL;
						gchar* _tmp179_ = NULL;
						const gchar* _tmp180_ = NULL;
						gint _tmp181_ = 0;
						gboolean _tmp182_ = FALSE;
						_tmp175_ = dev_path;
						_tmp176_ = string_substring (_tmp175_, (glong) 5, (glong) (-1));
						_tmp177_ = _tmp176_;
						_tmp178_ = g_strconcat ("../../", _tmp177_, NULL);
						_tmp179_ = _tmp178_;
						_tmp180_ = dest;
						_tmp181_ = symlink (_tmp179_, _tmp180_);
						_tmp182_ = _tmp181_ < 0;
						_g_free0 (_tmp179_);
						_g_free0 (_tmp177_);
						if (_tmp182_) {
							const gchar* _tmp183_ = NULL;
							const gchar* _tmp184_ = NULL;
							const gchar* _tmp185_ = NULL;
							gchar* _tmp186_ = NULL;
							gchar* _tmp187_ = NULL;
							gint _tmp188_ = 0;
							const gchar* _tmp189_ = NULL;
							_tmp183_ = name;
							_tmp184_ = dest;
							_tmp185_ = dev_path;
							_tmp186_ = string_substring (_tmp185_, (glong) 5, (glong) (-1));
							_tmp187_ = _tmp186_;
							_tmp188_ = errno;
							_tmp189_ = g_strerror (_tmp188_);
							g_error ("umockdev.vala:406: add_device %s: failed to symlink %s to %s: %s\n", _tmp183_, _tmp184_, _tmp187_, _tmp189_);
							_g_free0 (_tmp187_);
						}
					}
					_g_free0 (dest);
					_g_free0 (sysdev_dir);
					_g_free0 (infodir);
				}
			}
		}
	}
	_tmp190_ = attributes;
	_tmp190__length1 = _vala_array_length (attributes);
	if ((_tmp190__length1 % 2) != 0) {
		gchar** _tmp191_ = NULL;
		gint _tmp191__length1 = 0;
		gchar** _tmp192_ = NULL;
		gint _tmp192__length1 = 0;
		const gchar* _tmp193_ = NULL;
		_tmp191_ = attributes;
		_tmp191__length1 = _vala_array_length (attributes);
		_tmp192_ = attributes;
		_tmp192__length1 = _vala_array_length (attributes);
		_tmp193_ = _tmp191_[_tmp192__length1 - 1];
		g_warning ("umockdev.vala:412: add_devicev: Ignoring attribute key '%s' without va" \
"lue", _tmp193_);
	}
	_tmp194_ = umockdev_in_mock_environment ();
	if (_tmp194_) {
		const gchar* _tmp195_ = NULL;
		_tmp195_ = dev_path;
		umockdev_testbed_uevent (self, _tmp195_, "add");
	}
	result = dev_path;
	_g_free0 (props);
	_g_free0 (dev_path_no_sys);
	_g_free0 (class_dir);
	_g_free0 (dev_dir);
	_g_free0 (dev_node);
	return result;
}


/**
     * umockdev_testbed_add_device: (skip)
     * @self: A #UMockdevTestbed.
     * @subsystem: The subsystem name, e. g. "usb"
     * @name: The device name; arbitrary, but needs to be unique within the testbed
     * @parent: (allow-none): device path of the parent device. Use %NULL for a
     *          top-level device.
     * @...: Arbitrarily many pairs of sysfs attributes (alternating names and
     *       values), terminated by %NULL, followed by arbitrarily many pairs of udev
     *       properties, terminated by another %NULL.
     *
     * Add a new device to the testbed. A Linux kernel device always has a
     * subsystem (such as "usb" or "pci"), and a device name. The test bed only
     * builds a very simple sysfs structure without nested namespaces, so it
     * requires device names to be unique. Some gudev client programs might make
     * assumptions about the name (e. g. a SCSI disk block device should be called
     * sdaN). A device also has an arbitrary number of sysfs attributes and udev
     * properties; usually you should specify them upon creation, but it is also
     * possible to change them later on with umockdev_testbed_set_attribute() and
     * umockdev_testbed_set_property().
     *
     * Example:
     *   |[
     *   umockdev_testbed_add_device (testbed, "usb", "dev1", NULL,
     *                              "idVendor", "0815", "idProduct", "AFFE", NULL,
     *                              "ID_MODEL", "KoolGadget", NULL);
     *   ]|
     *
     * Returns: The sysfs path for the newly created device. Free with g_free().
     */
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar* umockdev_testbed_add_device (UMockdevTestbed* self, const gchar* subsystem, const gchar* name, const gchar* parent, ...) {
	gchar* result = NULL;
	gchar** attributes = NULL;
	gchar** _tmp0_ = NULL;
	gint attributes_length1 = 0;
	gint _attributes_size_ = 0;
	gchar** properties = NULL;
	gchar** _tmp1_ = NULL;
	gint properties_length1 = 0;
	gint _properties_size_ = 0;
	gint arg_set = 0;
	va_list l = {0};
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gchar* _tmp19_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	attributes = _tmp0_;
	attributes_length1 = 0;
	_attributes_size_ = attributes_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	properties = _tmp1_;
	properties_length1 = 0;
	_properties_size_ = properties_length1;
	arg_set = 0;
	va_start (l, parent);
	while (TRUE) {
		gchar* arg = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gint _tmp7_ = 0;
		_tmp2_ = va_arg (l, gchar*);
		_tmp3_ = g_strdup (_tmp2_);
		arg = _tmp3_;
		_tmp4_ = arg;
		if (_tmp4_ == NULL) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			_tmp5_ = arg_set;
			arg_set = _tmp5_ + 1;
			_tmp6_ = arg_set;
			if (_tmp6_ > 1) {
				_g_free0 (arg);
				break;
			} else {
				_g_free0 (arg);
				continue;
			}
		}
		_tmp7_ = arg_set;
		if (_tmp7_ == 0) {
			gchar** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			_tmp8_ = attributes;
			_tmp8__length1 = attributes_length1;
			_tmp9_ = arg;
			_tmp10_ = g_strdup (_tmp9_);
			_vala_array_add1 (&attributes, &attributes_length1, &_attributes_size_, _tmp10_);
		} else {
			gchar** _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			_tmp11_ = properties;
			_tmp11__length1 = properties_length1;
			_tmp12_ = arg;
			_tmp13_ = g_strdup (_tmp12_);
			_vala_array_add2 (&properties, &properties_length1, &_properties_size_, _tmp13_);
		}
		_g_free0 (arg);
	}
	_tmp14_ = subsystem;
	_tmp15_ = name;
	_tmp16_ = parent;
	_tmp17_ = attributes;
	_tmp17__length1 = attributes_length1;
	_tmp18_ = properties;
	_tmp18__length1 = properties_length1;
	_tmp19_ = umockdev_testbed_add_devicev (self, _tmp14_, _tmp15_, _tmp16_, _tmp17_, _tmp18_);
	result = _tmp19_;
	va_end (l);
	properties = (_vala_array_free (properties, properties_length1, (GDestroyNotify) g_free), NULL);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


/**
     * umockdev_testbed_remove_device:
     * @self: A #UMockdevTestbed.
     * @syspath: Sysfs path of device
     *
     * Remove a device from the testbed. This removes the sysfs directory, the
     * /sys/class/ link, the device node, and all other information related to
     * it. Note that this will also remove all child devices (i. e.
     * subdirectories of @syspath).
     */
void umockdev_testbed_remove_device (UMockdevTestbed* self, const gchar* syspath) {
	gchar* real_path = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* devname = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* subsystem = NULL;
	const gchar* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	gboolean _tmp58_ = FALSE;
	const gchar* _tmp59_ = NULL;
	gboolean _tmp61_ = FALSE;
	const gchar* _tmp75_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (syspath != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = syspath;
	_tmp2_ = g_build_filename (_tmp0_, _tmp1_, NULL);
	real_path = _tmp2_;
	_tmp3_ = syspath;
	_tmp4_ = g_path_get_basename (_tmp3_);
	devname = _tmp4_;
	_tmp5_ = real_path;
	_tmp6_ = g_file_test (_tmp5_, G_FILE_TEST_IS_DIR);
	if (!_tmp6_) {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = syspath;
		g_critical ("umockdev.vala:492: umockdev_testbed_remove_device(): device %s does no" \
"t exist", _tmp7_);
		_g_free0 (devname);
		_g_free0 (real_path);
		return;
	}
	{
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp9_ = real_path;
		_tmp10_ = g_build_filename (_tmp9_, "subsystem", NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_file_read_link (_tmp11_, &_inner_error_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_tmp8_ = _tmp13_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			_g_free0 (subsystem);
			_g_free0 (devname);
			_g_free0 (real_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp14_ = _tmp8_;
		_tmp15_ = g_path_get_basename (_tmp14_);
		_g_free0 (subsystem);
		subsystem = _tmp15_;
		_g_free0 (_tmp14_);
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = syspath;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_critical ("umockdev.vala:502: umockdev_testbed_remove_device(): cannot determine " \
"subsystem of %s: %s", _tmp16_, _tmp18_);
		_g_error_free0 (e);
		_g_free0 (subsystem);
		_g_free0 (devname);
		_g_free0 (real_path);
		return;
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (subsystem);
		_g_free0 (devname);
		_g_free0 (real_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gchar* dev_maj_min = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
		const gchar* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* dev_node = NULL;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		_tmp19_ = real_path;
		_tmp20_ = g_build_filename (_tmp19_, "dev", NULL);
		_tmp21_ = _tmp20_;
		g_file_get_contents (_tmp21_, &_tmp22_, NULL, &_inner_error_);
		_g_free0 (dev_maj_min);
		dev_maj_min = _tmp22_;
		_g_free0 (_tmp21_);
		if (_inner_error_ != NULL) {
			_g_free0 (dev_maj_min);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch5_g_file_error;
			}
			_g_free0 (dev_maj_min);
			_g_free0 (subsystem);
			_g_free0 (devname);
			_g_free0 (real_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp24_ = syspath;
		_tmp25_ = string_contains (_tmp24_, "/block/");
		if (_tmp25_) {
			_tmp23_ = "block";
		} else {
			_tmp23_ = "char";
		}
		_tmp26_ = self->priv->sys_dir;
		_tmp27_ = _tmp23_;
		_tmp28_ = dev_maj_min;
		_tmp29_ = g_build_filename (_tmp26_, "dev", _tmp27_, _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		g_unlink (_tmp30_);
		_g_free0 (_tmp30_);
		_tmp31_ = real_path;
		_tmp32_ = umockdev_find_devnode (_tmp31_);
		dev_node = _tmp32_;
		_tmp33_ = dev_node;
		if (_tmp33_ != NULL) {
			gchar* real_node = NULL;
			const gchar* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			const gchar* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			_tmp34_ = self->priv->root_dir;
			_tmp35_ = dev_node;
			_tmp36_ = g_build_filename (_tmp34_, _tmp35_, NULL);
			real_node = _tmp36_;
			_tmp37_ = real_node;
			g_unlink (_tmp37_);
			_tmp38_ = real_node;
			_tmp39_ = g_path_get_dirname (_tmp38_);
			_tmp40_ = _tmp39_;
			g_rmdir (_tmp40_);
			_g_free0 (_tmp40_);
			_tmp41_ = self->priv->root_dir;
			_tmp42_ = dev_node;
			_tmp43_ = string_substring (_tmp42_, (glong) 5, (glong) (-1));
			_tmp44_ = _tmp43_;
			_tmp45_ = string_replace (_tmp44_, "/", "_");
			_tmp46_ = _tmp45_;
			_tmp47_ = g_build_filename (_tmp41_, "dev", ".node", _tmp46_, NULL);
			_tmp48_ = _tmp47_;
			g_unlink (_tmp48_);
			_g_free0 (_tmp48_);
			_g_free0 (_tmp46_);
			_g_free0 (_tmp44_);
			_g_free0 (real_node);
		}
		_g_free0 (dev_node);
		_g_free0 (dev_maj_min);
	}
	goto __finally5;
	__catch5_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_free0 (subsystem);
		_g_free0 (devname);
		_g_free0 (real_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp49_ = self->priv->sys_dir;
	_tmp50_ = subsystem;
	_tmp51_ = devname;
	_tmp52_ = g_build_filename (_tmp49_, "class", _tmp50_, _tmp51_, NULL);
	_tmp53_ = _tmp52_;
	g_unlink (_tmp53_);
	_g_free0 (_tmp53_);
	_tmp54_ = self->priv->sys_dir;
	_tmp55_ = subsystem;
	_tmp56_ = g_build_filename (_tmp54_, "class", _tmp55_, NULL);
	_tmp57_ = _tmp56_;
	g_rmdir (_tmp57_);
	_g_free0 (_tmp57_);
	_tmp59_ = subsystem;
	if (g_strcmp0 (_tmp59_, "usb") == 0) {
		_tmp58_ = TRUE;
	} else {
		const gchar* _tmp60_ = NULL;
		_tmp60_ = subsystem;
		_tmp58_ = g_strcmp0 (_tmp60_, "pci") == 0;
	}
	_tmp61_ = _tmp58_;
	if (_tmp61_) {
		const gchar* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		gchar* _tmp65_ = NULL;
		gchar* _tmp66_ = NULL;
		const gchar* _tmp67_ = NULL;
		const gchar* _tmp68_ = NULL;
		gchar* _tmp69_ = NULL;
		gchar* _tmp70_ = NULL;
		const gchar* _tmp71_ = NULL;
		const gchar* _tmp72_ = NULL;
		gchar* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
		_tmp62_ = self->priv->sys_dir;
		_tmp63_ = subsystem;
		_tmp64_ = devname;
		_tmp65_ = g_build_filename (_tmp62_, "bus", _tmp63_, "devices", _tmp64_, NULL);
		_tmp66_ = _tmp65_;
		g_unlink (_tmp66_);
		_g_free0 (_tmp66_);
		_tmp67_ = self->priv->sys_dir;
		_tmp68_ = subsystem;
		_tmp69_ = g_build_filename (_tmp67_, "bus", _tmp68_, "devices", NULL);
		_tmp70_ = _tmp69_;
		g_rmdir (_tmp70_);
		_g_free0 (_tmp70_);
		_tmp71_ = self->priv->sys_dir;
		_tmp72_ = subsystem;
		_tmp73_ = g_build_filename (_tmp71_, "bus", _tmp72_, NULL);
		_tmp74_ = _tmp73_;
		g_rmdir (_tmp74_);
		_g_free0 (_tmp74_);
	}
	_tmp75_ = real_path;
	umockdev_remove_dir (_tmp75_, TRUE);
	_g_free0 (subsystem);
	_g_free0 (devname);
	_g_free0 (real_path);
}


/**
     * umockdev_testbed_add_from_string:
     * @self: A #UMockdevTestbed.
     * @data: Description of the device(s) as generated with umockdev-record
     * @error: return location for a GError, or %NULL
     *
     * Add a set of devices to the testbed from a textual description. This reads
     * the format generated by the umockdev-record tool.
     *
     * Each paragraph defines one device. A line starts with a type tag (like 'E'),
     * followed by a colon, followed by either a value or a "key=value" assignment,
     * depending on the type tag. A device description must start with a 'P:' line.
     * Available type tags are:
     * <itemizedlist>
     *   <listitem><type>P:</type> <emphasis>path</emphasis>: device path in sysfs, starting with
     *             <filename>/devices/</filename>; must occur exactly once at the
     *             start of device definition</listitem>
     *   <listitem><type>E:</type> <emphasis>key=value</emphasis>: udev property
     *             </listitem>
     *   <listitem><type>A:</type> <emphasis>key=value</emphasis>: ASCII sysfs
     *             attribute, with backslash-style escaping of \ (\\) and newlines
     *             (\n)</listitem>
     *   <listitem><type>H:</type> <emphasis>key=value</emphasis>: binary sysfs
     *             attribute, with the value being written as continuous hex string
     *             (e. g. 0081FE0A..)</listitem>
     *   <listitem><type>N:</type> <emphasis>devname</emphasis>[=<emphasis>contents</emphasis>]:
     *             device node name (without the <filename>/dev/</filename>
     *             prefix); if <emphasis>contents</emphasis> is given (encoded in a
     *             continuous hex string), it creates a
     *             <filename>/dev/devname</filename> in the mock environment with
     *             the given contents, otherwise the created dev file will be a
     *             pty; see #umockdev_testbed_get_dev_fd for details.</listitem>
     *   <listitem><type>S:</type> <emphasis>linkname</emphasis>: device node
     *             symlink (without the <filename>/dev/</filename> prefix); ignored right
     *             now.</listitem>
     * </itemizedlist>
     *
     * Returns: %TRUE on success, %FALSE if the data is invalid and an error
     *          occurred.
     */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gboolean umockdev_testbed_add_from_string (UMockdevTestbed* self, const gchar* data, GError** error) {
	gboolean result = FALSE;
	gchar* cur_data = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp6_ = NULL;
		_tmp0_ = self->priv->re_record_val;
		if (_tmp0_ == NULL) {
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_ = NULL;
			_tmp2_ = g_regex_new ("^([PS]): (.*)(?>\n|$)", 0, 0, &_inner_error_);
			_tmp1_ = _tmp2_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch6_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_g_regex_unref0 (self->priv->re_record_val);
			self->priv->re_record_val = _tmp1_;
		}
		_tmp3_ = self->priv->re_record_keyval;
		if (_tmp3_ == NULL) {
			GRegex* _tmp4_ = NULL;
			GRegex* _tmp5_ = NULL;
			_tmp5_ = g_regex_new ("^([EAHL]): ([^=\n]+)=(.*)(?>\n|$)", 0, 0, &_inner_error_);
			_tmp4_ = _tmp5_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch6_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_g_regex_unref0 (self->priv->re_record_keyval);
			self->priv->re_record_keyval = _tmp4_;
		}
		_tmp6_ = self->priv->re_record_optval;
		if (_tmp6_ == NULL) {
			GRegex* _tmp7_ = NULL;
			GRegex* _tmp8_ = NULL;
			_tmp8_ = g_regex_new ("^([N]): ([^=\n]+)(?>=([0-9A-F]+))?(?>\n|$)", 0, 0, &_inner_error_);
			_tmp7_ = _tmp8_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch6_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_g_regex_unref0 (self->priv->re_record_optval);
			self->priv->re_record_optval = _tmp7_;
		}
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e->message;
		g_error ("umockdev.vala:587: Internal error, cannot create regex: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp10_ = data;
	_tmp11_ = g_strdup (_tmp10_);
	cur_data = _tmp11_;
	while (TRUE) {
		const gchar* _tmp12_ = NULL;
		gchar _tmp13_ = '\0';
		gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp12_ = cur_data;
		_tmp13_ = string_get (_tmp12_, (glong) 0);
		if (!(_tmp13_ != '\0')) {
			break;
		}
		_tmp15_ = cur_data;
		_tmp16_ = umockdev_testbed_add_dev_from_string (self, _tmp15_, &_inner_error_);
		_tmp14_ = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (cur_data);
				return FALSE;
			} else {
				_g_free0 (cur_data);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_g_free0 (cur_data);
		cur_data = _tmp14_;
	}
	result = TRUE;
	_g_free0 (cur_data);
	return result;
}


/**
     * umockdev_testbed_add_from_file:
     * @self: A #UMockdevTestbed.
     * @path: Path to file with description of the device(s) as generated with umockdev-record
     * @error: return location for a GError, or %NULL
     *
     * Add a set of devices to the testbed from a textual description. This
     * reads a file with the format generated by the umockdev-record tool, and
     * is mostly a convenience wrapper around
     * @umockdev_testbed_add_from_string.
     *
     * Returns: %TRUE on success, %FALSE if the @path cannot be read or thhe
     *          data is invalid and an error occurred.
     */
gboolean umockdev_testbed_add_from_file (UMockdevTestbed* self, const gchar* path, GError** error) {
	gboolean result = FALSE;
	gchar* contents = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = path;
	g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error_);
	_g_free0 (contents);
	contents = _tmp1_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == UMOCKDEV_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (contents);
			return FALSE;
		} else {
			_g_free0 (contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp3_ = contents;
	_tmp4_ = umockdev_testbed_add_from_string (self, _tmp3_, &_inner_error_);
	_tmp2_ = _tmp4_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == UMOCKDEV_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (contents);
			return FALSE;
		} else {
			_g_free0 (contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp2_;
	_g_free0 (contents);
	return result;
}


/**
     * umockdev_testbed_uevent:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @action: "add", "remove", or "change"
     *
     * Generate an uevent for a device.
     */
void umockdev_testbed_uevent (UMockdevTestbed* self, const gchar* devpath, const gchar* action) {
	uevent_sender* _tmp0_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	uevent_sender* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->ev_sender;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		uevent_sender* _tmp2_ = NULL;
		uevent_sender* _tmp3_ = NULL;
		g_debug ("umockdev.vala:630: umockdev_testbed_uevent: lazily initializing uevent" \
"_sender");
		_tmp1_ = self->priv->root_dir;
		_tmp2_ = uevent_sender_open (_tmp1_);
		_uevent_sender_close0 (self->priv->ev_sender);
		self->priv->ev_sender = _tmp2_;
		_tmp3_ = self->priv->ev_sender;
		_vala_assert (_tmp3_ != NULL, "this.ev_sender != null");
	}
	_tmp4_ = action;
	_tmp5_ = devpath;
	g_debug ("umockdev.vala:634: umockdev_testbed_uevent: sending uevent %s for devi" \
"ce %s", _tmp4_, _tmp5_);
	_tmp6_ = self->priv->ev_sender;
	_tmp7_ = devpath;
	_tmp8_ = action;
	uevent_sender_send (_tmp6_, _tmp7_, _tmp8_);
}


/**
     * umockdev_testbed_load_ioctl:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the ioctl record.
     *       %NULL is valid; in this case the ioctl record is associated with
     *       the device node it was recorded from.
     * @recordfile: Path of the ioctl record file.
     * @error: return location for a GError, or %NULL
     *
     * Load an ioctl record file for a particular device into the testbed.
     * ioctl records can be created with umockdev-record --ioctl.
     * They can optionally be xz compressed to save space (but then are
     * required to have an .xz file name suffix).
     *
     * Returns: %TRUE on success, %FALSE if the data is invalid and an error
     *          occurred.
     */
static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


gboolean umockdev_testbed_load_ioctl (UMockdevTestbed* self, const gchar* dev, const gchar* recordfile, GError** error) {
	gboolean result = FALSE;
	GDataInputStream* recording = NULL;
	gchar* owned_dev = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp30_ = NULL;
	gchar* dest = NULL;
	const gchar* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	gchar* _tmp58_ = NULL;
	gchar* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gchar* contents = NULL;
	GDataInputStream* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	gboolean _tmp65_ = FALSE;
	const gchar* _tmp66_ = NULL;
	const gchar* _tmp67_ = NULL;
	gboolean _tmp68_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	_tmp0_ = dev;
	_tmp1_ = g_strdup (_tmp0_);
	owned_dev = _tmp1_;
	_tmp2_ = recordfile;
	_tmp3_ = g_str_has_suffix (_tmp2_, ".xz");
	if (_tmp3_) {
		{
			gchar* contents = NULL;
			gint exit = 0;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar** _tmp8_ = NULL;
			gchar** _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
			gchar* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			const gchar* _tmp13_ = NULL;
			guint8* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			guint8* _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			guint8* _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			GMemoryInputStream* _tmp17_ = NULL;
			GMemoryInputStream* _tmp18_ = NULL;
			GDataInputStream* _tmp19_ = NULL;
			_tmp4_ = g_strdup ("xz");
			_tmp5_ = g_strdup ("-cd");
			_tmp6_ = recordfile;
			_tmp7_ = g_strdup (_tmp6_);
			_tmp8_ = g_new0 (gchar*, 3 + 1);
			_tmp8_[0] = _tmp4_;
			_tmp8_[1] = _tmp5_;
			_tmp8_[2] = _tmp7_;
			_tmp9_ = _tmp8_;
			_tmp9__length1 = 3;
			g_spawn_sync (NULL, _tmp9_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp10_, NULL, &_tmp11_, &_inner_error_);
			_g_free0 (contents);
			contents = _tmp10_;
			exit = _tmp11_;
			_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
			if (_inner_error_ != NULL) {
				_g_free0 (contents);
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch7_g_spawn_error;
				}
				_g_free0 (contents);
				_g_free0 (owned_dev);
				_g_object_unref0 (recording);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp12_ = exit;
			_vala_assert (_tmp12_ == 0, "exit == 0");
			_tmp13_ = contents;
			_tmp14_ = string_get_data (_tmp13_, &_tmp14__length1);
			_tmp15_ = _tmp14_;
			_tmp15__length1 = _tmp14__length1;
			_tmp16_ = (_tmp15_ != NULL) ? _vala_array_dup1 (_tmp15_, _tmp15__length1) : ((gpointer) _tmp15_);
			_tmp16__length1 = _tmp15__length1;
			_tmp17_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp16_, _tmp16__length1, NULL);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_data_input_stream_new ((GInputStream*) _tmp18_);
			_g_object_unref0 (recording);
			recording = _tmp19_;
			_g_object_unref0 (_tmp18_);
			_g_free0 (contents);
		}
		goto __finally7;
		__catch7_g_spawn_error:
		{
			GError* e = NULL;
			const gchar* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp20_ = recordfile;
			_tmp21_ = e->message;
			g_error ("umockdev.vala:675: Cannot call xz to decompress %s: %s", _tmp20_, _tmp21_);
			_g_error_free0 (e);
		}
		__finally7:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return FALSE;
		}
	} else {
		GFileInputStream* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		GFile* _tmp24_ = NULL;
		GFile* _tmp25_ = NULL;
		GFileInputStream* _tmp26_ = NULL;
		GFileInputStream* _tmp27_ = NULL;
		GFileInputStream* _tmp28_ = NULL;
		GDataInputStream* _tmp29_ = NULL;
		_tmp23_ = recordfile;
		_tmp24_ = g_file_new_for_path (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_file_read (_tmp25_, NULL, &_inner_error_);
		_tmp27_ = _tmp26_;
		_g_object_unref0 (_tmp25_);
		_tmp22_ = _tmp27_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return FALSE;
		}
		_tmp28_ = _tmp22_;
		_tmp29_ = g_data_input_stream_new ((GInputStream*) _tmp28_);
		_g_object_unref0 (recording);
		recording = _tmp29_;
		_g_object_unref0 (_tmp28_);
	}
	_tmp30_ = owned_dev;
	if (_tmp30_ == NULL) {
		gchar* line = NULL;
		GDataInputStream* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		const gchar* _tmp41_ = NULL;
		GMatchInfo* header_matcher = NULL;
		GRegex* _tmp43_ = NULL;
		GRegex* _tmp44_ = NULL;
		GRegex* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		GMatchInfo* _tmp47_ = NULL;
		gboolean _tmp48_ = FALSE;
		gboolean _tmp49_ = FALSE;
		GMatchInfo* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		GDataInputStream* _tmp53_ = NULL;
		_tmp31_ = recording;
		_tmp32_ = g_data_input_stream_read_line (_tmp31_, NULL, NULL, &_inner_error_);
		line = _tmp32_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return FALSE;
		}
		while (TRUE) {
			gboolean _tmp33_ = FALSE;
			const gchar* _tmp34_ = NULL;
			gboolean _tmp37_ = FALSE;
			gchar* _tmp38_ = NULL;
			GDataInputStream* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			_tmp34_ = line;
			if (_tmp34_ != NULL) {
				const gchar* _tmp35_ = NULL;
				gboolean _tmp36_ = FALSE;
				_tmp35_ = line;
				_tmp36_ = g_str_has_prefix (_tmp35_, "#");
				_tmp33_ = _tmp36_;
			} else {
				_tmp33_ = FALSE;
			}
			_tmp37_ = _tmp33_;
			if (!_tmp37_) {
				break;
			}
			_tmp39_ = recording;
			_tmp40_ = g_data_input_stream_read_line (_tmp39_, NULL, NULL, &_inner_error_);
			_tmp38_ = _tmp40_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (line);
				_g_free0 (owned_dev);
				_g_object_unref0 (recording);
				return FALSE;
			}
			_g_free0 (line);
			line = _tmp38_;
		}
		_tmp41_ = line;
		if (_tmp41_ == NULL) {
			const gchar* _tmp42_ = NULL;
			_tmp42_ = recordfile;
			g_error ("umockdev.vala:690: ioctl recording file %s has no non-comment content", _tmp42_);
		}
		_tmp44_ = g_regex_new ("^@DEV (.*)(\n|$)", 0, 0, &_inner_error_);
		_tmp43_ = _tmp44_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_match_info_unref0 (header_matcher);
			_g_free0 (line);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return FALSE;
		}
		_tmp45_ = _tmp43_;
		_tmp46_ = line;
		_tmp48_ = g_regex_match (_tmp45_, _tmp46_, 0, &_tmp47_);
		_g_match_info_unref0 (header_matcher);
		header_matcher = _tmp47_;
		_tmp49_ = !_tmp48_;
		_g_regex_unref0 (_tmp45_);
		if (_tmp49_) {
			const gchar* _tmp50_ = NULL;
			_tmp50_ = recordfile;
			g_error ("umockdev.vala:694: null passed for device node, but recording %s has n" \
"o @DEV header", _tmp50_);
		}
		_tmp51_ = header_matcher;
		_tmp52_ = g_match_info_fetch (_tmp51_, 1);
		_g_free0 (owned_dev);
		owned_dev = _tmp52_;
		_tmp53_ = recording;
		g_seekable_seek ((GSeekable*) _tmp53_, (gint64) 0, G_SEEK_SET, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_match_info_unref0 (header_matcher);
			_g_free0 (line);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return FALSE;
		}
		_g_match_info_unref0 (header_matcher);
		_g_free0 (line);
	}
	_tmp54_ = self->priv->root_dir;
	_tmp55_ = owned_dev;
	_tmp56_ = g_build_filename (_tmp54_, "ioctl", _tmp55_, NULL);
	dest = _tmp56_;
	_tmp57_ = dest;
	_tmp58_ = g_path_get_dirname (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = g_mkdir_with_parents (_tmp59_, 0755);
	_vala_assert (_tmp60_ == 0, "DirUtils.create_with_parents(Path.get_dirname(dest), 0755) == 0");
	_g_free0 (_tmp59_);
	_tmp61_ = recording;
	_tmp62_ = g_data_input_stream_read_upto (_tmp61_, "", (gssize) 0, NULL, NULL, &_inner_error_);
	contents = _tmp62_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dest);
		_g_free0 (owned_dev);
		_g_object_unref0 (recording);
		return FALSE;
	}
	_tmp63_ = contents;
	if (_tmp63_ == NULL) {
		gchar* _tmp64_ = NULL;
		_tmp64_ = g_strdup ("");
		_g_free0 (contents);
		contents = _tmp64_;
	}
	_tmp66_ = dest;
	_tmp67_ = contents;
	_tmp68_ = g_file_set_contents (_tmp66_, _tmp67_, (gssize) (-1), &_inner_error_);
	_tmp65_ = _tmp68_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (contents);
		_g_free0 (dest);
		_g_free0 (owned_dev);
		_g_object_unref0 (recording);
		return FALSE;
	}
	result = _tmp65_;
	_g_free0 (contents);
	_g_free0 (dest);
	_g_free0 (owned_dev);
	_g_object_unref0 (recording);
	return result;
}


/**
     * umockdev_testbed_load_script:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the script record.
     *       %NULL is valid; in this case the script is associated with
     *       the device node it was recorded from.
     * @recordfile: Path of the script record file.
     * @error: return location for a GError, or %NULL
     *
     * Load a script record file for a particular device into the testbed.
     * script records can be created with umockdev-record --script.
     *
     * Returns: %TRUE on success, %FALSE if @recordfile is invalid and an error
     *          occurred.
     */
gboolean umockdev_testbed_load_script (UMockdevTestbed* self, const gchar* dev, const gchar* recordfile, GError** error) {
	gboolean result = FALSE;
	gchar* owned_dev = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GHashTable* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	gint fd = 0;
	const gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	UMockdevScriptRunner* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	UMockdevScriptRunner* _tmp49_ = NULL;
	GHashTable* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	_tmp0_ = dev;
	_tmp1_ = g_strdup (_tmp0_);
	owned_dev = _tmp1_;
	_tmp2_ = owned_dev;
	if (_tmp2_ == NULL) {
		GFileInputStream* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		GFileInputStream* _tmp7_ = NULL;
		GFileInputStream* _tmp8_ = NULL;
		GDataInputStream* recording = NULL;
		GFileInputStream* _tmp9_ = NULL;
		GDataInputStream* _tmp10_ = NULL;
		GDataInputStream* _tmp11_ = NULL;
		gchar* line = NULL;
		GDataInputStream* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		const gchar* _tmp22_ = NULL;
		GMatchInfo* header_matcher = NULL;
		GRegex* _tmp24_ = NULL;
		GRegex* _tmp25_ = NULL;
		GRegex* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		GMatchInfo* _tmp28_ = NULL;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		GMatchInfo* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		_tmp4_ = recordfile;
		_tmp5_ = g_file_new_for_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_file_read (_tmp6_, NULL, &_inner_error_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_tmp3_ = _tmp8_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (owned_dev);
			return FALSE;
		}
		_tmp9_ = _tmp3_;
		_tmp10_ = g_data_input_stream_new ((GInputStream*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		recording = _tmp11_;
		_tmp12_ = recording;
		_tmp13_ = g_data_input_stream_read_line (_tmp12_, NULL, NULL, &_inner_error_);
		line = _tmp13_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (recording);
			_g_free0 (owned_dev);
			return FALSE;
		}
		while (TRUE) {
			gboolean _tmp14_ = FALSE;
			const gchar* _tmp15_ = NULL;
			gboolean _tmp18_ = FALSE;
			gchar* _tmp19_ = NULL;
			GDataInputStream* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			_tmp15_ = line;
			if (_tmp15_ != NULL) {
				const gchar* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
				_tmp16_ = line;
				_tmp17_ = g_str_has_prefix (_tmp16_, "#");
				_tmp14_ = _tmp17_;
			} else {
				_tmp14_ = FALSE;
			}
			_tmp18_ = _tmp14_;
			if (!_tmp18_) {
				break;
			}
			_tmp20_ = recording;
			_tmp21_ = g_data_input_stream_read_line (_tmp20_, NULL, NULL, &_inner_error_);
			_tmp19_ = _tmp21_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (line);
				_g_object_unref0 (recording);
				_g_free0 (owned_dev);
				return FALSE;
			}
			_g_free0 (line);
			line = _tmp19_;
		}
		_tmp22_ = line;
		if (_tmp22_ == NULL) {
			const gchar* _tmp23_ = NULL;
			_tmp23_ = recordfile;
			g_error ("umockdev.vala:736: script recording %s has no non-comment content", _tmp23_);
		}
		_tmp25_ = g_regex_new ("^d 0 (.*)(\n|$)", 0, 0, &_inner_error_);
		_tmp24_ = _tmp25_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_match_info_unref0 (header_matcher);
			_g_free0 (line);
			_g_object_unref0 (recording);
			_g_free0 (owned_dev);
			return FALSE;
		}
		_tmp26_ = _tmp24_;
		_tmp27_ = line;
		_tmp29_ = g_regex_match (_tmp26_, _tmp27_, 0, &_tmp28_);
		_g_match_info_unref0 (header_matcher);
		header_matcher = _tmp28_;
		_tmp30_ = !_tmp29_;
		_g_regex_unref0 (_tmp26_);
		if (_tmp30_) {
			const gchar* _tmp31_ = NULL;
			_tmp31_ = recordfile;
			g_error ("umockdev.vala:740: null passed for device node, but recording %s has n" \
"o d 0 header", _tmp31_);
		}
		_tmp32_ = header_matcher;
		_tmp33_ = g_match_info_fetch (_tmp32_, 1);
		_g_free0 (owned_dev);
		owned_dev = _tmp33_;
		_g_match_info_unref0 (header_matcher);
		_g_free0 (line);
		_g_object_unref0 (recording);
	}
	_tmp34_ = self->priv->dev_script_runner;
	_tmp35_ = owned_dev;
	_tmp36_ = g_hash_table_contains (_tmp34_, _tmp35_);
	_vala_assert (!_tmp36_, "!this.dev_script_runner.contains (owned_dev)");
	_tmp37_ = owned_dev;
	_tmp38_ = umockdev_testbed_get_dev_fd (self, _tmp37_);
	fd = _tmp38_;
	_tmp39_ = fd;
	if (_tmp39_ < 0) {
		const gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		GError* _tmp43_ = NULL;
		GError* _tmp44_ = NULL;
		_tmp40_ = owned_dev;
		_tmp41_ = g_strconcat (_tmp40_, " is not a device suitable for scripts", NULL);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp42_);
		_tmp44_ = _tmp43_;
		_g_free0 (_tmp42_);
		_inner_error_ = _tmp44_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (owned_dev);
		return FALSE;
	}
	_tmp46_ = owned_dev;
	_tmp47_ = recordfile;
	_tmp48_ = fd;
	_tmp49_ = umockdev_script_runner_new (_tmp46_, _tmp47_, _tmp48_, &_inner_error_);
	_tmp45_ = _tmp49_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (owned_dev);
		return FALSE;
	}
	_tmp50_ = self->priv->dev_script_runner;
	_tmp51_ = owned_dev;
	_tmp52_ = g_strdup (_tmp51_);
	g_hash_table_insert (_tmp50_, _tmp52_, _tmp45_);
	result = TRUE;
	_g_free0 (owned_dev);
	return result;
}


/**
     * umockdev_testbed_load_socket_script:
     * @self: A #UMockdevTestbed.
     * @path: Unix socket path
     * @type: Unix socket type (#SOCK_STREAM, #SOCK_DGRAM)
     * @recordfile: Path of the script record file.
     * @error: return location for a GError, or %NULL
     *
     * Add an Unix socket to the testbed that is backed by a recorded script.
     * Clients can connect to the socket using @path (i. e. without the testbed
     * prefix).
     *
     * Returns: %TRUE on success, %FALSE if the @path or @type are
     *          invalid and an error occurred.
     */
gboolean umockdev_testbed_load_socket_script (UMockdevTestbed* self, const gchar* path, gint type, const gchar* recordfile, GError** error) {
	gboolean result = FALSE;
	gint fd = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* real_path = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gboolean _tmp17_ = FALSE;
	UMockdevSocketServer* _tmp24_ = NULL;
	UMockdevSocketServer* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	const gchar* _tmp29_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	_tmp0_ = type;
	_tmp1_ = socket (AF_UNIX, _tmp0_, 0);
	fd = _tmp1_;
	_tmp2_ = fd;
	if (_tmp2_ < 0) {
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		_tmp3_ = type;
		_tmp4_ = errno;
		_tmp5_ = g_strerror (_tmp4_);
		_tmp6_ = g_strdup_printf ("Cannot create socket type %i: %s", _tmp3_, _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == G_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp10_ = self->priv->root_dir;
	_tmp11_ = path;
	_tmp12_ = g_build_filename (_tmp10_, _tmp11_, NULL);
	real_path = _tmp12_;
	_tmp13_ = real_path;
	_tmp14_ = g_path_get_dirname (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_mkdir_with_parents (_tmp15_, 0755);
	_tmp17_ = _tmp16_ != 0;
	_g_free0 (_tmp15_);
	if (_tmp17_) {
		gint _tmp18_ = 0;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
		GError* _tmp23_ = NULL;
		_tmp18_ = errno;
		_tmp19_ = g_strerror (_tmp18_);
		_tmp20_ = g_strdup_printf ("Cannot create socket path: %s", _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		_inner_error_ = _tmp23_;
		if (_inner_error_->domain == G_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (real_path);
			return FALSE;
		} else {
			_g_free0 (real_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp24_ = self->priv->socket_server;
	if (_tmp24_ == NULL) {
		UMockdevSocketServer* _tmp25_ = NULL;
		_tmp25_ = umockdev_socket_server_new ();
		_umockdev_socket_server_unref0 (self->priv->socket_server);
		self->priv->socket_server = _tmp25_;
	}
	_tmp26_ = self->priv->socket_server;
	_tmp27_ = real_path;
	_tmp28_ = fd;
	_tmp29_ = recordfile;
	umockdev_socket_server_add (_tmp26_, _tmp27_, _tmp28_, _tmp29_);
	result = TRUE;
	_g_free0 (real_path);
	return result;
}


/**
     * umockdev_testbed_load_evemu_events:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the evemu events.
     *       %NULL is valid; in this case the events are associated with
     *       the device node it was recorded from.
     * @eventsfile: Path of the evemu events file.
     * @error: return location for a GError, or %NULL
     *
     * Load an evemu event file for a particular device into the testbed. These
     * have a very simple line-based format with 4 fields that represent the
     * data in a struct input_event:
     *
     *  E: sec.usec evtype(hex) evcode(hex) evvalue
     *
     * The timestamps in those are absolute, and are usually as they were at
     * record time. When loading them into umockdev they are interpreted
     * relatively: the first event happens immediately, and the time to the
     * next event is the difference between the corresponding timestamps in the
     * .event file.
     *
     * Returns: %TRUE on success, %FALSE if @eventsfile is invalid and an error
     *          occurred.
     */
static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


gboolean umockdev_testbed_load_evemu_events (UMockdevTestbed* self, const gchar* dev, const gchar* eventsfile, GError** error) {
	gboolean result = FALSE;
	GFile* f_ev = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInputStream* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFileInputStream* _tmp4_ = NULL;
	GDataInputStream* s_ev = NULL;
	GFileInputStream* _tmp5_ = NULL;
	GDataInputStream* _tmp6_ = NULL;
	GDataInputStream* _tmp7_ = NULL;
	gchar* line = NULL;
	gchar* recorded_dev = NULL;
	gsize len = 0UL;
	GMatchInfo* match = NULL;
	struct input_event ev = {0};
	struct input_event _tmp8_ = {0};
	GRegex* default_dev_re = NULL;
	GRegex* _tmp9_ = NULL;
	GRegex* event_re = NULL;
	GRegex* _tmp10_ = NULL;
	gchar* script_file = NULL;
	gint script_fd = 0;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint delay = 0;
	gboolean first = FALSE;
	gint _tmp88_ = 0;
	gchar* owned_dev = NULL;
	const gchar* _tmp89_ = NULL;
	gchar* _tmp90_ = NULL;
	const gchar* _tmp91_ = NULL;
	gboolean ret = FALSE;
	const gchar* _tmp96_ = NULL;
	const gchar* _tmp97_ = NULL;
	gboolean _tmp98_ = FALSE;
	const gchar* _tmp99_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (eventsfile != NULL, FALSE);
	_tmp0_ = eventsfile;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	f_ev = _tmp1_;
	_tmp3_ = f_ev;
	_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error_);
	_tmp2_ = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (f_ev);
		return FALSE;
	}
	_tmp5_ = _tmp2_;
	_tmp6_ = g_data_input_stream_new ((GInputStream*) _tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	s_ev = _tmp7_;
	recorded_dev = NULL;
	ev = _tmp8_;
	_tmp9_ = g_regex_new ("^# device (.*)$", 0, 0, &_inner_error_);
	default_dev_re = _tmp9_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (f_ev);
		return FALSE;
	}
	_tmp10_ = g_regex_new ("^E: ([0-9]+)\\.([0-9]+) +([0-9a-fA-F]+) +([0-9a-fA-F]+) +(-?[0-9]+) *#" \
"?", 0, 0, &_inner_error_);
	event_re = _tmp10_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_regex_unref0 (default_dev_re);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (f_ev);
		return FALSE;
	}
	_tmp12_ = g_file_open_tmp ("evemu.XXXXXX.script", &_tmp11_, &_inner_error_);
	_g_free0 (script_file);
	script_file = _tmp11_;
	script_fd = _tmp12_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (script_file);
		_g_regex_unref0 (event_re);
		_g_regex_unref0 (default_dev_re);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (f_ev);
		return FALSE;
	}
	delay = 0;
	first = TRUE;
	while (TRUE) {
		gchar* _tmp13_ = NULL;
		GDataInputStream* _tmp14_ = NULL;
		gsize _tmp15_ = 0UL;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GRegex* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		GMatchInfo* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		GRegex* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		GMatchInfo* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		time_t ev_sec = 0;
		GMatchInfo* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		guint64 _tmp35_ = 0ULL;
		time_t _tmp36_ = 0;
		time_t ev_usec = 0;
		GMatchInfo* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		guint64 _tmp40_ = 0ULL;
		time_t _tmp41_ = 0;
		gboolean _tmp42_ = FALSE;
		time_t _tmp52_ = 0;
		time_t _tmp53_ = 0;
		GMatchInfo* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_ = NULL;
		gulong _tmp57_ = 0UL;
		GMatchInfo* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		gulong _tmp61_ = 0UL;
		GMatchInfo* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		guint8* ev_data = NULL;
		guint8* _tmp66_ = NULL;
		gint ev_data_length1 = 0;
		gint _ev_data_size_ = 0;
		guint8* _tmp67_ = NULL;
		gint _tmp67__length1 = 0;
		guint8* _tmp68_ = NULL;
		gint _tmp68__length1 = 0;
		gchar* script_line = NULL;
		gint _tmp69_ = 0;
		gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_ = NULL;
		gchar* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_ = NULL;
		guint8* _tmp76_ = NULL;
		gint _tmp76__length1 = 0;
		gchar* _tmp77_ = NULL;
		gchar* _tmp78_ = NULL;
		gchar* _tmp79_ = NULL;
		gchar* _tmp80_ = NULL;
		gchar* _tmp81_ = NULL;
		gchar* _tmp82_ = NULL;
		gint _tmp83_ = 0;
		const gchar* _tmp84_ = NULL;
		const gchar* _tmp85_ = NULL;
		gint _tmp86_ = 0;
		gint _tmp87_ = 0;
		_tmp14_ = s_ev;
		_tmp16_ = g_data_input_stream_read_line (_tmp14_, &_tmp15_, NULL, &_inner_error_);
		len = _tmp15_;
		_tmp13_ = _tmp16_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (script_file);
			_g_regex_unref0 (event_re);
			_g_regex_unref0 (default_dev_re);
			_g_match_info_unref0 (match);
			_g_free0 (recorded_dev);
			_g_free0 (line);
			_g_object_unref0 (s_ev);
			_g_object_unref0 (f_ev);
			return FALSE;
		}
		_g_free0 (line);
		line = _tmp13_;
		_tmp17_ = line;
		if (!(_tmp17_ != NULL)) {
			break;
		}
		_tmp18_ = default_dev_re;
		_tmp19_ = line;
		_tmp21_ = g_regex_match (_tmp18_, _tmp19_, 0, &_tmp20_);
		_g_match_info_unref0 (match);
		match = _tmp20_;
		if (_tmp21_) {
			GMatchInfo* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			_tmp22_ = match;
			_tmp23_ = g_match_info_fetch (_tmp22_, 1);
			_g_free0 (recorded_dev);
			recorded_dev = _tmp23_;
			continue;
		}
		_tmp24_ = event_re;
		_tmp25_ = line;
		_tmp27_ = g_regex_match (_tmp24_, _tmp25_, 0, &_tmp26_);
		_g_match_info_unref0 (match);
		match = _tmp26_;
		if (!_tmp27_) {
			const gchar* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
			_tmp28_ = line;
			_tmp29_ = g_str_has_prefix (_tmp28_, "#");
			if (!_tmp29_) {
				const gchar* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				_tmp30_ = eventsfile;
				_tmp31_ = line;
				g_warning ("umockdev.vala:839: Ignoring invalid line in %s: %s", _tmp30_, _tmp31_);
			}
			continue;
		}
		_tmp32_ = match;
		_tmp33_ = g_match_info_fetch (_tmp32_, 1);
		_tmp34_ = _tmp33_;
		_tmp35_ = uint64_parse (_tmp34_);
		_tmp36_ = (time_t) _tmp35_;
		_g_free0 (_tmp34_);
		ev_sec = _tmp36_;
		_tmp37_ = match;
		_tmp38_ = g_match_info_fetch (_tmp37_, 2);
		_tmp39_ = _tmp38_;
		_tmp40_ = uint64_parse (_tmp39_);
		_tmp41_ = (time_t) _tmp40_;
		_g_free0 (_tmp39_);
		ev_usec = _tmp41_;
		_tmp42_ = first;
		if (_tmp42_) {
			delay = 0;
			first = FALSE;
		} else {
			time_t _tmp43_ = 0;
			struct input_event _tmp44_ = {0};
			struct timeval _tmp45_ = {0};
			time_t _tmp46_ = 0;
			time_t _tmp47_ = 0;
			struct input_event _tmp48_ = {0};
			struct timeval _tmp49_ = {0};
			glong _tmp50_ = 0L;
			gint _tmp51_ = 0;
			_tmp43_ = ev_sec;
			_tmp44_ = ev;
			_tmp45_ = _tmp44_.time;
			_tmp46_ = _tmp45_.tv_sec;
			_tmp47_ = ev_usec;
			_tmp48_ = ev;
			_tmp49_ = _tmp48_.time;
			_tmp50_ = _tmp49_.tv_usec;
			delay = (((gint) (_tmp43_ - _tmp46_)) * 1000) + (((gint) (_tmp47_ - _tmp50_)) / 1000);
			_tmp51_ = delay;
			if (_tmp51_ < 0) {
				delay = 0;
			}
		}
		_tmp52_ = ev_sec;
		ev.time.tv_sec = _tmp52_;
		_tmp53_ = ev_usec;
		ev.time.tv_usec = (glong) _tmp53_;
		_tmp54_ = match;
		_tmp55_ = g_match_info_fetch (_tmp54_, 3);
		_tmp56_ = _tmp55_;
		_tmp57_ = strtoul (_tmp56_, NULL, 16);
		ev.type = (guint16) _tmp57_;
		_g_free0 (_tmp56_);
		_tmp58_ = match;
		_tmp59_ = g_match_info_fetch (_tmp58_, 4);
		_tmp60_ = _tmp59_;
		_tmp61_ = strtoul (_tmp60_, NULL, 16);
		ev.code = (guint16) _tmp61_;
		_g_free0 (_tmp60_);
		_tmp62_ = match;
		_tmp63_ = g_match_info_fetch (_tmp62_, 5);
		_tmp64_ = _tmp63_;
		_tmp65_ = atoi (_tmp64_);
		ev.value = (gint32) _tmp65_;
		_g_free0 (_tmp64_);
		_tmp66_ = g_new0 (guint8, sizeof (struct input_event));
		ev_data = _tmp66_;
		ev_data_length1 = sizeof (struct input_event);
		_ev_data_size_ = ev_data_length1;
		_tmp67_ = ev_data;
		_tmp67__length1 = ev_data_length1;
		_tmp68_ = ev_data;
		_tmp68__length1 = ev_data_length1;
		memcpy (_tmp67_, &ev, (gsize) _tmp68__length1);
		_tmp69_ = delay;
		_tmp70_ = g_strdup_printf ("%i", _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = g_strconcat ("r ", _tmp71_, NULL);
		_tmp73_ = _tmp72_;
		_tmp74_ = g_strconcat (_tmp73_, " ", NULL);
		_tmp75_ = _tmp74_;
		_tmp76_ = ev_data;
		_tmp76__length1 = ev_data_length1;
		_tmp77_ = umockdev_script_runner_encode (_tmp76_, _tmp76__length1);
		_tmp78_ = _tmp77_;
		_tmp79_ = g_strconcat (_tmp75_, _tmp78_, NULL);
		_tmp80_ = _tmp79_;
		_tmp81_ = g_strconcat (_tmp80_, "\n", NULL);
		_tmp82_ = _tmp81_;
		_g_free0 (_tmp80_);
		_g_free0 (_tmp78_);
		_g_free0 (_tmp75_);
		_g_free0 (_tmp73_);
		_g_free0 (_tmp71_);
		script_line = _tmp82_;
		_tmp83_ = script_fd;
		_tmp84_ = script_line;
		_tmp85_ = script_line;
		_tmp86_ = strlen (_tmp85_);
		_tmp87_ = _tmp86_;
		write (_tmp83_, _tmp84_, (gsize) _tmp87_);
		_g_free0 (script_line);
		ev_data = (g_free (ev_data), NULL);
	}
	_tmp88_ = script_fd;
	close (_tmp88_);
	_tmp89_ = dev;
	_tmp90_ = g_strdup (_tmp89_);
	owned_dev = _tmp90_;
	_tmp91_ = owned_dev;
	if (_tmp91_ == NULL) {
		const gchar* _tmp92_ = NULL;
		const gchar* _tmp94_ = NULL;
		gchar* _tmp95_ = NULL;
		_tmp92_ = recorded_dev;
		if (_tmp92_ == NULL) {
			const gchar* _tmp93_ = NULL;
			_tmp93_ = eventsfile;
			g_error ("umockdev.vala:869: null passed for device node, but recording %s has n" \
"o '# device' header", _tmp93_);
		}
		_tmp94_ = recorded_dev;
		_tmp95_ = g_strdup (_tmp94_);
		_g_free0 (owned_dev);
		owned_dev = _tmp95_;
	}
	_tmp96_ = owned_dev;
	_tmp97_ = script_file;
	_tmp98_ = umockdev_testbed_load_script (self, _tmp96_, _tmp97_, &_inner_error_);
	ret = _tmp98_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (owned_dev);
		_g_free0 (script_file);
		_g_regex_unref0 (event_re);
		_g_regex_unref0 (default_dev_re);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (f_ev);
		return FALSE;
	}
	_tmp99_ = script_file;
	g_unlink (_tmp99_);
	result = ret;
	_g_free0 (owned_dev);
	_g_free0 (script_file);
	_g_regex_unref0 (event_re);
	_g_regex_unref0 (default_dev_re);
	_g_match_info_unref0 (match);
	_g_free0 (recorded_dev);
	_g_free0 (line);
	_g_object_unref0 (s_ev);
	_g_object_unref0 (f_ev);
	return result;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* umockdev_testbed_add_dev_from_string (UMockdevTestbed* self, const gchar* data, GError** error) {
	gchar* result = NULL;
	gchar type = '\0';
	gchar* key = NULL;
	gchar* val = NULL;
	gchar* devpath = NULL;
	gchar* subsystem = NULL;
	gchar* cur_data = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* devnode_path = NULL;
	guint8* devnode_contents = NULL;
	guint8* _tmp2_ = NULL;
	gint devnode_contents_length1 = 0;
	gint _devnode_contents_size_ = 0;
	const gchar* _tmp3_ = NULL;
	gchar _tmp4_ = '\0';
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp17_ = NULL;
	gchar** attrs = NULL;
	gchar** _tmp18_ = NULL;
	gint attrs_length1 = 0;
	gint _attrs_size_ = 0;
	gchar** binattrs = NULL;
	gchar** _tmp19_ = NULL;
	gint binattrs_length1 = 0;
	gint _binattrs_size_ = 0;
	gchar** linkattrs = NULL;
	gchar** _tmp20_ = NULL;
	gint linkattrs_length1 = 0;
	gint _linkattrs_size_ = 0;
	gchar** props = NULL;
	gchar** _tmp21_ = NULL;
	gint props_length1 = 0;
	gint _props_size_ = 0;
	const gchar* _tmp80_ = NULL;
	const gchar* _tmp83_ = NULL;
	const gchar* _tmp84_ = NULL;
	gchar* syspath = NULL;
	const gchar* _tmp85_ = NULL;
	const gchar* _tmp86_ = NULL;
	gchar* _tmp87_ = NULL;
	gchar* _tmp88_ = NULL;
	gchar** _tmp89_ = NULL;
	gint _tmp89__length1 = 0;
	gchar** _tmp90_ = NULL;
	gint _tmp90__length1 = 0;
	gchar* _tmp91_ = NULL;
	gchar* _tmp92_ = NULL;
	const gchar* _tmp121_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	devpath = NULL;
	subsystem = NULL;
	_tmp0_ = data;
	_tmp1_ = g_strdup (_tmp0_);
	cur_data = _tmp1_;
	devnode_path = NULL;
	_tmp2_ = g_new0 (guint8, 0);
	devnode_contents = _tmp2_;
	devnode_contents_length1 = 0;
	_devnode_contents_size_ = devnode_contents_length1;
	_tmp3_ = cur_data;
	_tmp7_ = umockdev_testbed_record_parse_line (self, _tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	type = _tmp4_;
	_g_free0 (key);
	key = _tmp5_;
	_g_free0 (devpath);
	devpath = _tmp6_;
	_g_free0 (cur_data);
	cur_data = _tmp7_;
	_tmp9_ = cur_data;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		gchar _tmp10_ = '\0';
		_tmp10_ = type;
		_tmp8_ = _tmp10_ != 'P';
	}
	_tmp11_ = _tmp8_;
	if (_tmp11_) {
		GError* _tmp12_ = NULL;
		_tmp12_ = g_error_new_literal (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "device descriptions must start with a \"P: /devices/path/...\" line");
		_inner_error_ = _tmp12_;
		if (_inner_error_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error_);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			return NULL;
		} else {
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp13_ = devpath;
	_tmp14_ = g_str_has_prefix (_tmp13_, "/devices/");
	if (!_tmp14_) {
		const gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		_tmp15_ = devpath;
		_tmp16_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "invalid device path '%s': must start with /devices/", _tmp15_);
		_inner_error_ = _tmp16_;
		if (_inner_error_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error_);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			return NULL;
		} else {
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp17_ = devpath;
	g_debug ("umockdev.vala:895: parsing device description for %s", _tmp17_);
	_tmp18_ = g_new0 (gchar*, 0 + 1);
	attrs = _tmp18_;
	attrs_length1 = 0;
	_attrs_size_ = attrs_length1;
	_tmp19_ = g_new0 (gchar*, 0 + 1);
	binattrs = _tmp19_;
	binattrs_length1 = 0;
	_binattrs_size_ = binattrs_length1;
	_tmp20_ = g_new0 (gchar*, 0 + 1);
	linkattrs = _tmp20_;
	linkattrs_length1 = 0;
	_linkattrs_size_ = linkattrs_length1;
	_tmp21_ = g_new0 (gchar*, 0 + 1);
	props = _tmp21_;
	props_length1 = 0;
	_props_size_ = props_length1;
	while (TRUE) {
		gboolean _tmp22_ = FALSE;
		const gchar* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_ = NULL;
		gchar _tmp30_ = '\0';
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gchar _tmp37_ = '\0';
		_tmp23_ = cur_data;
		_tmp24_ = strlen (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp25_ > 0) {
			const gchar* _tmp26_ = NULL;
			gchar _tmp27_ = '\0';
			_tmp26_ = cur_data;
			_tmp27_ = string_get (_tmp26_, (glong) 0);
			_tmp22_ = _tmp27_ != '\n';
		} else {
			_tmp22_ = FALSE;
		}
		_tmp28_ = _tmp22_;
		if (!_tmp28_) {
			break;
		}
		_tmp29_ = cur_data;
		_tmp33_ = umockdev_testbed_record_parse_line (self, _tmp29_, &_tmp30_, &_tmp31_, &_tmp32_);
		type = _tmp30_;
		_g_free0 (key);
		key = _tmp31_;
		_g_free0 (val);
		val = _tmp32_;
		_g_free0 (cur_data);
		cur_data = _tmp33_;
		_tmp34_ = cur_data;
		if (_tmp34_ == NULL) {
			const gchar* _tmp35_ = NULL;
			GError* _tmp36_ = NULL;
			_tmp35_ = devpath;
			_tmp36_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "malformed attribute or property line in description of device %s", _tmp35_);
			_inner_error_ = _tmp36_;
			if (_inner_error_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error_);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				return NULL;
			} else {
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp37_ = type;
		switch (_tmp37_) {
			case 'H':
			{
				gchar** _tmp38_ = NULL;
				gint _tmp38__length1 = 0;
				const gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				gchar** _tmp41_ = NULL;
				gint _tmp41__length1 = 0;
				const gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				_tmp38_ = binattrs;
				_tmp38__length1 = binattrs_length1;
				_tmp39_ = key;
				_tmp40_ = g_strdup (_tmp39_);
				_vala_array_add3 (&binattrs, &binattrs_length1, &_binattrs_size_, _tmp40_);
				_tmp41_ = binattrs;
				_tmp41__length1 = binattrs_length1;
				_tmp42_ = val;
				_tmp43_ = g_strdup (_tmp42_);
				_vala_array_add4 (&binattrs, &binattrs_length1, &_binattrs_size_, _tmp43_);
				break;
			}
			case 'A':
			{
				gchar** _tmp44_ = NULL;
				gint _tmp44__length1 = 0;
				const gchar* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				gchar** _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				const gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				_tmp44_ = attrs;
				_tmp44__length1 = attrs_length1;
				_tmp45_ = key;
				_tmp46_ = g_strdup (_tmp45_);
				_vala_array_add5 (&attrs, &attrs_length1, &_attrs_size_, _tmp46_);
				_tmp47_ = attrs;
				_tmp47__length1 = attrs_length1;
				_tmp48_ = val;
				_tmp49_ = g_strcompress (_tmp48_);
				_vala_array_add6 (&attrs, &attrs_length1, &_attrs_size_, _tmp49_);
				break;
			}
			case 'L':
			{
				gchar** _tmp50_ = NULL;
				gint _tmp50__length1 = 0;
				const gchar* _tmp51_ = NULL;
				gchar* _tmp52_ = NULL;
				gchar** _tmp53_ = NULL;
				gint _tmp53__length1 = 0;
				const gchar* _tmp54_ = NULL;
				gchar* _tmp55_ = NULL;
				_tmp50_ = linkattrs;
				_tmp50__length1 = linkattrs_length1;
				_tmp51_ = key;
				_tmp52_ = g_strdup (_tmp51_);
				_vala_array_add7 (&linkattrs, &linkattrs_length1, &_linkattrs_size_, _tmp52_);
				_tmp53_ = linkattrs;
				_tmp53__length1 = linkattrs_length1;
				_tmp54_ = val;
				_tmp55_ = g_strdup (_tmp54_);
				_vala_array_add8 (&linkattrs, &linkattrs_length1, &_linkattrs_size_, _tmp55_);
				break;
			}
			case 'E':
			{
				gchar** _tmp56_ = NULL;
				gint _tmp56__length1 = 0;
				const gchar* _tmp57_ = NULL;
				gchar* _tmp58_ = NULL;
				gchar** _tmp59_ = NULL;
				gint _tmp59__length1 = 0;
				const gchar* _tmp60_ = NULL;
				gchar* _tmp61_ = NULL;
				const gchar* _tmp62_ = NULL;
				_tmp56_ = props;
				_tmp56__length1 = props_length1;
				_tmp57_ = key;
				_tmp58_ = g_strdup (_tmp57_);
				_vala_array_add9 (&props, &props_length1, &_props_size_, _tmp58_);
				_tmp59_ = props;
				_tmp59__length1 = props_length1;
				_tmp60_ = val;
				_tmp61_ = g_strdup (_tmp60_);
				_vala_array_add10 (&props, &props_length1, &_props_size_, _tmp61_);
				_tmp62_ = key;
				if (g_strcmp0 (_tmp62_, "SUBSYSTEM") == 0) {
					const gchar* _tmp63_ = NULL;
					const gchar* _tmp66_ = NULL;
					gchar* _tmp67_ = NULL;
					_tmp63_ = subsystem;
					if (_tmp63_ != NULL) {
						const gchar* _tmp64_ = NULL;
						GError* _tmp65_ = NULL;
						_tmp64_ = devpath;
						_tmp65_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "duplicate SUBSYSTEM property in description of device %s", _tmp64_);
						_inner_error_ = _tmp65_;
						if (_inner_error_->domain == UMOCKDEV_ERROR) {
							g_propagate_error (error, _inner_error_);
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							return NULL;
						} else {
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp66_ = val;
					_tmp67_ = g_strdup (_tmp66_);
					_g_free0 (subsystem);
					subsystem = _tmp67_;
				}
				break;
			}
			case 'P':
			{
				const gchar* _tmp68_ = NULL;
				GError* _tmp69_ = NULL;
				_tmp68_ = devpath;
				_tmp69_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "invalid P: line in description of device %s", _tmp68_);
				_inner_error_ = _tmp69_;
				if (_inner_error_->domain == UMOCKDEV_ERROR) {
					g_propagate_error (error, _inner_error_);
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					return NULL;
				} else {
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			case 'N':
			{
				const gchar* _tmp70_ = NULL;
				const gchar* _tmp71_ = NULL;
				gchar* _tmp72_ = NULL;
				const gchar* _tmp73_ = NULL;
				_tmp70_ = self->priv->root_dir;
				_tmp71_ = key;
				_tmp72_ = g_build_filename (_tmp70_, "dev", _tmp71_, NULL);
				_g_free0 (devnode_path);
				devnode_path = _tmp72_;
				_tmp73_ = val;
				if (_tmp73_ != NULL) {
					guint8* _tmp74_ = NULL;
					const gchar* _tmp75_ = NULL;
					gint _tmp76_ = 0;
					guint8* _tmp77_ = NULL;
					gint _tmp74__length1 = 0;
					gint __tmp74__size_ = 0;
					_tmp75_ = val;
					_tmp77_ = umockdev_decode_hex (_tmp75_, &_tmp76_, &_inner_error_);
					_tmp74_ = _tmp77_;
					_tmp74__length1 = _tmp76_;
					__tmp74__size_ = _tmp74__length1;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == UMOCKDEV_ERROR) {
							g_propagate_error (error, _inner_error_);
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							return NULL;
						} else {
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					devnode_contents = (g_free (devnode_contents), NULL);
					devnode_contents = _tmp74_;
					devnode_contents_length1 = _tmp74__length1;
					_devnode_contents_size_ = devnode_contents_length1;
				}
				break;
			}
			case 'S':
			{
				break;
			}
			default:
			{
				gchar _tmp78_ = '\0';
				GError* _tmp79_ = NULL;
				_tmp78_ = type;
				_tmp79_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "Unknown line type '%c'\n", _tmp78_);
				_inner_error_ = _tmp79_;
				if (_inner_error_->domain == UMOCKDEV_ERROR) {
					g_propagate_error (error, _inner_error_);
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					return NULL;
				} else {
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	_tmp80_ = subsystem;
	if (_tmp80_ == NULL) {
		const gchar* _tmp81_ = NULL;
		GError* _tmp82_ = NULL;
		_tmp81_ = devpath;
		_tmp82_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "missing SUBSYSTEM property in description of device %s", _tmp81_);
		_inner_error_ = _tmp82_;
		if (_inner_error_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error_);
			props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
			linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
			binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
			attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			return NULL;
		} else {
			props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
			linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
			binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
			attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp83_ = devpath;
	_tmp84_ = subsystem;
	g_debug ("umockdev.vala:958: creating device %s (subsystem %s)", _tmp83_, _tmp84_);
	_tmp85_ = subsystem;
	_tmp86_ = devpath;
	_tmp87_ = string_substring (_tmp86_, (glong) 9, (glong) (-1));
	_tmp88_ = _tmp87_;
	_tmp89_ = attrs;
	_tmp89__length1 = attrs_length1;
	_tmp90_ = props;
	_tmp90__length1 = props_length1;
	_tmp91_ = umockdev_testbed_add_devicev (self, _tmp85_, _tmp88_, NULL, _tmp89_, _tmp90_);
	_tmp92_ = _tmp91_;
	_g_free0 (_tmp88_);
	syspath = _tmp92_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp93_ = FALSE;
			_tmp93_ = TRUE;
			while (TRUE) {
				gboolean _tmp94_ = FALSE;
				gint _tmp96_ = 0;
				gchar** _tmp97_ = NULL;
				gint _tmp97__length1 = 0;
				guint8* _tmp98_ = NULL;
				gchar** _tmp99_ = NULL;
				gint _tmp99__length1 = 0;
				gint _tmp100_ = 0;
				const gchar* _tmp101_ = NULL;
				gint _tmp102_ = 0;
				guint8* _tmp103_ = NULL;
				gint _tmp98__length1 = 0;
				gint __tmp98__size_ = 0;
				const gchar* _tmp104_ = NULL;
				gchar** _tmp105_ = NULL;
				gint _tmp105__length1 = 0;
				gint _tmp106_ = 0;
				const gchar* _tmp107_ = NULL;
				guint8* _tmp108_ = NULL;
				gint _tmp108__length1 = 0;
				_tmp94_ = _tmp93_;
				if (!_tmp94_) {
					gint _tmp95_ = 0;
					_tmp95_ = i;
					i = _tmp95_ + 2;
				}
				_tmp93_ = FALSE;
				_tmp96_ = i;
				_tmp97_ = binattrs;
				_tmp97__length1 = binattrs_length1;
				if (!(_tmp96_ < _tmp97__length1)) {
					break;
				}
				_tmp99_ = binattrs;
				_tmp99__length1 = binattrs_length1;
				_tmp100_ = i;
				_tmp101_ = _tmp99_[_tmp100_ + 1];
				_tmp103_ = umockdev_decode_hex (_tmp101_, &_tmp102_, &_inner_error_);
				_tmp98_ = _tmp103_;
				_tmp98__length1 = _tmp102_;
				__tmp98__size_ = _tmp98__length1;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == UMOCKDEV_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (syspath);
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
						linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
						binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
						attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
						devnode_contents = (g_free (devnode_contents), NULL);
						_g_free0 (devnode_path);
						_g_free0 (cur_data);
						_g_free0 (subsystem);
						_g_free0 (devpath);
						_g_free0 (val);
						_g_free0 (key);
						return NULL;
					} else {
						_g_free0 (syspath);
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
						linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
						binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
						attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
						devnode_contents = (g_free (devnode_contents), NULL);
						_g_free0 (devnode_path);
						_g_free0 (cur_data);
						_g_free0 (subsystem);
						_g_free0 (devpath);
						_g_free0 (val);
						_g_free0 (key);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp104_ = syspath;
				_tmp105_ = binattrs;
				_tmp105__length1 = binattrs_length1;
				_tmp106_ = i;
				_tmp107_ = _tmp105_[_tmp106_];
				_tmp108_ = _tmp98_;
				_tmp108__length1 = _tmp98__length1;
				umockdev_testbed_set_attribute_binary (self, _tmp104_, _tmp107_, _tmp108_, _tmp98__length1);
				_tmp108_ = (g_free (_tmp108_), NULL);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp109_ = FALSE;
			_tmp109_ = TRUE;
			while (TRUE) {
				gboolean _tmp110_ = FALSE;
				gint _tmp112_ = 0;
				gchar** _tmp113_ = NULL;
				gint _tmp113__length1 = 0;
				const gchar* _tmp114_ = NULL;
				gchar** _tmp115_ = NULL;
				gint _tmp115__length1 = 0;
				gint _tmp116_ = 0;
				const gchar* _tmp117_ = NULL;
				gchar** _tmp118_ = NULL;
				gint _tmp118__length1 = 0;
				gint _tmp119_ = 0;
				const gchar* _tmp120_ = NULL;
				_tmp110_ = _tmp109_;
				if (!_tmp110_) {
					gint _tmp111_ = 0;
					_tmp111_ = i;
					i = _tmp111_ + 2;
				}
				_tmp109_ = FALSE;
				_tmp112_ = i;
				_tmp113_ = linkattrs;
				_tmp113__length1 = linkattrs_length1;
				if (!(_tmp112_ < _tmp113__length1)) {
					break;
				}
				_tmp114_ = syspath;
				_tmp115_ = linkattrs;
				_tmp115__length1 = linkattrs_length1;
				_tmp116_ = i;
				_tmp117_ = _tmp115_[_tmp116_];
				_tmp118_ = linkattrs;
				_tmp118__length1 = linkattrs_length1;
				_tmp119_ = i;
				_tmp120_ = _tmp118_[_tmp119_ + 1];
				umockdev_testbed_set_attribute_link (self, _tmp114_, _tmp117_, _tmp120_);
			}
		}
	}
	_tmp121_ = devnode_path;
	if (_tmp121_ != NULL) {
		const gchar* _tmp122_ = NULL;
		const gchar* _tmp123_ = NULL;
		guint8* _tmp124_ = NULL;
		gint _tmp124__length1 = 0;
		_tmp122_ = subsystem;
		_tmp123_ = devnode_path;
		_tmp124_ = devnode_contents;
		_tmp124__length1 = devnode_contents_length1;
		umockdev_testbed_create_node_for_device (self, _tmp122_, _tmp123_, _tmp124_, _tmp124__length1, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (syspath);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				return NULL;
			} else {
				_g_free0 (syspath);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	while (TRUE) {
		gboolean _tmp125_ = FALSE;
		const gchar* _tmp126_ = NULL;
		gchar _tmp127_ = '\0';
		gboolean _tmp130_ = FALSE;
		const gchar* _tmp131_ = NULL;
		const gchar* _tmp132_ = NULL;
		gchar* _tmp133_ = NULL;
		_tmp126_ = cur_data;
		_tmp127_ = string_get (_tmp126_, (glong) 0);
		if (_tmp127_ != '\0') {
			const gchar* _tmp128_ = NULL;
			gchar _tmp129_ = '\0';
			_tmp128_ = cur_data;
			_tmp129_ = string_get (_tmp128_, (glong) 0);
			_tmp125_ = _tmp129_ == '\n';
		} else {
			_tmp125_ = FALSE;
		}
		_tmp130_ = _tmp125_;
		if (!_tmp130_) {
			break;
		}
		_tmp131_ = cur_data;
		_tmp132_ = g_utf8_next_char (_tmp131_);
		_tmp133_ = g_strdup (_tmp132_);
		_g_free0 (cur_data);
		cur_data = _tmp133_;
	}
	result = cur_data;
	_g_free0 (syspath);
	props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
	linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
	binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
	attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
	devnode_contents = (g_free (devnode_contents), NULL);
	_g_free0 (devnode_path);
	_g_free0 (subsystem);
	_g_free0 (devpath);
	_g_free0 (val);
	_g_free0 (key);
	return result;
}


static void umockdev_testbed_create_node_for_device (UMockdevTestbed* self, const gchar* subsystem, const gchar* node_path, guint8* node_contents, int node_contents_length1, GError** error) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	guint8* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gint ptym = 0;
	gint ptys = 0;
	gchar* ptyname_array = NULL;
	gchar* _tmp17_ = NULL;
	gint ptyname_array_length1 = 0;
	gint _ptyname_array_size_ = 0;
	gchar* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gchar* ptyname = NULL;
	gchar* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	struct termios ios = {0};
	gint _tmp27_ = 0;
	struct termios _tmp28_ = {0};
	gint _tmp29_ = 0;
	tcflag_t _tmp30_ = {0};
	tcflag_t _tmp31_ = {0};
	tcflag_t _tmp32_ = {0};
	gint _tmp33_ = 0;
	struct termios _tmp34_ = {0};
	gint _tmp35_ = 0;
	const gchar* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gchar* devname = NULL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gchar* _tmp43_ = NULL;
	GHashTable* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	GHashTable* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subsystem != NULL);
	g_return_if_fail (node_path != NULL);
	_tmp0_ = node_path;
	_tmp1_ = g_path_get_dirname (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_mkdir_with_parents (_tmp2_, 0755);
	_vala_assert (_tmp3_ == 0, "DirUtils.create_with_parents(Path.get_dirname(node_path), 0755) == 0");
	_g_free0 (_tmp2_);
	_tmp6_ = node_contents;
	_tmp6__length1 = node_contents_length1;
	if (_tmp6__length1 > 0) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = subsystem;
		_tmp5_ = g_strcmp0 (_tmp7_, "block") == 0;
	}
	_tmp8_ = _tmp5_;
	if (_tmp8_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp9_ = NULL;
		_tmp9_ = subsystem;
		_tmp4_ = g_strcmp0 (_tmp9_, "usb") == 0;
	}
	_tmp10_ = _tmp4_;
	if (_tmp10_) {
		{
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			guint8* _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			const gchar* _tmp14_ = NULL;
			_tmp11_ = node_path;
			g_debug ("umockdev.vala:991: create_node_for_device: creating file device %s", _tmp11_);
			_tmp12_ = node_path;
			_tmp13_ = node_contents;
			_tmp13__length1 = node_contents_length1;
			g_file_set_contents (_tmp12_, (const char*) _tmp13_, (size_t) _tmp13__length1, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch8_g_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp14_ = subsystem;
			if (g_strcmp0 (_tmp14_, "block") == 0) {
				const gchar* _tmp15_ = NULL;
				_tmp15_ = node_path;
				g_chmod (_tmp15_, 01644);
			}
		}
		goto __finally8;
		__catch8_g_file_error:
		{
			GError* e = NULL;
			const gchar* _tmp16_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp16_ = e->message;
			g_error ("umockdev.vala:998: Cannot create dev node file: %s", _tmp16_);
			_g_error_free0 (e);
		}
		__finally8:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		return;
	}
	_tmp17_ = g_new0 (gchar, 8192);
	ptyname_array = _tmp17_;
	ptyname_array_length1 = 8192;
	_ptyname_array_size_ = ptyname_array_length1;
	_tmp18_ = ptyname_array;
	_tmp18__length1 = ptyname_array_length1;
	_tmp21_ = openpty (&_tmp19_, &_tmp20_, _tmp18_, NULL, NULL);
	ptym = _tmp19_;
	ptys = _tmp20_;
	_vala_assert (_tmp21_ == 0, "Linux.openpty (out ptym, out ptys, ptyname_array, null, null) == 0");
	_tmp22_ = ptyname_array;
	_tmp22__length1 = ptyname_array_length1;
	_tmp23_ = g_strdup ((const gchar*) _tmp22_);
	ptyname = _tmp23_;
	_tmp24_ = node_path;
	_tmp25_ = ptyname;
	g_debug ("umockdev.vala:1009: create_node_for_device: creating pty device %s: go" \
"t pty %s", _tmp24_, _tmp25_);
	_tmp26_ = ptys;
	close (_tmp26_);
	_tmp27_ = ptym;
	_tmp29_ = tcgetattr (_tmp27_, &_tmp28_);
	ios = _tmp28_;
	_vala_assert (_tmp29_ == 0, "Posix.tcgetattr (ptym, out ios) == 0");
	_tmp30_ = ios.c_iflag;
	ios.c_iflag = _tmp30_ & (~((IGNCR | INLCR) | ICRNL));
	_tmp31_ = ios.c_oflag;
	ios.c_oflag = _tmp31_ & (~(ONLCR | OCRNL));
	_tmp32_ = ios.c_lflag;
	ios.c_lflag = _tmp32_ & (~(ICANON | ECHO));
	cfmakeraw (&ios);
	_tmp33_ = ptym;
	_tmp34_ = ios;
	_tmp35_ = tcsetattr (_tmp33_, TCSANOW, &_tmp34_);
	_vala_assert (_tmp35_ == 0, "Posix.tcsetattr (ptym, Posix.TCSANOW, ios) == 0");
	_tmp36_ = ptyname;
	_tmp37_ = node_path;
	_tmp38_ = symlink (_tmp36_, _tmp37_);
	_vala_assert (_tmp38_ == 0, "FileUtils.symlink (ptyname, node_path) == 0");
	_tmp39_ = node_path;
	_tmp40_ = self->priv->root_dir;
	_tmp41_ = strlen (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = string_substring (_tmp39_, (glong) _tmp42_, (glong) (-1));
	devname = _tmp43_;
	_tmp44_ = self->priv->dev_fd;
	_tmp45_ = devname;
	_tmp46_ = g_hash_table_contains (_tmp44_, _tmp45_);
	_vala_assert (!_tmp46_, "!this.dev_fd.contains (devname)");
	_tmp47_ = self->priv->dev_fd;
	_tmp48_ = devname;
	_tmp49_ = g_strdup (_tmp48_);
	_tmp50_ = ptym;
	g_hash_table_insert (_tmp47_, _tmp49_, (gpointer) ((gintptr) _tmp50_));
	_g_free0 (devname);
	_g_free0 (ptyname);
	ptyname_array = (g_free (ptyname_array), NULL);
}


/**
     * umockdev_testbed_record_parse_line:
     * @data: String to parse
     * @type: Pointer to a gchar which will get the line type (one of P, N,
     *        S, E, or H)
     * @key:  Pointer to a string which will get the key name; this will be
     *        set to %NULL for line types which do not have a key (P, N, S). You
     *        need to free this with g_free().
     * @value: Pointer to a string which will get the value. You need to
     *         free this with g_free().
     *
     * Parse one line from a device record file.
     *
     * Returns: Pointer to the next line start in @data, or %NULL if the first line
     * is not valid.
     */
static gchar* umockdev_testbed_record_parse_line (UMockdevTestbed* self, const gchar* data, gchar* type, gchar** key, gchar** val) {
	gchar _vala_type = '\0';
	gchar* _vala_key = NULL;
	gchar* _vala_val = NULL;
	gchar* result = NULL;
	GMatchInfo* match = NULL;
	GRegex* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GMatchInfo* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gchar* type_str = NULL;
	GMatchInfo* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gchar _tmp28_ = '\0';
	gint end_pos = 0;
	GMatchInfo* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gboolean _tmp31_ = FALSE;
	const gchar* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gchar* _tmp34_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = self->priv->re_record_val;
	_tmp1_ = data;
	_tmp3_ = g_regex_match (_tmp0_, _tmp1_, 0, &_tmp2_);
	_g_match_info_unref0 (match);
	match = _tmp2_;
	if (_tmp3_) {
		GMatchInfo* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_g_free0 (_vala_key);
		_vala_key = NULL;
		_tmp4_ = match;
		_tmp5_ = g_match_info_fetch (_tmp4_, 2);
		_g_free0 (_vala_val);
		_vala_val = _tmp5_;
	} else {
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GMatchInfo* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp6_ = self->priv->re_record_keyval;
		_tmp7_ = data;
		_tmp9_ = g_regex_match (_tmp6_, _tmp7_, 0, &_tmp8_);
		_g_match_info_unref0 (match);
		match = _tmp8_;
		if (_tmp9_) {
			GMatchInfo* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			GMatchInfo* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			_tmp10_ = match;
			_tmp11_ = g_match_info_fetch (_tmp10_, 2);
			_g_free0 (_vala_key);
			_vala_key = _tmp11_;
			_tmp12_ = match;
			_tmp13_ = g_match_info_fetch (_tmp12_, 3);
			_g_free0 (_vala_val);
			_vala_val = _tmp13_;
			_tmp14_ = _vala_val;
			_vala_assert (_tmp14_ != NULL, "val != null");
		} else {
			GRegex* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			GMatchInfo* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
			_tmp15_ = self->priv->re_record_optval;
			_tmp16_ = data;
			_tmp18_ = g_regex_match (_tmp15_, _tmp16_, 0, &_tmp17_);
			_g_match_info_unref0 (match);
			match = _tmp17_;
			if (_tmp18_) {
				GMatchInfo* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				GMatchInfo* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				_tmp19_ = match;
				_tmp20_ = g_match_info_fetch (_tmp19_, 2);
				_g_free0 (_vala_key);
				_vala_key = _tmp20_;
				_tmp21_ = match;
				_tmp22_ = g_match_info_fetch (_tmp21_, 3);
				_g_free0 (_vala_val);
				_vala_val = _tmp22_;
			} else {
				const gchar* _tmp23_ = NULL;
				_tmp23_ = data;
				g_debug ("umockdev.vala:1062: record_parse_line: >%s< does not match anything, f" \
"ailing", _tmp23_);
				_vala_type = '\0';
				_g_free0 (_vala_key);
				_vala_key = NULL;
				_g_free0 (_vala_val);
				_vala_val = NULL;
				result = NULL;
				_g_match_info_unref0 (match);
				if (type) {
					*type = _vala_type;
				}
				if (key) {
					*key = _vala_key;
				} else {
					_g_free0 (_vala_key);
				}
				if (val) {
					*val = _vala_val;
				} else {
					_g_free0 (_vala_val);
				}
				return result;
			}
		}
	}
	_tmp24_ = match;
	_tmp25_ = g_match_info_fetch (_tmp24_, 1);
	type_str = _tmp25_;
	_tmp26_ = type_str;
	_vala_assert (_tmp26_ != NULL, "type_str != null");
	_tmp27_ = type_str;
	_tmp28_ = string_get (_tmp27_, (glong) 0);
	_vala_type = _tmp28_;
	_tmp29_ = match;
	_tmp31_ = g_match_info_fetch_pos (_tmp29_, 0, NULL, &_tmp30_);
	end_pos = _tmp30_;
	_vala_assert (_tmp31_, "match.fetch_pos(0, null, out end_pos)");
	_tmp32_ = data;
	_tmp33_ = end_pos;
	_tmp34_ = string_substring (_tmp32_, (glong) _tmp33_, (glong) (-1));
	result = _tmp34_;
	_g_free0 (type_str);
	_g_match_info_unref0 (match);
	if (type) {
		*type = _vala_type;
	}
	if (key) {
		*key = _vala_key;
	} else {
		_g_free0 (_vala_key);
	}
	if (val) {
		*val = _vala_val;
	} else {
		_g_free0 (_vala_val);
	}
	return result;
}


/**
     * umockdev_testbed_disable:
     * @self: A #UMockdevTestbed.
     *
     * Disable the testbed.  This can be used for temporarily switching back to
     * the real /sys and /dev without having to destroy or change $UMOCKDEV_DIR
     * and the #UMockdevTestbed instance. Use @umockdev_testbed_enable() to
     * re-enable the testbed.
     */
void umockdev_testbed_disable (UMockdevTestbed* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	FILE* _tmp3_ = NULL;
	FILE* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, "disabled", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_fopen (_tmp2_, "w");
	_tmp4_ = _tmp3_;
	_fclose0 (_tmp4_);
	_g_free0 (_tmp2_);
}


/**
     * umockdev_testbed_enable:
     * @self: A #UMockdevTestbed.
     *
     * Re-enable the testbed after @@umockdev_testbed_disable().
     */
void umockdev_testbed_enable (UMockdevTestbed* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, "disabled", NULL);
	_tmp2_ = _tmp1_;
	g_remove (_tmp2_);
	_g_free0 (_tmp2_);
}


/**
     * umockdev_testbed_clear:
     * @self: A #UMockdevTestbed.
     *
     * Remove all added devices from testbed directory.  After that, the
     * umockdev root directory will be in the same state as directly after the
     * constructor.
     */
void umockdev_testbed_clear (UMockdevTestbed* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_dir;
	umockdev_remove_dir (_tmp0_, FALSE);
	_tmp1_ = self->priv->sys_dir;
	g_mkdir (_tmp1_, 0755);
}


/**
     * umockdev_testbed_get_dev_fd:
     * @self: A #UMockdevTestbed.
     * @devnode: Device node name ("/dev/...")
     *
     * Simulated devices without a pre-defined contents are backed by a
     * stream-like device node (PTY). Return the file descriptor
     * for accessing their "master" side, i. e. the end that gets
     * controlled by test suites. The tested program opens the "slave" side,
     * which is just openening the device specified by @devnode, e. g.
     * /dev/ttyUSB2. Once that happened, your test can directly communicate
     * with the tested program over that descriptor.
     *
     * Returns: File descriptor for communicating with clients that connect to
     *           @devnode, or -1 if @devnode does not exist or is not a
     *           simulated stream device. This must not be closed!
     */
gint umockdev_testbed_get_dev_fd (UMockdevTestbed* self, const gchar* devnode) {
	gint result = 0;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (devnode != NULL, 0);
	_tmp0_ = self->priv->dev_fd;
	_tmp1_ = devnode;
	_tmp2_ = g_hash_table_contains (_tmp0_, _tmp1_);
	if (_tmp2_) {
		GHashTable* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gconstpointer _tmp5_ = NULL;
		_tmp3_ = self->priv->dev_fd;
		_tmp4_ = devnode;
		_tmp5_ = g_hash_table_lookup (_tmp3_, _tmp4_);
		result = (gint) ((gintptr) _tmp5_);
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void umockdev_testbed_class_init (UMockdevTestbedClass * klass) {
	umockdev_testbed_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UMockdevTestbedPrivate));
	G_OBJECT_CLASS (klass)->finalize = umockdev_testbed_finalize;
}


static void umockdev_testbed_instance_init (UMockdevTestbed * self) {
	self->priv = UMOCKDEV_TESTBED_GET_PRIVATE (self);
	self->priv->ev_sender = NULL;
	self->priv->socket_server = NULL;
}


static void umockdev_testbed_finalize (GObject* obj) {
	UMockdevTestbed * self;
	GHashTable* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GHashTable* _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	UMockdevSocketServer* _tmp8_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_TESTBED, UMockdevTestbed);
	_tmp0_ = self->priv->dev_script_runner;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* r_collection = NULL;
		GList* r_it = NULL;
		r_collection = _tmp1_;
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
			UMockdevScriptRunner* r = NULL;
			r = (UMockdevScriptRunner*) r_it->data;
			{
				UMockdevScriptRunner* _tmp2_ = NULL;
				_tmp2_ = r;
				umockdev_script_runner_stop (_tmp2_);
			}
		}
		_g_list_free0 (r_collection);
	}
	_tmp3_ = self->priv->dev_script_runner;
	g_hash_table_remove_all (_tmp3_);
	_tmp4_ = self->priv->dev_fd;
	_tmp5_ = g_hash_table_get_values (_tmp4_);
	{
		GList* fd_collection = NULL;
		GList* fd_it = NULL;
		fd_collection = _tmp5_;
		for (fd_it = fd_collection; fd_it != NULL; fd_it = fd_it->next) {
			gint fd = 0;
			fd = (gint) ((gintptr) fd_it->data);
			{
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				_tmp6_ = fd;
				g_debug ("umockdev.vala:87: closing master pty fd %i for emulated device", _tmp6_);
				_tmp7_ = fd;
				close (_tmp7_);
			}
		}
		_g_list_free0 (fd_collection);
	}
	_tmp8_ = self->priv->socket_server;
	if (_tmp8_ != NULL) {
		UMockdevSocketServer* _tmp9_ = NULL;
		g_debug ("umockdev.vala:92: shutting down socket server thread");
		_tmp9_ = self->priv->socket_server;
		umockdev_socket_server_stop (_tmp9_);
		_umockdev_socket_server_unref0 (self->priv->socket_server);
		self->priv->socket_server = NULL;
	}
	_tmp10_ = self->priv->root_dir;
	g_debug ("umockdev.vala:97: Removing test bed %s", _tmp10_);
	_tmp11_ = self->priv->root_dir;
	umockdev_remove_dir (_tmp11_, TRUE);
	g_unsetenv ("UMOCKDEV_DIR");
	_g_free0 (self->priv->root_dir);
	_g_free0 (self->priv->sys_dir);
	_g_regex_unref0 (self->priv->re_record_val);
	_g_regex_unref0 (self->priv->re_record_keyval);
	_g_regex_unref0 (self->priv->re_record_optval);
	_uevent_sender_close0 (self->priv->ev_sender);
	_g_hash_table_unref0 (self->priv->dev_fd);
	_g_hash_table_unref0 (self->priv->dev_script_runner);
	_umockdev_socket_server_unref0 (self->priv->socket_server);
	G_OBJECT_CLASS (umockdev_testbed_parent_class)->finalize (obj);
}


/**
 * UMockdevTestbed:
 *
 * The #UMockdevTestbed class builds a temporary sandbox for mock devices.
 * You can add a number of devices including arbitrary sysfs attributes and
 * udev properties, and then run your software in that test bed that is
 * independent of the actual hardware it is running on.  With this you can
 * simulate particular hardware in virtual environments up to some degree,
 * without needing any particular privileges or disturbing the whole system.
 *
 * You can either add devices by specifying individual device paths,
 * properties, and attributes, or use the umockdev-record tool to create a human
 * readable/editable record of a real device (and all its parents) and load
 * that into the testbed with umockdev_testbed_add_from_string().
 *
 * Instantiating a #UMockdevTestbed object creates a temporary directory with
 * an empty sysfs tree and sets the $UMOCKDEV_DIR environment variable so that
 * programs subsequently started under umockdev-wrapper will use the test bed
 * instead of the system's real sysfs.
 */
GType umockdev_testbed_get_type (void) {
	static volatile gsize umockdev_testbed_type_id__volatile = 0;
	if (g_once_init_enter (&umockdev_testbed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UMockdevTestbedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_testbed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevTestbed), 0, (GInstanceInitFunc) umockdev_testbed_instance_init, NULL };
		GType umockdev_testbed_type_id;
		umockdev_testbed_type_id = g_type_register_static (G_TYPE_OBJECT, "UMockdevTestbed", &g_define_type_info, 0);
		g_once_init_leave (&umockdev_testbed_type_id__volatile, umockdev_testbed_type_id);
	}
	return umockdev_testbed_type_id__volatile;
}


void umockdev_remove_dir (const gchar* path, gboolean remove_toplevel) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp20_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (path != NULL);
	_tmp1_ = path;
	_tmp2_ = g_file_test (_tmp1_, G_FILE_TEST_IS_DIR);
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = path;
		_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_IS_SYMLINK);
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		GDir* d = NULL;
		gchar* name = NULL;
		{
			GDir* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			GDir* _tmp8_ = NULL;
			_tmp7_ = path;
			_tmp8_ = g_dir_open (_tmp7_, (guint) 0, &_inner_error_);
			_tmp6_ = _tmp8_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch9_g_file_error;
				}
				_g_dir_close0 (d);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_dir_close0 (d);
			d = _tmp6_;
		}
		goto __finally9;
		__catch9_g_file_error:
		{
			GError* e = NULL;
			const gchar* _tmp9_ = NULL;
			GError* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = path;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("umockdev.vala:1167: cannot open: %s: %s", _tmp9_, _tmp11_);
			_g_error_free0 (e);
			_g_dir_close0 (d);
			return;
		}
		__finally9:
		if (_inner_error_ != NULL) {
			_g_dir_close0 (d);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		while (TRUE) {
			GDir* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			_tmp12_ = d;
			_tmp13_ = g_dir_read_name (_tmp12_);
			_tmp14_ = g_strdup (_tmp13_);
			_g_free0 (name);
			name = _tmp14_;
			_tmp15_ = name;
			if (!(_tmp15_ != NULL)) {
				break;
			}
			_tmp16_ = path;
			_tmp17_ = name;
			_tmp18_ = g_build_filename (_tmp16_, _tmp17_, NULL);
			_tmp19_ = _tmp18_;
			umockdev_remove_dir (_tmp19_, TRUE);
			_g_free0 (_tmp19_);
		}
		_g_free0 (name);
		_g_dir_close0 (d);
	}
	_tmp20_ = remove_toplevel;
	if (_tmp20_) {
		const gchar* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		_tmp21_ = path;
		_tmp22_ = g_remove (_tmp21_);
		if (_tmp22_ < 0) {
			const gchar* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			const gchar* _tmp25_ = NULL;
			_tmp23_ = path;
			_tmp24_ = errno;
			_tmp25_ = g_strerror (_tmp24_);
			g_warning ("umockdev.vala:1178: cannot remove %s: %s", _tmp23_, _tmp25_);
		}
	}
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* umockdev_make_dotdots (const gchar* path) {
	gchar* result = NULL;
	gint offset = 0;
	guint count = 0U;
	gchar* dots = NULL;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	offset = 0;
	count = (guint) 0;
	while (TRUE) {
		const gchar* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		guint _tmp4_ = 0U;
		gint _tmp5_ = 0;
		_tmp0_ = path;
		_tmp1_ = offset;
		_tmp2_ = string_index_of_char (_tmp0_, (gunichar) '/', _tmp1_);
		offset = _tmp2_;
		_tmp3_ = offset;
		if (!(_tmp3_ >= 0)) {
			break;
		}
		_tmp4_ = count;
		count = _tmp4_ + 1;
		_tmp5_ = offset;
		offset = _tmp5_ + 1;
	}
	_tmp6_ = g_strdup ("");
	dots = _tmp6_;
	while (TRUE) {
		guint _tmp7_ = 0U;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		_tmp7_ = count;
		if (!(_tmp7_ > ((guint) 1))) {
			break;
		}
		_tmp8_ = dots;
		_tmp9_ = g_strconcat (_tmp8_, "../", NULL);
		_g_free0 (dots);
		dots = _tmp9_;
		_tmp10_ = count;
		count = _tmp10_ - 1;
	}
	result = dots;
	return result;
}


guint8 umockdev_hexdigit (gchar c) {
	guint8 result = 0U;
	gint _tmp0_ = 0;
	gchar _tmp1_ = '\0';
	gint _tmp8_ = 0;
	_tmp1_ = c;
	if (_tmp1_ >= 'a') {
		gchar _tmp2_ = '\0';
		_tmp2_ = c;
		_tmp0_ = (_tmp2_ - 'a') + 10;
	} else {
		gint _tmp3_ = 0;
		gchar _tmp4_ = '\0';
		gint _tmp7_ = 0;
		_tmp4_ = c;
		if (_tmp4_ >= 'A') {
			gchar _tmp5_ = '\0';
			_tmp5_ = c;
			_tmp3_ = (_tmp5_ - 'A') + 10;
		} else {
			gchar _tmp6_ = '\0';
			_tmp6_ = c;
			_tmp3_ = (gint) (_tmp6_ - '0');
		}
		_tmp7_ = _tmp3_;
		_tmp0_ = _tmp7_;
	}
	_tmp8_ = _tmp0_;
	result = (guint8) _tmp8_;
	return result;
}


guint8* umockdev_decode_hex (const gchar* data, int* result_length1, GError** error) {
	guint8* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint len = 0;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	guint8* bin = NULL;
	gint _tmp8_ = 0;
	guint8* _tmp9_ = NULL;
	gint bin_length1 = 0;
	gint _bin_size_ = 0;
	guint8* _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if ((_tmp2_ % 2) != 0) {
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp3_ = data;
		_tmp4_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "malformed hexadecimal value: %s", _tmp3_);
		_inner_error_ = _tmp4_;
		if (_inner_error_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = data;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	len = _tmp7_;
	_tmp8_ = len;
	_tmp9_ = g_new0 (guint8, _tmp8_ / 2);
	bin = _tmp9_;
	bin_length1 = _tmp8_ / 2;
	_bin_size_ = bin_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				guint _tmp13_ = 0U;
				guint8* _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				guint8* _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				guint _tmp16_ = 0U;
				const gchar* _tmp17_ = NULL;
				guint _tmp18_ = 0U;
				gchar _tmp19_ = '\0';
				guint8 _tmp20_ = 0U;
				const gchar* _tmp21_ = NULL;
				guint _tmp22_ = 0U;
				gchar _tmp23_ = '\0';
				guint8 _tmp24_ = 0U;
				guint8 _tmp25_ = 0U;
				_tmp11_ = _tmp10_;
				if (!_tmp11_) {
					guint _tmp12_ = 0U;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp13_ = i;
				_tmp14_ = bin;
				_tmp14__length1 = bin_length1;
				if (!(_tmp13_ < ((guint) _tmp14__length1))) {
					break;
				}
				_tmp15_ = bin;
				_tmp15__length1 = bin_length1;
				_tmp16_ = i;
				_tmp17_ = data;
				_tmp18_ = i;
				_tmp19_ = string_get (_tmp17_, (glong) (_tmp18_ * 2));
				_tmp20_ = umockdev_hexdigit (_tmp19_);
				_tmp21_ = data;
				_tmp22_ = i;
				_tmp23_ = string_get (_tmp21_, (glong) ((_tmp22_ * 2) + 1));
				_tmp24_ = umockdev_hexdigit (_tmp23_);
				_tmp15_[_tmp16_] = (guint8) ((_tmp20_ << 4) | _tmp24_);
				_tmp25_ = _tmp15_[_tmp16_];
			}
		}
	}
	_tmp26_ = bin;
	_tmp26__length1 = bin_length1;
	if (result_length1) {
		*result_length1 = _tmp26__length1;
	}
	result = _tmp26_;
	return result;
}


gchar* umockdev_find_devnode (const gchar* devpath) {
	gchar* result = NULL;
	gchar* devname = NULL;
	GFile* f = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (devpath != NULL, NULL);
	devname = NULL;
	_tmp0_ = devpath;
	_tmp1_ = g_build_filename (_tmp0_, "uevent", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	f = _tmp4_;
	{
		GFileInputStream* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		GFileInputStream* _tmp7_ = NULL;
		GDataInputStream* inp = NULL;
		GFileInputStream* _tmp8_ = NULL;
		GDataInputStream* _tmp9_ = NULL;
		GDataInputStream* _tmp10_ = NULL;
		gchar* line = NULL;
		gsize len = 0UL;
		GDataInputStream* _tmp24_ = NULL;
		_tmp6_ = f;
		_tmp7_ = g_file_read (_tmp6_, NULL, &_inner_error_);
		_tmp5_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		_tmp8_ = _tmp5_;
		_tmp9_ = g_data_input_stream_new ((GInputStream*) _tmp8_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		inp = _tmp10_;
		while (TRUE) {
			gchar* _tmp11_ = NULL;
			GDataInputStream* _tmp12_ = NULL;
			gsize _tmp13_ = 0UL;
			gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			_tmp12_ = inp;
			_tmp14_ = g_data_input_stream_read_line (_tmp12_, &_tmp13_, NULL, &_inner_error_);
			len = _tmp13_;
			_tmp11_ = _tmp14_;
			if (_inner_error_ != NULL) {
				_g_free0 (line);
				_g_object_unref0 (inp);
				goto __catch10_g_error;
			}
			_g_free0 (line);
			line = _tmp11_;
			_tmp15_ = line;
			if (!(_tmp15_ != NULL)) {
				break;
			}
			_tmp16_ = line;
			_tmp17_ = g_str_has_prefix (_tmp16_, "DEVNAME=");
			if (_tmp17_) {
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				gboolean _tmp21_ = FALSE;
				_tmp18_ = line;
				_tmp19_ = string_substring (_tmp18_, (glong) 8, (glong) (-1));
				_g_free0 (devname);
				devname = _tmp19_;
				_tmp20_ = devname;
				_tmp21_ = g_str_has_prefix (_tmp20_, "/dev/");
				if (!_tmp21_) {
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					_tmp22_ = devname;
					_tmp23_ = g_strconcat ("/dev/", _tmp22_, NULL);
					_g_free0 (devname);
					devname = _tmp23_;
				}
				break;
			}
		}
		_tmp24_ = inp;
		g_input_stream_close ((GInputStream*) _tmp24_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			goto __catch10_g_error;
		}
		_g_free0 (line);
		_g_object_unref0 (inp);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_warning ("umockdev.vala:1246: Cannot read uevent file: %s\n", _tmp26_);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (f);
		_g_free0 (devname);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = devname;
	_g_object_unref0 (f);
	return result;
}


static gpointer _umockdev_script_runner_run_gthread_func (gpointer self) {
	gpointer result;
	result = umockdev_script_runner_run (self);
	umockdev_script_runner_unref (self);
	return result;
}


UMockdevScriptRunner* umockdev_script_runner_construct (GType object_type, const gchar* device, const gchar* script_file, gint fd, GError** error) {
	UMockdevScriptRunner* self = NULL;
	const gchar* _tmp0_ = NULL;
	FILE* _tmp1_ = NULL;
	FILE* _tmp2_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	const gchar* _tmp12_ = NULL;
	GThread* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (script_file != NULL, NULL);
	self = (UMockdevScriptRunner*) g_type_create_instance (object_type);
	_tmp0_ = script_file;
	_tmp1_ = g_fopen (_tmp0_, "r");
	_fclose0 (self->priv->script);
	self->priv->script = _tmp1_;
	_tmp2_ = self->priv->script;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		_tmp3_ = script_file;
		_tmp4_ = g_strconcat ("Cannot open script record file ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == G_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_umockdev_script_runner_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = device;
	umockdev_script_runner_set_device (self, _tmp8_);
	_tmp9_ = script_file;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (self->priv->script_file);
	self->priv->script_file = _tmp10_;
	_tmp11_ = fd;
	self->priv->fd = _tmp11_;
	self->priv->running = TRUE;
	_tmp12_ = device;
	_tmp13_ = g_thread_new (_tmp12_, _umockdev_script_runner_run_gthread_func, umockdev_script_runner_ref (self));
	_g_thread_unref0 (self->priv->thread);
	self->priv->thread = _tmp13_;
	return self;
}


UMockdevScriptRunner* umockdev_script_runner_new (const gchar* device, const gchar* script_file, gint fd, GError** error) {
	return umockdev_script_runner_construct (UMOCKDEV_TYPE_SCRIPT_RUNNER, device, script_file, fd, error);
}


void umockdev_script_runner_stop (UMockdevScriptRunner* self) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	GThread* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->running;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->_device;
	g_debug ("umockdev.vala:1277: Stopping script runner for %s: joining thread", _tmp1_);
	self->priv->running = FALSE;
	_tmp2_ = self->priv->thread;
	g_thread_join (_tmp2_);
}


static void* umockdev_script_runner_run (UMockdevScriptRunner* self) {
	void* result = NULL;
	gchar op = '\0';
	guint32 delta = 0U;
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp38_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	g_debug ("umockdev.vala:1288: ScriptRunner[%s]: start", _tmp0_);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gchar _tmp2_ = '\0';
		guint32 _tmp3_ = 0U;
		gint _tmp4_ = 0;
		guint8* _tmp5_ = NULL;
		gchar _tmp6_ = '\0';
		_tmp1_ = self->priv->running;
		if (!_tmp1_) {
			break;
		}
		_tmp5_ = umockdev_script_runner_next_line (self, &_tmp2_, &_tmp3_, &_tmp4_);
		op = _tmp2_;
		delta = _tmp3_;
		data = (g_free (data), NULL);
		data = _tmp5_;
		data_length1 = _tmp4_;
		_data_size_ = data_length1;
		_tmp6_ = op;
		switch (_tmp6_) {
			case 'r':
			{
				const gchar* _tmp7_ = NULL;
				guint32 _tmp8_ = 0U;
				guint32 _tmp9_ = 0U;
				const gchar* _tmp10_ = NULL;
				guint8* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gssize l = 0L;
				gint _tmp14_ = 0;
				guint8* _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				guint8* _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gssize _tmp17_ = 0L;
				gssize _tmp18_ = 0L;
				gssize _tmp22_ = 0L;
				guint8* _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				_tmp7_ = self->priv->_device;
				_tmp8_ = delta;
				g_debug ("ScriptRunner[%s]: read op; sleeping %" G_GUINT32_FORMAT " ms", _tmp7_, _tmp8_);
				_tmp9_ = delta;
				g_usleep ((gulong) (_tmp9_ * 1000));
				_tmp10_ = self->priv->_device;
				_tmp11_ = data;
				_tmp11__length1 = data_length1;
				_tmp12_ = umockdev_script_runner_encode (_tmp11_, _tmp11__length1);
				_tmp13_ = _tmp12_;
				g_debug ("umockdev.vala:1298: ScriptRunner[%s]: read op after sleep; writing dat" \
"a '%s'", _tmp10_, _tmp13_);
				_g_free0 (_tmp13_);
				_tmp14_ = self->priv->fd;
				_tmp15_ = data;
				_tmp15__length1 = data_length1;
				_tmp16_ = data;
				_tmp16__length1 = data_length1;
				_tmp17_ = write (_tmp14_, _tmp15_, (gsize) _tmp16__length1);
				l = _tmp17_;
				_tmp18_ = l;
				if (_tmp18_ < ((gssize) 0)) {
					const gchar* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					const gchar* _tmp21_ = NULL;
					_tmp19_ = self->priv->_device;
					_tmp20_ = errno;
					_tmp21_ = g_strerror (_tmp20_);
					g_error ("umockdev.vala:1301: ScriptRunner[%s]: write failed: %s", _tmp19_, _tmp21_);
				}
				_tmp22_ = l;
				_tmp23_ = data;
				_tmp23__length1 = data_length1;
				_vala_assert (_tmp22_ == ((gssize) _tmp23__length1), "l == data.length");
				break;
			}
			case 'w':
			{
				const gchar* _tmp24_ = NULL;
				guint8* _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				guint8* _tmp28_ = NULL;
				gint _tmp28__length1 = 0;
				guint32 _tmp29_ = 0U;
				_tmp24_ = self->priv->_device;
				_tmp25_ = data;
				_tmp25__length1 = data_length1;
				_tmp26_ = umockdev_script_runner_encode (_tmp25_, _tmp25__length1);
				_tmp27_ = _tmp26_;
				g_debug ("umockdev.vala:1306: ScriptRunner[%s]: write op, data '%s'", _tmp24_, _tmp27_);
				_g_free0 (_tmp27_);
				_tmp28_ = data;
				_tmp28__length1 = data_length1;
				_tmp29_ = delta;
				umockdev_script_runner_op_write (self, _tmp28_, _tmp28__length1, _tmp29_);
				break;
			}
			case 'Q':
			{
				self->priv->running = FALSE;
				break;
			}
			case 'f':
			{
				guint32 _tmp30_ = 0U;
				guint32 _tmp33_ = 0U;
				const gchar* _tmp34_ = NULL;
				guint _tmp35_ = 0U;
				_tmp30_ = delta;
				if (_tmp30_ > ((guint32) 100)) {
					const gchar* _tmp31_ = NULL;
					guint32 _tmp32_ = 0U;
					_tmp31_ = self->priv->_device;
					_tmp32_ = delta;
					g_error ("umockdev.vala:1316: ScriptRunner[%s]: fuzz value %u is invalid (must b" \
"e between 0 and 100)", _tmp31_, (guint) _tmp32_);
				}
				_tmp33_ = delta;
				self->priv->fuzz = (guint) _tmp33_;
				_tmp34_ = self->priv->_device;
				_tmp35_ = self->priv->fuzz;
				g_debug ("umockdev.vala:1319: ScriptRunner[%s]: setting fuzz level to %u%%", _tmp34_, _tmp35_);
				break;
			}
			case 'd':
			{
				break;
			}
			default:
			{
				const gchar* _tmp36_ = NULL;
				gchar _tmp37_ = '\0';
				_tmp36_ = self->priv->_device;
				_tmp37_ = op;
				g_debug ("umockdev.vala:1327: ScriptRunner[%s]: got unknown line op %c, ignoring", _tmp36_, (gint) _tmp37_);
				break;
			}
		}
	}
	_tmp38_ = self->priv->_device;
	g_debug ("umockdev.vala:1332: ScriptRunner[%s]: not running any more, ending thr" \
"ead", _tmp38_);
	result = NULL;
	data = (g_free (data), NULL);
	return result;
}


static gchar* g_file_stream_read_line (FILE* self) {
	gchar* result = NULL;
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		GString* _tmp2_ = NULL;
		gint _tmp4_ = 0;
		GString* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp0_ = fgetc (self);
		c = _tmp0_;
		_tmp1_ = c;
		if (!(_tmp1_ != EOF)) {
			break;
		}
		_tmp2_ = ret;
		if (_tmp2_ == NULL) {
			GString* _tmp3_ = NULL;
			_tmp3_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp3_;
		}
		_tmp4_ = c;
		if (_tmp4_ == ((gint) '\n')) {
			break;
		}
		_tmp5_ = ret;
		_tmp6_ = c;
		g_string_append_c ((GString*) _tmp5_, (gchar) _tmp6_);
	}
	_tmp7_ = ret;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp8_ = ret;
		_tmp9_ = ((GString*) _tmp8_)->str;
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}


static guint8* umockdev_script_runner_next_line (UMockdevScriptRunner* self, gchar* op, guint32* delta, int* result_length1) {
	gchar _vala_op = '\0';
	guint32 _vala_delta = 0U;
	guint8* result = NULL;
	gint c = 0;
	glong cur_pos = 0L;
	FILE* _tmp15_ = NULL;
	glong _tmp16_ = 0L;
	FILE* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	FILE* _tmp21_ = NULL;
	glong _tmp22_ = 0L;
	FILE* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gchar* line = NULL;
	FILE* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	guint8* _tmp32_ = NULL;
	guint8* _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			FILE* _tmp2_ = NULL;
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
			}
			_tmp0_ = FALSE;
			_tmp2_ = self->priv->script;
			_tmp3_ = fgetc (_tmp2_);
			c = _tmp3_;
			_tmp4_ = c;
			if (_tmp4_ == EOF) {
				const gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				guint8* _tmp7_ = NULL;
				guint8* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				_tmp5_ = self->priv->_device;
				_tmp6_ = self->priv->script_file;
				g_debug ("umockdev.vala:1343: ScriptRunner[%s]: end of script %s, closing", _tmp5_, _tmp6_);
				_vala_op = 'Q';
				_vala_delta = (guint32) 0;
				_tmp7_ = g_new0 (guint8, 0);
				_tmp8_ = _tmp7_;
				_tmp8__length1 = 0;
				if (result_length1) {
					*result_length1 = _tmp8__length1;
				}
				result = _tmp8_;
				if (op) {
					*op = _vala_op;
				}
				if (delta) {
					*delta = _vala_delta;
				}
				return result;
			} else {
				gint _tmp9_ = 0;
				_tmp9_ = c;
				if (_tmp9_ == ((gint) '#')) {
					FILE* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					_tmp10_ = self->priv->script;
					_tmp11_ = g_file_stream_read_line (_tmp10_);
					_tmp12_ = _tmp11_;
					_vala_assert (_tmp12_ != NULL, "this.script.read_line () != null");
					_g_free0 (_tmp12_);
				} else {
					gint _tmp13_ = 0;
					_tmp13_ = c;
					if (_tmp13_ != ((gint) '\n')) {
						gint _tmp14_ = 0;
						_tmp14_ = c;
						_vala_op = (gchar) _tmp14_;
						break;
					}
				}
			}
		}
	}
	_tmp15_ = self->priv->script;
	_tmp16_ = ftell (_tmp15_);
	cur_pos = _tmp16_;
	_tmp17_ = self->priv->script;
	_tmp18_ = fgetc (_tmp17_);
	if (_tmp18_ != ((gint) ' ')) {
		const gchar* _tmp19_ = NULL;
		glong _tmp20_ = 0L;
		_tmp19_ = self->priv->script_file;
		_tmp20_ = cur_pos;
		g_error ("umockdev.vala:1357: Missing space after operation code in %s at positi" \
"on %li", _tmp19_, _tmp20_);
	}
	_tmp21_ = self->priv->script;
	_tmp22_ = ftell (_tmp21_);
	cur_pos = _tmp22_;
	_tmp23_ = self->priv->script;
	_tmp24_ = fscanf (_tmp23_, "%" G_GUINT32_FORMAT " ", &_vala_delta);
	if (_tmp24_ != 1) {
		const gchar* _tmp25_ = NULL;
		glong _tmp26_ = 0L;
		_tmp25_ = self->priv->script_file;
		_tmp26_ = cur_pos;
		g_error ("umockdev.vala:1362: Cannot parse time in %s at position %li", _tmp25_, _tmp26_);
	}
	_tmp27_ = self->priv->script;
	_tmp28_ = g_file_stream_read_line (_tmp27_);
	line = _tmp28_;
	_tmp29_ = line;
	_vala_assert (_tmp29_ != NULL, "line != null");
	_tmp30_ = line;
	_tmp32_ = umockdev_script_runner_decode (_tmp30_, &_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp33__length1 = _tmp31_;
	if (result_length1) {
		*result_length1 = _tmp33__length1;
	}
	result = _tmp33_;
	_g_free0 (line);
	if (op) {
		*op = _vala_op;
	}
	if (delta) {
		*delta = _vala_delta;
	}
	return result;
}


static void umockdev_script_runner_op_write (UMockdevScriptRunner* self, guint8* data, int data_length1, guint32 delta) {
	fd_set fds = {0};
	struct timeval timeout = {0};
	struct timeval _tmp0_ = {0};
	gsize offset = 0UL;
	guint8* buf = NULL;
	guint8* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	guint8* _tmp2_ = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_.tv_sec = (time_t) 0;
	_tmp0_.tv_usec = (glong) 200000;
	timeout = _tmp0_;
	offset = (gsize) 0;
	_tmp1_ = data;
	_tmp1__length1 = data_length1;
	_tmp2_ = g_new0 (guint8, _tmp1__length1);
	buf = _tmp2_;
	buf_length1 = _tmp1__length1;
	_buf_size_ = buf_length1;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp7_ = FALSE;
		fd_set _tmp8_ = {0};
		gint _tmp9_ = 0;
		gint res = 0;
		gint _tmp10_ = 0;
		struct timeval _tmp11_ = {0};
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp18_ = 0;
		gssize len = 0L;
		gint _tmp25_ = 0;
		guint8* _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		guint8* _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gsize _tmp28_ = 0UL;
		gssize _tmp29_ = 0L;
		gssize _tmp30_ = 0L;
		guint _tmp38_ = 0U;
		gsize _tmp79_ = 0UL;
		gssize _tmp80_ = 0L;
		const gchar* _tmp81_ = NULL;
		gssize _tmp82_ = 0L;
		gsize _tmp83_ = 0UL;
		guint8* _tmp84_ = NULL;
		gint _tmp84__length1 = 0;
		_tmp4_ = self->priv->running;
		if (_tmp4_) {
			gsize _tmp5_ = 0UL;
			guint8* _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			_tmp5_ = offset;
			_tmp6_ = data;
			_tmp6__length1 = data_length1;
			_tmp3_ = _tmp5_ < ((gsize) _tmp6__length1);
		} else {
			_tmp3_ = FALSE;
		}
		_tmp7_ = _tmp3_;
		if (!_tmp7_) {
			break;
		}
		FD_ZERO (&_tmp8_);
		fds = _tmp8_;
		_tmp9_ = self->priv->fd;
		FD_SET (_tmp9_, &fds);
		_tmp10_ = self->priv->fd;
		_tmp11_ = timeout;
		_tmp12_ = select (_tmp10_ + 1, &fds, NULL, NULL, &_tmp11_);
		res = _tmp12_;
		_tmp13_ = res;
		if (_tmp13_ < 0) {
			gint _tmp14_ = 0;
			const gchar* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			const gchar* _tmp17_ = NULL;
			_tmp14_ = errno;
			if (_tmp14_ == EINTR) {
				continue;
			}
			_tmp15_ = self->priv->_device;
			_tmp16_ = errno;
			_tmp17_ = g_strerror (_tmp16_);
			g_error ("umockdev.vala:1387: ScriptRunner op_write[%s]: select() failed: %s", _tmp15_, _tmp17_);
		}
		_tmp18_ = res;
		if (_tmp18_ == 0) {
			const gchar* _tmp19_ = NULL;
			guint8* _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			gsize _tmp21_ = 0UL;
			guint8* _tmp22_ = NULL;
			gint _tmp22__length1 = 0;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			_tmp19_ = self->priv->_device;
			_tmp20_ = data;
			_tmp20__length1 = data_length1;
			_tmp21_ = offset;
			_tmp22_ = data;
			_tmp22__length1 = data_length1;
			_tmp23_ = umockdev_script_runner_encode (_tmp20_ + ((gint) _tmp21_), _tmp22__length1 - ((gint) _tmp21_));
			_tmp24_ = _tmp23_;
			g_debug ("umockdev.vala:1392: ScriptRunner[%s]: timed out on read operation on e" \
"xpected block '%s', trying again", _tmp19_, _tmp24_);
			_g_free0 (_tmp24_);
			continue;
		}
		_tmp25_ = self->priv->fd;
		_tmp26_ = buf;
		_tmp26__length1 = buf_length1;
		_tmp27_ = data;
		_tmp27__length1 = data_length1;
		_tmp28_ = offset;
		_tmp29_ = read (_tmp25_, _tmp26_, _tmp27__length1 - _tmp28_);
		len = _tmp29_;
		_tmp30_ = len;
		if (_tmp30_ <= ((gssize) 0)) {
			const gchar* _tmp31_ = NULL;
			guint8* _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			gsize _tmp33_ = 0UL;
			guint8* _tmp34_ = NULL;
			gint _tmp34__length1 = 0;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			FILE* _tmp37_ = NULL;
			_tmp31_ = self->priv->_device;
			_tmp32_ = data;
			_tmp32__length1 = data_length1;
			_tmp33_ = offset;
			_tmp34_ = data;
			_tmp34__length1 = data_length1;
			_tmp35_ = umockdev_script_runner_encode (_tmp32_ + ((gint) _tmp33_), _tmp34__length1 - ((gint) _tmp33_));
			_tmp36_ = _tmp35_;
			g_debug ("umockdev.vala:1400: ScriptRunner[%s]: got failure or EOF on read opera" \
"tion on expected block '%s', resetting", _tmp31_, _tmp36_);
			_g_free0 (_tmp36_);
			_tmp37_ = self->priv->script;
			fseek (_tmp37_, (glong) 0, SEEK_SET);
			buf = (g_free (buf), NULL);
			return;
		}
		_tmp38_ = self->priv->fuzz;
		if (_tmp38_ == ((guint) 0)) {
			guint8* _tmp39_ = NULL;
			gint _tmp39__length1 = 0;
			guint8* _tmp40_ = NULL;
			gint _tmp40__length1 = 0;
			gsize _tmp41_ = 0UL;
			guint8* _tmp42_ = NULL;
			gint _tmp42__length1 = 0;
			gssize _tmp43_ = 0L;
			gint _tmp44_ = 0;
			_tmp39_ = buf;
			_tmp39__length1 = buf_length1;
			_tmp40_ = data;
			_tmp40__length1 = data_length1;
			_tmp41_ = offset;
			_tmp42_ = data;
			_tmp42__length1 = data_length1;
			_tmp43_ = len;
			_tmp44_ = memcmp (_tmp39_, _tmp40_ + ((gint) _tmp41_), (gsize) _tmp43_);
			if (_tmp44_ != 0) {
				const gchar* _tmp45_ = NULL;
				guint8* _tmp46_ = NULL;
				gint _tmp46__length1 = 0;
				gchar* _tmp47_ = NULL;
				gchar* _tmp48_ = NULL;
				gssize _tmp49_ = 0L;
				guint8* _tmp50_ = NULL;
				gint _tmp50__length1 = 0;
				gsize _tmp51_ = 0UL;
				gsize _tmp52_ = 0UL;
				gssize _tmp53_ = 0L;
				gchar* _tmp54_ = NULL;
				gchar* _tmp55_ = NULL;
				_tmp45_ = self->priv->_device;
				_tmp46_ = buf;
				_tmp46__length1 = buf_length1;
				_tmp47_ = umockdev_script_runner_encode (_tmp46_, _tmp46__length1);
				_tmp48_ = _tmp47_;
				_tmp49_ = len;
				_tmp50_ = data;
				_tmp50__length1 = data_length1;
				_tmp51_ = offset;
				_tmp52_ = offset;
				_tmp53_ = len;
				_tmp54_ = umockdev_script_runner_encode (_tmp50_ + ((gint) _tmp51_), ((gint) (_tmp52_ + _tmp53_)) - ((gint) _tmp51_));
				_tmp55_ = _tmp54_;
				g_error ("ScriptRunner op_write[%s]: data mismatch; got block '%s' (%" G_GSSIZE_FORMAT " bytes), expected block '%s'", _tmp45_, _tmp48_, _tmp49_, _tmp55_);
				_g_free0 (_tmp55_);
				_g_free0 (_tmp48_);
			}
		} else {
			guint d = 0U;
			guint8* _tmp56_ = NULL;
			gint _tmp56__length1 = 0;
			guint8* _tmp57_ = NULL;
			gint _tmp57__length1 = 0;
			gsize _tmp58_ = 0UL;
			gsize _tmp59_ = 0UL;
			gssize _tmp60_ = 0L;
			guint _tmp61_ = 0U;
			guint _tmp62_ = 0U;
			guint _tmp63_ = 0U;
			gssize _tmp64_ = 0L;
			_tmp56_ = buf;
			_tmp56__length1 = buf_length1;
			_tmp57_ = data;
			_tmp57__length1 = data_length1;
			_tmp58_ = offset;
			_tmp59_ = offset;
			_tmp60_ = len;
			_tmp61_ = umockdev_script_runner_hamming (_tmp56_, _tmp56__length1, _tmp57_ + ((gint) _tmp58_), ((gint) (_tmp59_ + _tmp60_)) - ((gint) _tmp58_));
			d = _tmp61_;
			_tmp62_ = d;
			_tmp63_ = self->priv->fuzz;
			_tmp64_ = len;
			if (((gssize) (_tmp62_ * 100)) > (_tmp63_ * _tmp64_)) {
				const gchar* _tmp65_ = NULL;
				guint8* _tmp66_ = NULL;
				gint _tmp66__length1 = 0;
				gchar* _tmp67_ = NULL;
				gchar* _tmp68_ = NULL;
				gssize _tmp69_ = 0L;
				guint8* _tmp70_ = NULL;
				gint _tmp70__length1 = 0;
				gsize _tmp71_ = 0UL;
				gsize _tmp72_ = 0UL;
				gssize _tmp73_ = 0L;
				gchar* _tmp74_ = NULL;
				gchar* _tmp75_ = NULL;
				guint _tmp76_ = 0U;
				gssize _tmp77_ = 0L;
				guint _tmp78_ = 0U;
				_tmp65_ = self->priv->_device;
				_tmp66_ = buf;
				_tmp66__length1 = buf_length1;
				_tmp67_ = umockdev_script_runner_encode (_tmp66_, _tmp66__length1);
				_tmp68_ = _tmp67_;
				_tmp69_ = len;
				_tmp70_ = data;
				_tmp70__length1 = data_length1;
				_tmp71_ = offset;
				_tmp72_ = offset;
				_tmp73_ = len;
				_tmp74_ = umockdev_script_runner_encode (_tmp70_ + ((gint) _tmp71_), ((gint) (_tmp72_ + _tmp73_)) - ((gint) _tmp71_));
				_tmp75_ = _tmp74_;
				_tmp76_ = d;
				_tmp77_ = len;
				_tmp78_ = self->priv->fuzz;
				g_error ("ScriptRunner op_write[%s]: data mismatch; got block '%s' (%" G_GSSIZE_FORMAT " bytes), expected block '%s', difference %u%% > fuzz level %u%%", _tmp65_, _tmp68_, _tmp69_, _tmp75_, ((guint) (((_tmp76_ * 1000) / _tmp77_) + 5)) / 10, _tmp78_);
				_g_free0 (_tmp75_);
				_g_free0 (_tmp68_);
			}
		}
		_tmp79_ = offset;
		_tmp80_ = len;
		offset = _tmp79_ + _tmp80_;
		_tmp81_ = self->priv->_device;
		_tmp82_ = len;
		_tmp83_ = offset;
		_tmp84_ = data;
		_tmp84__length1 = data_length1;
		g_debug ("ScriptRunner[%s]: op_write, got %" G_GSSIZE_FORMAT " bytes; offset: %" G_GSIZE_FORMAT ", full block size %i", _tmp81_, _tmp82_, _tmp83_, _tmp84__length1);
	}
	buf = (g_free (buf), NULL);
}


static void _vala_array_add11 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add12 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static guint8* umockdev_script_runner_decode (const gchar* quoted, int* result_length1) {
	guint8* result = NULL;
	guint8* data = NULL;
	guint8* _tmp0_ = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	guint8* _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	g_return_val_if_fail (quoted != NULL, NULL);
	_tmp0_ = g_new0 (guint8, 0);
	data = _tmp0_;
	data_length1 = 0;
	_data_size_ = data_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				gint _tmp4_ = 0;
				const gchar* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				const gchar* _tmp8_ = NULL;
				guint8* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				guint8* _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gint _tmp11_ = 0;
				guint8 _tmp12_ = 0U;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = quoted;
				_tmp6_ = strlen (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ < _tmp7_)) {
					break;
				}
				_tmp8_ = quoted;
				_tmp9_ = string_get_data (_tmp8_, &_tmp9__length1);
				_tmp10_ = _tmp9_;
				_tmp10__length1 = _tmp9__length1;
				_tmp11_ = i;
				_tmp12_ = _tmp10_[_tmp11_];
				if (_tmp12_ == ((guint8) '^')) {
					gint _tmp13_ = 0;
					const gchar* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					gchar _tmp17_ = '\0';
					const gchar* _tmp18_ = NULL;
					guint8* _tmp19_ = NULL;
					gint _tmp19__length1 = 0;
					guint8* _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
					gint _tmp21_ = 0;
					guint8 _tmp22_ = 0U;
					guint8* _tmp28_ = NULL;
					gint _tmp28__length1 = 0;
					gchar _tmp29_ = '\0';
					gint _tmp30_ = 0;
					_tmp13_ = i;
					_tmp14_ = quoted;
					_tmp15_ = strlen (_tmp14_);
					_tmp16_ = _tmp15_;
					_vala_assert ((_tmp13_ + 1) < _tmp16_, "i + 1 < quoted.length");
					_tmp18_ = quoted;
					_tmp19_ = string_get_data (_tmp18_, &_tmp19__length1);
					_tmp20_ = _tmp19_;
					_tmp20__length1 = _tmp19__length1;
					_tmp21_ = i;
					_tmp22_ = _tmp20_[_tmp21_ + 1];
					if (_tmp22_ == ((guint8) '`')) {
						_tmp17_ = '^';
					} else {
						const gchar* _tmp23_ = NULL;
						guint8* _tmp24_ = NULL;
						gint _tmp24__length1 = 0;
						guint8* _tmp25_ = NULL;
						gint _tmp25__length1 = 0;
						gint _tmp26_ = 0;
						guint8 _tmp27_ = 0U;
						_tmp23_ = quoted;
						_tmp24_ = string_get_data (_tmp23_, &_tmp24__length1);
						_tmp25_ = _tmp24_;
						_tmp25__length1 = _tmp24__length1;
						_tmp26_ = i;
						_tmp27_ = _tmp25_[_tmp26_ + 1];
						_tmp17_ = (gchar) (_tmp27_ - 64);
					}
					_tmp28_ = data;
					_tmp28__length1 = data_length1;
					_tmp29_ = _tmp17_;
					_vala_array_add11 (&data, &data_length1, &_data_size_, (guint8) _tmp29_);
					_tmp30_ = i;
					i = _tmp30_ + 1;
				} else {
					guint8* _tmp31_ = NULL;
					gint _tmp31__length1 = 0;
					const gchar* _tmp32_ = NULL;
					guint8* _tmp33_ = NULL;
					gint _tmp33__length1 = 0;
					guint8* _tmp34_ = NULL;
					gint _tmp34__length1 = 0;
					gint _tmp35_ = 0;
					guint8 _tmp36_ = 0U;
					_tmp31_ = data;
					_tmp31__length1 = data_length1;
					_tmp32_ = quoted;
					_tmp33_ = string_get_data (_tmp32_, &_tmp33__length1);
					_tmp34_ = _tmp33_;
					_tmp34__length1 = _tmp33__length1;
					_tmp35_ = i;
					_tmp36_ = _tmp34_[_tmp35_];
					_vala_array_add12 (&data, &data_length1, &_data_size_, _tmp36_);
				}
			}
		}
	}
	_tmp37_ = data;
	_tmp37__length1 = data_length1;
	if (result_length1) {
		*result_length1 = _tmp37__length1;
	}
	result = _tmp37_;
	return result;
}


static void _vala_array_add13 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add14 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add15 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add16 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add17 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add18 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


gchar* umockdev_script_runner_encode (guint8* data, int data_length1) {
	gchar* result = NULL;
	guint8* quoted = NULL;
	guint8* _tmp0_ = NULL;
	gint quoted_length1 = 0;
	gint _quoted_size_ = 0;
	guint8* _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	guint8* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	gchar* _tmp25_ = NULL;
	_tmp0_ = g_new0 (guint8, 0);
	quoted = _tmp0_;
	quoted_length1 = 0;
	_quoted_size_ = quoted_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				gint _tmp4_ = 0;
				guint8* _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				guint8* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				guint8 _tmp8_ = 0U;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = data;
				_tmp5__length1 = data_length1;
				if (!(_tmp4_ < _tmp5__length1)) {
					break;
				}
				_tmp6_ = data;
				_tmp6__length1 = data_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				if (((gint) _tmp8_) < 32) {
					guint8* _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					guint8* _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					guint8* _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					gint _tmp12_ = 0;
					guint8 _tmp13_ = 0U;
					_tmp9_ = quoted;
					_tmp9__length1 = quoted_length1;
					_vala_array_add13 (&quoted, &quoted_length1, &_quoted_size_, (guint8) '^');
					_tmp10_ = quoted;
					_tmp10__length1 = quoted_length1;
					_tmp11_ = data;
					_tmp11__length1 = data_length1;
					_tmp12_ = i;
					_tmp13_ = _tmp11_[_tmp12_];
					_vala_array_add14 (&quoted, &quoted_length1, &_quoted_size_, (guint8) (_tmp13_ + 64));
				} else {
					guint8* _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					guint8 _tmp16_ = 0U;
					_tmp14_ = data;
					_tmp14__length1 = data_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_];
					if (_tmp16_ == ((guint8) '^')) {
						guint8* _tmp17_ = NULL;
						gint _tmp17__length1 = 0;
						guint8* _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						_tmp17_ = quoted;
						_tmp17__length1 = quoted_length1;
						_vala_array_add15 (&quoted, &quoted_length1, &_quoted_size_, (guint8) '^');
						_tmp18_ = quoted;
						_tmp18__length1 = quoted_length1;
						_vala_array_add16 (&quoted, &quoted_length1, &_quoted_size_, (guint8) '`');
					} else {
						guint8* _tmp19_ = NULL;
						gint _tmp19__length1 = 0;
						guint8* _tmp20_ = NULL;
						gint _tmp20__length1 = 0;
						gint _tmp21_ = 0;
						guint8 _tmp22_ = 0U;
						_tmp19_ = quoted;
						_tmp19__length1 = quoted_length1;
						_tmp20_ = data;
						_tmp20__length1 = data_length1;
						_tmp21_ = i;
						_tmp22_ = _tmp20_[_tmp21_];
						_vala_array_add17 (&quoted, &quoted_length1, &_quoted_size_, _tmp22_);
					}
				}
			}
		}
	}
	_tmp23_ = quoted;
	_tmp23__length1 = quoted_length1;
	_vala_array_add18 (&quoted, &quoted_length1, &_quoted_size_, (guint8) 0);
	_tmp24_ = quoted;
	_tmp24__length1 = quoted_length1;
	_tmp25_ = g_strdup ((const gchar*) _tmp24_);
	result = _tmp25_;
	quoted = (g_free (quoted), NULL);
	return result;
}


static guint umockdev_script_runner_hamming (guint8* d1, int d1_length1, guint8* d2, int d2_length1) {
	guint result = 0U;
	guint8* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	guint8* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	guint d = 0U;
	guint i = 0U;
	_tmp0_ = d1;
	_tmp0__length1 = d1_length1;
	_tmp1_ = d2;
	_tmp1__length1 = d2_length1;
	_vala_assert (_tmp0__length1 == _tmp1__length1, "d1.length == d2.length");
	d = (guint) 0;
	{
		gboolean _tmp2_ = FALSE;
		i = (guint) 0;
		_tmp2_ = TRUE;
		while (TRUE) {
			gboolean _tmp3_ = FALSE;
			guint _tmp5_ = 0U;
			guint8* _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			guint _tmp7_ = 0U;
			guint8* _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			guint _tmp9_ = 0U;
			guint8 _tmp10_ = 0U;
			guint8* _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
			guint _tmp12_ = 0U;
			guint8 _tmp13_ = 0U;
			_tmp3_ = _tmp2_;
			if (!_tmp3_) {
				guint _tmp4_ = 0U;
				_tmp4_ = i;
				i = _tmp4_ + 1;
			}
			_tmp2_ = FALSE;
			_tmp5_ = i;
			_tmp6_ = d1;
			_tmp6__length1 = d1_length1;
			if (!(_tmp5_ < ((guint) _tmp6__length1))) {
				break;
			}
			_tmp7_ = d;
			_tmp8_ = d1;
			_tmp8__length1 = d1_length1;
			_tmp9_ = i;
			_tmp10_ = _tmp8_[_tmp9_];
			_tmp11_ = d2;
			_tmp11__length1 = d2_length1;
			_tmp12_ = i;
			_tmp13_ = _tmp11_[_tmp12_];
			d = _tmp7_ + ((guint) (((gint) (_tmp10_ ^ _tmp13_)) > 0));
		}
	}
	result = d;
	return result;
}


const gchar* umockdev_script_runner_get_device (UMockdevScriptRunner* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}


static void umockdev_script_runner_set_device (UMockdevScriptRunner* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_device);
	self->priv->_device = _tmp1_;
}


static void umockdev_value_script_runner_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void umockdev_value_script_runner_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		umockdev_script_runner_unref (value->data[0].v_pointer);
	}
}


static void umockdev_value_script_runner_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = umockdev_script_runner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer umockdev_value_script_runner_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* umockdev_value_script_runner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UMockdevScriptRunner* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = umockdev_script_runner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* umockdev_value_script_runner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UMockdevScriptRunner** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = umockdev_script_runner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* umockdev_param_spec_script_runner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UMockdevParamSpecScriptRunner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UMOCKDEV_TYPE_SCRIPT_RUNNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer umockdev_value_get_script_runner (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SCRIPT_RUNNER), NULL);
	return value->data[0].v_pointer;
}


void umockdev_value_set_script_runner (GValue* value, gpointer v_object) {
	UMockdevScriptRunner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SCRIPT_RUNNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SCRIPT_RUNNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		umockdev_script_runner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_script_runner_unref (old);
	}
}


void umockdev_value_take_script_runner (GValue* value, gpointer v_object) {
	UMockdevScriptRunner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SCRIPT_RUNNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SCRIPT_RUNNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_script_runner_unref (old);
	}
}


static void umockdev_script_runner_class_init (UMockdevScriptRunnerClass * klass) {
	umockdev_script_runner_parent_class = g_type_class_peek_parent (klass);
	UMOCKDEV_SCRIPT_RUNNER_CLASS (klass)->finalize = umockdev_script_runner_finalize;
	g_type_class_add_private (klass, sizeof (UMockdevScriptRunnerPrivate));
}


static void umockdev_script_runner_instance_init (UMockdevScriptRunner * self) {
	self->priv = UMOCKDEV_SCRIPT_RUNNER_GET_PRIVATE (self);
	self->priv->fuzz = (guint) 0;
	self->ref_count = 1;
}


static void umockdev_script_runner_finalize (UMockdevScriptRunner* obj) {
	UMockdevScriptRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunner);
	umockdev_script_runner_stop (self);
	_g_free0 (self->priv->_device);
	_g_free0 (self->priv->script_file);
	_g_thread_unref0 (self->priv->thread);
	_fclose0 (self->priv->script);
}


GType umockdev_script_runner_get_type (void) {
	static volatile gsize umockdev_script_runner_type_id__volatile = 0;
	if (g_once_init_enter (&umockdev_script_runner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { umockdev_value_script_runner_init, umockdev_value_script_runner_free_value, umockdev_value_script_runner_copy_value, umockdev_value_script_runner_peek_pointer, "p", umockdev_value_script_runner_collect_value, "p", umockdev_value_script_runner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UMockdevScriptRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_script_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevScriptRunner), 0, (GInstanceInitFunc) umockdev_script_runner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType umockdev_script_runner_type_id;
		umockdev_script_runner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UMockdevScriptRunner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&umockdev_script_runner_type_id__volatile, umockdev_script_runner_type_id);
	}
	return umockdev_script_runner_type_id__volatile;
}


gpointer umockdev_script_runner_ref (gpointer instance) {
	UMockdevScriptRunner* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void umockdev_script_runner_unref (gpointer instance) {
	UMockdevScriptRunner* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UMOCKDEV_SCRIPT_RUNNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _umockdev_socket_server_run_gthread_func (gpointer self) {
	gpointer result;
	result = umockdev_socket_server_run (self);
	umockdev_socket_server_unref (self);
	return result;
}


UMockdevSocketServer* umockdev_socket_server_construct (GType object_type) {
	UMockdevSocketServer* self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GHashFunc _tmp3_ = NULL;
	GEqualFunc _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GThread* _tmp6_ = NULL;
	gint* fds = NULL;
	gint* _tmp7_ = NULL;
	gint fds_length1 = 0;
	gint _fds_size_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	self = (UMockdevSocketServer*) g_type_create_instance (object_type);
	self->priv->running = TRUE;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->socket_scriptfile);
	self->priv->socket_scriptfile = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _umockdev_script_runner_unref0_);
	_g_hash_table_unref0 (self->priv->script_runners);
	self->priv->script_runners = _tmp5_;
	_tmp6_ = g_thread_new ("SocketServer", _umockdev_socket_server_run_gthread_func, umockdev_socket_server_ref (self));
	_g_thread_unref0 (self->priv->thread);
	self->priv->thread = _tmp6_;
	_tmp7_ = g_new0 (gint, 2);
	fds = _tmp7_;
	fds_length1 = 2;
	_fds_size_ = fds_length1;
	_tmp8_ = pipe (fds);
	_vala_assert (_tmp8_ == 0, "Posix.pipe (fds) == 0");
	_tmp9_ = fds[0];
	self->priv->ctrl_r = _tmp9_;
	_tmp10_ = fds[1];
	self->priv->ctrl_w = _tmp10_;
	fds = (g_free (fds), NULL);
	return self;
}


UMockdevSocketServer* umockdev_socket_server_new (void) {
	return umockdev_socket_server_construct (UMOCKDEV_TYPE_SOCKET_SERVER);
}


void umockdev_socket_server_stop (UMockdevSocketServer* self) {
	gboolean _tmp0_ = FALSE;
	gchar b = '\0';
	gint _tmp1_ = 0;
	gssize _tmp2_ = 0L;
	GHashTable* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GHashTable* _tmp6_ = NULL;
	GThread* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->running;
	if (!_tmp0_) {
		return;
	}
	self->priv->running = FALSE;
	g_debug ("umockdev.vala:1520: Stopping SocketServer: signalling thread");
	b = '1';
	_tmp1_ = self->priv->ctrl_w;
	_tmp2_ = write (_tmp1_, &b, (gsize) 1);
	_vala_assert (_tmp2_ == ((gssize) 1), "Posix.write (this.ctrl_w, &b, 1) == 1");
	_tmp3_ = self->priv->script_runners;
	_tmp4_ = g_hash_table_get_values (_tmp3_);
	{
		GList* r_collection = NULL;
		GList* r_it = NULL;
		r_collection = _tmp4_;
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
			UMockdevScriptRunner* r = NULL;
			r = (UMockdevScriptRunner*) r_it->data;
			{
				UMockdevScriptRunner* _tmp5_ = NULL;
				_tmp5_ = r;
				umockdev_script_runner_stop (_tmp5_);
			}
		}
		_g_list_free0 (r_collection);
	}
	_tmp6_ = self->priv->script_runners;
	g_hash_table_remove_all (_tmp6_);
	g_debug ("umockdev.vala:1529: Stopping SocketServer: joining thread");
	_tmp7_ = self->priv->thread;
	g_thread_join (_tmp7_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add19 (GSocket*** array, int* length, int* size, GSocket* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GSocket*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void umockdev_socket_server_add (UMockdevSocketServer* self, const gchar* sock_path, gint fd, const gchar* record_file) {
	const gchar* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	GHashTable* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar b = '\0';
	gint _tmp24_ = 0;
	gssize _tmp25_ = 0L;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sock_path != NULL);
	g_return_if_fail (record_file != NULL);
	{
		GSocket* s = NULL;
		gint _tmp0_ = 0;
		GSocket* _tmp1_ = NULL;
		GSocket* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GSocket* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GUnixSocketAddress* _tmp6_ = NULL;
		GUnixSocketAddress* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		GSocket* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		GSocket** _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		GSocket* _tmp14_ = NULL;
		GSocket* _tmp15_ = NULL;
		_tmp0_ = fd;
		_tmp1_ = g_socket_new_from_fd (_tmp0_, &_inner_error_);
		s = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		_tmp2_ = s;
		_vala_assert (_tmp2_ != NULL, "s != null");
		_tmp4_ = s;
		_tmp5_ = sock_path;
		_tmp6_ = (GUnixSocketAddress*) g_unix_socket_address_new (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_socket_bind (_tmp4_, (GSocketAddress*) _tmp7_, TRUE, &_inner_error_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_tmp3_ = _tmp9_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (s);
			goto __catch11_g_error;
		}
		_vala_assert (_tmp3_, "s.bind (new UnixSocketAddress (sock_path), true)");
		_tmp11_ = s;
		_tmp12_ = g_socket_listen (_tmp11_, &_inner_error_);
		_tmp10_ = _tmp12_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (s);
			goto __catch11_g_error;
		}
		_vala_assert (_tmp10_, "s.listen ()");
		_tmp13_ = self->priv->listen_sockets;
		_tmp13__length1 = self->priv->listen_sockets_length1;
		_tmp14_ = s;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_vala_array_add19 (&self->priv->listen_sockets, &self->priv->listen_sockets_length1, &self->priv->_listen_sockets_size_, _tmp15_);
		_g_object_unref0 (s);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e->message;
		g_error ("umockdev.vala:1542: load_socket_script(): cannot create Socket: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp17_ = sock_path;
	_tmp18_ = fd;
	g_debug ("umockdev.vala:1545: SocketServer.add: Created socket path %s, fd %i", _tmp17_, _tmp18_);
	_tmp19_ = self->priv->socket_scriptfile;
	_tmp20_ = sock_path;
	_tmp21_ = g_strdup (_tmp20_);
	_tmp22_ = record_file;
	_tmp23_ = g_strdup (_tmp22_);
	g_hash_table_insert (_tmp19_, _tmp21_, _tmp23_);
	b = '1';
	_tmp24_ = self->priv->ctrl_w;
	_tmp25_ = write (_tmp24_, &b, (gsize) 1);
	_vala_assert (_tmp25_ == ((gssize) 1), "Posix.write (this.ctrl_w, &b, 1) == 1");
}


static void* umockdev_socket_server_run (UMockdevSocketServer* self) {
	void* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_debug ("umockdev.vala:1556: starting SocketServer thread");
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		fd_set fds = {0};
		fd_set _tmp1_ = {0};
		gint _tmp2_ = 0;
		gint max = 0;
		gint _tmp3_ = 0;
		GSocket** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gint res = 0;
		gint _tmp15_ = 0;
		struct timeval _tmp16_ = {0};
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		fd_set _tmp24_ = {0};
		gint _tmp25_ = 0;
		GSocket** _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		_tmp0_ = self->priv->running;
		if (!_tmp0_) {
			break;
		}
		FD_ZERO (&_tmp1_);
		fds = _tmp1_;
		_tmp2_ = self->priv->ctrl_r;
		FD_SET (_tmp2_, &fds);
		_tmp3_ = self->priv->ctrl_r;
		max = _tmp3_;
		_tmp4_ = self->priv->listen_sockets;
		_tmp4__length1 = self->priv->listen_sockets_length1;
		{
			GSocket** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp4_;
			s_collection_length1 = _tmp4__length1;
			for (s_it = 0; s_it < _tmp4__length1; s_it = s_it + 1) {
				GSocket* s = NULL;
				s = s_collection[s_it];
				{
					GSocket* _tmp5_ = NULL;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					GSocket* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					_tmp5_ = s;
					_tmp6_ = g_socket_get_fd (_tmp5_);
					_tmp7_ = _tmp6_;
					FD_SET (_tmp7_, &fds);
					_tmp8_ = s;
					_tmp9_ = g_socket_get_fd (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = max;
					if (_tmp10_ > _tmp11_) {
						GSocket* _tmp12_ = NULL;
						gint _tmp13_ = 0;
						gint _tmp14_ = 0;
						_tmp12_ = s;
						_tmp13_ = g_socket_get_fd (_tmp12_);
						_tmp14_ = _tmp13_;
						max = _tmp14_;
					}
				}
			}
		}
		_tmp15_ = max;
		_tmp16_.tv_sec = (time_t) 0;
		_tmp16_.tv_usec = (glong) 500000;
		_tmp17_ = select (_tmp15_ + 1, &fds, NULL, NULL, &_tmp16_);
		res = _tmp17_;
		_tmp18_ = res;
		if (_tmp18_ < 0) {
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			const gchar* _tmp21_ = NULL;
			_tmp19_ = errno;
			if (_tmp19_ == EINTR) {
				continue;
			}
			_tmp20_ = errno;
			_tmp21_ = g_strerror (_tmp20_);
			g_error ("umockdev.vala:1575: socket server thread: select() failed: %s", _tmp21_);
		}
		_tmp22_ = res;
		if (_tmp22_ == 0) {
			continue;
		}
		_tmp23_ = self->priv->ctrl_r;
		_tmp24_ = fds;
		_tmp25_ = FD_ISSET (_tmp23_, &_tmp24_);
		if (_tmp25_ > 0) {
			gchar buf = '\0';
			gint _tmp26_ = 0;
			gssize _tmp27_ = 0L;
			g_debug ("umockdev.vala:1582: socket server thread: woken up by control fd");
			_tmp26_ = self->priv->ctrl_r;
			_tmp27_ = read (_tmp26_, &buf, (gsize) 1);
			_vala_assert (_tmp27_ == ((gssize) 1), "Posix.read (this.ctrl_r, &buf, 1) == 1");
			continue;
		}
		g_debug ("umockdev.vala:1588: socket server thread: select() got requests");
		_tmp28_ = self->priv->listen_sockets;
		_tmp28__length1 = self->priv->listen_sockets_length1;
		{
			GSocket** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp28_;
			s_collection_length1 = _tmp28__length1;
			for (s_it = 0; s_it < _tmp28__length1; s_it = s_it + 1) {
				GSocket* s = NULL;
				s = s_collection[s_it];
				{
					GSocket* _tmp29_ = NULL;
					gint _tmp30_ = 0;
					gint _tmp31_ = 0;
					fd_set _tmp32_ = {0};
					gint _tmp33_ = 0;
					_tmp29_ = s;
					_tmp30_ = g_socket_get_fd (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = fds;
					_tmp33_ = FD_ISSET (_tmp31_, &_tmp32_);
					if (_tmp33_ > 0) {
						gint fd = 0;
						GSocket* _tmp34_ = NULL;
						gint _tmp35_ = 0;
						gint _tmp36_ = 0;
						gint _tmp37_ = 0;
						gint _tmp38_ = 0;
						gchar* sock_path = NULL;
						_tmp34_ = s;
						_tmp35_ = g_socket_get_fd (_tmp34_);
						_tmp36_ = _tmp35_;
						_tmp37_ = accept (_tmp36_, NULL, NULL);
						fd = _tmp37_;
						_tmp38_ = fd;
						if (_tmp38_ < 0) {
							gint _tmp39_ = 0;
							const gchar* _tmp40_ = NULL;
							_tmp39_ = errno;
							_tmp40_ = g_strerror (_tmp39_);
							g_error ("umockdev.vala:1595: socket server thread: accept() failed: %s", _tmp40_);
						}
						sock_path = NULL;
						{
							GSocketAddress* _tmp41_ = NULL;
							GSocket* _tmp42_ = NULL;
							GSocketAddress* _tmp43_ = NULL;
							GUnixSocketAddress* _tmp44_ = NULL;
							const gchar* _tmp45_ = NULL;
							const gchar* _tmp46_ = NULL;
							gchar* _tmp47_ = NULL;
							gchar* script = NULL;
							GHashTable* _tmp48_ = NULL;
							const gchar* _tmp49_ = NULL;
							gconstpointer _tmp50_ = NULL;
							gchar* _tmp51_ = NULL;
							GSocket* _tmp52_ = NULL;
							gint _tmp53_ = 0;
							gint _tmp54_ = 0;
							const gchar* _tmp55_ = NULL;
							const gchar* _tmp56_ = NULL;
							gchar* key = NULL;
							const gchar* _tmp57_ = NULL;
							gint _tmp58_ = 0;
							gchar* _tmp59_ = NULL;
							UMockdevScriptRunner* _tmp60_ = NULL;
							const gchar* _tmp61_ = NULL;
							const gchar* _tmp62_ = NULL;
							gint _tmp63_ = 0;
							UMockdevScriptRunner* _tmp64_ = NULL;
							GHashTable* _tmp65_ = NULL;
							const gchar* _tmp66_ = NULL;
							gchar* _tmp67_ = NULL;
							_tmp42_ = s;
							_tmp43_ = g_socket_get_local_address (_tmp42_, &_inner_error_);
							_tmp41_ = _tmp43_;
							if (_inner_error_ != NULL) {
								goto __catch12_g_error;
							}
							_tmp44_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, G_TYPE_UNIX_SOCKET_ADDRESS, GUnixSocketAddress);
							_tmp45_ = g_unix_socket_address_get_path (_tmp44_);
							_tmp46_ = _tmp45_;
							_tmp47_ = g_strdup (_tmp46_);
							_g_free0 (sock_path);
							sock_path = _tmp47_;
							_g_object_unref0 (_tmp44_);
							_tmp48_ = self->priv->socket_scriptfile;
							_tmp49_ = sock_path;
							_tmp50_ = g_hash_table_lookup (_tmp48_, _tmp49_);
							_tmp51_ = g_strdup ((const gchar*) _tmp50_);
							script = _tmp51_;
							_tmp52_ = s;
							_tmp53_ = g_socket_get_fd (_tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = sock_path;
							_tmp56_ = script;
							g_debug ("umockdev.vala:1600: socket server thread: accepted request on server s" \
"ocket fd %i, path %s, script %s", _tmp54_, _tmp55_, _tmp56_);
							_tmp57_ = sock_path;
							_tmp58_ = fd;
							_tmp59_ = g_strdup_printf ("%s%i", _tmp57_, _tmp58_);
							key = _tmp59_;
							_tmp61_ = key;
							_tmp62_ = script;
							_tmp63_ = fd;
							_tmp64_ = umockdev_script_runner_new (_tmp61_, _tmp62_, _tmp63_, &_inner_error_);
							_tmp60_ = _tmp64_;
							if (_inner_error_ != NULL) {
								_g_free0 (key);
								_g_free0 (script);
								goto __catch12_g_error;
							}
							_tmp65_ = self->priv->script_runners;
							_tmp66_ = key;
							_tmp67_ = g_strdup (_tmp66_);
							g_hash_table_insert (_tmp65_, _tmp67_, _tmp60_);
							_g_free0 (key);
							_g_free0 (script);
						}
						goto __finally12;
						__catch12_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp68_ = NULL;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp68_ = e->message;
							g_error ("umockdev.vala:1605: socket server thread: cannot launch ScriptRunner: " \
"%s", _tmp68_);
							_g_error_free0 (e);
						}
						__finally12:
						if (_inner_error_ != NULL) {
							_g_free0 (sock_path);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_g_free0 (sock_path);
					}
				}
			}
		}
	}
	g_debug ("umockdev.vala:1611: socket server thread: end");
	result = NULL;
	return result;
}


static void umockdev_value_socket_server_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void umockdev_value_socket_server_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		umockdev_socket_server_unref (value->data[0].v_pointer);
	}
}


static void umockdev_value_socket_server_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = umockdev_socket_server_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer umockdev_value_socket_server_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* umockdev_value_socket_server_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UMockdevSocketServer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = umockdev_socket_server_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* umockdev_value_socket_server_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UMockdevSocketServer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = umockdev_socket_server_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* umockdev_param_spec_socket_server (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UMockdevParamSpecSocketServer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UMOCKDEV_TYPE_SOCKET_SERVER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer umockdev_value_get_socket_server (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SOCKET_SERVER), NULL);
	return value->data[0].v_pointer;
}


void umockdev_value_set_socket_server (GValue* value, gpointer v_object) {
	UMockdevSocketServer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SOCKET_SERVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SOCKET_SERVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		umockdev_socket_server_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_socket_server_unref (old);
	}
}


void umockdev_value_take_socket_server (GValue* value, gpointer v_object) {
	UMockdevSocketServer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SOCKET_SERVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SOCKET_SERVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_socket_server_unref (old);
	}
}


static void umockdev_socket_server_class_init (UMockdevSocketServerClass * klass) {
	umockdev_socket_server_parent_class = g_type_class_peek_parent (klass);
	UMOCKDEV_SOCKET_SERVER_CLASS (klass)->finalize = umockdev_socket_server_finalize;
	g_type_class_add_private (klass, sizeof (UMockdevSocketServerPrivate));
}


static void umockdev_socket_server_instance_init (UMockdevSocketServer * self) {
	GSocket** _tmp0_ = NULL;
	self->priv = UMOCKDEV_SOCKET_SERVER_GET_PRIVATE (self);
	_tmp0_ = g_new0 (GSocket*, 0 + 1);
	self->priv->listen_sockets = _tmp0_;
	self->priv->listen_sockets_length1 = 0;
	self->priv->_listen_sockets_size_ = self->priv->listen_sockets_length1;
	self->ref_count = 1;
}


static void umockdev_socket_server_finalize (UMockdevSocketServer* obj) {
	UMockdevSocketServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServer);
	umockdev_socket_server_stop (self);
	self->priv->listen_sockets = (_vala_array_free (self->priv->listen_sockets, self->priv->listen_sockets_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (self->priv->socket_scriptfile);
	_g_hash_table_unref0 (self->priv->script_runners);
	_g_thread_unref0 (self->priv->thread);
}


GType umockdev_socket_server_get_type (void) {
	static volatile gsize umockdev_socket_server_type_id__volatile = 0;
	if (g_once_init_enter (&umockdev_socket_server_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { umockdev_value_socket_server_init, umockdev_value_socket_server_free_value, umockdev_value_socket_server_copy_value, umockdev_value_socket_server_peek_pointer, "p", umockdev_value_socket_server_collect_value, "p", umockdev_value_socket_server_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UMockdevSocketServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_socket_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevSocketServer), 0, (GInstanceInitFunc) umockdev_socket_server_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType umockdev_socket_server_type_id;
		umockdev_socket_server_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UMockdevSocketServer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&umockdev_socket_server_type_id__volatile, umockdev_socket_server_type_id);
	}
	return umockdev_socket_server_type_id__volatile;
}


gpointer umockdev_socket_server_ref (gpointer instance) {
	UMockdevSocketServer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void umockdev_socket_server_unref (gpointer instance) {
	UMockdevSocketServer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UMOCKDEV_SOCKET_SERVER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


/**
 * umockdev_in_mock_environment:
 *
 * Check whether the current process is running under umockdev-wrapper, i. e.
 * the umockdev preload library.
 *
 * Returns: %TRUE if running under preload with mocked devices, %FALSE if
 *          running against the real system.
 */
gboolean umockdev_in_mock_environment (void) {
	gboolean result = FALSE;
	gchar* preload = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	_tmp0_ = g_getenv ("LD_PRELOAD");
	_tmp1_ = g_strdup (_tmp0_);
	preload = _tmp1_;
	_tmp2_ = preload;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_free0 (preload);
		return result;
	}
	_tmp3_ = preload;
	_tmp4_ = string_contains (_tmp3_, "libumockdev-preload");
	result = _tmp4_;
	_g_free0 (preload);
	return result;
}


GQuark umockdev_error_quark (void) {
	return g_quark_from_static_string ("umockdev_error-quark");
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



