/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (unshar-opts.c)
 *
 *  It has been AutoGen-ed  October 18, 2013 at 02:02:22 PM by AutoGen 5.18.2
 *  From the definitions    unshar-opts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 40:1:15 templates.
 *
 *  AutoOpts is a copyrighted work.  This source file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the unshar author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 *
 * The unshar program is copyrighted and licensed
 * under the following terms:
 *
 *  Copyright (C) 1994-2013 Free Software Foundation, Inc., all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 *  unshar is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  unshar is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __doxygen__
#define OPTION_CODE_COMPILE 1
#include "unshar-opts.h"
#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifdef  __cplusplus
extern "C" {
#endif
extern FILE * option_usage_fp;
#define zCopyright      (unshar_opt_strs+0)
#define zLicenseDescrip (unshar_opt_strs+290)

/*
 *  global included definitions
 */
size_t separator_str_len = 6;

extern void init_unshar (void);

char const * const program_name = "unshar";

#ifndef NULL
#  define NULL 0
#endif

/**
 *  static const strings for unshar options
 */
static char const unshar_opt_strs[3901] =
/*     0 */ "unshar (GNU sharutils) 4.14\n"
            "Copyright (C) 1994-2013 Free Software Foundation, Inc., all rights reserved.\n"
            "This is free software. It is licensed for use, modification and\n"
            "redistribution under the terms of the GNU General Public License,\n"
            "version 3 or later <http://gnu.org/licenses/gpl.html>\n\0"
/*   290 */ "unshar is free software: you can redistribute it and/or modify it under the\n"
            "terms of the GNU General Public License as published by the Free Software\n"
            "Foundation, either version 3 of the License, or (at your option) any later\n"
            "version.\n\n"
            "unshar is distributed in the hope that it will be useful, but WITHOUT ANY\n"
            "WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n"
            "FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more\n"
            "details.\n\n"
            "You should have received a copy of the GNU General Public License along\n"
            "with this program.  If not, see <http://www.gnu.org/licenses/>.\n\0"
/*   891 */ "unpack into the directory dir\0"
/*   921 */ "DIRECTORY\0"
/*   931 */ "directory\0"
/*   941 */ "overwrite any pre-existing files\0"
/*   974 */ "OVERWRITE\0"
/*   984 */ "overwrite\0"
/*   994 */ "an alias for the 'overwrite' option\0"
/*  1030 */ "force\0"
/*  1036 */ "split input on split-mark lines\0"
/*  1068 */ "SPLIT_AT\0"
/*  1077 */ "split-at\0"
/*  1086 */ "exit 0\0"
/*  1093 */ "split input on \"exit 0\" lines\0"
/*  1123 */ "EXIT_0\0"
/*  1130 */ "exit-0\0"
/*  1137 */ "debug the shell code\0"
/*  1158 */ "DEBUG\0"
/*  1164 */ "debug\0"
/*  1170 */ "display extended usage information and exit\0"
/*  1214 */ "help\0"
/*  1219 */ "extended usage information passed thru pager\0"
/*  1264 */ "more-help\0"
/*  1274 */ "output version information and exit\0"
/*  1310 */ "version\0"
/*  1318 */ "save the option state to a config file\0"
/*  1357 */ "save-opts\0"
/*  1367 */ "load options from a config file\0"
/*  1399 */ "LOAD_OPTS\0"
/*  1409 */ "no-load-opts\0"
/*  1422 */ "no\0"
/*  1425 */ "UNSHAR\0"
/*  1432 */ "unshar (GNU sharutils) - unpack a shar archive\n"
            "Usage:  %s [ -<flag> [<val>] | --<name>[{=| }<val>] ]... [<file>...]\n\0"
/*  1549 */ "$HOME\0"
/*  1555 */ ".sharrc\0"
/*  1563 */ "bug-gnu-utils@gnu.org\0"
/*  1585 */ "\n"
            "If no arguments are provided, input arguments are read from stdin,\n"
            "one per line; blank and '#'-prefixed lines are comments.\n"
            "'stdin' may not be a terminal (tty).\n\0"
/*  1748 */ "Unshar scans the input files (typically email messages) looking for the\n"
            "start of a shell archive.  If no files are given, then standard input is\n"
            "processed instead.  It then passes each archive discovered through an\n"
            "invocation of the shell program to unpack it.\n\0"
/*  2010 */ "unshar (GNU sharutils) 4.14\0"
/*  2038 */ "unshar (GNU sharutils) - unpack a shar archive\n"
            "Usage:  unshar [ -<flag> [<val>] | --<name>[{=| }<val>] ]... [<file>...]\n\n"
            "   -d, --directory=DIR        unpack into the directory DIR\n"
            "   -c, --overwrite            overwrite any pre-existing files\n"
            "   -f, --force                an alias for the 'overwrite' option\n"
            "   -E, --split-at=SPLIT-PAT   split input on SPLIT-PAT lines\n"
            "   -e, --exit-0               split input on \"exit 0\" lines\n"
            "                                - prohibits the option 'split-at'\n"
            "   -D, --debug                debug the shell code\n"
            "   -v, --version[=MODE]       output version information and exit\n"
            "   -h, --help                 display extended usage information and exit\n"
            "   -!, --more-help            extended usage information passed thru pager\n"
            "   -R, --save-opts[=FILE]     save the option state to the config file FILE\n"
            "   -r, --load-opts=FILE       load options from the config file FILE\n"
            "                                - disabled as '--no-load-opts'\n"
            "                                - may appear multiple times\n\n"
            "Options are specified by doubled hyphens and their name or by a single\n"
            "hyphen and the flag character.\n\n"
            "If no arguments are provided, input arguments are read from stdin,\n"
            "one per line; blank and '#'-prefixed lines are comments.\n"
            "'stdin' may not be a terminal (tty).\n\n"
            "The following option preset mechanisms are supported:\n"
            " - reading file $HOME/.sharrc\n\n"
            "'unshar' scans the input files (typically email messages) looking for the\n"
            "start of a shell archive.  If no files are given, then standard input is\n"
            "processed instead.  It then passes each archive discovered through an\n"
            "invocation of the shell program to unpack it.\n\n"
            "Please send bug reports to:  <bug-gnu-utils@gnu.org>\n\0"
/*  3738 */ "unshar (GNU sharutils) - unpack a shar archive\n"
            "Usage:  unshar [ -<flag> [<val>] | --<name>[{=| }<val>] ]... [<file>...]\n"
            "Try 'unshar --help' for more information.\n";

/**
 *  directory option description:
 */
/** Descriptive text for the directory option */
#define DIRECTORY_DESC      (unshar_opt_strs+891)
/** Upper-cased name for the directory option */
#define DIRECTORY_NAME      (unshar_opt_strs+921)
/** Name string for the directory option */
#define DIRECTORY_name      (unshar_opt_strs+931)
/** Compiled in flag settings for the directory option */
#define DIRECTORY_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  overwrite option description:
 */
/** Descriptive text for the overwrite option */
#define OVERWRITE_DESC      (unshar_opt_strs+941)
/** Upper-cased name for the overwrite option */
#define OVERWRITE_NAME      (unshar_opt_strs+974)
/** Name string for the overwrite option */
#define OVERWRITE_name      (unshar_opt_strs+984)
/** Compiled in flag settings for the overwrite option */
#define OVERWRITE_FLAGS     (OPTST_DISABLED)

/**
 *  force option description:
 */
/** Descriptive text for the force option */
#define FORCE_DESC    (unshar_opt_strs+994)
#define FORCE_NAME    NULL
/** Unmodified name string for the force option */
#define FORCE_name    (unshar_opt_strs+1030)
/** Compiled in flag settings for the force option */
#define FORCE_FLAGS     (OVERWRITE_FLAGS | OPTST_ALIAS)

/**
 *  split-at option description:
 */
/** Descriptive text for the split-at option */
#define SPLIT_AT_DESC      (unshar_opt_strs+1036)
/** Upper-cased name for the split-at option */
#define SPLIT_AT_NAME      (unshar_opt_strs+1068)
/** Name string for the split-at option */
#define SPLIT_AT_name      (unshar_opt_strs+1077)
/** The compiled in default value for the split-at option argument */
#define SPLIT_AT_DFT_ARG   (unshar_opt_strs+1086)
/** Compiled in flag settings for the split-at option */
#define SPLIT_AT_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  exit-0 option description with
 *  "Must also have options" and "Incompatible options":
 */
/** Descriptive text for the exit-0 option */
#define EXIT_0_DESC      (unshar_opt_strs+1093)
/** Upper-cased name for the exit-0 option */
#define EXIT_0_NAME      (unshar_opt_strs+1123)
/** Name string for the exit-0 option */
#define EXIT_0_name      (unshar_opt_strs+1130)
/** Other options that appear in conjunction with the exit-0 option */
static int const aExit_0CantList[] = {
    INDEX_OPT_SPLIT_AT, NO_EQUIVALENT };
/** Compiled in flag settings for the exit-0 option */
#define EXIT_0_FLAGS     (OPTST_DISABLED)

/**
 *  debug option description:
 */
/** Descriptive text for the debug option */
#define DEBUG_DESC      (unshar_opt_strs+1137)
/** Upper-cased name for the debug option */
#define DEBUG_NAME      (unshar_opt_strs+1158)
/** Name string for the debug option */
#define DEBUG_name      (unshar_opt_strs+1164)
/** Compiled in flag settings for the debug option */
#define DEBUG_FLAGS     (OPTST_DISABLED)

/*
 *  Help/More_Help/Version option descriptions:
 */
#define HELP_DESC       (unshar_opt_strs+1170)
#define HELP_name       (unshar_opt_strs+1214)
#ifdef HAVE_WORKING_FORK
#define MORE_HELP_DESC  (unshar_opt_strs+1219)
#define MORE_HELP_name  (unshar_opt_strs+1264)
#define MORE_HELP_FLAGS (OPTST_IMM | OPTST_NO_INIT)
#else
#define MORE_HELP_DESC  HELP_DESC
#define MORE_HELP_name  HELP_name
#define MORE_HELP_FLAGS (OPTST_OMITTED | OPTST_NO_INIT)
#endif
#ifdef NO_OPTIONAL_OPT_ARGS
#  define VER_FLAGS     (OPTST_IMM | OPTST_NO_INIT)
#else
#  define VER_FLAGS     (OPTST_SET_ARGTYPE(OPARG_TYPE_STRING) | \
                         OPTST_ARG_OPTIONAL | OPTST_IMM | OPTST_NO_INIT)
#endif
#define VER_DESC        (unshar_opt_strs+1274)
#define VER_name        (unshar_opt_strs+1310)
#define SAVE_OPTS_DESC  (unshar_opt_strs+1318)
#define SAVE_OPTS_name  (unshar_opt_strs+1357)
#define LOAD_OPTS_DESC     (unshar_opt_strs+1367)
#define LOAD_OPTS_NAME     (unshar_opt_strs+1399)
#define NO_LOAD_OPTS_name  (unshar_opt_strs+1409)
#define LOAD_OPTS_pfx      (unshar_opt_strs+1422)
#define LOAD_OPTS_name     (NO_LOAD_OPTS_name + 3)
/**
 *  Declare option callback procedures
 */
extern tOptProc
    optionBooleanVal,   optionNestedVal,    optionNumericVal,
    optionPagedUsage,   optionPrintVersion, optionResetOpt,
    optionStackArg,     optionTimeDate,     optionTimeVal,
    optionUnstackArg,   optionVendorOption;
static tOptProc
    doOptExit_0, doOptForce, doOptSplit_At, doUsageOpt;
#define VER_PROC        optionPrintVersion

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Define the unshar Option Descriptions.
 * This is an array of OPTION_CT entries, one for each
 * option that the unshar program responds to.
 */
static tOptDesc optDesc[OPTION_CT] = {
  {  /* entry idx, value */ 0, VALUE_OPT_DIRECTORY,
     /* equiv idx, value */ 0, VALUE_OPT_DIRECTORY,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DIRECTORY_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --directory */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ DIRECTORY_DESC, DIRECTORY_NAME, DIRECTORY_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 1, VALUE_OPT_OVERWRITE,
     /* equiv idx, value */ 1, VALUE_OPT_OVERWRITE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OVERWRITE_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --overwrite */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ OVERWRITE_DESC, OVERWRITE_NAME, OVERWRITE_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 2, VALUE_OPT_FORCE,
     /* equiv idx, value */ 2, VALUE_OPT_FORCE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ FORCE_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --force */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptForce,
     /* desc, NAME, name */ FORCE_DESC, FORCE_NAME, FORCE_name,
     /* disablement strs */ 0, 0 },

  {  /* entry idx, value */ 3, VALUE_OPT_SPLIT_AT,
     /* equiv idx, value */ 3, VALUE_OPT_SPLIT_AT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ SPLIT_AT_FLAGS, 0,
     /* last opt argumnt */ { SPLIT_AT_DFT_ARG },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptSplit_At,
     /* desc, NAME, name */ SPLIT_AT_DESC, SPLIT_AT_NAME, SPLIT_AT_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 4, VALUE_OPT_EXIT_0,
     /* equiv idx, value */ 4, VALUE_OPT_EXIT_0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ EXIT_0_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --exit-0 */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aExit_0CantList,
     /* option proc      */ doOptExit_0,
     /* desc, NAME, name */ EXIT_0_DESC, EXIT_0_NAME, EXIT_0_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 5, VALUE_OPT_DEBUG,
     /* equiv idx, value */ 5, VALUE_OPT_DEBUG,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DEBUG_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --debug */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ DEBUG_DESC, DEBUG_NAME, DEBUG_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_VERSION, VALUE_OPT_VERSION,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_VERSION,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VER_FLAGS, AOUSE_VERSION,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ VER_PROC,
     /* desc, NAME, name */ VER_DESC, NULL, VER_name,
     /* disablement strs */ NULL, NULL },



  {  /* entry idx, value */ INDEX_OPT_HELP, VALUE_OPT_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM | OPTST_NO_INIT, AOUSE_HELP,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doUsageOpt,
     /* desc, NAME, name */ HELP_DESC, NULL, HELP_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_MORE_HELP, VALUE_OPT_MORE_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_MORE_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ MORE_HELP_FLAGS, AOUSE_MORE_HELP,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ optionPagedUsage,
     /* desc, NAME, name */ MORE_HELP_DESC, NULL, MORE_HELP_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_SAVE_OPTS, VALUE_OPT_SAVE_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_SAVE_OPTS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_SET_ARGTYPE(OPARG_TYPE_STRING)
                       | OPTST_ARG_OPTIONAL | OPTST_NO_INIT, AOUSE_SAVE_OPTS,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ SAVE_OPTS_DESC, NULL, SAVE_OPTS_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_LOAD_OPTS, VALUE_OPT_LOAD_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_LOAD_OPTS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, NOLIMIT, 0,
     /* opt state flags  */ OPTST_SET_ARGTYPE(OPARG_TYPE_STRING)
			  | OPTST_DISABLE_IMM, AOUSE_LOAD_OPTS,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionLoadOpt,
     /* desc, NAME, name */ LOAD_OPTS_DESC, LOAD_OPTS_NAME, LOAD_OPTS_name,
     /* disablement strs */ NO_LOAD_OPTS_name, LOAD_OPTS_pfx }
};


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/** Reference to the upper cased version of unshar. */
#define zPROGNAME       (unshar_opt_strs+1425)
/** Reference to the title line for unshar usage. */
#define zUsageTitle     (unshar_opt_strs+1432)
/** unshar configuration file name. */
#define zRcName         (unshar_opt_strs+1555)
/** Directories to search for unshar config files. */
static char const * const apzHomeList[2] = {
    unshar_opt_strs+1549,
    NULL };
/** The unshar program bug email address. */
#define zBugsAddr       (unshar_opt_strs+1563)
/** Clarification/explanation of what unshar does. */
#define zExplain        (unshar_opt_strs+1585)
/** Extra detail explaining what unshar does. */
#define zDetail         (unshar_opt_strs+1748)
/** The full version string for unshar. */
#define zFullVersion    (unshar_opt_strs+2010)
/* extracted from optcode.tlib near line 364 */

#if defined(ENABLE_NLS)
# define OPTPROC_BASE OPTPROC_TRANSLATE
  static tOptionXlateProc translate_option_strings;
#else
# define OPTPROC_BASE OPTPROC_NONE
# define translate_option_strings NULL
#endif /* ENABLE_NLS */

#define unshar_full_usage (unshar_opt_strs+2038)
#define unshar_short_usage (unshar_opt_strs+3738)

#endif /* not defined __doxygen__ */

/*
 *  Create the static procedure(s) declared above.
 */
/**
 * The callout function that invokes the optionUsage function.
 *
 * @param[in] opts the AutoOpts option description structure
 * @param[in] od   the descriptor for the "help" (usage) option.
 * @noreturn
 */
static void
doUsageOpt(tOptions * opts, tOptDesc * od)
{
    int ex_code;
    ex_code = UNSHAR_EXIT_SUCCESS;
    optionUsage(&unsharOptions, ex_code);
    /* NOTREACHED */
    exit(1);
    (void)opts;
    (void)od;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the force option.
 *
 * @param[in] pOptions the unshar options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptForce(tOptions* pOptions, tOptDesc* pOptDesc)
{
    int res = optionAlias(pOptions, pOptDesc, INDEX_OPT_OVERWRITE);
    if ((res != 0) && ((pOptions->fOptSet & OPTPROC_ERRSTOP) != 0))
        USAGE(UNSHAR_EXIT_USAGE_ERROR);

}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the split-at option.
 * With this option, @command{unshar} isolates each different shell archive
 * from the others which have been placed in the same file, unpacking each
 * in turn, from the beginning of the file to the end.  Its proper
 * operation relies on the fact that many shar files are terminated by a
 * readily identifiable string at the start of the last line.
 *
 * For example, noticing that most `.signatures' have a double hyphen
 * ("--") on a line right before them, one can then sometimes use
 * @code{--split-at=--}.  The signature will then be skipped, along with
 * the headers of the following message.
 * @param[in] pOptions the unshar options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptSplit_At(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from unshar-opts.def, line 95 */
    separator_str_len = strlen (pOptDesc->optArg.argString);
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the exit-0 option.
 * Most shell archives end with a line consisting of simply "exit 0".
 * This option is equivalent to (and conflicts with)
 * @code{--split-at="exit 0"}.
 * @param[in] pOptions the unshar options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptExit_0(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from unshar-opts.def, line 118 */
    SET_OPT_SPLIT_AT("exit 0");
    (void)pOptDesc;
    (void)pOptions;
}
/* extracted from optmain.tlib near line 116 */


extern int unshar_file(char const* pz_fname, FILE* entry_fp);
/* extracted from optmain.tlib near line 204 */

/**
 * validate file name and dispach callout procedure.
 * This procedure is generated by AutoOpts.
 * It will make sure that the input file name refers to a file
 * that exists and has been opened for reading.
 *
 * @param pz_fname the name of the file to process
 * @returns program exit code flag
 */
static unshar_exit_code_t
validate_fname(char const * pz_fname)
{
    static char const * pz_fs_err = NULL;

    if (pz_fs_err == NULL)
        pz_fs_err = _("fs error %d (%s) %s-ing %s\n");
    if ((pz_fname[0] == '-') && (pz_fname[1] == '\0'))
        return unshar_file(_("standard input"), stdin);
    {
        struct stat sb;
        if (stat(pz_fname, &sb) < 0) {
            fprintf(stderr, pz_fs_err, errno, strerror(errno), "stat",
                    pz_fname);
            return UNSHAR_EXIT_NO_CONFIG_INPUT;
        }
    }
/* extracted from optmain.tlib near line 295 */

    {
        int res;
        FILE* fp = fopen(pz_fname, "r");
        if (fp == NULL) {
            fprintf(stderr, pz_fs_err, errno, strerror(errno), "fopen",
                    pz_fname);
            return UNSHAR_EXIT_NO_CONFIG_INPUT;
        }
        res = unshar_file(pz_fname, fp);
        fclose(fp);
        return res;
    }
}
/* extracted from optmain.tlib near line 131 */

/**
 * Generated main procedure.  This will call the validate_fname procedure
 * for every operand on the command line.  If there are no operands, then stdin
 * is read for a list of file names to process.  stdin must not be a terminal.
 * It must be a pipe or a file.
 *
 * @param[in] argc argument count
 * @param[in] argv argument vector
 * @returns program exit code
 */
int
main(int argc, char ** argv)
{
    int res     = 0;
    int proc_ct = 0;
    int arg_ix  = optionProcess(&unsharOptions, argc, argv);
    
/* extracted from unshar-opts.def near line 34 */

    init_unshar ();
/* extracted from optmain.tlib near line 160 */

    /*
     *  IF the input list is from the command line...
     */
    if (arg_ix < argc) {
        for (; arg_ix < argc; arg_ix++) {
            char * arg = argv[arg_ix];
            res |= validate_fname(arg);
            proc_ct++;
        }
    }
    else
        /*
         * process standard input as input file
         */
        res = unshar_file(_("standard input"), stdin);
    return res;
}
/* extracted from optmain.tlib near line 1245 */

/**
 * Print a usage message with a format and va_list argument.
 * The optionUsage function is then invoked to print
 * the error usage text (somewhat abbreviated) and then exit.
 *
 * @param[in] fmt the message format string
 * @param[in] ap  the var-arg list.
 * @noreturn
 */
void
vusage_message(char const * fmt, va_list ap)
{
    char const * er_leader = _("unshar usage error:\n");
    fputs(er_leader, stderr);
    vfprintf(stderr, fmt, ap);
    optionUsage(&unsharOptions, UNSHAR_EXIT_USAGE_ERROR);
    /* NOTREACHED */
    exit(1);
}

/**
 * Print a usage message with a format and a variable argument list.
 * vusage_message() is called to do the work.
 *
 * @param[in] fmt the message format string
 * @param[in] ... the argument list for the message
 * @noreturn
 */
void
usage_message(char const * fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vusage_message(fmt, ap);
    /* NOTREACHED */
    va_end(ap);
}

/**
 * Print a fatal error message and die, \a va_list style.
 *
 * @param[in] exit_code  the value to call exit(3) with
 * @param[in] fmt        the death rattle message
 * @param[in] ap         the argument list for the message
 * @noreturn
 */
void
vdie(int exit_code, char const * fmt, va_list ap)
{
    char const * die_leader = _("unshar fatal error:\n");
    fputs(die_leader, stderr);
    vfprintf(stderr, fmt, ap);
    fflush(stderr);
    exit(exit_code);
    /* NOTREACHED */
}

/**
 * Print a fatal error message and die, var-arg style.
 *
 * @param[in] exit_code  the value to call exit(3) with
 * @param[in] fmt        the death rattle message
 * @param[in] ...        the list of arguments for the message
 * @noreturn
 */
void
die(int exit_code, char const * fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vdie(exit_code, fmt, ap);
    /* NOTREACHED */
    va_end(ap);
}

/**
 * Print a file system error fatal error message and die.
 *
 * @param[in] exit_code  the value to call exit(3) with.
 * @param[in] op         the operation that failed.
 * @param[in] fname      the file name the operation was on.
 * @noreturn
 */
void
fserr(int exit_code, char const * op, char const * fname)
{
    char const * fserr_fmt = _("fserr %d (%s) performing '%s' on %s\n");
    die(exit_code, fserr_fmt, errno, strerror(errno), op, fname);
    /* NOTREACHED */
}

/**
 * The directory containing the data associated with unshar.
 */
#ifndef  PKGDATADIR
# define PKGDATADIR ""
#endif

/**
 * Information about the person or institution that packaged unshar
 * for the current distribution.
 */
#ifndef  WITH_PACKAGER
# define unshar_packager_info NULL
#else
/** Packager information for unshar. */
static char const unshar_packager_info[] =
    "Packaged by " WITH_PACKAGER

# ifdef WITH_PACKAGER_VERSION
        " ("WITH_PACKAGER_VERSION")"
# endif

# ifdef WITH_PACKAGER_BUG_REPORTS
    "\nReport unshar bugs to " WITH_PACKAGER_BUG_REPORTS
# endif
    "\n";
#endif
#ifndef __doxygen__

#endif /* __doxygen__ */
/**
 * The option definitions for unshar.  The one structure that
 * binds them all.
 */
tOptions unsharOptions = {
    OPTIONS_STRUCT_VERSION,
    0, NULL,                    /* original argc + argv    */
    ( OPTPROC_BASE
    + OPTPROC_ERRSTOP
    + OPTPROC_SHORTOPT
    + OPTPROC_LONGOPT
    + OPTPROC_NO_REQ_OPT
    + OPTPROC_GNUUSAGE
    + OPTPROC_MISUSE ),
    0, NULL,                    /* current option index, current option */
    NULL,         NULL,         zPROGNAME,
    zRcName,      zCopyright,   zLicenseDescrip,
    zFullVersion, apzHomeList,  zUsageTitle,
    zExplain,     zDetail,      optDesc,
    zBugsAddr,                  /* address to send bugs to */
    NULL, NULL,                 /* extensions/saved state  */
    optionUsage, /* usage procedure */
    translate_option_strings,   /* translation procedure */
    /*
     *  Indexes to special options
     */
    { INDEX_OPT_MORE_HELP, /* more-help option index */
      INDEX_OPT_SAVE_OPTS, /* save option index */
      NO_EQUIVALENT, /* '-#' option index */
      NO_EQUIVALENT /* index of default opt */
    },
    11 /* full option count */, 6 /* user option count */,
    unshar_full_usage, unshar_short_usage,
    NULL, NULL,
    PKGDATADIR, unshar_packager_info
};

#if ENABLE_NLS
/**
 * This code is designed to translate translatable option text for the
 * unshar program.  These translations happen upon entry
 * to optionProcess().
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#ifdef HAVE_DCGETTEXT
# include <gettext.h>
#endif
#include <autoopts/usage-txt.h>

static char * AO_gettext(char const * pz);
static void   coerce_it(void ** s);

/**
 * AutoGen specific wrapper function for gettext.  It relies on the macro _()
 * to convert from English to the target language, then strdup-duplicates the
 * result string.  It tries the "libopts" domain first, then whatever has been
 * set via the \a textdomain(3) call.
 *
 * @param[in] pz the input text used as a lookup key.
 * @returns the translated text (if there is one),
 *   or the original text (if not).
 */
static char *
AO_gettext(char const * pz)
{
    char * res;
    if (pz == NULL)
        return NULL;
#ifdef HAVE_DCGETTEXT
    /*
     * While processing the option_xlateable_txt data, try to use the
     * "libopts" domain.  Once we switch to the option descriptor data,
     * do *not* use that domain.
     */
    if (option_xlateable_txt.field_ct != 0) {
        res = dgettext("libopts", pz);
        if (res == pz)
            res = (char *)(void *)_(pz);
    } else
        res = (char *)(void *)_(pz);
#else
    res = (char *)(void *)_(pz);
#endif
    if (res == pz)
        return res;
    res = strdup(res);
    if (res == NULL) {
        fputs(_("No memory for duping translated strings\n"), stderr);
        exit(UNSHAR_EXIT_NOMEM);
    }
    return res;
}

/**
 * All the pointers we use are marked "* const", but they are stored in
 * writable memory.  Coerce the mutability and set the pointer.
 */
static void coerce_it(void ** s) { *s = AO_gettext(*s);
}

/**
 * Translate all the translatable strings in the unsharOptions
 * structure defined above.  This is done only once.
 */
static void
translate_option_strings(void)
{
    tOptions * const opts = &unsharOptions;

    /*
     *  Guard against re-translation.  It won't work.  The strings will have
     *  been changed by the first pass through this code.  One shot only.
     */
    if (option_xlateable_txt.field_ct != 0) {
        /*
         *  Do the translations.  The first pointer follows the field count
         *  field.  The field count field is the size of a pointer.
         */
        char ** ppz = (char**)(void*)&(option_xlateable_txt);
        int     ix  = option_xlateable_txt.field_ct;

        do {
            ppz++; /* skip over field_ct */
            *ppz = AO_gettext(*ppz);
        } while (--ix > 0);
        /* prevent re-translation and disable "libopts" domain lookup */
        option_xlateable_txt.field_ct = 0;

        coerce_it((void*)&(opts->pzCopyright));
        coerce_it((void*)&(opts->pzCopyNotice));
        coerce_it((void*)&(opts->pzFullVersion));
    }
}
#endif /* ENABLE_NLS */

#ifdef DO_NOT_COMPILE_THIS_CODE_IT_IS_FOR_GETTEXT
/** I18N function strictly for xgettext.  Do not compile. */
static void bogus_function(void) {
  /* TRANSLATORS:

     The following dummy function was crated solely so that xgettext can
     extract the correct strings.  These strings are actually referenced
     by a field name in the unsharOptions structure noted in the
     comments below.  The literal text is defined in unshar_opt_strs.
   
     NOTE: the strings below are segmented with respect to the source string
     unshar_opt_strs.  The strings above are handed off for translation
     at run time a paragraph at a time.  Consequently, they are presented here
     for translation a paragraph at a time.
   
     ALSO: often the description for an option will reference another option
     by name.  These are set off with apostrophe quotes (I hope).  Do not
     translate option names.
   */
  /* referenced via unsharOptions.pzCopyright */
  puts(_("unshar (GNU sharutils) 4.14\n\
Copyright (C) 1994-2013 Free Software Foundation, Inc., all rights reserved.\n\
This is free software. It is licensed for use, modification and\n\
redistribution under the terms of the GNU General Public License,\n\
version 3 or later <http://gnu.org/licenses/gpl.html>\n"));

  /* referenced via unsharOptions.pzCopyNotice */
  puts(_("unshar is free software: you can redistribute it and/or modify it under the\n\
terms of the GNU General Public License as published by the Free Software\n\
Foundation, either version 3 of the License, or (at your option) any later\n\
version.\n\n"));
  puts(_("unshar is distributed in the hope that it will be useful, but WITHOUT ANY\n\
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n\
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more\n\
details.\n\n"));
  puts(_("You should have received a copy of the GNU General Public License along\n\
with this program.  If not, see <http://www.gnu.org/licenses/>.\n"));

  /* referenced via unsharOptions.pzUsageTitle */
  puts(_("unshar (GNU sharutils) - unpack a shar archive\n\
Usage:  %s [ -<flag> [<val>] | --<name>[{=| }<val>] ]... [<file>...]\n"));

  /* referenced via unsharOptions.pzExplain */
  puts(_("\n\
If no arguments are provided, input arguments are read from stdin,\n\
one per line; blank and '#'-prefixed lines are comments.\n\
'stdin' may not be a terminal (tty).\n"));

  /* referenced via unsharOptions.pzDetail */
  puts(_("Unshar scans the input files (typically email messages) looking for the\n\
start of a shell archive.  If no files are given, then standard input is\n\
processed instead.  It then passes each archive discovered through an\n\
invocation of the shell program to unpack it.\n"));

  /* referenced via unsharOptions.pzFullVersion */
  puts(_("unshar (GNU sharutils) 4.14"));

  /* referenced via unsharOptions.pzFullUsage */
  puts(_("unshar (GNU sharutils) - unpack a shar archive\n\
Usage:  unshar [ -<flag> [<val>] | --<name>[{=| }<val>] ]... [<file>...]\n\n"));
  puts(_("   -d, --directory=DIR        unpack into the directory DIR\n"));
  puts(_("   -c, --overwrite            overwrite any pre-existing files\n"));
  puts(_("   -f, --force                an alias for the 'overwrite' option\n"));
  puts(_("   -E, --split-at=SPLIT-PAT   split input on SPLIT-PAT lines\n"));
  puts(_("   -e, --exit-0               split input on \"exit 0\" lines\n\
                                - prohibits the option 'split-at'\n"));
  puts(_("   -D, --debug                debug the shell code\n"));
  puts(_("   -v, --version[=MODE]       output version information and exit\n"));
  puts(_("   -h, --help                 display extended usage information and exit\n"));
  puts(_("   -!, --more-help            extended usage information passed thru pager\n"));
  puts(_("   -R, --save-opts[=FILE]     save the option state to the config file FILE\n"));
  puts(_("   -r, --load-opts=FILE       load options from the config file FILE\n\
                                - disabled as '--no-load-opts'\n\
                                - may appear multiple times\n\n"));
  puts(_("Options are specified by doubled hyphens and their name or by a single\n\
hyphen and the flag character.\n\n"));
  puts(_("If no arguments are provided, input arguments are read from stdin,\n\
one per line; blank and '#'-prefixed lines are comments.\n\
'stdin' may not be a terminal (tty).\n\n"));
  puts(_("The following option preset mechanisms are supported:\n"));
  puts(_(" - reading file $HOME/.sharrc\n\n\
'unshar' scans the input files (typically email messages) looking for the\n\
start of a shell archive.  If no files are given, then standard input is\n\
processed instead.  It then passes each archive discovered through an\n\
invocation of the shell program to unpack it.\n\n"));
  puts(_("Please send bug reports to:  <bug-gnu-utils@gnu.org>\n"));

  /* referenced via unsharOptions.pzShortUsage */
  puts(_("unshar (GNU sharutils) - unpack a shar archive\n\
Usage:  unshar [ -<flag> [<val>] | --<name>[{=| }<val>] ]... [<file>...]\n\
Try 'unshar --help' for more information.\n"));
  /* LIBOPTS-MESSAGES: */
#line 67 "../autoopts.c"
  puts(_("allocation of %d bytes failed\n"));
#line 93 "../autoopts.c"
  puts(_("allocation of %d bytes failed\n"));
#line 53 "../init.c"
  puts(_("AutoOpts function called without option descriptor\n"));
#line 90 "../init.c"
  puts(_("\tThis exceeds the compiled library version:  "));
#line 88 "../init.c"
  puts(_("Automated Options Processing Error!\n"
       "\t%s called AutoOpts function with structure version %d:%d:%d.\n"));
#line 80 "../autoopts.c"
  puts(_("realloc of %d bytes at 0x%p failed\n"));
#line 92 "../init.c"
  puts(_("\tThis is less than the minimum library version:  "));
#line 121 "../version.c"
  puts(_("Automated Options version %s\n"
       "\tCopyright (C) 1999-2013 by Bruce Korb - all rights reserved\n"));
#line 82 "../makeshell.c"
  puts(_("(AutoOpts bug):  %s.\n"));
#line 90 "../reset.c"
  puts(_("optionResetOpt() called, but reset-option not configured"));
#line 292 "../usage.c"
  puts(_("could not locate the 'help' option"));
#line 336 "../autoopts.c"
  puts(_("optionProcess() was called with invalid data"));
#line 748 "../usage.c"
  puts(_("invalid argument type specified"));
#line 598 "../find.c"
  puts(_("defaulted to option with optional arg"));
#line 76 "../alias.c"
  puts(_("aliasing option is out of range."));
#line 234 "../enum.c"
  puts(_("%s error:  the keyword '%s' is ambiguous for %s\n"));
#line 108 "../find.c"
  puts(_("  The following options match:\n"));
#line 293 "../find.c"
  puts(_("%s: ambiguous option name: %s (matches %d options)\n"));
#line 161 "../check.c"
  puts(_("%s: Command line arguments required\n"));
#line 43 "../alias.c"
  puts(_("%d %s%s options allowed\n"));
#line 89 "../makeshell.c"
  puts(_("%s error %d (%s) calling %s for '%s'\n"));
#line 301 "../makeshell.c"
  puts(_("interprocess pipe"));
#line 168 "../version.c"
  puts(_("error: version option argument '%c' invalid.  Use:\n"
       "\t'v' - version only\n"
       "\t'c' - version and copyright\n"
       "\t'n' - version and full copyright notice\n"));
#line 58 "../check.c"
  puts(_("%s error:  the '%s' and '%s' options conflict\n"));
#line 217 "../find.c"
  puts(_("%s: The '%s' option has been disabled."));
#line 430 "../find.c"
  puts(_("%s: The '%s' option has been disabled."));
#line 38 "../alias.c"
  puts(_("-equivalence"));
#line 469 "../find.c"
  puts(_("%s: illegal option -- %c\n"));
#line 110 "../reset.c"
  puts(_("%s: illegal option -- %c\n"));
#line 271 "../find.c"
  puts(_("%s: illegal option -- %s\n"));
#line 755 "../find.c"
  puts(_("%s: illegal option -- %s\n"));
#line 118 "../reset.c"
  puts(_("%s: illegal option -- %s\n"));
#line 335 "../find.c"
  puts(_("%s: unknown vendor extension option -- %s\n"));
#line 159 "../enum.c"
  puts(_("  or an integer from %d through %d\n"));
#line 169 "../enum.c"
  puts(_("  or an integer from %d through %d\n"));
#line 747 "../usage.c"
  puts(_("%s error:  invalid option descriptor for %s\n"));
#line 1081 "../usage.c"
  puts(_("%s error:  invalid option descriptor for %s\n"));
#line 385 "../find.c"
  puts(_("%s: invalid option name: %s\n"));
#line 527 "../find.c"
  puts(_("%s: The '%s' option requires an argument.\n"));
#line 156 "../autoopts.c"
  puts(_("(AutoOpts bug):  Equivalenced option '%s' was equivalenced to both\n"
       "\t'%s' and '%s'."));
#line 94 "../check.c"
  puts(_("%s error:  The %s option is required\n"));
#line 632 "../find.c"
  puts(_("%s: The '%s' option cannot have an argument.\n"));
#line 151 "../check.c"
  puts(_("%s: Command line arguments are not allowed.\n"));
#line 535 "../save.c"
  puts(_("error %d (%s) creating %s\n"));
#line 234 "../enum.c"
  puts(_("%s error:  '%s' does not match any %s keywords.\n"));
#line 93 "../reset.c"
  puts(_("%s error: The '%s' option requires an argument.\n"));
#line 184 "../save.c"
  puts(_("error %d (%s) stat-ing %s\n"));
#line 238 "../save.c"
  puts(_("error %d (%s) stat-ing %s\n"));
#line 143 "../restore.c"
  puts(_("%s error: no saved option state\n"));
#line 231 "../autoopts.c"
  puts(_("'%s' is not a command line option.\n"));
#line 114 "../time.c"
  puts(_("%s error:  '%s' is not a recognizable date/time.\n"));
#line 132 "../save.c"
  puts(_("'%s' not defined\n"));
#line 53 "../time.c"
  puts(_("%s error:  '%s' is not a recognizable time duration.\n"));
#line 92 "../check.c"
  puts(_("%s error:  The %s option must appear %d times.\n"));
#line 157 "../numeric.c"
  puts(_("%s error:  '%s' is not a recognizable number.\n"));
#line 200 "../enum.c"
  puts(_("%s error:  %s exceeds %s keyword count\n"));
#line 330 "../usage.c"
  puts(_("Try '%s %s' for more information.\n"));
#line 45 "../alias.c"
  puts(_("one %s%s option allowed\n"));
#line 203 "../makeshell.c"
  puts(_("standard output"));
#line 938 "../makeshell.c"
  puts(_("standard output"));
#line 274 "../usage.c"
  puts(_("standard output"));
#line 415 "../usage.c"
  puts(_("standard output"));
#line 625 "../usage.c"
  puts(_("standard output"));
#line 175 "../version.c"
  puts(_("standard output"));
#line 274 "../usage.c"
  puts(_("standard error"));
#line 415 "../usage.c"
  puts(_("standard error"));
#line 625 "../usage.c"
  puts(_("standard error"));
#line 175 "../version.c"
  puts(_("standard error"));
#line 203 "../makeshell.c"
  puts(_("write"));
#line 938 "../makeshell.c"
  puts(_("write"));
#line 273 "../usage.c"
  puts(_("write"));
#line 414 "../usage.c"
  puts(_("write"));
#line 624 "../usage.c"
  puts(_("write"));
#line 174 "../version.c"
  puts(_("write"));
#line 60 "../numeric.c"
  puts(_("%s error:  %s option value %ld is out of range.\n"));
#line 44 "../check.c"
  puts(_("%s error:  %s option requires the %s option\n"));
#line 131 "../save.c"
  puts(_("%s warning:  cannot save options - %s not regular file\n"));
#line 183 "../save.c"
  puts(_("%s warning:  cannot save options - %s not regular file\n"));
#line 237 "../save.c"
  puts(_("%s warning:  cannot save options - %s not regular file\n"));
#line 256 "../save.c"
  puts(_("%s warning:  cannot save options - %s not regular file\n"));
#line 534 "../save.c"
  puts(_("%s warning:  cannot save options - %s not regular file\n"));
  /* END-LIBOPTS-MESSAGES */
}
#endif /* uncompilable code */
#ifdef  __cplusplus
}
#endif
/* unshar-opts.c ends here */
