## RabbitMQ 3.6.2

RabbitMQ `3.6.2` is a maintenance release that includes a [new statistics
collector in the management plugin](https://github.com/rabbitmq/rabbitmq-management/issues/41).

### Management Plugin Incompatibility with Earlier 3.6.x Releases

Because this version includes significant changes to the management plugin,
it should not be deployed into clusters with mixed `3.6.x` node versions
unless **all nodes that have the management plugin enabled** run `3.6.2`.
Otherwise HTTP API requests will fail with exceptions in some scenarios and parts of
management UI may not be updated.

There are no other known incompatibilities with earlier `3.6.x` releases.


### OpenSSL Requirement for Standalone Mac Release

Standalone Mac OS X package now requires OpenSSL 1.0.x to be provided by the system, for example,
from Homebrew.

### Optional `socat` Package Dependency for Distributions that Use `systemd`

Starting with `3.6.2`, RabbitMQ Debian and RPM packages have an optional
[dependency on socat](https://groups.google.com/forum/#!searchin/rabbitmq-users/socat/rabbitmq-users/ktzOsgNEBkY/cOlF_eP6AAAJ). When
installing using `dpkg`, this dependency won't be automatically installed. To install it manually, use

    sudo apt-get install socat


### Server

#### Bug Fixes

 * Channel operations that time out no longer produce noisy crash reports in
   RabbitMQ log files

   GitHub issue: [rabbitmq-common#63](https://github.com/rabbitmq/rabbitmq-common/issues/63)

 * Channel operation timeout default is bumped to 15 seconds

   GitHub issue: [rabbitmq-server/issues/667](https://github.com/rabbitmq/rabbitmq-server/issues/667)

 * Windows service will pick up RabbitMQ config file regardless of whether
   it was present during service installation

   GitHub issue: [rabbitmq-server#659](https://github.com/rabbitmq/rabbitmq-server/issues/659)

 * Erlang distribution failures for `rabbitmqctl` and cross-node links will
   provide more detail when running on Erlang 19 (scheduled for release in Q3 2016).

   GitHub issue: [rabbitmq-server#401](https://github.com/rabbitmq/rabbitmq-server/issues/401)

 * `rabbitmqctl list_consumers` now lists all consumers on a given queue

   Previously it would only list one.

   Contributed by Alexey Lebedeff (Mirantis).

   GitHub issue: [rabbitmq-server#701](https://github.com/rabbitmq/rabbitmq-server/issues/701)

 * `rabbitmqctl list_queues` now correctly outputs rows for unavailable queues

   Contributed by Alexey Lebedeff (Mirantis).

   GitHub issue: [rabbitmq-server#696](https://github.com/rabbitmq/rabbitmq-server/issues/696)

 * `rabbitmqctl set_disk_free_limit mem_relative` erroneously rejected values greater than `1.0`

   GitHub issue: [rabbitmq-server#717](https://github.com/rabbitmq/rabbitmq-server/issues/717)

 * Messages with an invalid client-provided `x-death` header value caused queue process termination

   GitHub issue: [rabbitmq-server#767](https://github.com/rabbitmq/rabbitmq-server/issues/767)

 * Messages with priorities higher than queue max are now assigned max configured priority
   and no longer cause an unhandled exception that results in queue process restart

   GitHub issue: [rabbitmq-server#795](https://github.com/rabbitmq/rabbitmq-server/issues/795)

 * Policy-related `rabbitmqctl` commands could return unformatted messages

   GitHub issue: [rabbitmq-server#742](https://github.com/rabbitmq/rabbitmq-server/issues/742)

 * `RABBITMQ_IO_THREAD_POOL_SIZE` is no longer ignored by `rabbitmq-server.bat`

   GitHub issue: [rabbitmq-server#705](https://github.com/rabbitmq/rabbitmq-server/issues/705)

 * Deleting a vhost in parallel with updating a policy in it resulted
   in unhandled exceptions

   GitHub issues: [rabbitmq-server#755](https://github.com/rabbitmq/rabbitmq-server/issues/755),
                  [rabbitmq-server#759](https://github.com/rabbitmq/rabbitmq-server/issues/759),
                  [rabbitmq-server#744](https://github.com/rabbitmq/rabbitmq-server/issues/744)

#### Enhancements

 * Connections now emit stats unconditionally when they are blocked and unblocked
   by resource alarms. This makes management UI and HTTP API-reported data to be more up-to-date

   GitHub issue: [rabbitmq-server#679](https://github.com/rabbitmq/rabbitmq-server/issues/679)

 * New (node-local) health check command

   `rabbitmqctl node_health_check` is a new command that performs basic health check of a node

   GitHub issue: [rabbitmq-server#398](https://github.com/rabbitmq/rabbitmq-server/issues/398)

 * Automatic restart policy enabled for Windows service

   GitHub issue: [rabbitmq-server#645](https://github.com/rabbitmq/rabbitmq-server/issues/645)

 * Default number of async I/O VM threads is now calculated based on the
   number of available CPU cores

   GitHub issue: [rabbitmq-server#151](https://github.com/rabbitmq/rabbitmq-server/issues/151)

 * `rabbitmqctl list_queues` now supports new flags, `--offline` and `--online`, that limit
   result to only unavailable or available queues (queue leaders, to be more precise)

   Contributed by Alexey Lebedeff (Mirantis).

   GitHub issue: [rabbitmq-server#688](https://github.com/rabbitmq/rabbitmq-server/issues/688)

 * RabbitMQ will no longer log a warning about disabled kernel polling on Windows

   The runtime does not support kernel polling (I/O completion ports) on Windows,
   so there is nothing the user can do about it.

   GitHub issue: [rabbitmq-server#695](https://github.com/rabbitmq/rabbitmq-server/issues/695)

 * Queue index is now updated in batches when messages are requeued

   GitHub issue: [rabbitmq-server#343](https://github.com/rabbitmq/rabbitmq-server/issues/343)


### Management plugin

#### Bug Fixes

 * Samples (stats) for abnormally terminated connections and channels will now be cleaned up more aggressively

   GitHub issue: [rabbitmq-management#198](https://github.com/rabbitmq/rabbitmq-management/issues/198)

 * Cluster name could be returned by HTTP API as a non-string value

   GitHub issue: [rabbitmq-management#143](https://github.com/rabbitmq/rabbitmq-management/issues/143)

 * Improved IE 11 compatibility

   GitHub issue: [rabbitmq-management#123](https://github.com/rabbitmq/rabbitmq-management/issues/123)

#### Enhancements

 * Management plugin has a new, better parallelised event collector which is less likely to
   fall behind.

   GitHub issues: [rabbitmq-management#41](https://github.com/rabbitmq/rabbitmq-management/issues/41),
                  [rabbitmq-management#166](https://github.com/rabbitmq/rabbitmq-management/issues/166),
                  [rabbitmq-management#173](https://github.com/rabbitmq/rabbitmq-management/issues/173),
                  [rabbitmq-management#185](https://github.com/rabbitmq/rabbitmq-management/issues/185),
                  [rabbitmq-management#174](https://github.com/rabbitmq/rabbitmq-management/issues/174)

 * Clients now can provide a human-readable connection name that will be displayed
   in the management UI. Currently Java, .NET and Erlang clients support this.
   In order to use this feature, set the `connection_name` key in client properties.
   Note that this name doesn't have to be unique and cannot be used as a connection identifier,
   for example, in HTTP API requests.

   GitHub issue: [rabbitmq-server#104](https://github.com/rabbitmq/rabbitmq-server/issues/104)

 * `GET /api/nodes/{node}/memory` and `GET /api/nodes/{node}/memory/relative` are new HTTP API
   endpoints that return memory usage breakdown in absolute (same as `rabbitmqctl status`) and
   relative terms.

   GitHub issue: [rabbitmq-management#161](https://github.com/rabbitmq/rabbitmq-management/issues/161)

 * HTTPS related improvements in `rabbitmqadmin`.

   GitHub issues: [rabbitmq-management#152](https://github.com/rabbitmq/rabbitmq-management/issues/152), [rabbitmq-management#151](https://github.com/rabbitmq/rabbitmq-management/issues/151), [rabbitmq-management#149](https://github.com/rabbitmq/rabbitmq-management/issues/149).

 * Policies now can be listed (read) by the users tagged with `management` and `monitoring`

   As well as those tagged with `policymaker` and `administrator`, of course.

   GitHub issue: [rabbitmq-management#156](https://github.com/rabbitmq/rabbitmq-management/issues/156)

 * Effective rates mode is now displayed for cluster nodes by default

   GitHub issue: [rabbitmq-management#177](https://github.com/rabbitmq/rabbitmq-management/issues/177)


### MQTT plugin

#### Bug Fixes

 * Resource alarms are handled correctly by MQTT connections

   GitHub issues: [rabbitmq-mqtt#62](https://github.com/rabbitmq/rabbitmq-mqtt/issues/62)

 * Session [pre-existing] presence is now correctly communicated to clients

   GitHub issue: [rabbitmq-mqtt#61](https://github.com/rabbitmq/rabbitmq-mqtt/issues/61)

#### Enhancements

 * Connections now emit stats unconditionally when they are blocked and unblocked
   by resource alarms. This makes management UI and HTTP API-reported data to be more up-to-date.

   GitHub issue: [rabbitmq-mqtt#71](https://github.com/rabbitmq/rabbitmq-mqtt/issues/71)

 * More connection details for MQTT connections reported to management UI

   GitHub issue: [rabbitmq-mqtt#66](https://github.com/rabbitmq/rabbitmq-mqtt/pull/66)

### STOMP plugin

#### Bug Fixes

 * Resource alarms are handled correctly by STOMP connections

   GitHub issues: [rabbitmq-stomp#68](https://github.com/rabbitmq/rabbitmq-stomp/issues/68),
                  [rabbitmq-stomp#67](https://github.com/rabbitmq/rabbitmq-stomp/issues/67)

#### Enhancements

 * Connections now emit stats unconditionally when they are blocked and unblocked
   by resource alarms. This makes management UI and HTTP API-reported data to be more up-to-date.

   GitHub issue: [rabbitmq-stomp#70](https://github.com/rabbitmq/rabbitmq-stomp/issues/70)

 * More connection details for STOMP connections reported to management UI

   GitHub issue: [rabbitmq-stomp#55](https://github.com/rabbitmq/rabbitmq-stomp/issues/55)



### Web STOMP plugin

#### Enhancements

 * More connection details for STOMP-over-WebSockets connections reported to management UI

   GitHub issue: [rabbitmq-web-stomp#45](https://github.com/rabbitmq/rabbitmq-web-stomp/pull/45)

 * The plugin now sends a protocol header (`Sec-WebSocket-Protocol`) response when
   client presents it.

   GitHub issue: [rabbitmq-web-stomp#53](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/53)


### Web MQTT plugin

#### Bug Fixes

 * More connection details for MQTT-over-WebSockets connections reported to management UI

   GitHub issue: [rabbitmq-web-mqtt#3](https://github.com/rabbitmq/rabbitmq-web-mqtt/pull/3)

 * Plugin deactivation now correctly stops TCP listener

   GitHub issue: [rabbitmq-web-mqtt#7](https://github.com/rabbitmq/rabbitmq-web-mqtt/issues/7)


### .NET client

#### Bug Fixes

 * Compatibility with SQL Server 2014 CLR restored

   GitHub issue: [rabbitmq-dotnet-client#167](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/167)

 * Autorecovering connections now respect all provided hostnames
   when reconnecting.

   GitHub issue: [rabbitmq-dotnet-client#157](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/157)

 * `ConnectionFactory#CreateConnection` now respects all provided hostnames
   when automatic connection recovery is disabled.

   GitHub issue: [rabbitmq-dotnet-client#176](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/176)

### Erlang client

#### Bug Fixes

 * Certain channel failures resulted in a race condition during process [tree] shutdown.

   GitHub issue: [rabbitmq-erlang-client#42](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/42)


### LDAP Authentication/Authorisation Backend

#### Bug Fixes

 * LDAP connection pool is now more resilient to TCP connection closure/loss on Erlang/OTP 18.3

   GitHub issue: [rabbitmq-auth-backend-ldap#41](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/41)

 * Non-existent group in `tag_queries` shouldn't terminate authorisation

   GitHub issue: [rabbitmq-auth-backend-ldap#15](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/15)

 * `attribute` query should not fail when multiple values are returned

   GitHub issue: [rabbitmq-auth-backend-ldap#16](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/16)

#### Enhancements

 * Virtual host is now available as a variable in `tag_queries`

   GitHub issue: [rabbitmq-auth-backend-ldap#13](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/13)

 * Default LDAP connection pool size was increased from `10` to `64`

   GitHub issue: [rabbitmq-auth-backend-ldap#35](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/35)


### HTTP Authentication/Authorisation Backend

#### Enhancements

 * The plugin now uses HTTP 1.1 and keep-alive connections for requests.

   GitHub issue: [rabbitmq-auth-backend-http#20](https://github.com/rabbitmq/rabbitmq-auth-backend-http/issues/20)

 * It is now possible to configure the plugin to use `POST` requests instead of
   `GET`, so that no sensitive information is logged.

   GitHub issue: [rabbitmq-auth-backend-http#7](https://github.com/rabbitmq/rabbitmq-auth-backend-http/issues/7)

 * The plugin now supports HTTP client TLS options, so authenticating apps can use HTTPS

   GitHub issue: [rabbitmq-auth-backend-http#29](https://github.com/rabbitmq/rabbitmq-auth-backend-http/issues/29)

 * Vhost access requests now include client IP address

   GitHub issue: [rabbitmq-auth-backend-http#33](https://github.com/rabbitmq/rabbitmq-auth-backend-http/pull/33)

   Contributed by Abdulrazak Alkl.

### Event Exchange plugin

#### Enhancements

 * Policy events now include a vhost field

   GitHub issue: [rabbitmq-event-exchange#17](https://github.com/rabbitmq/rabbitmq-event-exchange/issues/17)

 * Binding events now include a vhost field

   GitHub issue: [rabbitmq-event-exchange#9](https://github.com/rabbitmq/rabbitmq-event-exchange/issues/9)

 * Millesecond resolution timestamp of events is now back as a message header

   GitHub issue: [rabbitmq-event-exchange#12](https://github.com/rabbitmq/rabbitmq-event-exchange/issues/12)

 * `user.authentication.success` no longer has the `vhost` field
   since vhost is only available at a later point. `connection.created`
   events should be used to track successful connections if vhost
   information is desired.

   GitHub issue: [rabbitmq-event-exchange#13](https://github.com/rabbitmq/rabbitmq-event-exchange/issues/13)


## Upgrading

To upgrade a non-clustered RabbitMQ simply install the new version. All configuration and persistent message data are retained. When upgrading using definitions export/import from versions earlier than 3.6.1, see http://rabbitmq.com/passwords.html.

To upgrade a RabbitMQ cluster, follow the instructions [in RabbitMQ documentation](https://www.rabbitmq.com/clustering.html#upgrading). All nodes that have RabbitMQ management plugin enabled
must be upgraded in lock step.

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker, not the plugins or the client libraries. Please download the archive named `rabbitmq-3.6.2.tar.gz`.
