/* candidatepanel.c generated by valac 0.56.13, the Vala compiler
 * generated from candidatepanel.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2015 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2015-2023 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <ibus.h>
#include <string.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <gdk/gdkwayland.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CANDIDATE_PANEL (candidate_panel_get_type ())
#define CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_PANEL, CandidatePanel))
#define CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_PANEL, CandidatePanelClass))
#define IS_CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_PANEL))
#define IS_CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_PANEL))
#define CANDIDATE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_PANEL, CandidatePanelClass))

typedef struct _CandidatePanel CandidatePanel;
typedef struct _CandidatePanelClass CandidatePanelClass;
typedef struct _CandidatePanelPrivate CandidatePanelPrivate;

#define TYPE_CANDIDATE_AREA (candidate_area_get_type ())
#define CANDIDATE_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_AREA, CandidateArea))
#define CANDIDATE_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_AREA, CandidateAreaClass))
#define IS_CANDIDATE_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_AREA))
#define IS_CANDIDATE_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_AREA))
#define CANDIDATE_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_AREA, CandidateAreaClass))

typedef struct _CandidateArea CandidateArea;
typedef struct _CandidateAreaClass CandidateAreaClass;

#define TYPE_HSEPARATOR (hseparator_get_type ())
#define HSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HSEPARATOR, HSeparator))
#define HSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HSEPARATOR, HSeparatorClass))
#define IS_HSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HSEPARATOR))
#define IS_HSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HSEPARATOR))
#define HSEPARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HSEPARATOR, HSeparatorClass))

typedef struct _HSeparator HSeparator;
typedef struct _HSeparatorClass HSeparatorClass;
enum  {
	CANDIDATE_PANEL_0_PROPERTY,
	CANDIDATE_PANEL_NUM_PROPERTIES
};
static GParamSpec* candidate_panel_properties[CANDIDATE_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))

#define TYPE_HANDLE (handle_get_type ())
#define HANDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HANDLE, Handle))
#define HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HANDLE, HandleClass))
#define IS_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HANDLE))
#define IS_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HANDLE))
#define HANDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HANDLE, HandleClass))

typedef struct _Handle Handle;
typedef struct _HandleClass HandleClass;
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	CANDIDATE_PANEL_CURSOR_UP_SIGNAL,
	CANDIDATE_PANEL_CURSOR_DOWN_SIGNAL,
	CANDIDATE_PANEL_PAGE_UP_SIGNAL,
	CANDIDATE_PANEL_PAGE_DOWN_SIGNAL,
	CANDIDATE_PANEL_CANDIDATE_CLICKED_SIGNAL,
	CANDIDATE_PANEL_REALIZE_SURFACE_SIGNAL,
	CANDIDATE_PANEL_NUM_SIGNALS
};
static guint candidate_panel_signals[CANDIDATE_PANEL_NUM_SIGNALS] = {0};

struct _CandidatePanel {
	GtkBox parent_instance;
	CandidatePanelPrivate * priv;
};

struct _CandidatePanelClass {
	GtkBoxClass parent_class;
};

struct _CandidatePanelPrivate {
	gboolean m_vertical_panel_system;
	gboolean m_vertical_writing;
	GtkWindow* m_toplevel;
	GtkBox* m_vbox;
	gboolean m_hide_after_show;
	GtkLabel* m_preedit_label;
	GtkLabel* m_aux_label;
	CandidateArea* m_candidate_area;
	HSeparator* m_hseparator;
	GdkRectangle m_cursor_location;
	PangoAttribute* m_language_attribute;
};

static gint CandidatePanel_private_offset;
static gpointer candidate_panel_parent_class = NULL;

VALA_EXTERN GType candidate_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CandidatePanel, g_object_unref)
VALA_EXTERN GType candidate_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CandidateArea, g_object_unref)
VALA_EXTERN GType hseparator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HSeparator, g_object_unref)
VALA_EXTERN CandidatePanel* candidate_panel_new (void);
VALA_EXTERN CandidatePanel* candidate_panel_construct (GType object_type);
static gboolean __lambda35_ (CandidatePanel* self,
                      GtkWidget* w,
                      GdkEventButton* e);
VALA_EXTERN void candidate_panel_set_vertical (CandidatePanel* self,
                                   gboolean vertical);
static gboolean ___lambda35__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static void __lambda36_ (CandidatePanel* self,
                  GtkWidget* w,
                  GtkAllocation* a);
static void candidate_panel_adjust_window_position (CandidatePanel* self,
                                             GtkWidget* window);
static void ___lambda36__gtk_widget_size_allocate (GtkWidget* _sender,
                                            GtkAllocation* allocation,
                                            gpointer self);
VALA_EXTERN gboolean binding_common_default_is_xdisplay (void);
static void ___lambda37_ (CandidatePanel* self,
                   GtkWidget* w);
static void candidate_panel_realize_window (CandidatePanel* self,
                                     gboolean initial);
static void ____lambda37__gtk_widget_realize (GtkWidget* _sender,
                                       gpointer self);
static void ___lambda38_ (CandidatePanel* self,
                   GtkWidget* w);
static void ____lambda38__gtk_widget_show (GtkWidget* _sender,
                                    gpointer self);
static void ___lambda39_ (CandidatePanel* self,
                   GtkWidget* w);
static void ____lambda39__gtk_widget_hide (GtkWidget* _sender,
                                    gpointer self);
VALA_EXTERN GType handle_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Handle, g_object_unref)
VALA_EXTERN Handle* handle_new (void);
VALA_EXTERN Handle* handle_construct (GType object_type);
static void candidate_panel_create_ui (CandidatePanel* self);
VALA_EXTERN void candidate_area_set_vertical (CandidateArea* self,
                                  gboolean vertical,
                                  gboolean force);
static void candidate_panel_set_orientation (CandidatePanel* self,
                                      IBusOrientation orientation);
VALA_EXTERN void candidate_panel_set_cursor_location (CandidatePanel* self,
                                          gint x,
                                          gint y,
                                          gint width,
                                          gint height);
static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                                     const cairo_rectangle_int_t * s2);
static void candidate_panel_set_labels (CandidatePanel* self,
                                 IBusText** labels,
                                 gint labels_length1);
VALA_EXTERN void candidate_area_set_labels (CandidateArea* self,
                                IBusText** labels,
                                gint labels_length1);
VALA_EXTERN void candidate_panel_set_language (CandidatePanel* self,
                                   PangoAttribute* language_attribute);
VALA_EXTERN void candidate_area_set_language (CandidateArea* self,
                                  PangoAttribute* language_attribute);
static void candidate_panel_set_attributes (CandidatePanel* self,
                                     GtkLabel* label,
                                     IBusText* text);
VALA_EXTERN PangoAttrList* get_pango_attr_list_from_ibus_text (IBusText* text);
VALA_EXTERN void candidate_panel_set_preedit_text (CandidatePanel* self,
                                       IBusText* text,
                                       guint cursor);
static void candidate_panel_update (CandidatePanel* self);
VALA_EXTERN void candidate_panel_set_auxiliary_text (CandidatePanel* self,
                                         IBusText* text);
VALA_EXTERN void candidate_panel_set_lookup_table (CandidatePanel* self,
                                       IBusLookupTable* table);
static void _vala_array_add9 (IBusText** * array,
                       gint* length,
                       gint* size,
                       IBusText* value);
static void _vala_array_add10 (IBusText** * array,
                        gint* length,
                        gint* size,
                        IBusText* value);
VALA_EXTERN void candidate_area_set_candidates (CandidateArea* self,
                                    IBusText** candidates,
                                    gint candidates_length1,
                                    guint focus_candidate,
                                    gboolean show_cursor);
VALA_EXTERN void candidate_panel_set_content_type (CandidatePanel* self,
                                       guint purpose,
                                       guint hints);
VALA_EXTERN CandidateArea* candidate_area_new (gboolean vertical);
VALA_EXTERN CandidateArea* candidate_area_construct (GType object_type,
                                         gboolean vertical);
static void __lambda40_ (CandidatePanel* self,
                  CandidateArea* w,
                  guint i,
                  guint b,
                  guint s);
static void ___lambda40__candidate_area_candidate_clicked (CandidateArea* _sender,
                                                    guint index,
                                                    guint button,
                                                    guint state,
                                                    gpointer self);
static void __lambda41_ (CandidatePanel* self,
                  CandidateArea* c);
static void ___lambda41__candidate_area_page_up (CandidateArea* _sender,
                                          gpointer self);
static void __lambda42_ (CandidatePanel* self,
                  CandidateArea* c);
static void ___lambda42__candidate_area_page_down (CandidateArea* _sender,
                                            gpointer self);
static void __lambda43_ (CandidatePanel* self,
                  CandidateArea* c);
static void ___lambda43__candidate_area_cursor_up (CandidateArea* _sender,
                                            gpointer self);
static void __lambda44_ (CandidatePanel* self,
                  CandidateArea* c);
static void ___lambda44__candidate_area_cursor_down (CandidateArea* _sender,
                                              gpointer self);
VALA_EXTERN HSeparator* hseparator_new (void);
VALA_EXTERN HSeparator* hseparator_construct (GType object_type);
static void candidate_panel_pack_all_widgets (CandidatePanel* self);
VALA_EXTERN void candidate_panel_show (CandidatePanel* self);
VALA_EXTERN void candidate_panel_hide (CandidatePanel* self);
static void candidate_panel_move (CandidatePanel* self,
                           gint x,
                           gint y);
static void candidate_panel_adjust_window_position_horizontal (CandidatePanel* self,
                                                        GtkWidget* window);
static void candidate_panel_adjust_window_position_vertical (CandidatePanel* self,
                                                      GtkWidget* window);
static void candidate_panel_get_monitor_geometry (CandidatePanel* self,
                                           GtkWidget* window,
                                           GdkRectangle* result);
VALA_EXTERN gboolean candidate_area_get_vertical (CandidateArea* self);
static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void candidate_panel_finalize (GObject * obj);
static GType candidate_panel_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
candidate_panel_get_instance_private (CandidatePanel* self)
{
	return G_STRUCT_MEMBER_P (self, CandidatePanel_private_offset);
}

static gboolean
__lambda35_ (CandidatePanel* self,
             GtkWidget* w,
             GdkEventButton* e)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (e->state & GDK_CONTROL_MASK) == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	candidate_panel_set_vertical (self, !self->priv->m_vertical_panel_system);
	result = TRUE;
	return result;
}

static gboolean
___lambda35__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda35_ ((CandidatePanel*) self, _sender, event);
	return result;
}

static void
__lambda36_ (CandidatePanel* self,
             GtkWidget* w,
             GtkAllocation* a)
{
	g_return_if_fail (w != NULL);
	g_return_if_fail (a != NULL);
	candidate_panel_adjust_window_position (self, w);
}

static void
___lambda36__gtk_widget_size_allocate (GtkWidget* _sender,
                                       GtkAllocation* allocation,
                                       gpointer self)
{
	__lambda36_ ((CandidatePanel*) self, _sender, allocation);
}

static void
___lambda37_ (CandidatePanel* self,
              GtkWidget* w)
{
	g_return_if_fail (w != NULL);
	candidate_panel_realize_window (self, TRUE);
}

static void
____lambda37__gtk_widget_realize (GtkWidget* _sender,
                                  gpointer self)
{
	___lambda37_ ((CandidatePanel*) self, _sender);
}

static void
___lambda38_ (CandidatePanel* self,
              GtkWidget* w)
{
	g_return_if_fail (w != NULL);
	if (self->priv->m_hide_after_show) {
		candidate_panel_realize_window (self, FALSE);
	}
	self->priv->m_hide_after_show = FALSE;
}

static void
____lambda38__gtk_widget_show (GtkWidget* _sender,
                               gpointer self)
{
	___lambda38_ ((CandidatePanel*) self, _sender);
}

static void
___lambda39_ (CandidatePanel* self,
              GtkWidget* w)
{
	g_return_if_fail (w != NULL);
	self->priv->m_hide_after_show = TRUE;
}

static void
____lambda39__gtk_widget_hide (GtkWidget* _sender,
                               gpointer self)
{
	___lambda39_ ((CandidatePanel*) self, _sender);
}

CandidatePanel*
candidate_panel_construct (GType object_type)
{
	CandidatePanel * self = NULL;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	Handle* handle = NULL;
	Handle* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* _tmp10_;
	GtkWindow* _tmp11_;
	self = (CandidatePanel*) g_object_new (object_type, "name", "IBusCandidate", "orientation", GTK_ORIENTATION_HORIZONTAL, "visible", TRUE, NULL);
	_tmp0_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_POPUP);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_toplevel);
	self->priv->m_toplevel = _tmp0_;
	_tmp1_ = self->priv->m_toplevel;
	gtk_widget_add_events ((GtkWidget*) _tmp1_, (gint) GDK_BUTTON_PRESS_MASK);
	_tmp2_ = self->priv->m_toplevel;
	g_signal_connect_object ((GtkWidget*) _tmp2_, "button-press-event", (GCallback) ___lambda35__gtk_widget_button_press_event, self, 0);
	_tmp3_ = self->priv->m_toplevel;
	g_signal_connect_object ((GtkWidget*) _tmp3_, "size-allocate", (GCallback) ___lambda36__gtk_widget_size_allocate, self, 0);
	if (!binding_common_default_is_xdisplay ()) {
		GtkWindow* _tmp4_;
		GtkWindow* _tmp5_;
		GtkWindow* _tmp6_;
		_tmp4_ = self->priv->m_toplevel;
		g_signal_connect_object ((GtkWidget*) _tmp4_, "realize", (GCallback) ____lambda37__gtk_widget_realize, self, 0);
		_tmp5_ = self->priv->m_toplevel;
		g_signal_connect_object ((GtkWidget*) _tmp5_, "show", (GCallback) ____lambda38__gtk_widget_show, self, 0);
		_tmp6_ = self->priv->m_toplevel;
		g_signal_connect_object ((GtkWidget*) _tmp6_, "hide", (GCallback) ____lambda39__gtk_widget_hide, self, 0);
	}
	_tmp7_ = handle_new ();
	g_object_ref_sink (_tmp7_);
	handle = _tmp7_;
	gtk_widget_set_visible ((GtkWidget*) handle, TRUE);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) handle, FALSE, FALSE, (guint) 0);
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->m_vbox);
	self->priv->m_vbox = _tmp8_;
	_tmp9_ = self->priv->m_vbox;
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, TRUE);
	_tmp10_ = self->priv->m_vbox;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp10_, FALSE, FALSE, (guint) 0);
	_tmp11_ = self->priv->m_toplevel;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) self);
	candidate_panel_create_ui (self);
	_g_object_unref0 (handle);
	return self;
}

CandidatePanel*
candidate_panel_new (void)
{
	return candidate_panel_construct (TYPE_CANDIDATE_PANEL);
}

void
candidate_panel_set_vertical (CandidatePanel* self,
                              gboolean vertical)
{
	CandidateArea* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->m_vertical_panel_system == vertical) {
		return;
	}
	self->priv->m_vertical_panel_system = vertical;
	_tmp0_ = self->priv->m_candidate_area;
	candidate_area_set_vertical (_tmp0_, vertical, FALSE);
}

static void
candidate_panel_set_orientation (CandidatePanel* self,
                                 IBusOrientation orientation)
{
	g_return_if_fail (self != NULL);
	switch (orientation) {
		case IBUS_ORIENTATION_VERTICAL:
		{
			CandidateArea* _tmp0_;
			_tmp0_ = self->priv->m_candidate_area;
			candidate_area_set_vertical (_tmp0_, TRUE, FALSE);
			break;
		}
		case IBUS_ORIENTATION_HORIZONTAL:
		{
			CandidateArea* _tmp1_;
			_tmp1_ = self->priv->m_candidate_area;
			candidate_area_set_vertical (_tmp1_, FALSE, FALSE);
			break;
		}
		case IBUS_ORIENTATION_SYSTEM:
		{
			CandidateArea* _tmp2_;
			_tmp2_ = self->priv->m_candidate_area;
			candidate_area_set_vertical (_tmp2_, self->priv->m_vertical_panel_system, FALSE);
			break;
		}
		default:
		break;
	}
}

static gboolean
_cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                            const cairo_rectangle_int_t * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

void
candidate_panel_set_cursor_location (CandidatePanel* self,
                                     gint x,
                                     gint y,
                                     gint width,
                                     gint height)
{
	GdkRectangle location = {0};
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	g_return_if_fail (self != NULL);
	memset (&_tmp0_, 0, sizeof (GdkRectangle));
	_tmp0_.x = x;
	_tmp0_.y = y;
	_tmp0_.width = width;
	_tmp0_.height = height;
	location = _tmp0_;
	_tmp1_ = self->priv->m_cursor_location;
	_tmp2_ = location;
	if (_cairo_rectangle_int_equal (&_tmp1_, &_tmp2_) == TRUE) {
		return;
	}
	_tmp3_ = location;
	self->priv->m_cursor_location = _tmp3_;
}

static void
candidate_panel_set_labels (CandidatePanel* self,
                            IBusText** labels,
                            gint labels_length1)
{
	CandidateArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_candidate_area;
	candidate_area_set_labels (_tmp0_, labels, (gint) labels_length1);
}

void
candidate_panel_set_language (CandidatePanel* self,
                              PangoAttribute* language_attribute)
{
	CandidateArea* _tmp0_;
	PangoAttribute* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (language_attribute != NULL);
	_tmp0_ = self->priv->m_candidate_area;
	candidate_area_set_language (_tmp0_, language_attribute);
	_tmp1_ = pango_attribute_copy (language_attribute);
	_pango_attribute_destroy0 (self->priv->m_language_attribute);
	self->priv->m_language_attribute = _tmp1_;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
candidate_panel_set_attributes (CandidatePanel* self,
                                GtkLabel* label,
                                IBusText* text)
{
	PangoAttrList* attrs = NULL;
	PangoAttrList* _tmp0_;
	PangoAttrList* _tmp1_;
	PangoAttribute* _tmp2_;
	PangoAttribute* _tmp3_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp4_;
	GtkStyleContext* _tmp5_;
	GdkRGBA color = {0};
	GtkStyleContext* _tmp6_;
	GdkRGBA _tmp7_ = {0};
	gboolean _tmp8_;
	PangoAttrList* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = get_pango_attr_list_from_ibus_text (text);
	attrs = _tmp0_;
	_tmp1_ = attrs;
	_tmp2_ = self->priv->m_language_attribute;
	_tmp3_ = pango_attribute_copy (_tmp2_);
	pango_attr_list_change (_tmp1_, _tmp3_);
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) label);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	context = _tmp5_;
	_tmp6_ = context;
	_tmp8_ = gtk_style_context_lookup_color (_tmp6_, "placeholder_text_color", &_tmp7_);
	color = _tmp7_;
	if (_tmp8_) {
		PangoAttribute* pango_attr = NULL;
		GdkRGBA _tmp9_;
		GdkRGBA _tmp10_;
		GdkRGBA _tmp11_;
		PangoAttribute* _tmp12_;
		PangoAttribute* _tmp13_;
		PangoAttribute* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		PangoAttrList* _tmp18_;
		PangoAttribute* _tmp19_;
		_tmp9_ = color;
		_tmp10_ = color;
		_tmp11_ = color;
		_tmp12_ = pango_attr_foreground_new ((guint16) (_tmp9_.red * G_MAXUINT16), (guint16) (_tmp10_.green * G_MAXUINT16), (guint16) (_tmp11_.blue * G_MAXUINT16));
		pango_attr = _tmp12_;
		_tmp13_ = pango_attr;
		_tmp13_->start_index = (guint) 0;
		_tmp14_ = pango_attr;
		_tmp15_ = gtk_label_get_text (label);
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp14_->end_index = (guint) _tmp17_;
		_tmp18_ = attrs;
		_tmp19_ = pango_attr;
		pango_attr = NULL;
		pango_attr_list_insert (_tmp18_, _tmp19_);
		_pango_attribute_destroy0 (pango_attr);
	}
	_tmp20_ = attrs;
	gtk_label_set_attributes (label, _tmp20_);
	_g_object_unref0 (context);
	_pango_attr_list_unref0 (attrs);
}

void
candidate_panel_set_preedit_text (CandidatePanel* self,
                                  IBusText* text,
                                  guint cursor)
{
	g_return_if_fail (self != NULL);
	if (text != NULL) {
		gchar* str = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp0_ = ibus_text_get_text (text);
		_tmp1_ = g_strdup (_tmp0_);
		str = _tmp1_;
		_tmp2_ = str;
		_tmp3_ = strlen (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ > 0) {
			GtkLabel* _tmp5_;
			const gchar* _tmp6_;
			GtkLabel* _tmp7_;
			GtkLabel* _tmp8_;
			_tmp5_ = self->priv->m_preedit_label;
			_tmp6_ = str;
			gtk_label_set_text (_tmp5_, _tmp6_);
			_tmp7_ = self->priv->m_preedit_label;
			gtk_widget_show ((GtkWidget*) _tmp7_);
			_tmp8_ = self->priv->m_preedit_label;
			candidate_panel_set_attributes (self, _tmp8_, text);
		} else {
			GtkLabel* _tmp9_;
			GtkLabel* _tmp10_;
			_tmp9_ = self->priv->m_preedit_label;
			gtk_label_set_text (_tmp9_, "");
			_tmp10_ = self->priv->m_preedit_label;
			gtk_widget_hide ((GtkWidget*) _tmp10_);
		}
		_g_free0 (str);
	} else {
		GtkLabel* _tmp11_;
		GtkLabel* _tmp12_;
		_tmp11_ = self->priv->m_preedit_label;
		gtk_label_set_text (_tmp11_, "");
		_tmp12_ = self->priv->m_preedit_label;
		gtk_widget_hide ((GtkWidget*) _tmp12_);
	}
	candidate_panel_update (self);
}

void
candidate_panel_set_auxiliary_text (CandidatePanel* self,
                                    IBusText* text)
{
	g_return_if_fail (self != NULL);
	if (text != NULL) {
		GtkLabel* _tmp0_;
		const gchar* _tmp1_;
		PangoAttrList* attrs = NULL;
		PangoAttrList* _tmp2_;
		PangoAttrList* _tmp3_;
		PangoAttribute* _tmp4_;
		PangoAttribute* _tmp5_;
		GtkLabel* _tmp6_;
		PangoAttrList* _tmp7_;
		GtkLabel* _tmp8_;
		_tmp0_ = self->priv->m_aux_label;
		_tmp1_ = ibus_text_get_text (text);
		gtk_label_set_text (_tmp0_, _tmp1_);
		_tmp2_ = get_pango_attr_list_from_ibus_text (text);
		attrs = _tmp2_;
		_tmp3_ = attrs;
		_tmp4_ = self->priv->m_language_attribute;
		_tmp5_ = pango_attribute_copy (_tmp4_);
		pango_attr_list_change (_tmp3_, _tmp5_);
		_tmp6_ = self->priv->m_aux_label;
		_tmp7_ = attrs;
		gtk_label_set_attributes (_tmp6_, _tmp7_);
		_tmp8_ = self->priv->m_aux_label;
		gtk_widget_show ((GtkWidget*) _tmp8_);
		_pango_attr_list_unref0 (attrs);
	} else {
		GtkLabel* _tmp9_;
		GtkLabel* _tmp10_;
		_tmp9_ = self->priv->m_aux_label;
		gtk_label_set_text (_tmp9_, "");
		_tmp10_ = self->priv->m_aux_label;
		gtk_widget_hide ((GtkWidget*) _tmp10_);
	}
	candidate_panel_update (self);
}

static void
_vala_array_add9 (IBusText** * array,
                  gint* length,
                  gint* size,
                  IBusText* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusText*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add10 (IBusText** * array,
                   gint* length,
                   gint* size,
                   IBusText* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusText*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
candidate_panel_set_lookup_table (CandidatePanel* self,
                                  IBusLookupTable* table)
{
	IBusText** candidates = NULL;
	IBusText** _tmp0_;
	gint candidates_length1;
	gint _candidates_size_;
	guint cursor_in_page = 0U;
	gboolean show_cursor = FALSE;
	IBusText** labels = NULL;
	IBusText** _tmp1_;
	gint labels_length1;
	gint _labels_size_;
	IBusOrientation orientation = 0;
	CandidateArea* _tmp13_;
	IBusText** _tmp14_;
	gint _tmp14__length1;
	IBusText** _tmp15_;
	gint _tmp15__length1;
	IBusText** _tmp16_;
	gint _tmp16__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (IBusText*, 0 + 1);
	candidates = _tmp0_;
	candidates_length1 = 0;
	_candidates_size_ = candidates_length1;
	cursor_in_page = (guint) 0;
	show_cursor = TRUE;
	_tmp1_ = g_new0 (IBusText*, 0 + 1);
	labels = _tmp1_;
	labels_length1 = 0;
	_labels_size_ = labels_length1;
	orientation = IBUS_ORIENTATION_SYSTEM;
	if (table != NULL) {
		guint page_size = 0U;
		guint ncandidates = 0U;
		guint cursor = 0U;
		guint page_start_pos = 0U;
		guint page_end_pos = 0U;
		page_size = ibus_lookup_table_get_page_size (table);
		ncandidates = ibus_lookup_table_get_number_of_candidates (table);
		cursor = ibus_lookup_table_get_cursor_pos (table);
		cursor_in_page = ibus_lookup_table_get_cursor_in_page (table);
		show_cursor = ibus_lookup_table_is_cursor_visible (table);
		page_start_pos = (cursor / page_size) * page_size;
		page_end_pos = MIN (page_start_pos + page_size, ncandidates);
		{
			guint i = 0U;
			i = page_start_pos;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					IBusText* _tmp4_;
					IBusText* _tmp5_;
					if (!_tmp2_) {
						guint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					if (!(i < page_end_pos)) {
						break;
					}
					_tmp4_ = ibus_lookup_table_get_candidate (table, i);
					_tmp5_ = _g_object_ref0 (_tmp4_);
					_vala_array_add9 (&candidates, &candidates_length1, &_candidates_size_, _tmp5_);
				}
			}
		}
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					IBusText* label = NULL;
					IBusText* _tmp8_;
					IBusText* _tmp9_;
					IBusText* _tmp10_;
					if (!_tmp6_) {
						guint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					if (!(i < page_size)) {
						break;
					}
					_tmp8_ = ibus_lookup_table_get_label (table, i);
					_tmp9_ = _g_object_ref0 (_tmp8_);
					label = _tmp9_;
					_tmp10_ = label;
					if (_tmp10_ != NULL) {
						IBusText* _tmp11_;
						IBusText* _tmp12_;
						_tmp11_ = label;
						_tmp12_ = _g_object_ref0 (_tmp11_);
						_vala_array_add10 (&labels, &labels_length1, &_labels_size_, _tmp12_);
					}
					_g_object_unref0 (label);
				}
			}
		}
		orientation = (IBusOrientation) ibus_lookup_table_get_orientation (table);
	}
	_tmp13_ = self->priv->m_candidate_area;
	_tmp14_ = candidates;
	_tmp14__length1 = candidates_length1;
	candidate_area_set_candidates (_tmp13_, _tmp14_, (gint) _tmp14__length1, cursor_in_page, show_cursor);
	_tmp15_ = labels;
	_tmp15__length1 = labels_length1;
	candidate_panel_set_labels (self, _tmp15_, (gint) _tmp15__length1);
	if (table != NULL) {
		candidate_panel_set_orientation (self, orientation);
	}
	_tmp16_ = candidates;
	_tmp16__length1 = candidates_length1;
	if (_tmp16__length1 != 0) {
		CandidateArea* _tmp17_;
		_tmp17_ = self->priv->m_candidate_area;
		gtk_widget_show_all ((GtkWidget*) _tmp17_);
	} else {
		CandidateArea* _tmp18_;
		_tmp18_ = self->priv->m_candidate_area;
		gtk_widget_hide ((GtkWidget*) _tmp18_);
	}
	candidate_panel_update (self);
	labels = (_vala_array_free (labels, labels_length1, (GDestroyNotify) g_object_unref), NULL);
	candidates = (_vala_array_free (candidates, candidates_length1, (GDestroyNotify) g_object_unref), NULL);
}

void
candidate_panel_set_content_type (CandidatePanel* self,
                                  guint purpose,
                                  guint hints)
{
	g_return_if_fail (self != NULL);
	self->priv->m_vertical_writing = (hints & IBUS_INPUT_HINT_VERTICAL_WRITING) != ((guint) 0);
}

static void
candidate_panel_update (CandidatePanel* self)
{
	GtkWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	CandidateArea* _tmp3_;
	gboolean _tmp8_ = FALSE;
	GtkLabel* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_window_resize (_tmp0_, 1, 1);
	_tmp3_ = self->priv->m_candidate_area;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp3_)) {
		_tmp2_ = TRUE;
	} else {
		GtkLabel* _tmp4_;
		_tmp4_ = self->priv->m_preedit_label;
		_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _tmp4_);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GtkLabel* _tmp5_;
		_tmp5_ = self->priv->m_aux_label;
		_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp5_);
	}
	if (_tmp1_) {
		GtkWindow* _tmp6_;
		_tmp6_ = self->priv->m_toplevel;
		gtk_widget_show ((GtkWidget*) _tmp6_);
	} else {
		GtkWindow* _tmp7_;
		_tmp7_ = self->priv->m_toplevel;
		gtk_widget_hide ((GtkWidget*) _tmp7_);
	}
	_tmp9_ = self->priv->m_aux_label;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp9_)) {
		gboolean _tmp10_ = FALSE;
		CandidateArea* _tmp11_;
		_tmp11_ = self->priv->m_candidate_area;
		if (gtk_widget_get_visible ((GtkWidget*) _tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			GtkLabel* _tmp12_;
			_tmp12_ = self->priv->m_preedit_label;
			_tmp10_ = gtk_widget_get_visible ((GtkWidget*) _tmp12_);
		}
		_tmp8_ = _tmp10_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		HSeparator* _tmp13_;
		_tmp13_ = self->priv->m_hseparator;
		gtk_widget_show ((GtkWidget*) _tmp13_);
	} else {
		HSeparator* _tmp14_;
		_tmp14_ = self->priv->m_hseparator;
		gtk_widget_hide ((GtkWidget*) _tmp14_);
	}
}

static void
__lambda40_ (CandidatePanel* self,
             CandidateArea* w,
             guint i,
             guint b,
             guint s)
{
	g_return_if_fail (w != NULL);
	g_signal_emit (self, candidate_panel_signals[CANDIDATE_PANEL_CANDIDATE_CLICKED_SIGNAL], 0, i, b, s);
}

static void
___lambda40__candidate_area_candidate_clicked (CandidateArea* _sender,
                                               guint index,
                                               guint button,
                                               guint state,
                                               gpointer self)
{
	__lambda40_ ((CandidatePanel*) self, _sender, index, button, state);
}

static void
__lambda41_ (CandidatePanel* self,
             CandidateArea* c)
{
	g_return_if_fail (c != NULL);
	g_signal_emit (self, candidate_panel_signals[CANDIDATE_PANEL_PAGE_UP_SIGNAL], 0);
}

static void
___lambda41__candidate_area_page_up (CandidateArea* _sender,
                                     gpointer self)
{
	__lambda41_ ((CandidatePanel*) self, _sender);
}

static void
__lambda42_ (CandidatePanel* self,
             CandidateArea* c)
{
	g_return_if_fail (c != NULL);
	g_signal_emit (self, candidate_panel_signals[CANDIDATE_PANEL_PAGE_DOWN_SIGNAL], 0);
}

static void
___lambda42__candidate_area_page_down (CandidateArea* _sender,
                                       gpointer self)
{
	__lambda42_ ((CandidatePanel*) self, _sender);
}

static void
__lambda43_ (CandidatePanel* self,
             CandidateArea* c)
{
	g_return_if_fail (c != NULL);
	g_signal_emit (self, candidate_panel_signals[CANDIDATE_PANEL_CURSOR_UP_SIGNAL], 0);
}

static void
___lambda43__candidate_area_cursor_up (CandidateArea* _sender,
                                       gpointer self)
{
	__lambda43_ ((CandidatePanel*) self, _sender);
}

static void
__lambda44_ (CandidatePanel* self,
             CandidateArea* c)
{
	g_return_if_fail (c != NULL);
	g_signal_emit (self, candidate_panel_signals[CANDIDATE_PANEL_CURSOR_DOWN_SIGNAL], 0);
}

static void
___lambda44__candidate_area_cursor_down (CandidateArea* _sender,
                                         gpointer self)
{
	__lambda44_ ((CandidatePanel*) self, _sender);
}

static void
candidate_panel_create_ui (CandidatePanel* self)
{
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	CandidateArea* _tmp14_;
	CandidateArea* _tmp15_;
	CandidateArea* _tmp16_;
	CandidateArea* _tmp17_;
	CandidateArea* _tmp18_;
	CandidateArea* _tmp19_;
	HSeparator* _tmp20_;
	HSeparator* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_preedit_label);
	self->priv->m_preedit_label = _tmp0_;
	_tmp1_ = self->priv->m_preedit_label;
	gtk_widget_set_size_request ((GtkWidget*) _tmp1_, 20, -1);
	_tmp2_ = self->priv->m_preedit_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_START);
	_tmp3_ = self->priv->m_preedit_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
	_tmp4_ = self->priv->m_preedit_label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, 8);
	_tmp5_ = self->priv->m_preedit_label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp5_, 8);
	_tmp6_ = self->priv->m_preedit_label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp6_, TRUE);
	_tmp7_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->m_aux_label);
	self->priv->m_aux_label = _tmp7_;
	_tmp8_ = self->priv->m_aux_label;
	gtk_widget_set_size_request ((GtkWidget*) _tmp8_, 20, -1);
	_tmp9_ = self->priv->m_aux_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_START);
	_tmp10_ = self->priv->m_aux_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp10_, GTK_ALIGN_CENTER);
	_tmp11_ = self->priv->m_aux_label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp11_, 8);
	_tmp12_ = self->priv->m_aux_label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp12_, 8);
	_tmp13_ = self->priv->m_aux_label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp13_, TRUE);
	_tmp14_ = candidate_area_new (self->priv->m_vertical_panel_system);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->m_candidate_area);
	self->priv->m_candidate_area = _tmp14_;
	_tmp15_ = self->priv->m_candidate_area;
	g_signal_connect_object (_tmp15_, "candidate-clicked", (GCallback) ___lambda40__candidate_area_candidate_clicked, self, 0);
	_tmp16_ = self->priv->m_candidate_area;
	g_signal_connect_object (_tmp16_, "page-up", (GCallback) ___lambda41__candidate_area_page_up, self, 0);
	_tmp17_ = self->priv->m_candidate_area;
	g_signal_connect_object (_tmp17_, "page-down", (GCallback) ___lambda42__candidate_area_page_down, self, 0);
	_tmp18_ = self->priv->m_candidate_area;
	g_signal_connect_object (_tmp18_, "cursor-up", (GCallback) ___lambda43__candidate_area_cursor_up, self, 0);
	_tmp19_ = self->priv->m_candidate_area;
	g_signal_connect_object (_tmp19_, "cursor-down", (GCallback) ___lambda44__candidate_area_cursor_down, self, 0);
	_tmp20_ = hseparator_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->m_hseparator);
	self->priv->m_hseparator = _tmp20_;
	_tmp21_ = self->priv->m_hseparator;
	gtk_widget_set_visible ((GtkWidget*) _tmp21_, TRUE);
	candidate_panel_pack_all_widgets (self);
}

static void
candidate_panel_pack_all_widgets (CandidatePanel* self)
{
	GtkBox* _tmp0_;
	GtkLabel* _tmp1_;
	GtkBox* _tmp2_;
	GtkLabel* _tmp3_;
	GtkBox* _tmp4_;
	HSeparator* _tmp5_;
	GtkBox* _tmp6_;
	CandidateArea* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_vbox;
	_tmp1_ = self->priv->m_preedit_label;
	gtk_box_pack_start (_tmp0_, (GtkWidget*) _tmp1_, FALSE, FALSE, (guint) 4);
	_tmp2_ = self->priv->m_vbox;
	_tmp3_ = self->priv->m_aux_label;
	gtk_box_pack_start (_tmp2_, (GtkWidget*) _tmp3_, FALSE, FALSE, (guint) 4);
	_tmp4_ = self->priv->m_vbox;
	_tmp5_ = self->priv->m_hseparator;
	gtk_box_pack_start (_tmp4_, (GtkWidget*) _tmp5_, FALSE, FALSE, (guint) 0);
	_tmp6_ = self->priv->m_vbox;
	_tmp7_ = self->priv->m_candidate_area;
	gtk_box_pack_start (_tmp6_, (GtkWidget*) _tmp7_, FALSE, FALSE, (guint) 0);
}

void
candidate_panel_show (CandidatePanel* self)
{
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
}

void
candidate_panel_hide (CandidatePanel* self)
{
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}

static void
candidate_panel_move (CandidatePanel* self,
                      gint x,
                      gint y)
{
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_window_move (_tmp0_, x, y);
}

static void
candidate_panel_adjust_window_position (CandidatePanel* self,
                                        GtkWidget* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (!self->priv->m_vertical_writing) {
		candidate_panel_adjust_window_position_horizontal (self, window);
	} else {
		candidate_panel_adjust_window_position_vertical (self, window);
	}
}

static void
candidate_panel_get_monitor_geometry (CandidatePanel* self,
                                      GtkWidget* window,
                                      GdkRectangle* result)
{
	GdkRectangle monitor_area = {0};
	GdkRectangle _tmp0_ = {0};
	GdkMonitor* monitor = NULL;
	GdkDisplay* _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkMonitor* _tmp4_;
	GdkMonitor* _tmp5_;
	GdkRectangle _tmp6_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_.x = 0;
	monitor_area = _tmp0_;
	_tmp1_ = gtk_widget_get_display (window);
	_tmp2_ = self->priv->m_cursor_location;
	_tmp3_ = self->priv->m_cursor_location;
	_tmp4_ = gdk_display_get_monitor_at_point (_tmp1_, _tmp2_.x, _tmp3_.y);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	monitor = _tmp5_;
	gdk_monitor_get_geometry (monitor, &_tmp6_);
	monitor_area = _tmp6_;
	*result = monitor_area;
	_g_object_unref0 (monitor);
	return;
}

static void
candidate_panel_adjust_window_position_horizontal (CandidatePanel* self,
                                                   GtkWidget* window)
{
	GdkPoint cursor_right_bottom = {0};
	GdkRectangle _tmp0_;
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkPoint _tmp3_ = {0};
	GtkAllocation allocation = {0};
	GtkWindow* _tmp4_;
	GtkAllocation _tmp5_ = {0};
	GdkPoint window_right_bottom = {0};
	GdkPoint _tmp6_;
	GtkAllocation _tmp7_;
	GdkPoint _tmp8_;
	GtkAllocation _tmp9_;
	GdkPoint _tmp10_ = {0};
	GdkRectangle monitor_area = {0};
	GdkRectangle _tmp11_ = {0};
	gint monitor_right = 0;
	GdkRectangle _tmp12_;
	GdkRectangle _tmp13_;
	gint monitor_bottom = 0;
	GdkRectangle _tmp14_;
	GdkRectangle _tmp15_;
	gint x = 0;
	gint y = 0;
	GdkPoint _tmp16_;
	GdkPoint _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->m_cursor_location;
	_tmp1_ = self->priv->m_cursor_location;
	_tmp2_ = self->priv->m_cursor_location;
	_tmp3_.x = _tmp0_.x;
	_tmp3_.y = _tmp1_.y + _tmp2_.height;
	cursor_right_bottom = _tmp3_;
	_tmp4_ = self->priv->m_toplevel;
	gtk_widget_get_allocation ((GtkWidget*) _tmp4_, &_tmp5_);
	allocation = _tmp5_;
	_tmp6_ = cursor_right_bottom;
	_tmp7_ = allocation;
	_tmp8_ = cursor_right_bottom;
	_tmp9_ = allocation;
	_tmp10_.x = _tmp6_.x + _tmp7_.width;
	_tmp10_.y = _tmp8_.y + _tmp9_.height;
	window_right_bottom = _tmp10_;
	candidate_panel_get_monitor_geometry (self, window, &_tmp11_);
	monitor_area = _tmp11_;
	_tmp12_ = monitor_area;
	_tmp13_ = monitor_area;
	monitor_right = _tmp12_.x + _tmp13_.width;
	_tmp14_ = monitor_area;
	_tmp15_ = monitor_area;
	monitor_bottom = _tmp14_.y + _tmp15_.height;
	_tmp16_ = window_right_bottom;
	if (_tmp16_.x > monitor_right) {
		GtkAllocation _tmp17_;
		_tmp17_ = allocation;
		x = monitor_right - _tmp17_.width;
	} else {
		GdkPoint _tmp18_;
		_tmp18_ = cursor_right_bottom;
		x = _tmp18_.x;
	}
	if (x < 0) {
		x = 0;
	}
	_tmp19_ = window_right_bottom;
	if (_tmp19_.y > monitor_bottom) {
		GdkRectangle _tmp20_;
		GtkAllocation _tmp21_;
		_tmp20_ = self->priv->m_cursor_location;
		_tmp21_ = allocation;
		y = _tmp20_.y - _tmp21_.height;
	} else {
		GdkPoint _tmp22_;
		_tmp22_ = cursor_right_bottom;
		y = _tmp22_.y;
	}
	if (y < 0) {
		y = 0;
	}
	candidate_panel_move (self, x, y);
}

static void
candidate_panel_adjust_window_position_vertical (CandidatePanel* self,
                                                 GtkWidget* window)
{
	gint char_size = 0;
	GdkRectangle _tmp0_;
	GdkRectangle _tmp1_;
	GdkPoint cursor_right_bottom = {0};
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkPoint _tmp4_ = {0};
	GtkAllocation allocation = {0};
	GtkWindow* _tmp5_;
	GtkAllocation _tmp6_ = {0};
	GdkPoint hwindow_right_bottom = {0};
	GdkRectangle _tmp7_;
	GtkAllocation _tmp8_;
	GdkPoint _tmp9_;
	GtkAllocation _tmp10_;
	GdkPoint _tmp11_ = {0};
	GdkPoint vwindow_left_bottom = {0};
	GdkRectangle _tmp12_;
	GtkAllocation _tmp13_;
	GdkRectangle _tmp14_;
	GtkAllocation _tmp15_;
	GdkPoint _tmp16_ = {0};
	GdkRectangle monitor_area = {0};
	GdkRectangle _tmp17_ = {0};
	gint monitor_right = 0;
	GdkRectangle _tmp18_;
	GdkRectangle _tmp19_;
	gint monitor_bottom = 0;
	GdkRectangle _tmp20_;
	GdkRectangle _tmp21_;
	gint x = 0;
	gint y = 0;
	CandidateArea* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->m_cursor_location;
	_tmp1_ = self->priv->m_cursor_location;
	char_size = MAX (_tmp0_.width, _tmp1_.height);
	_tmp2_ = self->priv->m_cursor_location;
	_tmp3_ = self->priv->m_cursor_location;
	_tmp4_.x = _tmp2_.x + char_size;
	_tmp4_.y = _tmp3_.y + char_size;
	cursor_right_bottom = _tmp4_;
	_tmp5_ = self->priv->m_toplevel;
	gtk_widget_get_allocation ((GtkWidget*) _tmp5_, &_tmp6_);
	allocation = _tmp6_;
	_tmp7_ = self->priv->m_cursor_location;
	_tmp8_ = allocation;
	_tmp9_ = cursor_right_bottom;
	_tmp10_ = allocation;
	_tmp11_.x = _tmp7_.x + _tmp8_.width;
	_tmp11_.y = _tmp9_.y + _tmp10_.height;
	hwindow_right_bottom = _tmp11_;
	_tmp12_ = self->priv->m_cursor_location;
	_tmp13_ = allocation;
	_tmp14_ = self->priv->m_cursor_location;
	_tmp15_ = allocation;
	_tmp16_.x = _tmp12_.x - _tmp13_.width;
	_tmp16_.y = _tmp14_.y + _tmp15_.height;
	vwindow_left_bottom = _tmp16_;
	candidate_panel_get_monitor_geometry (self, window, &_tmp17_);
	monitor_area = _tmp17_;
	_tmp18_ = monitor_area;
	_tmp19_ = monitor_area;
	monitor_right = _tmp18_.x + _tmp19_.width;
	_tmp20_ = monitor_area;
	_tmp21_ = monitor_area;
	monitor_bottom = _tmp20_.y + _tmp21_.height;
	_tmp22_ = self->priv->m_candidate_area;
	if (!candidate_area_get_vertical (_tmp22_)) {
		GdkPoint _tmp23_;
		GdkPoint _tmp26_;
		_tmp23_ = hwindow_right_bottom;
		if (_tmp23_.x > monitor_right) {
			GtkAllocation _tmp24_;
			_tmp24_ = allocation;
			x = monitor_right - _tmp24_.width;
		} else {
			GdkRectangle _tmp25_;
			_tmp25_ = self->priv->m_cursor_location;
			x = _tmp25_.x;
		}
		_tmp26_ = hwindow_right_bottom;
		if (_tmp26_.y > monitor_bottom) {
			GdkRectangle _tmp27_;
			GtkAllocation _tmp28_;
			_tmp27_ = self->priv->m_cursor_location;
			_tmp28_ = allocation;
			y = _tmp27_.y - _tmp28_.height;
		} else {
			GdkPoint _tmp29_;
			_tmp29_ = cursor_right_bottom;
			y = _tmp29_.y;
		}
	} else {
		GdkPoint _tmp30_;
		GdkPoint _tmp35_;
		_tmp30_ = vwindow_left_bottom;
		if (_tmp30_.x > monitor_right) {
			GtkAllocation _tmp31_;
			_tmp31_ = allocation;
			x = monitor_right - _tmp31_.width;
		} else {
			GdkPoint _tmp32_;
			_tmp32_ = vwindow_left_bottom;
			if (_tmp32_.x < 0) {
				GdkPoint _tmp33_;
				_tmp33_ = cursor_right_bottom;
				x = _tmp33_.x;
			} else {
				GdkPoint _tmp34_;
				_tmp34_ = vwindow_left_bottom;
				x = _tmp34_.x;
			}
		}
		_tmp35_ = vwindow_left_bottom;
		if (_tmp35_.y > monitor_bottom) {
			GtkAllocation _tmp36_;
			_tmp36_ = allocation;
			y = monitor_bottom - _tmp36_.height;
		} else {
			GdkRectangle _tmp37_;
			_tmp37_ = self->priv->m_cursor_location;
			y = _tmp37_.y;
		}
	}
	if (x < 0) {
		x = 0;
	}
	if (y < 0) {
		y = 0;
	}
	candidate_panel_move (self, x, y);
}

static void
candidate_panel_realize_window (CandidatePanel* self,
                                gboolean initial)
{
	GdkWindow* window = NULL;
	GtkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	GdkWindow* _tmp3_;
	GType instance_type = 0UL;
	GdkWindow* _tmp4_;
	GType wayland_type = 0UL;
	void* surface = NULL;
	GdkWindow* _tmp6_;
	void* _tmp7_;
	void* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	window = _tmp2_;
	_tmp3_ = window;
	if (!gdk_window_ensure_native (_tmp3_)) {
		g_warning ("candidatepanel.vala:447: No native window.");
		_g_object_unref0 (window);
		return;
	}
	_tmp4_ = window;
	instance_type = G_TYPE_FROM_INSTANCE ((GObject*) _tmp4_);
	wayland_type = gdk_wayland_window_get_type ();
	if (!g_type_is_a (instance_type, wayland_type)) {
		g_warning ("candidatepanel.vala:453: Not GdkWindowWayland.");
		_g_object_unref0 (window);
		return;
	}
	if (initial) {
		GdkWindow* _tmp5_;
		_tmp5_ = window;
		gdk_wayland_window_set_use_custom_surface (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gdk_wayland_window_get_type (), GdkWaylandWindow));
	}
	_tmp6_ = window;
	_tmp7_ = gdk_wayland_window_get_wl_surface (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gdk_wayland_window_get_type (), GdkWaylandWindow));
	surface = _tmp7_;
	_tmp8_ = surface;
	g_signal_emit (self, candidate_panel_signals[CANDIDATE_PANEL_REALIZE_SURFACE_SIGNAL], 0, _tmp8_);
	_g_object_unref0 (window);
}

static void
g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), data2);
}

static void
candidate_panel_class_init (CandidatePanelClass * klass,
                            gpointer klass_data)
{
	candidate_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CandidatePanel_private_offset);
	G_OBJECT_CLASS (klass)->finalize = candidate_panel_finalize;
	candidate_panel_signals[CANDIDATE_PANEL_CURSOR_UP_SIGNAL] = g_signal_new ("cursor-up", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	candidate_panel_signals[CANDIDATE_PANEL_CURSOR_DOWN_SIGNAL] = g_signal_new ("cursor-down", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	candidate_panel_signals[CANDIDATE_PANEL_PAGE_UP_SIGNAL] = g_signal_new ("page-up", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	candidate_panel_signals[CANDIDATE_PANEL_PAGE_DOWN_SIGNAL] = g_signal_new ("page-down", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	candidate_panel_signals[CANDIDATE_PANEL_CANDIDATE_CLICKED_SIGNAL] = g_signal_new ("candidate-clicked", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_UINT, G_TYPE_NONE, 3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);
	candidate_panel_signals[CANDIDATE_PANEL_REALIZE_SURFACE_SIGNAL] = g_signal_new ("realize-surface", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
}

static void
candidate_panel_instance_init (CandidatePanel * self,
                               gpointer klass)
{
	self->priv = candidate_panel_get_instance_private (self);
	self->priv->m_vertical_panel_system = TRUE;
}

static void
candidate_panel_finalize (GObject * obj)
{
	CandidatePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CANDIDATE_PANEL, CandidatePanel);
	_g_object_unref0 (self->priv->m_toplevel);
	_g_object_unref0 (self->priv->m_vbox);
	_g_object_unref0 (self->priv->m_preedit_label);
	_g_object_unref0 (self->priv->m_aux_label);
	_g_object_unref0 (self->priv->m_candidate_area);
	_g_object_unref0 (self->priv->m_hseparator);
	_pango_attribute_destroy0 (self->priv->m_language_attribute);
	G_OBJECT_CLASS (candidate_panel_parent_class)->finalize (obj);
}

static GType
candidate_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CandidatePanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) candidate_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CandidatePanel), 0, (GInstanceInitFunc) candidate_panel_instance_init, NULL };
	GType candidate_panel_type_id;
	candidate_panel_type_id = g_type_register_static (gtk_box_get_type (), "CandidatePanel", &g_define_type_info, 0);
	CandidatePanel_private_offset = g_type_add_instance_private (candidate_panel_type_id, sizeof (CandidatePanelPrivate));
	return candidate_panel_type_id;
}

GType
candidate_panel_get_type (void)
{
	static volatile gsize candidate_panel_type_id__once = 0;
	if (g_once_init_enter (&candidate_panel_type_id__once)) {
		GType candidate_panel_type_id;
		candidate_panel_type_id = candidate_panel_get_type_once ();
		g_once_init_leave (&candidate_panel_type_id__once, candidate_panel_type_id);
	}
	return candidate_panel_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

