const ffs = @import("count0bits.zig");
const testing = @import("std").testing;

fn test__ffssi2(a: u32, expected: i32) !void {
    const x = @as(i32, @bitCast(a));
    const result = ffs.__ffssi2(x);
    try testing.expectEqual(expected, result);
}

test "ffssi2" {
    try test__ffssi2(0x00000001, 1);
    try test__ffssi2(0x00000002, 2);
    try test__ffssi2(0x00000003, 1);
    try test__ffssi2(0x00000004, 3);
    try test__ffssi2(0x00000005, 1);
    try test__ffssi2(0x00000006, 2);
    try test__ffssi2(0x00000007, 1);
    try test__ffssi2(0x00000008, 4);
    try test__ffssi2(0x00000009, 1);
    try test__ffssi2(0x0000000A, 2);
    try test__ffssi2(0x0000000B, 1);
    try test__ffssi2(0x0000000C, 3);
    try test__ffssi2(0x0000000D, 1);
    try test__ffssi2(0x0000000E, 2);
    try test__ffssi2(0x0000000F, 1);
    try test__ffssi2(0x00000010, 5);
    try test__ffssi2(0x00000011, 1);
    try test__ffssi2(0x00000012, 2);
    try test__ffssi2(0x00000013, 1);
    try test__ffssi2(0x00000014, 3);
    try test__ffssi2(0x00000015, 1);
    try test__ffssi2(0x00000016, 2);
    try test__ffssi2(0x00000017, 1);
    try test__ffssi2(0x00000018, 4);
    try test__ffssi2(0x00000019, 1);
    try test__ffssi2(0x0000001A, 2);
    try test__ffssi2(0x0000001B, 1);
    try test__ffssi2(0x0000001C, 3);
    try test__ffssi2(0x0000001D, 1);
    try test__ffssi2(0x0000001E, 2);
    try test__ffssi2(0x0000001F, 1);
    try test__ffssi2(0x00000020, 6);
    try test__ffssi2(0x00000021, 1);
    try test__ffssi2(0x00000022, 2);
    try test__ffssi2(0x00000023, 1);
    try test__ffssi2(0x00000024, 3);
    try test__ffssi2(0x00000025, 1);
    try test__ffssi2(0x00000026, 2);
    try test__ffssi2(0x00000027, 1);
    try test__ffssi2(0x00000028, 4);
    try test__ffssi2(0x00000029, 1);
    try test__ffssi2(0x0000002A, 2);
    try test__ffssi2(0x0000002B, 1);
    try test__ffssi2(0x0000002C, 3);
    try test__ffssi2(0x0000002D, 1);
    try test__ffssi2(0x0000002E, 2);
    try test__ffssi2(0x0000002F, 1);
    try test__ffssi2(0x00000030, 5);
    try test__ffssi2(0x00000031, 1);
    try test__ffssi2(0x00000032, 2);
    try test__ffssi2(0x00000033, 1);
    try test__ffssi2(0x00000034, 3);
    try test__ffssi2(0x00000035, 1);
    try test__ffssi2(0x00000036, 2);
    try test__ffssi2(0x00000037, 1);
    try test__ffssi2(0x00000038, 4);
    try test__ffssi2(0x00000039, 1);
    try test__ffssi2(0x0000003A, 2);
    try test__ffssi2(0x0000003B, 1);
    try test__ffssi2(0x0000003C, 3);
    try test__ffssi2(0x0000003D, 1);
    try test__ffssi2(0x0000003E, 2);
    try test__ffssi2(0x0000003F, 1);
    try test__ffssi2(0x00000040, 7);
    try test__ffssi2(0x00000041, 1);
    try test__ffssi2(0x00000042, 2);
    try test__ffssi2(0x00000043, 1);
    try test__ffssi2(0x00000044, 3);
    try test__ffssi2(0x00000045, 1);
    try test__ffssi2(0x00000046, 2);
    try test__ffssi2(0x00000047, 1);
    try test__ffssi2(0x00000048, 4);
    try test__ffssi2(0x00000049, 1);
    try test__ffssi2(0x0000004A, 2);
    try test__ffssi2(0x0000004B, 1);
    try test__ffssi2(0x0000004C, 3);
    try test__ffssi2(0x0000004D, 1);
    try test__ffssi2(0x0000004E, 2);
    try test__ffssi2(0x0000004F, 1);
    try test__ffssi2(0x00000050, 5);
    try test__ffssi2(0x00000051, 1);
    try test__ffssi2(0x00000052, 2);
    try test__ffssi2(0x00000053, 1);
    try test__ffssi2(0x00000054, 3);
    try test__ffssi2(0x00000055, 1);
    try test__ffssi2(0x00000056, 2);
    try test__ffssi2(0x00000057, 1);
    try test__ffssi2(0x00000058, 4);
    try test__ffssi2(0x00000059, 1);
    try test__ffssi2(0x0000005A, 2);
    try test__ffssi2(0x0000005B, 1);
    try test__ffssi2(0x0000005C, 3);
    try test__ffssi2(0x0000005D, 1);
    try test__ffssi2(0x0000005E, 2);
    try test__ffssi2(0x0000005F, 1);
    try test__ffssi2(0x00000060, 6);
    try test__ffssi2(0x00000061, 1);
    try test__ffssi2(0x00000062, 2);
    try test__ffssi2(0x00000063, 1);
    try test__ffssi2(0x00000064, 3);
    try test__ffssi2(0x00000065, 1);
    try test__ffssi2(0x00000066, 2);
    try test__ffssi2(0x00000067, 1);
    try test__ffssi2(0x00000068, 4);
    try test__ffssi2(0x00000069, 1);
    try test__ffssi2(0x0000006A, 2);
    try test__ffssi2(0x0000006B, 1);
    try test__ffssi2(0x0000006C, 3);
    try test__ffssi2(0x0000006D, 1);
    try test__ffssi2(0x0000006E, 2);
    try test__ffssi2(0x0000006F, 1);
    try test__ffssi2(0x00000070, 5);
    try test__ffssi2(0x00000071, 1);
    try test__ffssi2(0x00000072, 2);
    try test__ffssi2(0x00000073, 1);
    try test__ffssi2(0x00000074, 3);
    try test__ffssi2(0x00000075, 1);
    try test__ffssi2(0x00000076, 2);
    try test__ffssi2(0x00000077, 1);
    try test__ffssi2(0x00000078, 4);
    try test__ffssi2(0x00000079, 1);
    try test__ffssi2(0x0000007A, 2);
    try test__ffssi2(0x0000007B, 1);
    try test__ffssi2(0x0000007C, 3);
    try test__ffssi2(0x0000007D, 1);
    try test__ffssi2(0x0000007E, 2);
    try test__ffssi2(0x0000007F, 1);
    try test__ffssi2(0x00000080, 8);
    try test__ffssi2(0x00000081, 1);
    try test__ffssi2(0x00000082, 2);
    try test__ffssi2(0x00000083, 1);
    try test__ffssi2(0x00000084, 3);
    try test__ffssi2(0x00000085, 1);
    try test__ffssi2(0x00000086, 2);
    try test__ffssi2(0x00000087, 1);
    try test__ffssi2(0x00000088, 4);
    try test__ffssi2(0x00000089, 1);
    try test__ffssi2(0x0000008A, 2);
    try test__ffssi2(0x0000008B, 1);
    try test__ffssi2(0x0000008C, 3);
    try test__ffssi2(0x0000008D, 1);
    try test__ffssi2(0x0000008E, 2);
    try test__ffssi2(0x0000008F, 1);
    try test__ffssi2(0x00000090, 5);
    try test__ffssi2(0x00000091, 1);
    try test__ffssi2(0x00000092, 2);
    try test__ffssi2(0x00000093, 1);
    try test__ffssi2(0x00000094, 3);
    try test__ffssi2(0x00000095, 1);
    try test__ffssi2(0x00000096, 2);
    try test__ffssi2(0x00000097, 1);
    try test__ffssi2(0x00000098, 4);
    try test__ffssi2(0x00000099, 1);
    try test__ffssi2(0x0000009A, 2);
    try test__ffssi2(0x0000009B, 1);
    try test__ffssi2(0x0000009C, 3);
    try test__ffssi2(0x0000009D, 1);
    try test__ffssi2(0x0000009E, 2);
    try test__ffssi2(0x0000009F, 1);
    try test__ffssi2(0x000000A0, 6);
    try test__ffssi2(0x000000A1, 1);
    try test__ffssi2(0x000000A2, 2);
    try test__ffssi2(0x000000A3, 1);
    try test__ffssi2(0x000000A4, 3);
    try test__ffssi2(0x000000A5, 1);
    try test__ffssi2(0x000000A6, 2);
    try test__ffssi2(0x000000A7, 1);
    try test__ffssi2(0x000000A8, 4);
    try test__ffssi2(0x000000A9, 1);
    try test__ffssi2(0x000000AA, 2);
    try test__ffssi2(0x000000AB, 1);
    try test__ffssi2(0x000000AC, 3);
    try test__ffssi2(0x000000AD, 1);
    try test__ffssi2(0x000000AE, 2);
    try test__ffssi2(0x000000AF, 1);
    try test__ffssi2(0x000000B0, 5);
    try test__ffssi2(0x000000B1, 1);
    try test__ffssi2(0x000000B2, 2);
    try test__ffssi2(0x000000B3, 1);
    try test__ffssi2(0x000000B4, 3);
    try test__ffssi2(0x000000B5, 1);
    try test__ffssi2(0x000000B6, 2);
    try test__ffssi2(0x000000B7, 1);
    try test__ffssi2(0x000000B8, 4);
    try test__ffssi2(0x000000B9, 1);
    try test__ffssi2(0x000000BA, 2);
    try test__ffssi2(0x000000BB, 1);
    try test__ffssi2(0x000000BC, 3);
    try test__ffssi2(0x000000BD, 1);
    try test__ffssi2(0x000000BE, 2);
    try test__ffssi2(0x000000BF, 1);
    try test__ffssi2(0x000000C0, 7);
    try test__ffssi2(0x000000C1, 1);
    try test__ffssi2(0x000000C2, 2);
    try test__ffssi2(0x000000C3, 1);
    try test__ffssi2(0x000000C4, 3);
    try test__ffssi2(0x000000C5, 1);
    try test__ffssi2(0x000000C6, 2);
    try test__ffssi2(0x000000C7, 1);
    try test__ffssi2(0x000000C8, 4);
    try test__ffssi2(0x000000C9, 1);
    try test__ffssi2(0x000000CA, 2);
    try test__ffssi2(0x000000CB, 1);
    try test__ffssi2(0x000000CC, 3);
    try test__ffssi2(0x000000CD, 1);
    try test__ffssi2(0x000000CE, 2);
    try test__ffssi2(0x000000CF, 1);
    try test__ffssi2(0x000000D0, 5);
    try test__ffssi2(0x000000D1, 1);
    try test__ffssi2(0x000000D2, 2);
    try test__ffssi2(0x000000D3, 1);
    try test__ffssi2(0x000000D4, 3);
    try test__ffssi2(0x000000D5, 1);
    try test__ffssi2(0x000000D6, 2);
    try test__ffssi2(0x000000D7, 1);
    try test__ffssi2(0x000000D8, 4);
    try test__ffssi2(0x000000D9, 1);
    try test__ffssi2(0x000000DA, 2);
    try test__ffssi2(0x000000DB, 1);
    try test__ffssi2(0x000000DC, 3);
    try test__ffssi2(0x000000DD, 1);
    try test__ffssi2(0x000000DE, 2);
    try test__ffssi2(0x000000DF, 1);
    try test__ffssi2(0x000000E0, 6);
    try test__ffssi2(0x000000E1, 1);
    try test__ffssi2(0x000000E2, 2);
    try test__ffssi2(0x000000E3, 1);
    try test__ffssi2(0x000000E4, 3);
    try test__ffssi2(0x000000E5, 1);
    try test__ffssi2(0x000000E6, 2);
    try test__ffssi2(0x000000E7, 1);
    try test__ffssi2(0x000000E8, 4);
    try test__ffssi2(0x000000E9, 1);
    try test__ffssi2(0x000000EA, 2);
    try test__ffssi2(0x000000EB, 1);
    try test__ffssi2(0x000000EC, 3);
    try test__ffssi2(0x000000ED, 1);
    try test__ffssi2(0x000000EE, 2);
    try test__ffssi2(0x000000EF, 1);
    try test__ffssi2(0x000000F0, 5);
    try test__ffssi2(0x000000F1, 1);
    try test__ffssi2(0x000000F2, 2);
    try test__ffssi2(0x000000F3, 1);
    try test__ffssi2(0x000000F4, 3);
    try test__ffssi2(0x000000F5, 1);
    try test__ffssi2(0x000000F6, 2);
    try test__ffssi2(0x000000F7, 1);
    try test__ffssi2(0x000000F8, 4);
    try test__ffssi2(0x000000F9, 1);
    try test__ffssi2(0x000000FA, 2);
    try test__ffssi2(0x000000FB, 1);
    try test__ffssi2(0x000000FC, 3);
    try test__ffssi2(0x000000FD, 1);
    try test__ffssi2(0x000000FE, 2);
    try test__ffssi2(0x000000FF, 1);

    try test__ffssi2(0x00000000, 0);
    try test__ffssi2(0x80000000, 32);
    try test__ffssi2(0x40000000, 31);
    try test__ffssi2(0x20000000, 30);
    try test__ffssi2(0x10000000, 29);
    try test__ffssi2(0x08000000, 28);
    try test__ffssi2(0x04000000, 27);
    try test__ffssi2(0x02000000, 26);
    try test__ffssi2(0x01000000, 25);
    try test__ffssi2(0x00800000, 24);
    try test__ffssi2(0x00400000, 23);
    try test__ffssi2(0x00200000, 22);
    try test__ffssi2(0x00100000, 21);
    try test__ffssi2(0x00080000, 20);
    try test__ffssi2(0x00040000, 19);
    try test__ffssi2(0x00020000, 18);
    try test__ffssi2(0x00010000, 17);
    try test__ffssi2(0x00008000, 16);
    try test__ffssi2(0x00004000, 15);
    try test__ffssi2(0x00002000, 14);
    try test__ffssi2(0x00001000, 13);
    try test__ffssi2(0x00000800, 12);
    try test__ffssi2(0x00000400, 11);
    try test__ffssi2(0x00000200, 10);
    try test__ffssi2(0x00000100, 9);
}
