/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.awt;

import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.InputObject;
import edu.hws.jcm.awt.JCMError;
import edu.hws.jcm.awt.Tie;
import edu.hws.jcm.awt.Tieable;
import edu.hws.jcm.data.Constant;
import edu.hws.jcm.data.Parser;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.data.Variable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;

public class VariableSlider
extends Scrollbar
implements InputObject,
Tieable,
Value {
    protected VS variable;
    protected Value min;
    protected Value max;
    private Controller onUserAction;
    protected boolean integerValued;
    protected int intervals;
    protected long serialNumber;
    protected boolean needsValueCheck;
    protected int oldPosition;
    protected double minVal = Double.NaN;
    protected double maxVal;

    public VariableSlider() {
        this(null, null, null, null);
    }

    public VariableSlider(Value value, Value value2) {
        this(null, value, value2, null);
    }

    public VariableSlider(String string, Value value, Value value2, Parser parser) {
        this(string, value, value2, parser, -1, 0);
    }

    public VariableSlider(String string, Value value, Value value2, Parser parser, int n, int n2) {
        super(n2);
        this.setBackground(Color.lightGray);
        this.setMin(value);
        this.setMax(value2);
        if (n <= 0) {
            n = 1000;
        }
        if (n <= 10) {
            n = 10;
        }
        this.intervals = n;
        int n3 = n / 50 + 3;
        if (n < 100) {
            this.setBlockIncrement(1);
        } else {
            this.setBlockIncrement(n / 100);
        }
        this.setValues(n / 2, n3, 0, n + n3);
        this.variable = new VS(string);
        if (string != null) {
            super.setName(string);
        }
        if (parser != null && string != null) {
            parser.add(this.variable);
        }
        this.needsValueCheck = true;
        this.oldPosition = -1;
        this.getVal();
    }

    public void setName(String string) {
        this.variable.setName(string);
        if (string != null) {
            super.setName(string);
        }
    }

    public void addTo(Parser parser) {
        if (parser != null && this.variable.getName() != null) {
            parser.add(this.variable);
        }
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setIntegerValued(boolean bl) {
        this.integerValued = bl;
        if (bl && !Double.isNaN(this.minVal) && !Double.isNaN(this.maxVal)) {
            this.checkIntegerLimits(this.minVal, this.maxVal);
        }
        this.needsValueCheck = true;
    }

    public boolean getIntegerValued() {
        return this.integerValued;
    }

    public void setMin(Value value) {
        this.min = value == null ? new Constant(-5.0) : value;
    }

    public void setMax(Value value) {
        this.max = value == null ? new Constant(5.0) : value;
    }

    public Value getMin() {
        return this.min;
    }

    public Value getMax() {
        return this.max;
    }

    public void setOnUserAction(Controller controller) {
        this.onUserAction = controller;
        this.enableEvents(256L);
    }

    public void notifyControllerOnChange(Controller controller) {
        this.setOnUserAction(controller);
    }

    public Controller getOnUserAction() {
        return this.onUserAction;
    }

    public long getSerialNumber() {
        if (this.needsValueCheck) {
            this.getVal();
        }
        return this.serialNumber;
    }

    public void sync(Tie tie, Tieable tieable) {
        if (tieable != this) {
            if (!(tieable instanceof Value)) {
                throw new IllegalArgumentException("Internal Error:  A VariableSlider can only sync with Value objects.");
            }
            this.setVal(((Value)((Object)tieable)).getVal());
            this.serialNumber = tieable.getSerialNumber();
        }
    }

    public double getVal() {
        if (this.needsValueCheck) {
            double d = Double.NaN;
            double d2 = Double.NaN;
            boolean bl = false;
            double d3 = this.variable.getVariableValue();
            try {
                d = this.min.getVal();
                d2 = this.max.getVal();
                if (!(Double.isNaN(d) || Double.isNaN(d2) || d == this.minVal && d2 == this.maxVal)) {
                    if (this.integerValued) {
                        this.checkIntegerLimits(d, d2);
                    }
                    this.minVal = d;
                    this.maxVal = d2;
                    bl = true;
                }
            }
            catch (JCMError jCMError) {
                // empty catch block
            }
            if (Double.isNaN(this.minVal) || Double.isNaN(this.maxVal) || Double.isInfinite(this.minVal) || Double.isInfinite(this.maxVal)) {
                this.variable.setVariableValue(Double.NaN);
                if (!Double.isNaN(d3)) {
                    ++this.serialNumber;
                }
                this.setValue(0);
            } else if (this.oldPosition != this.getValue()) {
                double d4 = this.minVal + (this.maxVal - this.minVal) * (double)this.getValue() / (double)this.intervals;
                d4 = this.clamp(d4, this.minVal, this.maxVal);
                if (this.integerValued) {
                    d4 = Math.round(d4);
                }
                if (d4 != d3) {
                    this.variable.setVariableValue(d4);
                    ++this.serialNumber;
                }
            } else if (!Double.isNaN(d3) && bl) {
                double d5 = this.clamp(d3, this.minVal, this.maxVal);
                if (d5 != d3) {
                    this.variable.setVariableValue(d5);
                    ++this.serialNumber;
                }
                if (this.minVal != this.maxVal) {
                    int n = (int)((d3 - this.minVal) / (this.maxVal - this.minVal) * (double)this.intervals);
                    this.setValue(n);
                }
            }
            this.oldPosition = this.getValue();
            this.needsValueCheck = false;
        }
        return this.variable.getVariableValue();
    }

    public void setVal(double d) {
        try {
            double d2 = this.min.getVal();
            double d3 = this.max.getVal();
            if (!(Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3) || Double.isInfinite(d) || Double.isInfinite(d2) || Double.isInfinite(d3))) {
                if (this.integerValued) {
                    d2 = Math.round(d2);
                    d3 = Math.round(d3);
                }
                double d4 = this.clamp(d, d2, d3);
                int n = (int)((d4 - d2) / (d3 - d2) * (double)this.intervals);
                this.setValue(n);
            }
        }
        catch (JCMError jCMError) {
            // empty catch block
        }
        this.variable.setVariableValue(d);
        this.needsValueCheck = false;
        this.oldPosition = this.getValue();
        ++this.serialNumber;
    }

    public void checkInput() {
        this.needsValueCheck = true;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getOrientation() == 0) {
            return new Dimension(200, dimension.height);
        }
        return new Dimension(dimension.width, 200);
    }

    private void checkIntegerLimits(double d, double d2) {
        int n = this.getValue();
        d = Math.round(d);
        d2 = Math.round(d2);
        double d3 = Math.round(this.variable.getVariableValue());
        double d4 = Math.abs(d - d2);
        if (d4 > 0.0 && d4 != (double)this.intervals) {
            this.intervals = (int)Math.min(d4, 10000.0);
            double d5 = this.clamp(d3, d, d2);
            int n2 = (int)((d5 - d) / (d2 - d) * (double)this.intervals);
            int n3 = this.intervals / 50 + 3;
            if (this.intervals < 10) {
                this.setBlockIncrement(1);
            } else if (this.intervals < 100) {
                this.setBlockIncrement(this.intervals / 10);
            } else {
                this.setBlockIncrement(10 + this.intervals / 100);
            }
            this.setValues(n2, n3, 0, this.intervals + n3);
        }
        this.oldPosition = n == this.oldPosition ? this.getValue() : -1;
    }

    private double clamp(double d, double d2, double d3) {
        double d4 = d;
        if (d2 < d3) {
            if (d4 < d2) {
                d4 = d2;
            } else if (d4 > d3) {
                d4 = d3;
            }
        } else if (d4 < d3) {
            d4 = d3;
        } else if (d4 > d2) {
            d4 = d2;
        }
        return d4;
    }

    public void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        if (this.onUserAction != null) {
            this.onUserAction.compute();
        }
        super.processAdjustmentEvent(adjustmentEvent);
    }

    private class VS
    extends Variable {
        VS(String string) {
            super(string);
        }

        public double getVal() {
            return VariableSlider.this.getVal();
        }

        public void setVal(double d) {
            VariableSlider.this.setVal(d);
        }

        void setVariableValue(double d) {
            super.setVal(d);
        }

        double getVariableValue() {
            return super.getVal();
        }
    }
}

