/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.awt;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.awt.ErrorReporter;
import edu.hws.jcm.awt.InputObject;
import edu.hws.jcm.awt.JCMError;
import edu.hws.jcm.awt.Tie;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.Serializable;
import java.util.Vector;

public class Controller
implements Serializable,
Computable,
InputObject,
AdjustmentListener,
ActionListener,
TextListener,
ItemListener {
    protected Vector computables;
    protected Vector inputs;
    protected Vector ties;
    protected ErrorReporter errorReporter;
    protected Controller parent;
    protected String errorMessage;

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void add(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Controller) {
            Controller controller = (Controller)object;
            if (controller.parent != null) {
                controller.parent.remove(this);
            }
            controller.parent = this;
        }
        if (object instanceof Computable) {
            if (this.computables == null) {
                this.computables = new Vector();
            }
            this.computables.addElement(object);
        }
        if (object instanceof InputObject) {
            if (this.inputs == null) {
                this.inputs = new Vector();
            }
            this.inputs.addElement(object);
        }
        if (object instanceof Tie) {
            if (this.ties == null) {
                this.ties = new Vector();
            }
            this.ties.addElement(object);
        }
    }

    public void remove(Object object) {
        if (object == null) {
            return;
        }
        if (this.computables != null) {
            this.computables.removeElement(object);
            if (this.computables.size() == 0) {
                this.computables = null;
            }
        }
        if (this.inputs != null) {
            this.inputs.removeElement(object);
            if (this.inputs.size() == 0) {
                this.inputs = null;
            }
        }
        if (this.ties != null) {
            this.ties.removeElement(object);
            if (this.ties.size() == 0) {
                this.ties = null;
            }
        }
        if (object instanceof Controller && ((Controller)object).parent == this) {
            ((Controller)object).parent = null;
        }
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.compute();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.compute();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.compute();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.compute();
    }

    public synchronized void compute() {
        try {
            this.checkInput();
            this.doTies();
            this.clearErrorMessage();
            this.doCompute();
        }
        catch (JCMError jCMError) {
            if (this.errorMessage == null || !this.errorMessage.equals(jCMError.getMessage())) {
                this.reportError(jCMError.getMessage());
            }
        }
        catch (RuntimeException runtimeException) {
            this.reportError("Internal programmer's error detected?  " + runtimeException);
            runtimeException.printStackTrace();
        }
    }

    public void checkInput() {
        if (this.inputs != null) {
            int n = this.inputs.size();
            for (int i = 0; i < n; ++i) {
                ((InputObject)this.inputs.elementAt(i)).checkInput();
            }
        }
    }

    protected void doTies() {
        int n;
        int n2;
        if (this.inputs != null) {
            n2 = this.inputs.size();
            for (n = 0; n < n2; ++n) {
                if (!(this.inputs.elementAt(n) instanceof Controller)) continue;
                ((Controller)this.inputs.elementAt(n)).doTies();
            }
        }
        if (this.ties != null) {
            n2 = this.ties.size();
            for (n = 0; n < n2; ++n) {
                ((Tie)this.ties.elementAt(n)).check();
            }
        }
    }

    protected void doCompute() {
        if (this.computables != null) {
            int n = this.computables.size();
            for (int i = 0; i < n; ++i) {
                Object e = this.computables.elementAt(i);
                if (e instanceof Controller) {
                    ((Controller)e).doCompute();
                    continue;
                }
                ((Computable)e).compute();
            }
        }
    }

    public void reportError(String string) {
        if (string == null) {
            this.clearErrorMessage();
        }
        if (this.errorReporter != null) {
            this.errorReporter.setErrorMessage(this, string);
            this.errorMessage = string;
        } else if (this.parent != null) {
            this.parent.reportError(this.errorMessage);
        } else {
            this.errorMessage = string;
            System.out.println("***** Error:  " + this.errorMessage);
        }
    }

    protected void clearErrorMessage() {
        if (this.errorReporter != null) {
            this.errorReporter.clearErrorMessage();
        } else if (this.parent != null) {
            this.parent.clearErrorMessage();
        }
        this.errorMessage = null;
    }

    public void errorCleared() {
        this.errorMessage = null;
    }

    public void notifyControllerOnChange(Controller controller) {
        if (this.inputs != null) {
            int n = this.inputs.size();
            for (int i = 0; i < n; ++i) {
                ((InputObject)this.inputs.elementAt(i)).notifyControllerOnChange(controller);
            }
        }
    }

    public void gatherInputs() {
        this.notifyControllerOnChange(this);
    }
}

