% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class-SDMXAttribute.R, R/SDMXAttribute-methods.R
\docType{class}
\name{SDMXAttribute}
\alias{SDMXAttribute}
\alias{SDMXAttribute,SDMXAttribute-method}
\alias{SDMXAttribute-class}
\title{Class "SDMXAttribute"}
\usage{
SDMXAttribute(xmlObj, namespaces)
}
\arguments{
\item{xmlObj}{object of class "XMLInternalDocument derived from XML package}

\item{namespaces}{object of class "data.frame" given the list of namespace URIs}
}
\value{
an object of class "SDMXAttribute"
}
\description{
A basic class to handle a SDMX Attribute
}
\section{Slots}{

\describe{
\item{\code{conceptRef}}{Object of class "character" giving the attribute conceptRef (required)}

\item{\code{conceptVersion}}{Object of class "character" giving the attribute concept version}

\item{\code{conceptAgency}}{Object of class "character" giving the attribute concept agency}

\item{\code{conceptSchemeRef}}{Object of class "character" giving the attribute conceptScheme ref}

\item{\code{conceptSchemeAgency}}{Object of class "character" giving the attribute conceptScheme agency}

\item{\code{codelist}}{Object of class "character" giving the codelist ref name}

\item{\code{codelistVersion}}{Object of class "character" giving the codelist ref version}

\item{\code{codelistAgency}}{Object of class "character" giving the codelist ref agency}

\item{\code{attachmentLevel}}{Object of class "character" giving the attachment level (e.g. DataSet)}

\item{\code{assignmentStatus}}{Object of class "character" giving the assignment status (e.g. Mandatory)}

\item{\code{isTimeFormat}}{Object of class "logical"}

\item{\code{crossSectionalAttachDataset}}{Object of class "logical"}

\item{\code{crossSectionalAttachGroup}}{Object of class "logical"}

\item{\code{crossSectionalAttachSection}}{Object of class "logical"}

\item{\code{crossSectionalAttachObservation}}{Object of class "logical"}

\item{\code{isEntityAttribute}}{Object of class "logical" indicating if the Attribute is an entity Attribute. Default value is FALSE}

\item{\code{isNonObservationTimeAttribute}}{Object of class "logical" indicating if the Attribute is a non-observation Attribute. Default value is FALSE}

\item{\code{isCountAttribute}}{Object of class "logical" indicating if the Attribute is a count Attribute. Default value is FALSE}

\item{\code{isFrequencyAttribute}}{Object of class "logical" indicating if the Attribute is a frequency Attribute. Default value is FALSE}

\item{\code{isIdentityAttribute}}{Object of class "logical" indicating if the Attribute is an identity Attribute. Default value is FALSE}
}}
\section{Warning}{

This class is not useful in itself, but all SDMX non-abstract classes will
encapsulate it as slot, when parsing an SDMX-ML document (DataStructures, or
DataStructureDefinitions)
}
\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}
\seealso{
\link{readSDMX}
}

