% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-re.R
\name{gr}
\alias{gr}
\title{Set up basic grouping terms in \pkg{brms}}
\usage{
gr(
  ...,
  by = NULL,
  cor = TRUE,
  id = NA,
  pw = NULL,
  cov = NULL,
  dist = "gaussian"
)
}
\arguments{
\item{...}{One or more terms containing grouping factors.}

\item{by}{An optional factor variable, specifying sub-populations of the
groups. For each level of the \code{by} variable, a separate
variance-covariance matrix will be fitted. Levels of the grouping factor
must be nested in levels of the \code{by} variable.}

\item{cor}{Logical. If \code{TRUE} (the default), group-level terms will be
modelled as correlated.}

\item{id}{Optional character string. All group-level terms across the model
with the same \code{id} will be modeled as correlated (if \code{cor} is
\code{TRUE}). See \code{\link{brmsformula}} for more details.}

\item{pw}{Optional numeric variable specifying prior weights. They weight the
contribution of each group to the log-prior of the group-level
coefficients. Should have one distinct value for each level of the
grouping variable.}

\item{cov}{An optional matrix which is proportional to the within-group
covariance matrix of the group-level effects. All levels of the grouping
factor should appear as rownames of the corresponding matrix. This argument
can be used, among others, to model pedigrees and phylogenetic effects. See
\code{vignette("brms_phylogenetics")} for more details. By default, levels
of the same grouping factor are modeled as independent of each other.}

\item{dist}{Name of the distribution of the group-level effects.
Currently \code{"gaussian"} is the only option.}
}
\description{
Function used to set up a basic grouping term in \pkg{brms}.
The function does not evaluate its arguments --
it exists purely to help set up a model with grouping terms.
\code{gr} is called implicitly inside the package
and there is usually no need to call it directly.
}
\examples{
\dontrun{
# model using basic lme4-style formula
fit1 <- brm(count ~ Trt + (1|patient), data = epilepsy)
summary(fit1)

# equivalent model using 'gr' which is called anyway internally
fit2 <- brm(count ~ Trt + (1|gr(patient)), data = epilepsy)
summary(fit2)

# include Trt as a by variable
fit3 <- brm(count ~ Trt + (1|gr(patient, by = Trt)), data = epilepsy)
summary(fit3)

# include a group-level weight variable
epilepsy[['patient_samp_wgt']] <- c(1, rep(c(0.9, 1.1), each = 29))
fit4 <- brm(count ~ Trt + (1|gr(patient, pw = patient_samp_wgt)),
            data = epilepsy)
summary(fit4)
}

}
\seealso{
\code{\link{brmsformula}}
}
