% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se.R
\name{se1}
\alias{se1}
\title{MDYPL state evolution functions with intercept}
\usage{
se1(
  mu,
  b,
  sigma,
  iota,
  kappa,
  gamma,
  alpha,
  intercept,
  gh = NULL,
  prox_tol = 1e-10
)
}
\arguments{
\item{mu}{aggregate bias parameter.}

\item{b}{parameter \code{b} in the state evolution functions.}

\item{sigma}{square root of the aggregate variance of the MDYPL
estimator.}

\item{iota}{limits of the MDYPL estimate for the intercept as the sample size goes to +Inf}

\item{kappa}{asymptotic ratio of columns/rows of the design
matrix. \code{kappa} should be in \verb{(0, 1)}.}

\item{gamma}{the square root of the limit of the variance of the
linear predictor.}

\item{alpha}{the shrinkage parameter of the MDYPL
estimator. \code{alpha} should be in \verb{(0, 1)}.}

\item{intercept}{intercept of the logistic regression model}

\item{gh}{A list with the Gauss-Hermite quadrature nodes and
weights, as returned from \code{statmod::gauss.quad()} with \code{kind = "hermite"}. Default is \code{NULL}, in which case \code{gh} is set to
\code{statmod::gauss.quad(200, kind = "hermite")} is used.}

\item{prox_tol}{tolerance for the computation of the proximal
operator; default is \code{1e-10}. fixed point problem solved via Newton-Raphson}
}
\description{
MDYPL state evolution functions with intercept
}
