/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef MESSAGE_H
#define MESSAGE_H

#include <QString>
#include <QColor>
#include <QFile>

#include "globals.h"
/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class Message
{
  private:
    /// version of QChat which sent this msg
    quint16 m_version;
    /// type of msg : MESSAGE, INFO, ERROR, etc
    quint16 m_type;
    quint64 m_srcIp;
    quint64 m_srcUid;
    quint64 m_sendTime;
    quint64 m_receiveTime;
    QColor  m_color;
    QString m_msg;
    QString m_userName;
    QString m_compName;
    bool    m_requested;
    bool    m_isHtml;
    bool    m_isIncoming;
    bool    m_isVisible;

  public:
    Message(QC_DatagramHeader* Hdr = 0, quint64 = 0);
    ~Message();

    quint16 version         () const {return m_version    ;}
    quint16 type            () const {return m_type       ;}
    quint64 srcIp           () const {return m_srcIp      ;}
    quint64 sendTime        () const {return m_sendTime   ;}
    quint64 receiveTime     () const {return m_receiveTime;}
    const QColor  & color   () const {return m_color      ;}
    const QString & userName() const {return m_userName   ;}
    const QString & compName() const {return m_compName   ;}
    const QString & msg     () const {return m_msg        ;}
    bool requested          () const {return m_requested  ;}

    void setVersion    (quint16 ver)         {m_version     = ver  ;}
    void setType       (quint16 type)        {m_type        = type ;}
    void setSrcIp      (quint64 ip)          {m_srcIp       = ip   ;}
    void setSendTime   (quint64 tm)          {m_sendTime    = tm   ;}
    void setReceiveTime(quint64 tm)          {m_receiveTime = tm   ;}
    void setColor      (const QColor & color){m_color       = color;}
    void setUserName   (const QString & name){m_userName    = name ;}
    void setCompName   (const QString & name){m_compName    = name ;}
    void setMsg        (const QString & msg) {m_msg         = msg  ;}
    void setMsg        (const QC_DatagramHeader* Hdr);
    void setRequested  (bool rq){m_requested = rq;}

    void setIsHtml(bool value) {m_isHtml = value;}
    bool isHtml() const {return m_isHtml;}

    void setSrcUid( const quint64& theValue ){m_srcUid = theValue;}
    quint64 srcUid() const {return m_srcUid;}

    void setIsIncoming(bool theValue){m_isIncoming = theValue;}
    bool isIncoming() const {return m_isIncoming;}

    void setIsVisible(bool theValue){m_isVisible = theValue;}
    bool isVisible() const {return m_isVisible;}
};

#endif
