###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_phpmyfaq_get_xss_vuln.nasl 5848 2009-11-24 11:25:02Z nov $
#
# phpMyFAQ GET Variable Cross-Site-Scripting Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900982);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-4040");
  script_bugtraq_id(37020);
  script_name("phpMyFAQ GET Variable Cross-Site-Scripting Vulnerability");
  desc = "
  Overview: This host is installed with phpMyFAQ and is prone to Cross Site
  Scripting vulnerability.

  Vulnerability Insight:
  This vulnerability is caused because the application does not properly sanitize
  the input passed into 'GET' parameter in 'search.php'.

  Impact:
  Successful exploitation will allow remote attackers to execute arbitrary HTML
  and script code and cause cross-site scripting attacks.

  Impact Level: Application

  Affected Software/OS:
  phpMyFAQ prior to 2.0.17 and 2.5.0 prior to 2.5.2.

  Fix: Upgrade to phpMyFAQ 2.0.17 or 2.5.2
  http://www.phpmyfaq.de/download.php

  References:
  http://secunia.com/advisories/37354
  http://www.phpmyfaq.de/advisory_2009-09-01.php
  http://www.vupen.com/english/advisories/2009/3241

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:None/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score  : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of phpMyFAQ");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("phpmyfaq_detect.nasl", "gb_ms_ie_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

pmfPort = get_http_port(default:80);
if(!pmfPort){
  exit(0);
}

pmfVer = get_kb_item("www/" + pmfPort + "/phpmyfaq");
pmfVer = eregmatch(pattern:"^(.+) under (/.*)$", string:pmfVer);

if(pmfVer[1] != NULL)
{
  if(version_is_less(version:pmfVer[1],  test_version:"2.0.17")||
     version_in_range(version:pmfVer[1], test_version:"2.5", test_version2:"2.5.1")){
    security_warning(pmfPort);
  }
}
