###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_v-webmail_mult_file_inc_vuln.nasl 3220 2009-07-02 20:09:17Z jul $
#
# V-webmail Multiple PHP Remote File Inclusion Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800822);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-6840", "CVE-2006-2666");
  script_bugtraq_id(30162, 30164);
  script_name("V-webmail Multiple PHP Remote File Inclusion Vulnerability");
  desc = "

  Overview:
  The host is running V-webmail and is prone to Multiple PHP Remote File
  Inclusion vulnerability.

  Vulnerability Insight:
  The flaws are due to error in 'CONFIG[pear_dir]' parameter to Mail/RFC822.php,
  Net/Socket.php, XML/Parser.php, XML/Tree.php, Mail/mimeDecode.php, Log.php,
  Console/Getopt.php, System.php, and File.php in includes/pear/ directory and
  also in includes/cachedConfig.php, includes/mailaccess/pop3.php, and
  includes/prepend.php files, and error exists in 'CONFIG[includes]' parameter
  to prepend.php and email.list.search.php in includes/.

  Impact:
  Successful exploitation will let the remote attacker to execute arbitrary
  PHP code via a URL in the CONFIG[pear_dir] or CONFIG[includes] parameters
  when register_globals is enabled.

  Impact Level: Application

  Affected Software/OS:
  V-webmail version 1.6.4 and prior

  Fix: No solution or patch is available as on 02nd July, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://sourceforge.net/projects/v-webmail/ 

  References:
  http://milw0rm.com/exploits/1827
  http://secunia.com/advisories/20297
  http://packetstormsecurity.org/0807-exploits/vwebmail-rfi.txt

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Attack and Version of V-webmail");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_v-webmail_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

vwmailPort = get_http_port(default:80);
if(!vwmailPort){
  exit(0);
}

vwmailVer = get_kb_item("www/" + vwmailPort + "/V-webmail");
vwmailVer = eregmatch(pattern:"^(.+) under (/.*)$", string:vwmailVer);

if(vwmailVer[2] != NULL && (!safe_checks()))
{
  sndReq = http_get(item:vwmailVer[2] + "/includes/mailaccess/pop3.php" +
                                        "?CONFIG[pear_dir]=[SHELL]",
                    port:vwmailPort);
  rcvRes = http_send_recv(data:sndReq, port:vwmailPort);
  if("SHELL" >!< rcvRes)
  {
    sndReq = http_get(item:vwmailVer[2] + "/includes/prepend.php?" +
                                          "CONFIG[includes]=[SHELL]",
                      port:vwmailPort);
    rcvRes = http_send_recv(data:sndReq, port:vwmailPort);
  }
  if("SHELL" >< rcvRes && egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    security_warning(vwmailPort);
    exit(0);
  }
}

if(vwmailVer[1] != NULL)
{
  if(version_is_less_equal(version:vwmailVer[1], test_version:"1.6.4"))
  {
    security_warning(vwmailPort);
    exit(0);
  }
}
