###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for python2.5 vulnerabilities USN-890-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840376);
  script_version("$Revision: 8167 $: 1.0");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "USN", value: "890-2");
  script_cve_id("CVE-2009-3560", "CVE-2009-3720", "CVE-2009-2625");
  script_name("Ubuntu Update for python2.5 vulnerabilities USN-890-2");
  desc = "

  Vulnerability Insight:

  USN-890-1 fixed vulnerabilities in Expat. This update provides the
  corresponding updates for the PyExpat module in Python 2.5.
  
  Original advisory details:
  
  Jukka Taimisto, Tero Rontti and Rauli Kaksonen discovered that Expat did
  not properly process malformed XML. If a user or application linked against
  Expat were tricked into opening a crafted XML file, an attacker could cause
  a denial of service via application crash. (CVE-2009-2625, CVE-2009-3720)
  
  It was discovered that Expat did not properly process malformed UTF-8
  sequences. If a user or application linked against Expat were tricked into
  opening a crafted XML file, an attacker could cause a denial of service via
  application crash. (CVE-2009-3560)

  Affected Software/OS:
  python2.5 vulnerabilities on Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-January/001034.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of python2.5 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"python2.5-dbg", ver:"2.5.4-1ubuntu4.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-dev", ver:"2.5.4-1ubuntu4.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-minimal", ver:"2.5.4-1ubuntu4.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5", ver:"2.5.4-1ubuntu4.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-doc", ver:"2.5.4-1ubuntu4.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"idle-python2.5", ver:"2.5.4-1ubuntu4.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-examples", ver:"2.5.4-1ubuntu4.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"python2.5-dbg", ver:"2.5.2-11.1ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-dev", ver:"2.5.2-11.1ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-minimal", ver:"2.5.2-11.1ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5", ver:"2.5.2-11.1ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-doc", ver:"2.5.2-11.1ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-examples", ver:"2.5.2-11.1ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"idle-python2.5", ver:"2.5.2-11.1ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"python2.5-dbg", ver:"2.5.2-2ubuntu6.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-dev", ver:"2.5.2-2ubuntu6.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-minimal", ver:"2.5.2-2ubuntu6.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5", ver:"2.5.2-2ubuntu6.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-doc", ver:"2.5.2-2ubuntu6.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-examples", ver:"2.5.2-2ubuntu6.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"idle-python2.5", ver:"2.5.2-2ubuntu6.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"python2.5-dbg", ver:"2.5.4-1ubuntu6.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-dev", ver:"2.5.4-1ubuntu6.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-minimal", ver:"2.5.4-1ubuntu6.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5", ver:"2.5.4-1ubuntu6.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-doc", ver:"2.5.4-1ubuntu6.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"idle-python2.5", ver:"2.5.4-1ubuntu6.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-examples", ver:"2.5.4-1ubuntu6.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}