###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_google_chrome_settimeout_xss_vuln.nasl 1971 2009-05-05 12:47:35Z may $
#
# Google Chrome Timeout XSS Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800562);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1413");
  script_name("Google Chrome Timeout XSS Vulnerability");
  desc = "

  Overview: The host is installed with Google Chrome and is prone to XSS
  vulnerability.

  Vulnerability Insight:
  Error exist when javascript: URLs with unescaped spaces and quotes are
  processed and fails to cancel timeouts over a page transition thus enabling
  future code execution.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes and
  universal XSS attack in the context of the web browser.

  Affected Software/OS:
  Google Chrome version 1.0.x

  Fix: No solution or patch is available as on 07th May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.google.com/chrome

  References:
  http://secunia.com/advisories/34900
  http://code.google.com/p/chromium/issues/detail?id=9860

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(!chromeVer){
  exit(0);
}

if(version_in_range(version:chromeVer, test_version:"1.0",
                                       test_version2:"1.0.154.59")){
  security_warning(0);
}
