###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for mono FEDORA-2007-2969
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861370);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-2969");
  script_cve_id("CVE-2007-5197");
  script_name( "Fedora Update for mono FEDORA-2007-2969");
  desc = "

  Vulnerability Insight:
  The Mono runtime implements a JIT engine for the ECMA CLI
  virtual machine (as well as a byte code interpreter, the
  class loader, the garbage collector, threading system and
  metadata access libraries.


  Affected Software/OS:
  mono on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00182.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mono");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"mono", rpm:"mono~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-core", rpm:"mono-core~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-sybase", rpm:"mono-data-sybase~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-winforms", rpm:"mono-winforms~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-nunit-devel", rpm:"mono-nunit-devel~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ibm-data-db2", rpm:"ibm-data-db2~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-postgresql", rpm:"mono-data-postgresql~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data", rpm:"mono-data~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-sqlite", rpm:"mono-data-sqlite~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-web", rpm:"mono-web~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-firebird", rpm:"mono-data-firebird~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-oracle", rpm:"mono-data-oracle~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-jscript", rpm:"mono-jscript~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-debuginfo", rpm:"mono-debuginfo~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-nunit", rpm:"mono-nunit~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bytefx-data-mysql", rpm:"bytefx-data-mysql~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-locale-extras", rpm:"mono-locale-extras~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-devel", rpm:"mono-devel~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-extras", rpm:"mono-extras~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-sqlite", rpm:"mono-data-sqlite~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-sybase", rpm:"mono-data-sybase~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-postgresql", rpm:"mono-data-postgresql~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-debuginfo", rpm:"mono-debuginfo~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-firebird", rpm:"mono-data-firebird~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-nunit-devel", rpm:"mono-nunit-devel~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data", rpm:"mono-data~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-web", rpm:"mono-web~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-winforms", rpm:"mono-winforms~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-jscript", rpm:"mono-jscript~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-core", rpm:"mono-core~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bytefx-data-mysql", rpm:"bytefx-data-mysql~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-nunit", rpm:"mono-nunit~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-extras", rpm:"mono-extras~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-locale-extras", rpm:"mono-locale-extras~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ibm-data-db2", rpm:"ibm-data-db2~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-oracle", rpm:"mono-data-oracle~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-devel", rpm:"mono-devel~1.2.5.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}