# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 824-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55470);
 script_cve_id("CVE-2005-2919", "CVE-2005-2920");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 824-1 (clamav)";
 script_name(name);

 desc = "The remote host is missing an update to clamav
announced via advisory DSA 824-1.

Two vulnerabilities have been discovered in Clam AntiVirus, the
antivirus scanner for Unix, designed for integration with mail servers
to perform attachment scanning.  The following problems were
identified:

CVE-2005-2919
A potentially infinite loop could lead to a denial of service.

CVE-2005-2920
A buffer overflow could lead to a denial of service.

The old stable distribution (woody) does not contain ClamAV packages.

For the stable distribution (sarge) these problems have been fixed in
version 0.84-2.sarge.4.

For the unstable distribution (sid) these problems have been fixed in
version 0.87-1.

We recommend that you upgrade your clamav package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20824-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 824-1 (clamav)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"clamav-base", ver:"0.84-2.sarge.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-docs", ver:"0.84-2.sarge.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-testfiles", ver:"0.84-2.sarge.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav", ver:"0.84-2.sarge.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-daemon", ver:"0.84-2.sarge.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-freshclam", ver:"0.84-2.sarge.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-milter", ver:"0.84-2.sarge.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav-dev", ver:"0.84-2.sarge.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav1", ver:"0.84-2.sarge.4", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
