# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 346-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53635);
 script_cve_id("CVE-2003-0536");
 script_version ("$");
 script_tag(name:"cvss_base", value:"3.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 346-1 (phpsysinfo)";
 script_name(name);

 desc = "The remote host is missing an update to phpsysinfo
announced via advisory DSA 346-1.

Albert Puigsech Galicia <ripe@7a69ezine.org> reported that phpsysinfo,
a web-based program to display status information about the system,
contains two vulnerabilities which could allow local files to be read,
or arbitrary PHP code to be executed, under the privileges of the web
server process (usually www-data).  These vulnerabilities require
access to a writable directory on the system in order to be exploited.

For the stable distribution (woody) this problem has been fixed in
version 2.0-3woody1.

For the unstable distribution (sid) this problem will be fixed soon.
See Debian bug #200543.

We recommend that you update your phpsysinfo package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20346-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 346-1 (phpsysinfo)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"phpsysinfo", ver:"2.0-3woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
