# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1480-1 (poppler)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60292);
 script_cve_id("CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1480-1 (poppler)";
 script_name(name);

 desc = "The remote host is missing an update to poppler
announced via advisory DSA 1480-1.

Alin Rad Pop discovered several buffer overflows in the Poppler PDF
library, which could allow the execution of arbitrary code if a
malformed PDF file is opened.

For the stable distribution (etch), these problems have been fixed in
version 0.4.5-5.1etch2.

The old stable distribution (sarge) doesn't contain poppler.

We recommend that you upgrade your poppler packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201480-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1480-1 (poppler)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpoppler0c2-qt", ver:"0.4.5-5.1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler0c2-glib", ver:"0.4.5-5.1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler-dev", ver:"0.4.5-5.1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler-qt-dev", ver:"0.4.5-5.1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler-glib-dev", ver:"0.4.5-5.1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler0c2", ver:"0.4.5-5.1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"poppler-utils", ver:"0.4.5-5.1etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
