/*###############################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_PowerManagementCapabilitiesAccess.h"

const string InstanceID= "OpenDRIM:PowerManagementCapabilities";
const string ElementName = "Power Management Capabilities";

int PowerManagement_OpenDRIM_PowerManagementCapabilities_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_PowerManagementCapabilities_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_PowerManagementCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PowerManagementCapabilities>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_PowerManagementCapabilities instance;
	instance.setInstanceID(InstanceID);

	if (discriminant == "ei")
		CF_assert(PowerManagement_OpenDRIM_PowerManagementCapabilities_populate(instance, errorMessage));

	result.push_back(instance);
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_PowerManagementCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PowerManagementCapabilities& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.InstanceID!=InstanceID)
	{
		errorMessage = "Invalid path";
		return NOT_FOUND;
	}
	
	CF_assert(PowerManagement_OpenDRIM_PowerManagementCapabilities_populate(instance, errorMessage));
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_PowerManagementCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementCapabilities& newInstance, const OpenDRIM_PowerManagementCapabilities& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_PowerManagementCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_PowerManagementCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_PowerManagementCapabilities_populate(OpenDRIM_PowerManagementCapabilities& instance, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] InstanceID               [KEY]
	 * [X] PowerChangeCapabilities
	 * [X] ElementName
	 * [X] PowerStatesSupported
	 */
	vector<unsigned short> powerChangeCapabilities, powerStatesSupported;
	vector<string> system_states;
	string states; 
	
	instance.setElementName(ElementName);
	
	// Set supported state based on values found in /sys/power/state
	CF_runCommandFL("cat /sys/power/state",states,errorMessage);
	CF_splitTextBySpace(system_states,states);
	
	// set supported state based on the kernel documentation: <kernel_root>/Documentation/power/states.txt
	powerStatesSupported.push_back(0); // On
	for(unsigned int i=0;i<system_states.size();i++)
	{
		if(system_states[i]=="standby")      // S1
			powerStatesSupported.push_back(3); // Sleep - Light
		else if(system_states[i]=="mem")     // S3
			powerStatesSupported.push_back(4); // Sleep - Deep
		else if(system_states[i]=="disk")    // S4
			powerStatesSupported.push_back(7); // Hibernate (Off - Soft)
	}
	instance.setPowerStatesSupported(powerStatesSupported);
	
	// Regarding to the Table 2 of the Power State Management  profile (DSP1027)
	// with the values found above
	instance.setPowerChangeCapabilities(powerChangeCapabilities);
	_L_;
	return OK;
}

