// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Intf_Interference_HeaderFile
#define _Intf_Interference_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Intf_SeqOfSectionPoint.hxx>
#include <Intf_SeqOfSectionLine.hxx>
#include <Intf_SeqOfTangentZone.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Real.hxx>
#include <Standard_Integer.hxx>
class Standard_OutOfRange;
class Intf_SectionPoint;
class Intf_SectionLine;
class Intf_TangentZone;


//! Describes the   Interference  computation    result
//! between polygon2d or polygon3d or polyhedron
//! (as  three sequences   of  points  of  intersection,
//! polylines of intersection and zones de tangence).
class Intf_Interference 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Gives the number   of  points of  intersection  in the
  //! interference.
      Standard_Integer NbSectionPoints()  const;
  
  //! Gives the point of  intersection of address  Index in
  //! the interference.
     const  Intf_SectionPoint& PntValue (const Standard_Integer Index)  const;
  
  //! Gives the number  of polylines of  intersection in the
  //! interference.
      Standard_Integer NbSectionLines()  const;
  
  //! Gives the polyline of intersection at address <Index> in
  //! the interference.
     const  Intf_SectionLine& LineValue (const Standard_Integer Index)  const;
  
  //! Gives the number of zones of tangence in the interference.
      Standard_Integer NbTangentZones()  const;
  
  //! Gives  the zone of  tangence at address   Index in the
  //! interference.
     const  Intf_TangentZone& ZoneValue (const Standard_Integer Index)  const;
  
  //! Gives the tolerance used for the calculation.
      Standard_Real GetTolerance()  const;
  
  //! Tests if the polylines of  intersection or the zones of
  //! tangence contain the point of intersection <ThePnt>.
  Standard_EXPORT   Standard_Boolean Contains (const Intf_SectionPoint& ThePnt)  const;
  
  //! Inserts a new zone of tangence in  the current list of
  //! tangent zones of  the interference  and  returns  True
  //! when done.
  Standard_EXPORT   Standard_Boolean Insert (const Intf_TangentZone& TheZone) ;
  
  //! Insert a new segment of intersection in the current  list of
  //! polylines of intersection of the interference.
  Standard_EXPORT   void Insert (const Intf_SectionPoint& pdeb, const Intf_SectionPoint& pfin) ;
  
  Standard_EXPORT   void Dump()  const;




protected:

  
  Standard_EXPORT Intf_Interference(const Standard_Boolean Self);
  
  //! Only one argument for the intersection.
  Standard_EXPORT   void SelfInterference (const Standard_Boolean Self) ;


  Intf_SeqOfSectionPoint mySPoins;
  Intf_SeqOfSectionLine mySLines;
  Intf_SeqOfTangentZone myTZones;
  Standard_Boolean SelfIntf;
  Standard_Real Tolerance;


private:





};


#include <Intf_Interference.lxx>





#endif // _Intf_Interference_HeaderFile
